/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ea;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.ide.FeedbackDescriptionProvider;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.system.CpuArch;
import com.intellij.util.system.OS;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.platform.diagnostics.BackendException;
import com.jetbrains.rider.NetCoreUtil;
import com.jetbrains.rider.ea.DotNetExceptionReporter;
import com.jetbrains.rider.ea.ExceptionAttachment;
import com.jetbrains.rider.ea.ExceptionDescription;
import com.jetbrains.rider.ea.ExceptionSummaryAndText;
import java.io.Closeable;
import java.io.InputStream;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002\u001a\"\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u001a\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "knownNamespacesToPluginName", "", "", "buildExceptionDescription", "Lcom/jetbrains/rider/ea/ExceptionDescription;", "event", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "project", "Lcom/intellij/openapi/project/Project;", "attachments", "", "Lcom/jetbrains/rider/ea/ExceptionAttachment;", "getExceptionText", "Lcom/jetbrains/rider/ea/ExceptionSummaryAndText;", "getExceptionSummaryAndText", "longSummary", "text", "appendJbrCrashInfo", "", "descriptionBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "tryGetPluginNameUsingStackTrace", "throwableText", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nDotNetExceptionReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetExceptionReporter.kt\ncom/jetbrains/rider/ea/DotNetExceptionReporterKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,294:1\n1563#2:295\n1634#2,3:296\n967#2,7:299\n756#2,10:306\n295#2,2:316\n13#3:318\n14#4:319\n*S KotlinDebug\n*F\n+ 1 DotNetExceptionReporter.kt\ncom/jetbrains/rider/ea/DotNetExceptionReporterKt\n*L\n247#1:295\n247#1:296,3\n247#1:299,7\n248#1:306,10\n272#1:316,2\n42#1:318\n42#1:319\n*E\n"})
public final class DotNetExceptionReporterKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Map<String, String> knownNamespacesToPluginName;

    private static final ExceptionDescription buildExceptionDescription(IdeaLoggingEvent event, Project project, List<ExceptionAttachment> attachments) {
        Throwable throwable = event.getThrowable();
        StringBuilder descriptionBuilder = new StringBuilder();
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"getInstance(...)");
        ApplicationNamesInfo appNamesInfo = applicationNamesInfo;
        Application application = ApplicationManager.getApplication();
        OffsetDateTime buildTime = appInfo.getBuildDate().toInstant().atOffset(ZoneOffset.UTC);
        OffsetDateTime releaseBuildTime = appInfo.getMajorReleaseBuildDate().toInstant().atOffset(ZoneOffset.UTC);
        BuildNumber buildNumber = appInfo.getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
        BuildNumber build = buildNumber;
        String string = build.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String buildNumberWithAllDetails = string;
        if (StringsKt.startsWith$default((String)buildNumberWithAllDetails, (String)(build.getProductCode() + "-"), (boolean)false, (int)2, null)) {
            String string2 = buildNumberWithAllDetails.substring(build.getProductCode().length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            buildNumberWithAllDetails = string2;
        }
        IdeaPluginDescriptor pluginInfo = event.getPlugin();
        descriptionBuilder.append(appNamesInfo.getFullProductName() + " " + appInfo.getMajorVersion() + "." + appInfo.getMinorVersion() + " Build " + appInfo.getApiVersion() + " Date " + DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(buildTime)).append('\n');
        if (pluginInfo != null && !pluginInfo.isBundled()) {
            descriptionBuilder.append('\n');
            descriptionBuilder.append("Plugin Name: " + pluginInfo.getName()).append('\n');
            descriptionBuilder.append("Plugin Version: " + pluginInfo.getVersion()).append('\n');
        }
        ExceptionSummaryAndText throwableText = DotNetExceptionReporterKt.getExceptionText(event);
        Object object = pluginInfo;
        if (object == null || (object = object.getName()) == null) {
            object = DotNetExceptionReporterKt.tryGetPluginNameUsingStackTrace(throwableText.getText());
        }
        Object pluginName = object;
        IdeaPluginDescriptor ideaPluginDescriptor = pluginInfo;
        String pluginVersion = ideaPluginDescriptor != null ? ideaPluginDescriptor.getVersion() : null;
        DotNetExceptionReporterKt.appendJbrCrashInfo(descriptionBuilder, attachments);
        descriptionBuilder.append('\n');
        descriptionBuilder.append(throwableText.getText()).append('\n');
        descriptionBuilder.append('\n');
        descriptionBuilder.append("last.action = " + IdeaLogger.ourLastActionId).append('\n');
        if (pluginName != null) {
            descriptionBuilder.append("plugin.name = " + (String)pluginName).append('\n');
        }
        if (pluginVersion != null) {
            descriptionBuilder.append("plugin.version = " + pluginVersion).append('\n');
        }
        descriptionBuilder.append('\n');
        descriptionBuilder.append("protocol.version = 1.1").append('\n');
        descriptionBuilder.append("app.name = " + appNamesInfo.getProductName()).append('\n');
        descriptionBuilder.append("app.name.full = " + appNamesInfo.getFullProductName()).append('\n');
        descriptionBuilder.append("app.name.version = " + appInfo.getVersionName()).append('\n');
        descriptionBuilder.append("app.eap = " + appInfo.isEAP()).append('\n');
        descriptionBuilder.append("app.internal = " + application.isInternal()).append('\n');
        descriptionBuilder.append("app.build = " + appInfo.getApiVersion()).append('\n');
        descriptionBuilder.append("app.version.major = " + appInfo.getMajorVersion()).append('\n');
        descriptionBuilder.append("app.version.minor = " + appInfo.getMinorVersion()).append('\n');
        descriptionBuilder.append("app.build.date = " + DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(buildTime)).append('\n');
        descriptionBuilder.append("app.build.date.release = " + DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(releaseBuildTime)).append('\n');
        descriptionBuilder.append("app.product.code = " + build.getProductCode()).append('\n');
        descriptionBuilder.append("app.build.number = " + buildNumberWithAllDetails).append('\n');
        descriptionBuilder.append('\n');
        descriptionBuilder.append("os.cpu.arch = " + (String)(CpuArch.isEmulated() ? CpuArch.CURRENT + "(emulated)" : String.valueOf(CpuArch.CURRENT))).append('\n');
        descriptionBuilder.append("os.name = " + OS.CURRENT.name()).append('\n');
        descriptionBuilder.append("os.version = " + OS.CURRENT.version).append('\n');
        descriptionBuilder.append("java.version = " + SystemInfo.JAVA_RUNTIME_VERSION).append('\n');
        descriptionBuilder.append("java.vm.vendor = " + SystemInfo.JAVA_VENDOR).append('\n');
        descriptionBuilder.append('\n');
        descriptionBuilder.append("UIUtil.isRetina = " + UIUtil.isRetina()).append('\n');
        descriptionBuilder.append("JBUI.isHiDPI() = " + JBUIScale.isUsrHiDPI()).append('\n');
        int imageScaleFactor = JBUIScale.isUsrHiDPI() || UIUtil.isRetina() ? 2 : 1;
        descriptionBuilder.append("ImageScaleFactor = " + imageScaleFactor).append('\n');
        descriptionBuilder.append('\n');
        descriptionBuilder.append("netcore = " + NetCoreUtil.INSTANCE.runOnNetCore()).append('\n');
        descriptionBuilder.append('\n');
        ExtensionPoint feedbackExtensionPoint = application.getExtensionArea().getExtensionPoint("com.intellij.feedbackDescriptionProvider");
        for (FeedbackDescriptionProvider ext : (FeedbackDescriptionProvider[])feedbackExtensionPoint.getExtensions()) {
            try {
                String pluginDescription2 = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(ext, project, null){
                    int label;
                    final /* synthetic */ FeedbackDescriptionProvider $ext;
                    final /* synthetic */ Project $project;
                    {
                        this.$ext = $ext;
                        this.$project = $project;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.$ext.getDescription(this.$project, (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
                CharSequence charSequence = pluginDescription2;
                if (charSequence == null || charSequence.length() == 0) continue;
                descriptionBuilder.append(pluginDescription2).append('\n');
                descriptionBuilder.append('\n');
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
        String string3 = throwableText.getSummary();
        String string4 = descriptionBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return new ExceptionDescription(string3, string4, (String)pluginName, pluginVersion);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ExceptionSummaryAndText getExceptionText(@NotNull IdeaLoggingEvent event) {
        String string;
        Object object;
        BackendException backendException;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String[] stringArray2 = event.getThrowable();
        Object object2 = stringArray2 instanceof BackendException ? (BackendException)stringArray2 : null;
        if (object2 == null) {
            stringArray = event.getData();
            AbstractMessage abstractMessage = stringArray instanceof AbstractMessage ? (AbstractMessage)stringArray : null;
            stringArray2 = abstractMessage != null ? abstractMessage.getThrowable() : null;
            object2 = stringArray2 instanceof BackendException ? (BackendException)stringArray2 : null;
        }
        if ((backendException = object2) != null) {
            void $this$takeWhile$iv;
            String p0;
            void $this$mapTo$iv$iv;
            BackendException backendException2 = backendException;
            boolean bl = false;
            stringArray = new String[]{"\n"};
            List lines = StringsKt.split$default((CharSequence)backendException2.getExceptionText(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Iterable $this$map$iv = lines;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(((Object)StringsKt.trim((CharSequence)p0)).toString());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                String p02 = (String)item$iv;
                boolean bl3 = false;
                boolean bl4 = ((CharSequence)p02).length() > 0;
                if (!bl4) break;
                list$iv.add(item$iv);
            }
            String longSummary = CollectionsKt.joinToString$default((Iterable)list$iv, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            Iterable $this$dropWhile$iv = lines;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv2 = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv2.add(item$iv);
                    continue;
                }
                p0 = (String)item$iv;
                boolean bl5 = false;
                if (!StringsKt.isBlank((CharSequence)p0)) continue;
                list$iv2.add(item$iv);
                yielding$iv = true;
            }
            String text = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)list$iv2, (int)1), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            return DotNetExceptionReporterKt.getExceptionSummaryAndText(longSummary, text);
        }
        String string3 = event.getThrowableText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getThrowableText(...)");
        String throwableText = string3;
        if (StringsKt.isBlank((CharSequence)throwableText)) {
            String string4 = event.getMessage();
            if (string4 == null) {
                string4 = "(null event message)";
            }
            return DotNetExceptionReporterKt.getExceptionSummaryAndText(string4, "(no exception instance)");
        }
        stringArray2 = new String[]{": "};
        List throwableSummary = StringsKt.split$default((CharSequence)((CharSequence)SequencesKt.first((Sequence)StringsKt.lineSequence((CharSequence)throwableText))), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        stringArray2 = TuplesKt.to(throwableSummary.get(0), (Object)CollectionsKt.getOrNull((List)throwableSummary, (int)1));
        Object object3 = stringArray2.component1();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"component1(...)");
        String throwableName = (String)object3;
        String throwableMessage = (String)stringArray2.component2();
        if (!Intrinsics.areEqual((Object)throwableName, (Object)"java.lang.Throwable")) {
            String string5 = throwableName.substring(StringsKt.lastIndexOf$default((CharSequence)throwableName, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            object = string5 + ": ";
        } else {
            object = "";
        }
        if ((string = event.getMessage()) == null) {
            string = "";
        }
        String longSummary = (String)object + string + (String)(throwableMessage != null && !Intrinsics.areEqual((Object)throwableMessage, (Object)event.getMessage()) ? " (" + throwableMessage + ")" : "");
        return DotNetExceptionReporterKt.getExceptionSummaryAndText(longSummary, "--- JAVA_EXCEPTION ---\n" + throwableText);
    }

    private static final ExceptionSummaryAndText getExceptionSummaryAndText(String longSummary, String text) {
        String string = StringUtil.shortenTextWithEllipsis((String)longSummary, (int)200, (int)0, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        String shortSummary = string;
        return new ExceptionSummaryAndText(shortSummary, (String)(!Intrinsics.areEqual((Object)shortSummary, (Object)longSummary) ? longSummary + "\n\n" : "") + text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void appendJbrCrashInfo(StringBuilder descriptionBuilder, List<ExceptionAttachment> attachments) {
        Object v0;
        Object $this$firstOrNull$iv;
        block9: {
            $this$firstOrNull$iv = attachments;
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                ExceptionAttachment it = (ExceptionAttachment)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getAttachment().getName(), (Object)"jbr_err.txt")) continue;
                v0 = element$iv;
                break block9;
            }
            v0 = null;
        }
        ExceptionAttachment exceptionAttachment = v0;
        if (exceptionAttachment == null) {
            return;
        }
        ExceptionAttachment jbrCrashReport = exceptionAttachment;
        descriptionBuilder.append('\n');
        try {
            Closeable closeable = jbrCrashReport.getAttachment().openContentStream();
            $this$firstOrNull$iv = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                byte[] byArray = it.readAllBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                byte[] byArray2 = byArray;
                String text = new String(byArray2, Charsets.UTF_8);
                StringBuilder stringBuilder = descriptionBuilder.append(text).append('\n');
            }
            catch (Throwable throwable) {
                $this$firstOrNull$iv = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)$this$firstOrNull$iv);
            }
        }
        catch (Throwable t) {
            LOG.warn(t);
        }
    }

    private static final String tryGetPluginNameUsingStackTrace(String throwableText) {
        for (Map.Entry<String, String> entry2 : knownNamespacesToPluginName.entrySet()) {
            String namespacePrefix = entry2.getKey();
            String pluginName = entry2.getValue();
            if (!StringsKt.contains$default((CharSequence)throwableText, (CharSequence)namespacePrefix, (boolean)false, (int)2, null)) continue;
            return pluginName;
        }
        return null;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ ExceptionDescription access$buildExceptionDescription(IdeaLoggingEvent event, Project project, List attachments) {
        return DotNetExceptionReporterKt.buildExceptionDescription(event, project, attachments);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DotNetExceptionReporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Pair[] pairArray = new Pair[]{new Pair((Object)"JetBrains.ReSharper.Plugins.Unity", (Object)"Unity Support"), new Pair((Object)"JetBrains.ReSharper.Plugins.FSharp", (Object)"F# Support")};
        knownNamespacesToPluginName = MapsKt.mapOf((Pair[])pairArray);
    }
}

