/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.actions.RdDataContextManager;
import com.jetbrains.rd.ide.model.ClipboardHandlerRequest;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.actions.base.FrontendEditorActionHandler;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rider.editorActions.RiderEditorActionHandler;
import com.jetbrains.rider.editors.LastFocusedEditorSuppressor;
import com.jetbrains.rider.rdclient.languages.assists.UtilsKt;
import com.jetbrains.rider.services.RiderDefaultBackend;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\"\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0012\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/editorActions/CopyOrCutHandler;", "Lcom/jetbrains/rider/editorActions/RiderEditorActionHandler;", "isCopyAction", "", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "<init>", "(ZLcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "backendIsEnabledForCaret", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "doExecute", "", "handleCopyCutInPatchEngine", "isFoldedMultiline", "currentCaretOffset", "", "currentCaretVisualPosition", "Lcom/intellij/openapi/editor/VisualPosition;", "callClipboardHandler", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nFrontendCopyCutHandlers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCopyCutHandlers.kt\ncom/jetbrains/rider/editorActions/CopyOrCutHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public class CopyOrCutHandler
extends RiderEditorActionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static boolean isNestedExecution;

    public CopyOrCutHandler(boolean isCopyAction, @NotNull EditorActionHandler baseHandler) {
        Intrinsics.checkNotNullParameter((Object)baseHandler, (String)"baseHandler");
        super(isCopyAction ? "EditorCopy" : "EditorCut", baseHandler);
    }

    @Override
    public boolean backendIsEnabledForCaret(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (PatchEngineRegistryKt.isPatchEngineEnabled()) {
            return false;
        }
        return super.backendIsEnabledForCaret(editor, caret, dataContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (PatchEngineRegistryKt.isPatchEngineEnabled()) {
            this.handleCopyCutInPatchEngine(editor, caret, dataContext);
            return;
        }
        boolean ret = this.backendIsEnabledForCaret(editor, caret, dataContext);
        if (ret && !isNestedExecution) {
            this.callClipboardHandler(dataContext);
            try {
                isNestedExecution = true;
                FrontendEditorActionHandler.getLogger().debug("Executing frontend editor base handler '" + this.getFrontendId() + "'");
                this.executeOnFrontend(editor, caret, dataContext);
            }
            finally {
                isNestedExecution = false;
            }
        } else {
            FrontendEditorActionHandler.getLogger().debug("Executing frontend editor base handler '" + this.getFrontendId() + "'");
            this.executeOnFrontend(editor, caret, dataContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleCopyCutInPatchEngine(Editor editor, Caret caret, DataContext dataContext) {
        Caret currentCaret;
        if (isNestedExecution) {
            this.executeOnFrontend(editor, caret, dataContext);
            return;
        }
        Caret caret2 = caret;
        if (caret2 == null) {
            Caret caret3 = editor.getCaretModel().getCurrentCaret();
            caret2 = caret3;
            Intrinsics.checkNotNullExpressionValue((Object)caret3, (String)"getCurrentCaret(...)");
        }
        if ((currentCaret = caret2).hasSelection()) {
            this.executeOnFrontend(editor, caret, dataContext);
            return;
        }
        if (Intrinsics.areEqual((Object)this.getFrontendId(), (Object)"EditorCopy")) {
            editor.putUserData(UtilsKt.getEXECUTE_ON_FRONTEND(), (Object)true);
            this.executeOnFrontend(editor, caret, dataContext);
            return;
        }
        if (!Intrinsics.areEqual((Object)this.getFrontendId(), (Object)"EditorCut")) {
            boolean bl = false;
            String string = "Expected Cut action";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            isNestedExecution = true;
            FrontendEditorActionHandler.getLogger().debug("Executing Cut action'");
            int n = currentCaret.getOffset();
            VisualPosition visualPosition = currentCaret.getVisualPosition();
            Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
            if (this.isFoldedMultiline(editor, n, visualPosition)) {
                editor.putUserData(UtilsKt.getEXECUTE_ON_FRONTEND(), (Object)true);
            }
            this.executeOnFrontend(editor, caret, dataContext);
        }
        finally {
            isNestedExecution = false;
        }
    }

    private final boolean isFoldedMultiline(Editor editor, int currentCaretOffset, VisualPosition currentCaretVisualPosition) {
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int currentLineNumber = document2.getLineNumber(currentCaretOffset);
        TextRange documentLineTextRange = new TextRange(document2.getLineStartOffset(currentLineNumber), document2.getLineEndOffset(currentLineNumber));
        TextRange textRange = EditorUtil.calcSurroundingTextRange((Editor)editor, (VisualPosition)currentCaretVisualPosition, (VisualPosition)currentCaretVisualPosition);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"calcSurroundingTextRange(...)");
        TextRange textRangeWithFoldedContent = textRange;
        boolean lineHasFolding = !Intrinsics.areEqual((Object)documentLineTextRange, (Object)textRangeWithFoldedContent);
        return lineHasFolding;
    }

    private final void callClipboardHandler(DataContext dataContext) {
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            FrontendEditorActionHandler.getLogger().error("project is null");
            return;
        }
        List modelDataContext = RdDataContextManager.Companion.createDataContextModel(dataContext);
        RiderDefaultBackend backend = RiderDefaultBackend.Companion.getInstance(project);
        String backendId = backend.getBackendActionId(this.getFrontendId());
        FrontendEditorActionHandler.getLogger().debug("Executing read-only clipboard editor handler '" + this.getFrontendId() + "'");
        LastFocusedEditorSuppressor.Companion.getInstance(project).forceReleaseSuppressionForLastFocusedEditor("Release all frontend changes before executing " + this.getFrontendId());
        backend.getActionsModel().getCopyOrCutHandler().fire((Object)new ClipboardHandlerRequest(backendId, modelDataContext));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/editorActions/CopyOrCutHandler$Companion;", "", "<init>", "()V", "isNestedExecution", "", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

