/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editorActions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rider.editorActions.FrontendTypingEditorActionHandler;
import com.jetbrains.rider.editorActions.TypingSessions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/editorActions/FrontendDeleteHandler;", "Lcom/jetbrains/rider/editorActions/FrontendTypingEditorActionHandler;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "<init>", "(Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;)V", "backendIsEnabledForCaret", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isSimpleChar", "char", "", "intellij.rider.rdclient.dotnet"})
public final class FrontendDeleteHandler
extends FrontendTypingEditorActionHandler {
    public FrontendDeleteHandler(@NotNull EditorActionHandler baseHandler) {
        Intrinsics.checkNotNullParameter((Object)baseHandler, (String)"baseHandler");
        super("EditorDelete", baseHandler);
    }

    @Override
    public boolean backendIsEnabledForCaret(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (editor.getInlayModel().hasInlineElementAt(editor.getCaretModel().getVisualPosition())) {
            return false;
        }
        Project project = editor.getProject();
        if (project != null && TypingSessions.Companion.isEnabled(project)) {
            return super.backendIsEnabledForCaret(editor, caret, dataContext);
        }
        int offset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Character c = DocumentExKt.getCharAt((Document)document, (int)offset);
        if (c == null) {
            return false;
        }
        char c2 = c.charValue();
        if (this.isSimpleChar(c2)) {
            return false;
        }
        return super.backendIsEnabledForCaret(editor, caret, dataContext);
    }

    @Override
    protected boolean isSimpleChar(char c) {
        return !CharsKt.isWhitespace((char)c) && super.isSimpleChar(c);
    }
}

