/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.rd.framework.impl.RdOptionalProperty;
import com.jetbrains.rd.ide.Suppressor;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizerBase;
import com.jetbrains.rd.ide.model.RdCaretModelChange;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RiderTextControlModel;
import com.jetbrains.rd.ide.model.ScrollingInfo;
import com.jetbrains.rd.ide.model.SelectionRange;
import com.jetbrains.rd.ide.model.SelectionRangeWithVersion;
import com.jetbrains.rd.ide.model.SelectionVersion;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.rdtext.ITypingSession;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHost;
import com.jetbrains.rider.document.TextBufferDocumentSynchronizer;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import com.jetbrains.rider.editors.SelectionVersionExKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 =2\u00020\u00012\u00020\u0002:\u0003=>?B1\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020$H\u0002J\u0010\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020(H\u0014J\b\u0010)\u001a\u00020$H\u0002J\u0010\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\u0019H\u0002J\u0010\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020$2\u0006\u0010+\u001a\u00020\u0019H\u0002J\u0010\u00100\u001a\u00020$2\u0006\u00101\u001a\u00020 H\u0002J\u0010\u00102\u001a\u00020$2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020$2\u0006\u00106\u001a\u000207H\u0016J\u0014\u00108\u001a\b\u0012\u0004\u0012\u00020 092\u0006\u0010:\u001a\u00020\u0006J\b\u0010;\u001a\u00020$H\u0002J\u0006\u0010<\u001a\u00020$R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0018\u00010\"R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession;", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizerBase;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/RiderTextControlModel;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/ide/model/TextControlId;Lcom/jetbrains/rd/ide/model/RiderTextControlModel;)V", "getEditorModel", "()Lcom/jetbrains/rd/ide/model/RiderTextControlModel;", "suppressor", "Lcom/jetbrains/rd/ide/Suppressor;", "getSuppressor", "()Lcom/jetbrains/rd/ide/Suppressor;", "dontReceiveChanges", "", "queuedChanges", "", "Lcom/jetbrains/rd/ide/model/SelectionRangeWithVersion;", "value", "Lcom/jetbrains/rd/ide/model/SelectionVersion;", "version", "getVersion", "()Lcom/jetbrains/rd/ide/model/SelectionVersion;", "currentSelection", "Lcom/jetbrains/rd/ide/model/SelectionRange;", "activeTypingSession", "Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$FrontendEditorTypingSession;", "init", "", "flushSuppressedChanges", "sendCaretStateChange", "reason", "", "incrementVersion", "performSend", "model", "receiveSelection", "change", "Lcom/jetbrains/rd/ide/model/RdCaretModelChange;", "doReceiveSelection", "applyBackendSelection", "backendSelection", "receiveScrollingRequest", "request", "Lcom/jetbrains/rd/ide/model/ScrollingInfo;", "documentChanged", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "startTypingSession", "Lcom/jetbrains/rd/rdtext/ITypingSession;", "lifetime", "finishTypingSession", "assertEmptyChangesQueue", "Companion", "State", "FrontendEditorTypingSession", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nEditorSynchronizerWithTypingSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorSynchronizerWithTypingSession.kt\ncom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,306:1\n68#2,4:307\n68#2,4:311\n68#2,4:315\n61#2,5:319\n68#2,4:324\n68#2,4:328\n68#2,4:332\n68#2,4:337\n68#2,4:341\n68#2,4:345\n68#2,4:349\n68#2,4:353\n68#2,4:357\n1#3:336\n*S KotlinDebug\n*F\n+ 1 EditorSynchronizerWithTypingSession.kt\ncom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession\n*L\n146#1:307,4\n153#1:311,4\n165#1:315,4\n168#1:319,5\n181#1:324,4\n188#1:328,4\n197#1:332,4\n100#1:337,4\n111#1:341,4\n113#1:345,4\n117#1:349,4\n123#1:353,4\n134#1:357,4\n*E\n"})
public class EditorSynchronizerWithTypingSession
extends EditorSynchronizerBase
implements DocumentListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RiderTextControlModel editorModel;
    @NotNull
    private final Suppressor suppressor;
    private boolean dontReceiveChanges;
    @NotNull
    private final List<SelectionRangeWithVersion> queuedChanges;
    @NotNull
    private SelectionVersion version;
    @NotNull
    private SelectionRange currentSelection;
    @Nullable
    private FrontendEditorTypingSession activeTypingSession;
    @NotNull
    public static final String PARANOID_CATEGORY = "#com.jetbrains.rider.editors@paranoid";
    @NotNull
    private static final Logger paranoidLogger;

    protected EditorSynchronizerWithTypingSession(@NotNull ClientAppSession session2, @NotNull Lifetime textControlLifetime, @NotNull Editor editor, @NotNull TextControlId textControlId, @NotNull RiderTextControlModel editorModel) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
        super(session2, textControlLifetime, textControlId, (TextControlModel)editorModel, editor);
        this.editorModel = editorModel;
        this.suppressor = new Suppressor();
        this.queuedChanges = new ArrayList();
        this.version = SelectionVersionExKt.getInitVersion();
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        this.currentSelection = PlatformTextControlUtilsKt.createSelectionRange(caretModel);
    }

    @NotNull
    public RiderTextControlModel getEditorModel() {
        return this.editorModel;
    }

    @NotNull
    public final Suppressor getSuppressor() {
        return this.suppressor;
    }

    @NotNull
    public final SelectionVersion getVersion() {
        return this.version;
    }

    protected void init() {
        ClientIdKt.assertClientIdConsistency$default((ClientId)new ClientId(this.getTextControlId().getClientId()), (String)"FrontendEditorSynchronizer", (boolean)false, (int)2, null);
        IOptProperty iOptProperty = this.getEditorModel().getSelection();
        Intrinsics.checkNotNull((Object)iOptProperty, (String)"null cannot be cast to non-null type com.jetbrains.rd.framework.impl.RdOptionalProperty<*>");
        ((RdOptionalProperty)iOptProperty).slave();
        super.init();
        this.suppressor.onRelease(this.getTextControlLifetime(), () -> EditorSynchronizerWithTypingSession.init$lambda$0(this));
        this.getEditorModel().getSelection().advise(this.getTextControlLifetime(), arg_0 -> EditorSynchronizerWithTypingSession.init$lambda$1(this, arg_0));
        this.getEditorModel().getScrolling().advise(this.getTextControlLifetime(), arg_0 -> EditorSynchronizerWithTypingSession.init$lambda$2(this, arg_0));
    }

    private final void flushSuppressedChanges() {
        ClientId.Companion.withClientId(this.getClientId(), () -> EditorSynchronizerWithTypingSession.flushSuppressedChanges$lambda$4(this));
    }

    protected void sendCaretStateChange(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        ClientId.Companion.withClientId(this.getClientId(), () -> EditorSynchronizerWithTypingSession.sendCaretStateChange$lambda$10(this, reason));
    }

    private final void incrementVersion() {
        Document document = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        boolean isMajorChange = !TextBufferDocumentSynchronizer.Companion.isBackendUpdateInProgress(document, this.getSession());
        this.version = SelectionVersionExKt.incrementMaster(this.version, isMajorChange);
        Logger $this$trace$iv = this.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Incrementing version: Current " + this.version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performSend(SelectionRangeWithVersion model2) {
        ClientIdKt.assertClientIdConsistency$default((ClientId)this.getClientId(), (String)"performSend", (boolean)false, (int)2, null);
        try {
            this.dontReceiveChanges = true;
            Logger $this$trace$iv = this.getLogger();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Sending selection " + PlatformTextControlUtilsKt.toDebugString(model2));
            }
            this.getEditorModel().getSelection().set((Object)model2);
        }
        finally {
            this.dontReceiveChanges = false;
        }
    }

    public void receiveSelection(@NotNull RdCaretModelChange change) {
        FrontendEditorTypingSession session2;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        SelectionRangeWithVersion cfr_ignored_0 = (SelectionRangeWithVersion)change;
        if (this.dontReceiveChanges) {
            return;
        }
        Logger $this$trace$iv = this.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Receiving selection " + PlatformTextControlUtilsKt.toDebugString((SelectionRangeWithVersion)change) + ".");
        }
        if (this.suppressor.shouldSuppress()) {
            Logger $this$debug_u24default$iv = this.getLogger();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Editor changes is suppressed.", e$iv);
            }
        }
        if ((session2 = this.activeTypingSession) != null && session2.tryPushRemoteChange((SelectionRangeWithVersion)change)) {
            return;
        }
        this.doReceiveSelection((SelectionRangeWithVersion)change);
    }

    private final void doReceiveSelection(SelectionRangeWithVersion model2) {
        if (SelectionVersionExKt.compareTo(this.version, model2.getVersion()) > 0) {
            Logger $this$trace$iv = this.getLogger();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Rejecting: local: " + PlatformTextControlUtilsKt.toDebugString(this.version) + " > remote: " + PlatformTextControlUtilsKt.toDebugString(model2.getVersion()) + ".");
            }
            return;
        }
        this.version = model2.getVersion();
        SelectionRange backendSelection = model2.getSelection();
        CaretModel caretModel = this.getEditor().getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        if (Intrinsics.areEqual((Object)PlatformTextControlUtilsKt.createSelectionRange(caretModel), (Object)backendSelection)) {
            Logger $this$trace$iv = this.getLogger();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Skipping equal selection.");
            }
            return;
        }
        this.applyBackendSelection(backendSelection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void applyBackendSelection(SelectionRange backendSelection) {
        try {
            Logger $this$trace$iv = this.getLogger();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Applying backend selection change.");
            }
            this.setDontSendChange(true);
            this.currentSelection = backendSelection;
            PlatformTextControlUtilsKt.applyTo(backendSelection, this.getEditor());
        }
        finally {
            this.setDontSendChange(false);
        }
    }

    public void receiveScrollingRequest(@NotNull ScrollingInfo request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.activeTypingSession != null) {
            return;
        }
        super.receiveScrollingRequest(request);
    }

    public void documentChanged(@NotNull DocumentEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.getEditor().isDisposed()) {
            Editor editor = this.getEditor();
            EditorImpl editorImpl = editor instanceof EditorImpl ? (EditorImpl)editor : null;
            if (editorImpl != null) {
                editorImpl.throwDisposalError("Editor is already disposed");
            } else {
                this.getLogger().error("Editor is already disposed.");
            }
        }
        ClientId.Companion.withClientId(this.getClientId(), () -> EditorSynchronizerWithTypingSession.documentChanged$lambda$18(this));
    }

    @NotNull
    public final ITypingSession<SelectionRange> startTypingSession(@NotNull Lifetime lifetime) {
        FrontendEditorTypingSession session2;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        ClientIdKt.assertClientIdConsistency$default((ClientId)this.getClientId(), (String)"FrontendEditorSynchronizer.startTypingSession", (boolean)false, (int)2, null);
        if (!(this.activeTypingSession == null)) {
            boolean bl = false;
            String string = "activeTypingSession == null";
            throw new IllegalArgumentException(string.toString());
        }
        if (!RLifetimeKt.isAlive((Lifetime)lifetime)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.activeTypingSession = session2 = new FrontendEditorTypingSession();
        lifetime.onTermination((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                EditorSynchronizerWithTypingSession.access$finishTypingSession((EditorSynchronizerWithTypingSession)((Object)this.receiver));
            }
        });
        return session2;
    }

    private final void finishTypingSession() {
        if (!(this.activeTypingSession != null)) {
            boolean bl = false;
            String string = "activeTypingSession != null";
            throw new IllegalArgumentException(string.toString());
        }
        this.activeTypingSession = null;
    }

    public final void assertEmptyChangesQueue() {
        this.getLogger().assertTrue(this.queuedChanges.isEmpty(), (Object)"queuedChanges.isEmpty()");
    }

    private static final Unit init$lambda$0(EditorSynchronizerWithTypingSession this$0) {
        this$0.flushSuppressedChanges();
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$1(EditorSynchronizerWithTypingSession this$0, SelectionRangeWithVersion it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.receiveSelection((RdCaretModelChange)it);
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$2(EditorSynchronizerWithTypingSession this$0, ScrollingInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.receiveScrollingRequest(it);
        return Unit.INSTANCE;
    }

    private static final Unit flushSuppressedChanges$lambda$4(EditorSynchronizerWithTypingSession this$0) {
        if (this$0.queuedChanges.isEmpty()) {
            return Unit.INSTANCE;
        }
        Logger $this$trace$iv = this$0.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Flushing queued selection changes (" + this$0.queuedChanges.size() + "), the last is " + PlatformTextControlUtilsKt.toDebugString((SelectionRangeWithVersion)CollectionsKt.last(this$0.queuedChanges)) + ".");
        }
        for (SelectionRangeWithVersion ch : this$0.queuedChanges) {
            this$0.performSend(ch);
        }
        this$0.queuedChanges.clear();
        return Unit.INSTANCE;
    }

    private static final Unit sendCaretStateChange$lambda$10(EditorSynchronizerWithTypingSession this$0, String $reason) {
        Logger logger;
        Logger $this$trace$iv = this$0.getLogger();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            CaretModel caretModel = this$0.getEditor().getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            logger.trace($reason + ". Selection is " + PlatformTextControlUtilsKt.toDebugString(PlatformTextControlUtilsKt.createSelectionRange(caretModel)) + ".");
        }
        if (this$0.getDontSendChange()) {
            $this$trace$iv = this$0.getLogger();
            $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Updating from backend is going.");
            }
            return Unit.INSTANCE;
        }
        $this$trace$iv = paranoidLogger;
        $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            String string = ExceptionUtil.currentStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentStackTrace(...)");
            logger.trace(string);
        }
        CaretModel caretModel = this$0.getEditor().getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        SelectionRange modelSelection = PlatformTextControlUtilsKt.createSelectionRange(caretModel);
        FrontendEditorTypingSession session2 = this$0.activeTypingSession;
        if (session2 != null && session2.isCommitting()) {
            Logger $this$trace$iv2 = this$0.getLogger();
            boolean $i$f$trace2 = false;
            if ($this$trace$iv2.isTraceEnabled()) {
                logger = $this$trace$iv2;
                boolean bl = false;
                logger.trace("Don't send selection because of committing: " + PlatformTextControlUtilsKt.toDebugString(modelSelection) + ".");
            }
            return Unit.INSTANCE;
        }
        this$0.incrementVersion();
        this$0.currentSelection = modelSelection;
        SelectionRangeWithVersion selectionWithVersion = new SelectionRangeWithVersion(modelSelection, this$0.version);
        FrontendEditorTypingSession frontendEditorTypingSession = session2;
        if (frontendEditorTypingSession != null) {
            frontendEditorTypingSession.tryPushLocalChange(modelSelection);
        }
        if (this$0.suppressor.shouldSuppress()) {
            Logger $this$trace$iv3 = this$0.getLogger();
            boolean $i$f$trace3 = false;
            if ($this$trace$iv3.isTraceEnabled()) {
                logger = $this$trace$iv3;
                boolean bl = false;
                logger.trace("Suppressing selection: " + PlatformTextControlUtilsKt.toDebugString(modelSelection) + ".");
            }
            this$0.queuedChanges.add(selectionWithVersion);
        } else {
            this$0.performSend(selectionWithVersion);
        }
        return Unit.INSTANCE;
    }

    private static final Unit documentChanged$lambda$18(EditorSynchronizerWithTypingSession this$0) {
        this$0.sendCaretStateChange("Document was changed");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$finishTypingSession(EditorSynchronizerWithTypingSession $this) {
        $this.finishTypingSession();
    }

    static {
        Logger logger = Logger.getInstance((String)PARANOID_CATEGORY);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        paranoidLogger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$Companion;", "", "<init>", "()V", "PARANOID_CATEGORY", "", "paranoidLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "create", "Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/RiderTextControlModel;", "recoverEditorsSynchronization", "", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nEditorSynchronizerWithTypingSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorSynchronizerWithTypingSession.kt\ncom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,306:1\n1563#2:307\n1634#2,3:308\n*S KotlinDebug\n*F\n+ 1 EditorSynchronizerWithTypingSession.kt\ncom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$Companion\n*L\n53#1:307\n53#1:308,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EditorSynchronizerWithTypingSession create(@NotNull ClientAppSession session2, @NotNull Lifetime textControlLifetime, @NotNull Editor editor, @NotNull TextControlId textControlId, @NotNull RiderTextControlModel editorModel) {
            EditorSynchronizerWithTypingSession editorSynchronizerWithTypingSession;
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
            Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
            EditorSynchronizerWithTypingSession $this$create_u24lambda_u240 = editorSynchronizerWithTypingSession = new EditorSynchronizerWithTypingSession(session2, textControlLifetime, editor, textControlId, editorModel);
            boolean bl = false;
            $this$create_u24lambda_u240.init();
            return editorSynchronizerWithTypingSession;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void recoverEditorsSynchronization(@NotNull RdDocumentId documentId, @NotNull ClientAppSession session2) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            FrontendTextControlHost textControlHost = FrontendTextControlHost.Companion.getInstance(session2);
            List allEditors = textControlHost.getEditorsIds(documentId);
            Iterable $this$map$iv = allEditors;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Editor editor = (Editor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)it, (Object)it.getCaretModel().getOffset()));
            }
            List editorToPrimaryCaretOffsetBefore = (List)destination$iv$iv;
            try {
                TextBufferDocumentSynchronizer.Companion.recoverDocumentModelSynchronization(documentId, session2);
            }
            catch (Throwable throwable) {
                for (Iterable iterable2 : editorToPrimaryCaretOffsetBefore) {
                    Editor editor = (Editor)iterable2.component1();
                    int caretOffset = ((Number)iterable2.component2()).intValue();
                    editor.getCaretModel().moveToOffset(caretOffset);
                    EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer((Editor)editor);
                    EditorSynchronizerWithTypingSession editorSynchronizerWithTypingSession = editorSynchronizer instanceof EditorSynchronizerWithTypingSession ? (EditorSynchronizerWithTypingSession)editorSynchronizer : null;
                    if (editorSynchronizerWithTypingSession == null) continue;
                    editorSynchronizerWithTypingSession.sendCaretStateChange("Recovering");
                }
                throw throwable;
            }
            for (Pair pair2 : editorToPrimaryCaretOffsetBefore) {
                Editor editor = (Editor)pair2.component1();
                int caretOffset = ((Number)pair2.component2()).intValue();
                editor.getCaretModel().moveToOffset(caretOffset);
                EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer((Editor)editor);
                EditorSynchronizerWithTypingSession editorSynchronizerWithTypingSession = editorSynchronizer instanceof EditorSynchronizerWithTypingSession ? (EditorSynchronizerWithTypingSession)editorSynchronizer : null;
                if (editorSynchronizerWithTypingSession == null) continue;
                editorSynchronizerWithTypingSession.sendCaretStateChange("Recovering");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0002J\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000bJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$FrontendEditorTypingSession;", "Lcom/jetbrains/rd/rdtext/ITypingSession;", "Lcom/jetbrains/rd/ide/model/SelectionRange;", "<init>", "(Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession;)V", "versionBeforeOpening", "Lcom/jetbrains/rd/ide/model/SelectionVersion;", "selectionBeforeOpening", "state", "Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$State;", "lastRemoteChange", "Lcom/jetbrains/rd/ide/model/SelectionRangeWithVersion;", "onRemoteChange", "Lcom/jetbrains/rd/util/reactive/Signal;", "getOnRemoteChange", "()Lcom/jetbrains/rd/util/reactive/Signal;", "onLocalChange", "getOnLocalChange", "isCommitting", "", "()Z", "tryPushLocalChange", "selection", "tryPushRemoteChange", "selectionWithVersion", "startCommitRemoteVersion", "", "finishCommitRemoteVersion", "rollbackRemoteVersion", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nEditorSynchronizerWithTypingSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorSynchronizerWithTypingSession.kt\ncom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$FrontendEditorTypingSession\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,306:1\n68#2,4:307\n68#2,4:311\n68#2,4:315\n1#3:319\n*S KotlinDebug\n*F\n+ 1 EditorSynchronizerWithTypingSession.kt\ncom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$FrontendEditorTypingSession\n*L\n255#1:307,4\n261#1:311,4\n270#1:315,4\n*E\n"})
    private final class FrontendEditorTypingSession
    implements ITypingSession<SelectionRange> {
        @NotNull
        private final SelectionVersion versionBeforeOpening;
        @NotNull
        private final SelectionRange selectionBeforeOpening;
        @NotNull
        private State state;
        @Nullable
        private SelectionRangeWithVersion lastRemoteChange;
        @NotNull
        private final Signal<SelectionRange> onRemoteChange;
        @NotNull
        private final Signal<SelectionRange> onLocalChange;

        public FrontendEditorTypingSession() {
            this.versionBeforeOpening = EditorSynchronizerWithTypingSession.this.getVersion();
            this.selectionBeforeOpening = EditorSynchronizerWithTypingSession.this.currentSelection;
            this.state = State.Opened;
            this.onRemoteChange = new Signal();
            this.onLocalChange = new Signal();
            EditorSynchronizerWithTypingSession.this.getEditorModel().getVersionBeforeTypingSession().set((Object)this.versionBeforeOpening);
            Logger $this$trace$iv = EditorSynchronizerWithTypingSession.this.getLogger();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("VersionBeforeTypingSession is " + PlatformTextControlUtilsKt.toDebugString(this.versionBeforeOpening));
            }
        }

        @NotNull
        public Signal<SelectionRange> getOnRemoteChange() {
            return this.onRemoteChange;
        }

        @NotNull
        public Signal<SelectionRange> getOnLocalChange() {
            return this.onLocalChange;
        }

        public final boolean isCommitting() {
            return this.state == State.Committing;
        }

        public final boolean tryPushLocalChange(@NotNull SelectionRange selection) {
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            if (this.state != State.Opened) {
                return false;
            }
            Logger $this$trace$iv = EditorSynchronizerWithTypingSession.this.getLogger();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Put local change into typing session.");
            }
            this.getOnLocalChange().fire((Object)selection);
            return true;
        }

        public final boolean tryPushRemoteChange(@NotNull SelectionRangeWithVersion selectionWithVersion) {
            Intrinsics.checkNotNullParameter((Object)selectionWithVersion, (String)"selectionWithVersion");
            if (this.state != State.Opened) {
                return false;
            }
            if (SelectionVersionExKt.compareTo(selectionWithVersion.getVersion(), this.versionBeforeOpening) < 0) {
                return false;
            }
            Logger $this$trace$iv = EditorSynchronizerWithTypingSession.this.getLogger();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Put remote change into typing session.");
            }
            SelectionRange selection = selectionWithVersion.getSelection();
            this.getOnRemoteChange().fire((Object)selection);
            this.lastRemoteChange = selectionWithVersion;
            return true;
        }

        public void startCommitRemoteVersion() {
            if (!(this.state == State.Opened)) {
                boolean bl = false;
                String string = "state == State.Opened";
                throw new IllegalArgumentException(string.toString());
            }
            this.state = State.Committing;
        }

        public void finishCommitRemoteVersion() {
            SelectionRangeWithVersion change = this.lastRemoteChange;
            if (change != null) {
                EditorSynchronizerWithTypingSession.this.version = change.getVersion();
                EditorSynchronizerWithTypingSession.this.currentSelection = change.getSelection();
            } else {
                EditorSynchronizerWithTypingSession.this.version = this.versionBeforeOpening;
                EditorSynchronizerWithTypingSession.this.currentSelection = this.selectionBeforeOpening;
            }
        }

        public void rollbackRemoteVersion() {
            if (!(this.state == State.Opened)) {
                boolean bl = false;
                String string = "state == State.Opened";
                throw new IllegalArgumentException(string.toString());
            }
            this.state = State.Closing;
            EditorSynchronizerWithTypingSession.this.sendCaretStateChange("Promote master version");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/editors/EditorSynchronizerWithTypingSession$State;", "", "<init>", "(Ljava/lang/String;I)V", "Opened", "Committing", "Closing", "intellij.rider.rdclient.dotnet"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State Opened = new State();
        public static final /* enum */ State Committing = new State();
        public static final /* enum */ State Closing = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.Opened, State.Committing, State.Closing};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

