/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors.notifications;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorNotificationPanel;
import com.jetbrains.rd.ide.model.NotificationPanelCallbackHyperlinkModel;
import com.jetbrains.rd.ide.model.NotificationPanelHyperlinkModel;
import com.jetbrains.rd.ide.model.NotificationPanelModel;
import com.jetbrains.rd.ide.model.NotificationPanelOpenSettingsHyperlinkModel;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.RiderOnly;
import com.jetbrains.rdclient.editors.FrontendTextControlHostListener;
import com.jetbrains.rider.editors.notifications.EditorModelExKt;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RiderOnly
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001f !B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J-\u0010\u0014\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0014\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u001d\u001a\u00020\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020\u0018H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/editors/notifications/NotificationPanelHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "createPanel", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "id", "", "notificationPanel", "Lcom/jetbrains/rd/ide/model/NotificationPanelModel;", "textControlModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "addHyperlinks", "project", "Lcom/intellij/openapi/project/Project;", "panel", "Lcom/jetbrains/rider/editors/notifications/NotificationPanelHost$EditorNotificationPanelModelHolder;", "links", "", "Lcom/jetbrains/rd/ide/model/NotificationPanelHyperlinkModel;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/editors/notifications/NotificationPanelHost$EditorNotificationPanelModelHolder;[Lcom/jetbrains/rd/ide/model/NotificationPanelHyperlinkModel;)V", "closePanel", "editorNotificationPanelHolder", "Companion", "NotificationsHostTextControlListener", "EditorNotificationPanelModelHolder", "intellij.rider.rdclient.dotnet"})
public class NotificationPanelHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;

    public NotificationPanelHost(@NotNull ClientAppSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
    }

    @NotNull
    public final ClientAppSession getSession() {
        return this.session;
    }

    protected void createPanel(@NotNull Lifetime lifetime, @NotNull Editor editor, int id, @NotNull NotificationPanelModel notificationPanel, @NotNull TextControlModel textControlModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)notificationPanel, (String)"notificationPanel");
        Intrinsics.checkNotNullParameter((Object)textControlModel, (String)"textControlModel");
        TextEditor textEditor = TextEditorProvider.Companion.getInstance().getTextEditor(editor);
        Project project = editor.getProject();
        EditorNotificationPanelModelHolder panel2 = new EditorNotificationPanelModelHolder((FileEditor)textEditor, textControlModel, id);
        panel2.setText(notificationPanel.getMessage());
        this.addHyperlinks(project, panel2, notificationPanel.getLinks());
        lifetime.onTermination(() -> NotificationPanelHost.createPanel$lambda$0(this, project, panel2));
        if (project != null) {
            FileEditorManager.getInstance((Project)project).addTopComponent((FileEditor)textEditor, (JComponent)((Object)panel2));
        }
    }

    protected void addHyperlinks(@Nullable Project project, @NotNull EditorNotificationPanelModelHolder panel2, @NotNull NotificationPanelHyperlinkModel[] links) {
        Intrinsics.checkNotNullParameter((Object)((Object)panel2), (String)"panel");
        Intrinsics.checkNotNullParameter((Object)links, (String)"links");
        for (NotificationPanelHyperlinkModel action2 : links) {
            NotificationPanelHyperlinkModel notificationPanelHyperlinkModel = action2;
            if (notificationPanelHyperlinkModel instanceof NotificationPanelOpenSettingsHyperlinkModel) {
                panel2.createActionLabel(action2.getText(), () -> NotificationPanelHost.addHyperlinks$lambda$1(project, action2, this, panel2), action2.getShowInIntentionMenu());
                continue;
            }
            if (!(notificationPanelHyperlinkModel instanceof NotificationPanelCallbackHyperlinkModel)) continue;
            panel2.createActionLabel(action2.getText(), () -> NotificationPanelHost.addHyperlinks$lambda$2(action2, this, project, panel2), action2.getShowInIntentionMenu());
        }
    }

    protected void closePanel(@Nullable Project project, @NotNull EditorNotificationPanelModelHolder editorNotificationPanelHolder) {
        Intrinsics.checkNotNullParameter((Object)((Object)editorNotificationPanelHolder), (String)"editorNotificationPanelHolder");
        if (project != null) {
            FileEditorManager.getInstance((Project)project).removeTopComponent(editorNotificationPanelHolder.getEditor(), (JComponent)((Object)editorNotificationPanelHolder));
        }
        IMutableViewableMap<Integer, NotificationPanelModel> iMutableViewableMap = EditorModelExKt.getNotificationPanels(editorNotificationPanelHolder.getTextControlModel());
        if (iMutableViewableMap == null) {
            return;
        }
        IMutableViewableMap<Integer, NotificationPanelModel> panels = iMutableViewableMap;
        int modelId = editorNotificationPanelHolder.getModelId();
        if (panels.containsKey((Object)modelId)) {
            panels.remove((Object)modelId);
        }
    }

    private static final Unit createPanel$lambda$0(NotificationPanelHost this$0, Project $project, EditorNotificationPanelModelHolder $panel) {
        this$0.closePanel($project, $panel);
        return Unit.INSTANCE;
    }

    private static final void addHyperlinks$lambda$1(Project $project, NotificationPanelHyperlinkModel $action, NotificationPanelHost this$0, EditorNotificationPanelModelHolder $panel) {
        ShowSettingsUtil.getInstance().showSettingsDialog($project, ((NotificationPanelOpenSettingsHyperlinkModel)$action).getConfigurableId());
        if ($action.getCloseAfterClick()) {
            this$0.closePanel($project, $panel);
        }
    }

    private static final void addHyperlinks$lambda$2(NotificationPanelHyperlinkModel $action, NotificationPanelHost this$0, Project $project, EditorNotificationPanelModelHolder $panel) {
        InterfacesKt.fire((ISignal)((NotificationPanelCallbackHyperlinkModel)$action).getClicked());
        if ($action.getCloseAfterClick()) {
            this$0.closePanel($project, $panel);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/editors/notifications/NotificationPanelHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/editors/notifications/NotificationPanelHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nNotificationPanelHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationPanelHost.kt\ncom/jetbrains/rider/editors/notifications/NotificationPanelHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,91:1\n30#2,2:92\n*S KotlinDebug\n*F\n+ 1 NotificationPanelHost.kt\ncom/jetbrains/rider/editors/notifications/NotificationPanelHost$Companion\n*L\n22#1:92,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NotificationPanelHost getInstance(@NotNull ClientAppSession session2) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            ComponentManager $this$service$iv = (ComponentManager)session2;
            boolean $i$f$service = false;
            Class<NotificationPanelHost> serviceClass$iv = NotificationPanelHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (NotificationPanelHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/editors/notifications/NotificationPanelHost$EditorNotificationPanelModelHolder;", "Lcom/intellij/ui/EditorNotificationPanel;", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "textControlModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "modelId", "", "<init>", "(Lcom/intellij/openapi/fileEditor/FileEditor;Lcom/jetbrains/rd/ide/model/TextControlModel;I)V", "getEditor", "()Lcom/intellij/openapi/fileEditor/FileEditor;", "getTextControlModel", "()Lcom/jetbrains/rd/ide/model/TextControlModel;", "getModelId", "()I", "intellij.rider.rdclient.dotnet"})
    protected static final class EditorNotificationPanelModelHolder
    extends EditorNotificationPanel {
        @NotNull
        private final FileEditor editor;
        @NotNull
        private final TextControlModel textControlModel;
        private final int modelId;

        public EditorNotificationPanelModelHolder(@NotNull FileEditor editor, @NotNull TextControlModel textControlModel, int modelId) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)textControlModel, (String)"textControlModel");
            super(editor, EditorNotificationPanel.Status.Warning);
            this.editor = editor;
            this.textControlModel = textControlModel;
            this.modelId = modelId;
        }

        @NotNull
        public final FileEditor getEditor() {
            return this.editor;
        }

        @NotNull
        public final TextControlModel getTextControlModel() {
            return this.textControlModel;
        }

        public final int getModelId() {
            return this.modelId;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/editors/notifications/NotificationPanelHost$NotificationsHostTextControlListener;", "Lcom/jetbrains/rdclient/editors/FrontendTextControlHostListener;", "<init>", "()V", "editorBound", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.rider.rdclient.dotnet"})
    public static final class NotificationsHostTextControlListener
    implements FrontendTextControlHostListener {
        public void editorBound(@NotNull Lifetime lifetime, @NotNull ClientAppSession appSession, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
                Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
                Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                IMutableViewableMap<Integer, NotificationPanelModel> iMutableViewableMap = EditorModelExKt.getNotificationPanels(editorModel);
                if (iMutableViewableMap == null) break block0;
                iMutableViewableMap.view(lifetime, (arg_0, arg_1, arg_2) -> NotificationsHostTextControlListener.editorBound$lambda$0(appSession, editor, editorModel, arg_0, arg_1, arg_2));
            }
        }

        private static final Unit editorBound$lambda$0(ClientAppSession $appSession, Editor $editor, TextControlModel $editorModel, Lifetime panelLifetime, int id, NotificationPanelModel panel2) {
            Intrinsics.checkNotNullParameter((Object)panelLifetime, (String)"panelLifetime");
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            Companion.getInstance($appSession).createPanel(panelLifetime, $editor, id, panel2, $editorModel);
            return Unit.INSTANCE;
        }
    }
}

