/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SingleAlarm;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.ideaInterop.vfs.VfsWarmQueue;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootFilter;
import com.jetbrains.rider.ideaInterop.vfs.VfsWatchRootManager;
import com.jetbrains.rider.model.RdSyncRequest;
import com.jetbrains.rider.model.RdWatchRootInfo;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelEvents;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u00020\u00152\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001d0\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "filter", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootFilter;", "warmQueue", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWarmQueue;", "manager", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootManager;", "alarm", "Lcom/intellij/util/SingleAlarm;", "initialized", "", "isReady", "()Z", "dump", "", "sync", "", "startup", "syncRequestHandler", "request", "Lcom/jetbrains/rider/model/RdSyncRequest;", "watchRootsHandler", "event", "Lcom/jetbrains/rd/util/reactive/IViewableMap$Event;", "Lcom/jetbrains/rider/model/RdWatchRootInfo;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nVfsWatchRootHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsWatchRootHost.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootHost\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,109:1\n13#2:110\n14#3:111\n*S KotlinDebug\n*F\n+ 1 VfsWatchRootHost.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootHost\n*L\n24#1:110\n24#1:111\n*E\n"})
public final class VfsWatchRootHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VfsWatchRootFilter filter;
    @NotNull
    private final VfsWarmQueue warmQueue;
    @NotNull
    private final VfsWatchRootManager manager;
    @NotNull
    private final SingleAlarm alarm;
    private boolean initialized;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final StringBuilder eventLog;

    public VfsWatchRootHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.filter = new VfsWatchRootFilter(this.project);
        this.warmQueue = new VfsWarmQueue(this.project, this.filter, (Disposable)this);
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        this.manager = new VfsWatchRootManager(localFileSystem, this.filter);
        SingleAlarm.Companion companion = SingleAlarm.Companion;
        Runnable runnable = () -> VfsWatchRootHost.alarm$lambda$0(this);
        this.alarm = companion.singleEdtAlarm(100, (Disposable)this, runnable);
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)WorkspaceModelEvents.Companion.getInstance(this.project).getSynced()), (Lifetime)ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), arg_0 -> VfsWatchRootHost._init_$lambda$1(this, arg_0));
        this.getServiceLifetime().onTermination(() -> VfsWatchRootHost._init_$lambda$2(this));
    }

    public final boolean isReady() {
        return this.warmQueue.isReady();
    }

    @NotNull
    public final String dump() {
        return this.manager.dump();
    }

    public final void sync() {
        this.manager.update();
    }

    public final void startup() {
        this.warmQueue.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void syncRequestHandler(@NotNull RdSyncRequest request) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        try {
            this.sync();
        }
        finally {
            InterfacesKt.fire(request.getReady());
        }
    }

    public final void watchRootsHandler(@NotNull IViewableMap.Event<String, RdWatchRootInfo> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (!this.project.isOpen()) {
            return;
        }
        File file = new File((String)event.getKey());
        VfsWatchRootManager.QueueFileItem old = null;
        VfsWatchRootManager.QueueFileItem queueFileItem = null;
        IViewableMap.Event<String, RdWatchRootInfo> event2 = event;
        if (event2 instanceof IViewableMap.Event.Add) {
            VfsWatchRootManager.QueueFileItem queueFileItem2;
            logger.trace("Add '" + file + "'$");
            old = null;
            VfsWatchRootManager.QueueFileItem queueFileItem3 = VfsWatchRootManager.QueueFileItem.Companion.create(file, (RdWatchRootInfo)((IViewableMap.Event.Add)event).getNewValue());
            if (queueFileItem3 != null) {
                VfsWatchRootManager.QueueFileItem queueFileItem4;
                VfsWatchRootManager.QueueFileItem $this$watchRootsHandler_u24lambda_u243 = queueFileItem4 = queueFileItem3;
                boolean bl = false;
                this.warmQueue.enqueue($this$watchRootsHandler_u24lambda_u243.getFile(), $this$watchRootsHandler_u24lambda_u243.isRecursive());
                queueFileItem2 = queueFileItem4;
            } else {
                queueFileItem2 = null;
            }
            queueFileItem = queueFileItem2;
        } else if (event2 instanceof IViewableMap.Event.Update) {
            logger.trace("Update '" + file + "'$");
            old = VfsWatchRootManager.QueueFileItem.Companion.create(file, (RdWatchRootInfo)((IViewableMap.Event.Update)event).getOldValue());
            queueFileItem = VfsWatchRootManager.QueueFileItem.Companion.create(file, (RdWatchRootInfo)((IViewableMap.Event.Update)event).getNewValue());
        } else if (event2 instanceof IViewableMap.Event.Remove) {
            logger.trace("Remove '" + file + "'$");
            old = VfsWatchRootManager.QueueFileItem.Companion.create(file, (RdWatchRootInfo)((IViewableMap.Event.Remove)event).getOldValue());
            queueFileItem = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.manager.register(new VfsWatchRootManager.QueueItem(file, old, queueFileItem));
        if (this.initialized) {
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this.alarm, (boolean)false, (int)1, null);
        }
    }

    private static final void alarm$lambda$0(VfsWatchRootHost this$0) {
        this$0.sync();
    }

    private static final Unit _init_$lambda$1(VfsWatchRootHost this$0, Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.initialized = true;
        this$0.sync();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(VfsWatchRootHost this$0) {
        this$0.manager.cleanup();
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VfsWatchRootHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        VfsWatchRootHost.logger = logger;
        eventLog = new StringBuilder();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootHost$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "eventLog", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getInstance", "Lcom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootHost;", "project", "Lcom/intellij/openapi/project/Project;", "reportEventLog", "", "message", "", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nVfsWatchRootHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VfsWatchRootHost.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,109:1\n30#2,2:110\n*S KotlinDebug\n*F\n+ 1 VfsWatchRootHost.kt\ncom/jetbrains/rider/ideaInterop/vfs/VfsWatchRootHost$Companion\n*L\n27#1:110,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VfsWatchRootHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<VfsWatchRootHost> serviceClass$iv = VfsWatchRootHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (VfsWatchRootHost)((Object)object);
        }

        public final void reportEventLog(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (!ApplicationKt.getApplication().isInternal()) {
                return;
            }
            eventLog.append(message).append('\n');
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

