/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.vfs.structure;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.ideaInterop.vfs.structure.FilePathComponentComparator;
import com.jetbrains.rider.ideaInterop.vfs.structure.FilePathTreeVisitor;
import com.jetbrains.rider.ideaInterop.vfs.structure.VisitResult;
import java.io.File;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 9*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u000389:B!\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\u0006J\u0015\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001b0\u001e2\u0006\u0010\u0016\u001a\u00020\u001bJ\u0013\u0010\u001f\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u001bJ\u001b\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u001b\u00a2\u0006\u0002\u0010#J2\u0010$\u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&2\u001c\b\u0002\u0010'\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\u001e\u0018\u00010(Jm\u0010)\u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&2\b\u0010\u0016\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00028\u00002\b\u0010*\u001a\u0004\u0018\u00010\u00032\u0018\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0,0\u000f2\u001a\u0010'\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u00000\u001e\u0018\u00010(H\u0002\u00a2\u0006\u0002\u0010-JE\u0010.\u001a\u0010\u0012\u0004\u0012\u00020/\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001e2\f\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000&2\b\u0010\u0016\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\"\u001a\u00028\u00002\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0002\u00100J\u0015\u00101\u001a\u0004\u0018\u00018\u00002\u0006\u0010\"\u001a\u00028\u0000\u00a2\u0006\u0002\u00102J\u001d\u00103\u001a\u0004\u0018\u00018\u00002\u0006\u0010\"\u001a\u00028\u00002\u0006\u00104\u001a\u00020\u000e\u00a2\u0006\u0002\u00105J\u0010\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u000eH\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR&\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u000fj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u0000`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u000fj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree;", "T", "Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "", "entryFactory", "Lkotlin/Function2;", "", "<init>", "(Lkotlin/jvm/functions/Function2;)V", "nextId", "root", "Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "childrenMap", "Ljava/util/TreeMap;", "", "Ljava/util/HashMap;", "entryMap", "Lkotlin/collections/HashMap;", "entryToNameMap", "interner", "Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$StringInterner;", "get", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "getNameById", "i", "Ljava/io/File;", "(Ljava/io/File;)Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "getOrFindExistingParent", "Lkotlin/Pair;", "getOrCreate", "removeIfEmpty", "", "entry", "(Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;Ljava/io/File;)V", "visit", "visitor", "Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTreeVisitor;", "comparator", "Ljava/util/Comparator;", "visitInternal", "context", "allChildren", "Ljava/util/ArrayList;", "(Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTreeVisitor;Ljava/io/File;Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;Ljava/lang/Object;Ljava/util/HashMap;Ljava/util/Comparator;)V", "doVisit", "Lcom/jetbrains/rider/ideaInterop/vfs/structure/VisitResult;", "(Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTreeVisitor;Ljava/io/File;Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;Ljava/lang/Object;)Lkotlin/Pair;", "getParent", "(Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;)Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "getChild", "pathComponent", "(Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;Ljava/lang/String;)Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "normalize", "part", "StringInterner", "Companion", "Entry", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nFilePathTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilePathTree.kt\ncom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,209:1\n382#2,7:210\n382#2,7:217\n*S KotlinDebug\n*F\n+ 1 FilePathTree.kt\ncom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree\n*L\n85#1:210,7\n132#1:217,7\n*E\n"})
public final class FilePathTree<T extends Entry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function2<Integer, Integer, T> entryFactory;
    private int nextId;
    @NotNull
    private final T root;
    @NotNull
    private final TreeMap<String, HashMap<Integer, T>> childrenMap;
    @NotNull
    private final HashMap<Integer, T> entryMap;
    @NotNull
    private final HashMap<Integer, String> entryToNameMap;
    @NotNull
    private final StringInterner interner;
    private static final int RootId;

    public FilePathTree(@NotNull Function2<? super Integer, ? super Integer, ? extends T> entryFactory) {
        Intrinsics.checkNotNullParameter(entryFactory, (String)"entryFactory");
        this.entryFactory = entryFactory;
        this.nextId = RootId + 1;
        this.root = (Entry)this.entryFactory.invoke((Object)RootId, (Object)(RootId - 1));
        this.childrenMap = new TreeMap(FilePathComponentComparator.INSTANCE);
        this.entryMap = new HashMap();
        this.entryToNameMap = new HashMap();
        this.interner = new StringInterner();
        this.entryMap.put(((Entry)this.root).getId(), this.root);
        this.entryToNameMap.put(((Entry)this.root).getId(), "");
    }

    @Nullable
    public final T get(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File file2 = VfsUtil.virtualToIoFile((VirtualFile)file);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"virtualToIoFile(...)");
        return this.get(file2);
    }

    @Nullable
    public final String getNameById(int i) {
        return this.entryToNameMap.get(i);
    }

    @Nullable
    public final T get(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List list = FileUtil.splitPath((String)file.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"splitPath(...)");
        List parts = list;
        T entry2 = this.root;
        for (String part : parts) {
            Intrinsics.checkNotNull((Object)part);
            if (this.getChild(entry2, part) != null) continue;
            return null;
        }
        return entry2;
    }

    @NotNull
    public final Pair<T, File> getOrFindExistingParent(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List list = FileUtil.splitPath((String)file.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"splitPath(...)");
        List parts = list;
        T entry2 = this.root;
        Iterator iterator = ((Iterable)parts).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            String part = (String)iterator.next();
            Intrinsics.checkNotNull((Object)part);
            T childEntry = this.getChild(entry2, part);
            if (childEntry == null) {
                File currentFile = file;
                int n2 = ((Collection)parts).size() - index;
                for (int i = 0; i < n2; ++i) {
                    File parentFile = currentFile.getParentFile();
                    if (parentFile == null) continue;
                    currentFile = parentFile;
                }
                return new Pair(entry2, (Object)currentFile);
            }
            entry2 = childEntry;
        }
        return new Pair(entry2, (Object)file);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final T getOrCreate(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List list = FileUtil.splitPath((String)file.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"splitPath(...)");
        List parts = list;
        T entry2 = this.root;
        for (String part : parts) {
            Intrinsics.checkNotNull((Object)part);
            Object childEntry = this.getChild(entry2, part);
            if (childEntry == null) {
                Object object;
                void $this$getOrPut$iv;
                int n = this.nextId;
                this.nextId = n + 1;
                childEntry = (Entry)this.entryFactory.invoke((Object)n, (Object)((Entry)entry2).getId());
                this.entryMap.put(((Entry)childEntry).getId(), childEntry);
                ((Collection)((Entry)entry2).getChildren()).add(((Entry)childEntry).getId());
                String normalizedPart = this.interner.intern(this.normalize(part));
                Map map = this.childrenMap;
                String key$iv = normalizedPart;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    HashMap answer$iv = new HashMap();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                HashMap map2 = (HashMap)object;
                map2.put(((Entry)entry2).getId(), childEntry);
                ((Map)this.entryToNameMap).put(((Entry)childEntry).getId(), normalizedPart);
            }
            entry2 = childEntry;
        }
        return entry2;
    }

    public final void removeIfEmpty(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        T t = this.get(file);
        if (t == null) {
            return;
        }
        T entry2 = t;
        this.removeIfEmpty(entry2, file);
    }

    public final void removeIfEmpty(@NotNull T entry2, @NotNull File file) {
        Intrinsics.checkNotNullParameter(entry2, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        int eid = ((Entry)entry2).getId();
        if (!this.entryMap.containsKey(eid)) {
            return;
        }
        if (!((Entry)entry2).isEmpty()) {
            return;
        }
        Object object = (Entry)this.entryMap.get(eid);
        boolean bl = object != null && (object = ((Entry)object).getChildren()) != null ? !((Collection)object).isEmpty() : false;
        if (bl) {
            return;
        }
        this.entryMap.remove(eid);
        HashMap<Integer, T> children = this.childrenMap.get(file.getName());
        if (children != null) {
            children.remove(((Entry)entry2).getParentId());
            if (children.isEmpty()) {
                this.childrenMap.remove(file.getName());
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                this.interner.remove(string);
            }
        }
        Entry entry3 = (Entry)this.entryMap.get(((Entry)entry2).getParentId());
        if (entry3 == null) {
            return;
        }
        Entry parentEntry = entry3;
        parentEntry.getChildren().remove(eid);
        File file2 = file.getParentFile();
        if (file2 == null) {
            return;
        }
        File parentFile = file2;
        this.removeIfEmpty(parentEntry, parentFile);
    }

    /*
     * WARNING - void declaration
     */
    public final void visit(@NotNull FilePathTreeVisitor<? super T> visitor2, @Nullable Comparator<Pair<String, T>> comparator) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        HashMap<Integer, ArrayList<String>> children = new HashMap<Integer, ArrayList<String>>();
        for (Map.Entry entry2 : ((Map)this.childrenMap).entrySet()) {
            String childName = (String)entry2.getKey();
            HashMap childList = (HashMap)entry2.getValue();
            Iterator iterator = ((Map)childList).entrySet().iterator();
            while (iterator.hasNext()) {
                Object object;
                void $this$getOrPut$iv;
                int id = ((Number)iterator.next().getKey()).intValue();
                Map map = children;
                Integer key$iv = id;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    ArrayList answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ArrayList nameList = (ArrayList)object;
                nameList.add(childName);
            }
        }
        this.visitInternal(visitor2, null, this.root, null, children, comparator);
    }

    public static /* synthetic */ void visit$default(FilePathTree filePathTree, FilePathTreeVisitor filePathTreeVisitor, Comparator comparator, int n, Object object) {
        if ((n & 2) != 0) {
            comparator = null;
        }
        filePathTree.visit(filePathTreeVisitor, comparator);
    }

    private final void visitInternal(FilePathTreeVisitor<? super T> visitor2, File file, T entry2, Object context, HashMap<Integer, ArrayList<String>> allChildren2, Comparator<Pair<String, T>> comparator) {
        ProgressManager.checkCanceled();
        Pair<VisitResult, Object> pair2 = this.doVisit(visitor2, file, entry2, context);
        VisitResult result2 = (VisitResult)((Object)pair2.component1());
        Object childContext = pair2.component2();
        if (result2 == VisitResult.Stop) {
            return;
        }
        ArrayList<Pair> children = new ArrayList<Pair>();
        ArrayList<String> arrayList = allChildren2.get(((Entry)entry2).getId());
        if (arrayList == null) {
            return;
        }
        ArrayList<String> childList = arrayList;
        Iterator<String> iterator = childList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<String> iterator2 = iterator;
        while (iterator2.hasNext()) {
            String childName;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            T child = this.getChild(entry2, childName);
            if (child == null) continue;
            children.add(new Pair((Object)childName, child));
        }
        if (comparator != null) {
            CollectionsKt.sortWith((List)children, comparator);
        }
        Iterator iterator3 = children.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            String string = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"next(...)");
            Pair pair3 = (Pair)string;
            String childName = (String)pair3.component1();
            Entry childNode = (Entry)pair3.component2();
            File childFile = new File(file, childName);
            this.visitInternal(visitor2, childFile, childNode, childContext, allChildren2, comparator);
        }
    }

    private final Pair<VisitResult, Object> doVisit(FilePathTreeVisitor<? super T> visitor2, File file, T entry2, Object context) {
        if (file == null) {
            return new Pair((Object)VisitResult.Continue, context);
        }
        return visitor2.visitEntry(file, entry2, context);
    }

    @Nullable
    public final T getParent(@NotNull T entry2) {
        Intrinsics.checkNotNullParameter(entry2, (String)"entry");
        ProgressManager.checkCanceled();
        return (T)((Entry)this.entryMap.get(((Entry)entry2).getParentId()));
    }

    @Nullable
    public final T getChild(@NotNull T entry2, @NotNull String pathComponent) {
        Intrinsics.checkNotNullParameter(entry2, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)pathComponent, (String)"pathComponent");
        ProgressManager.checkCanceled();
        String normalizedPart = this.normalize(pathComponent);
        HashMap<Integer, T> hashMap = this.childrenMap.get(normalizedPart);
        if (hashMap == null) {
            return null;
        }
        HashMap<Integer, T> map = hashMap;
        return (T)((Entry)map.get(((Entry)entry2).getId()));
    }

    private final String normalize(String part) {
        if (SystemInfo.isMac) {
            String string = Normalizer.normalize(part, Normalizer.Form.NFC);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalize(...)");
            return string;
        }
        if (SystemInfo.isWindows && StringsKt.endsWith$default((String)part, (String)":", (boolean)false, (int)2, null)) {
            return part + "\\";
        }
        return part;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Companion;", "", "<init>", "()V", "RootId", "", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$Entry;", "", "id", "", "parentId", "children", "", "<init>", "(IILjava/util/Set;)V", "getId", "()I", "getParentId", "getChildren", "()Ljava/util/Set;", "isEmpty", "", "intellij.rider.rdclient.dotnet"})
    public static abstract class Entry {
        private final int id;
        private final int parentId;
        @NotNull
        private final Set<Integer> children;

        public Entry(int id, int parentId, @NotNull Set<Integer> children) {
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.id = id;
            this.parentId = parentId;
            this.children = children;
        }

        public /* synthetic */ Entry(int n, int n2, Set set, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                set = new HashSet();
            }
            this(n, n2, set);
        }

        public final int getId() {
            return this.id;
        }

        public final int getParentId() {
            return this.parentId;
        }

        @NotNull
        public final Set<Integer> getChildren() {
            return this.children;
        }

        public abstract boolean isEmpty();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0006R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$StringInterner;", "", "<init>", "()V", "set", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "intern", "name", "remove", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nFilePathTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilePathTree.kt\ncom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$StringInterner\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,209:1\n382#2,7:210\n*S KotlinDebug\n*F\n+ 1 FilePathTree.kt\ncom/jetbrains/rider/ideaInterop/vfs/structure/FilePathTree$StringInterner\n*L\n15#1:210,7\n*E\n"})
    private static final class StringInterner {
        @NotNull
        private final HashMap<String, String> set = new HashMap();

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String intern(@NotNull String name) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Map map = this.set;
            String key$iv = name;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                String answer$iv = name;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (String)object;
        }

        @Nullable
        public final String remove(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.set.remove(name);
        }
    }
}

