/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.internal.dump;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.platform.internal.DumpAction;
import com.jetbrains.rider.settings.RdClientDotnetBundle;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/internal/dump/DumpShortcutsAction;", "Lcom/jetbrains/rd/platform/internal/DumpAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "printShortcuts", "keymap", "Lcom/intellij/openapi/keymap/Keymap;", "id", "", "writer", "Ljava/io/OutputStreamWriter;", "intellij.rider.rdclient.dotnet"})
public final class DumpShortcutsAction
extends DumpAction {
    public DumpShortcutsAction() {
        super(RdClientDotnetBundle.INSTANCE.message("action.keyboard.shortcuts.text", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ActionManagerEx actionManager = ActionManagerEx.Companion.getInstanceEx();
        List list = actionManager.getActionIdList("");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getActionIdList(...)");
        List registeredActionIds = list;
        Keymap defKeymap = KeymapManagerEx.getInstanceEx().getKeymap("$default");
        Keymap rsKeymap = KeymapManagerEx.getInstanceEx().getKeymap("ReSharper");
        Keymap vsKeymap = KeymapManagerEx.getInstanceEx().getKeymap("Visual Studio");
        Keymap rdKeymap = KeymapManagerEx.getInstanceEx().getKeymap("Rider");
        Keymap osxKeymap = KeymapManagerEx.getInstanceEx().getKeymap("Mac OS X");
        Keymap rsMacKeymap = KeymapManagerEx.getInstanceEx().getKeymap("ReSharper OSX");
        Keymap vsMacKeymap = KeymapManagerEx.getInstanceEx().getKeymap("Visual Studio OSX");
        Keymap rdMacKeymap = KeymapManagerEx.getInstanceEx().getKeymap("Rider OSX");
        this.dump(project2, arg_0 -> DumpShortcutsAction.actionPerformed$lambda$0(registeredActionIds, actionManager, defKeymap, vsKeymap, this, rsKeymap, rdKeymap, osxKeymap, vsMacKeymap, rsMacKeymap, rdMacKeymap, arg_0));
    }

    private final void printShortcuts(Keymap keymap, String id, OutputStreamWriter writer) {
        Shortcut[] shortcutArray = keymap;
        if (keymap == null || (shortcutArray = shortcutArray.getShortcuts(id)) == null) {
            return;
        }
        Shortcut[] shortcuts = shortcutArray;
        Object[] objectArray = new Object[]{"\t" + keymap.getName()};
        writer.append(String.format("%-38s", objectArray));
        for (Shortcut shortcut : shortcuts) {
            Map conflicts;
            writer.append("\t " + KeymapUtil.getShortcutText((Shortcut)shortcut));
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)keymap.getConflicts(id, (KeyboardShortcut)shortcut), (String)"getConflicts(...)");
            if (!(!conflicts.isEmpty())) continue;
            writer.append(" (Conflicts with:");
            for (String confId : conflicts.keySet()) {
                Object v = conflicts.get(confId);
                Intrinsics.checkNotNull(v);
                for (KeyboardShortcut s : (List)v) {
                    writer.append(" " + confId);
                }
            }
            writer.append(")");
        }
        writer.append("\n");
    }

    private static final Unit actionPerformed$lambda$0(List $registeredActionIds, ActionManagerEx $actionManager, Keymap $defKeymap, Keymap $vsKeymap, DumpShortcutsAction this$0, Keymap $rsKeymap, Keymap $rdKeymap, Keymap $osxKeymap, Keymap $vsMacKeymap, Keymap $rsMacKeymap, Keymap $rdMacKeymap, OutputStreamWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        ((Appendable)writer).append("=== Keyboard Shortcuts ===\n").append('\n');
        for (String id : $registeredActionIds) {
            AnAction action2 = $actionManager.getAction(id);
            if (action2 != null) {
                String text;
                Shortcut[] shortcutArray = $defKeymap;
                boolean bl = $defKeymap != null && (shortcutArray = shortcutArray.getShortcuts(id)) != null ? shortcutArray.length == 0 : false;
                if (bl) {
                    Shortcut[] shortcutArray2 = $vsKeymap;
                    if ($vsKeymap != null && (shortcutArray2 = shortcutArray2.getShortcuts(id)) != null ? shortcutArray2.length == 0 : false) continue;
                }
                if ((text = action2.getTemplatePresentation().getText()) == null || ((CharSequence)text).length() == 0) {
                    text = id;
                }
                Appendable appendable = writer;
                Object[] objectArray = new Object[]{id, text};
                appendable.append(String.format("%-40s%s", objectArray)).append('\n');
                Intrinsics.checkNotNull((Object)id);
                this$0.printShortcuts((Keymap)$defKeymap, id, writer);
                this$0.printShortcuts((Keymap)$vsKeymap, id, writer);
                this$0.printShortcuts($rsKeymap, id, writer);
                this$0.printShortcuts($rdKeymap, id, writer);
                this$0.printShortcuts($osxKeymap, id, writer);
                this$0.printShortcuts($vsMacKeymap, id, writer);
                this$0.printShortcuts($rsMacKeymap, id, writer);
                this$0.printShortcuts($rdMacKeymap, id, writer);
            }
            ((Appendable)writer).append("\n").append('\n');
        }
        return Unit.INSTANCE;
    }
}

