/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.util.reactive.RdFault;
import com.jetbrains.rider.model.ProjectModelTasks_PregeneratedKt;
import com.jetbrains.rider.model.RdAddItemsCommand;
import com.jetbrains.rider.model.RdExcludeItemsCommand;
import com.jetbrains.rider.model.RdProjectModelCommand;
import com.jetbrains.rider.model.RdRenameItemsCommand;
import com.jetbrains.rider.projectView.ProjectModelEventsFlushStrategy;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.util.idea.ExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0014\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010J\u0006\u0010\u0011\u001a\u00020\fJ\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/projectView/ProjectModelEventsService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "commands", "", "Lcom/jetbrains/rider/model/RdProjectModelCommand;", "strategy", "Lcom/jetbrains/rider/projectView/ProjectModelEventsFlushStrategy;", "changeStrategy", "", "newStrategy", "addCommands", "command", "", "flush", "getCommandsAndClear", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nProjectModelEventsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectModelEventsService.kt\ncom/jetbrains/rider/projectView/ProjectModelEventsService\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,64:1\n13#2:65\n14#3:66\n*S KotlinDebug\n*F\n+ 1 ProjectModelEventsService.kt\ncom/jetbrains/rider/projectView/ProjectModelEventsService\n*L\n16#1:65\n16#1:66\n*E\n"})
public final class ProjectModelEventsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<RdProjectModelCommand> commands;
    @NotNull
    private ProjectModelEventsFlushStrategy strategy;
    @NotNull
    private static final Logger logger;

    public ProjectModelEventsService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.commands = new ArrayList();
        this.strategy = ProjectModelEventsFlushStrategy.Default;
    }

    public final void changeStrategy(@NotNull ProjectModelEventsFlushStrategy newStrategy) {
        Intrinsics.checkNotNullParameter((Object)((Object)newStrategy), (String)"newStrategy");
        this.flush();
        this.strategy = newStrategy;
    }

    public final void addCommands(@NotNull List<? extends RdProjectModelCommand> command) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        ApplicationKt.getApplication().assertIsDispatchThread();
        this.commands.addAll((Collection<RdProjectModelCommand>)command);
    }

    public final void flush() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        if (this.strategy == ProjectModelEventsFlushStrategy.Manual) {
            return;
        }
        List commandsCopy = CollectionsKt.toList((Iterable)this.commands);
        this.commands.clear();
        for (RdProjectModelCommand command : commandsCopy) {
            try {
                RdProjectModelCommand rdProjectModelCommand = command;
                if (rdProjectModelCommand instanceof RdAddItemsCommand) {
                    ExtensionsKt.syncFromBackend$default((IRdCall)ProjectModelTasks_PregeneratedKt.getProjectModelTasks(SolutionHostExtensionsKt.getSolution(this.project)).getAddItems(), command, this.project, null, null, 12, null);
                    continue;
                }
                if (rdProjectModelCommand instanceof RdExcludeItemsCommand) {
                    ExtensionsKt.syncFromBackend$default((IRdCall)ProjectModelTasks_PregeneratedKt.getProjectModelTasks(SolutionHostExtensionsKt.getSolution(this.project)).getExclude(), command, this.project, null, null, 12, null);
                    continue;
                }
                if (!(rdProjectModelCommand instanceof RdRenameItemsCommand)) continue;
                ExtensionsKt.syncFromBackend$default((IRdCall)ProjectModelTasks_PregeneratedKt.getProjectModelTasks(SolutionHostExtensionsKt.getSolution(this.project)).getRename(), command, this.project, null, null, 12, null);
            }
            catch (RdFault ex) {
                logger.warn((Throwable)ex);
            }
        }
    }

    @NotNull
    public final List<RdProjectModelCommand> getCommandsAndClear() {
        if (this.strategy != ProjectModelEventsFlushStrategy.Manual) {
            return CollectionsKt.emptyList();
        }
        List toReturn = CollectionsKt.toList((Iterable)this.commands);
        this.commands.clear();
        return toReturn;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProjectModelEventsService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProjectModelEventsService.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/projectView/ProjectModelEventsService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/projectView/ProjectModelEventsService;", "project", "Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nProjectModelEventsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectModelEventsService.kt\ncom/jetbrains/rider/projectView/ProjectModelEventsService$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,64:1\n17#2,2:65\n*S KotlinDebug\n*F\n+ 1 ProjectModelEventsService.kt\ncom/jetbrains/rider/projectView/ProjectModelEventsService$Companion\n*L\n15#1:65,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProjectModelEventsService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$getService$iv = (ComponentManager)project;
            boolean $i$f$getService = false;
            Object object = $this$getService$iv.getService(ProjectModelEventsService.class);
            if (object == null) {
                throw new IllegalStateException("Service " + ProjectModelEventsService.class + " not found in container " + $this$getService$iv);
            }
            return (ProjectModelEventsService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

