/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.RdConfigurationAndPlatform;
import com.jetbrains.rd.ide.model.RdSolutionOpenStrategy;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.SolutionOpenStrategyProvider;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.protocol.ProtocolKeys;
import com.jetbrains.rider.protocol.ProtocolManager;
import com.jetbrains.rider.protocol.components.SolutionHost;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/projectView/SolutionInitializer;", "", "<init>", "()V", "solutionKey", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rider/projectView/SolutionInitializer$SolutionKey;", "getSolutionKey", "()Lcom/intellij/openapi/util/Key;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "solutionInitializationLifetimeKey", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "finishInitialization", "", "project", "Lcom/intellij/openapi/project/Project;", "initSolution", "strategy", "Lcom/jetbrains/rd/ide/model/RdSolutionOpenStrategy;", "solutionOpenStrategy", "protocolHost", "Lcom/jetbrains/rider/protocol/IProtocolHostWithBackend;", "Service", "SolutionKey", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nSolutionInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolutionInitializer.kt\ncom/jetbrains/rider/projectView/SolutionInitializer\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,124:1\n13#2:125\n14#3:126\n14#3:127\n*S KotlinDebug\n*F\n+ 1 SolutionInitializer.kt\ncom/jetbrains/rider/projectView/SolutionInitializer\n*L\n60#1:125\n60#1:126\n26#1:127\n*E\n"})
public final class SolutionInitializer {
    @NotNull
    public static final SolutionInitializer INSTANCE = new SolutionInitializer();
    @NotNull
    private static final Key<SolutionKey> solutionKey = new Key("SolutionKey");
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<LifetimeDefinition> solutionInitializationLifetimeKey;

    private SolutionInitializer() {
    }

    @NotNull
    public final Key<SolutionKey> getSolutionKey() {
        return solutionKey;
    }

    public final void finishInitialization(@NotNull Project project) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            logger.info("Finish initialization");
            LifetimeDefinition lifetimeDefinition = (LifetimeDefinition)project.getUserData(solutionInitializationLifetimeKey);
            if (lifetimeDefinition == null) break block0;
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
    }

    public final void initSolution(@NotNull Project project, @NotNull RdSolutionOpenStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        if (project.isDefault()) {
            return;
        }
        logger.info("Create protocol solution...");
        ProtocolManager protocolManager = ApplicationProtocolKt.getProtocolManager(ApplicationKt.getApplication());
        IProtocolHostWithBackend protocolHost = protocolManager.getOrCreate(project);
        IScheduler iScheduler = protocolHost.getProtocol().getScheduler();
        Intrinsics.checkNotNull((Object)iScheduler, (String)"null cannot be cast to non-null type com.jetbrains.rd.platform.protocol.IRdDispatcher");
        IRdDispatcher dispatcher = (IRdDispatcher)iScheduler;
        LifetimeDefinition initializationLifetimeDef = LifetimeDisposableExKt.defineNestedLifetime((Disposable)((Disposable)project));
        dispatcher.allowAllBackgroundThreadsAndSuppressPumping(initializationLifetimeDef.getLifetime());
        initializationLifetimeDef.getLifetime().onTermination(() -> SolutionInitializer.initSolution$lambda$0(project, protocolHost));
        project.putUserData(solutionInitializationLifetimeKey, (Object)initializationLifetimeDef);
        try {
            this.initSolution(project, strategy, protocolHost);
            logger.info("Protocol solution created, initialize protocol components...");
        }
        catch (Exception ex) {
            boolean $i$f$getLogger = false;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SolutionInitializer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)ex);
            if (protocolHost.isProjectAttached()) {
                protocolManager.release(protocolHost);
            }
            project.putUserData(solutionKey, (Object)new SolutionKey(null));
            throw ex;
        }
    }

    private final void initSolution(Project project, RdSolutionOpenStrategy solutionOpenStrategy, IProtocolHostWithBackend protocolHost) {
        SolutionHost solutionHost = SolutionHost.Companion.getInstance(protocolHost.getSession());
        solutionHost.assertReadyForSolution();
        Solution solution = new Solution(ProjectUtilKt.getOrCreateRdProjectId((Project)project), solutionOpenStrategy);
        RdConfigurationAndPlatform activeConfig = SolutionOpenStrategyProvider.Companion.getInstance().getActiveConfigurationAndPlatform(solution);
        if (activeConfig != null) {
            solution.getSolutionProperties().getActiveConfigurationPlatform().set((Object)activeConfig);
        }
        solutionHost.set(solution);
        project.putUserData(solutionKey, (Object)new SolutionKey(solution));
        project.putUserData(ProtocolKeys.Companion.getProtocolHostKey(), (Object)protocolHost);
        ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)project)).onTermination(() -> SolutionInitializer.initSolution$lambda$1(solutionHost, solution, protocolHost));
    }

    private static final Unit initSolution$lambda$0(Project $project, IProtocolHostWithBackend $protocolHost) {
        ClientProjectSession clientProjectSession = (ClientProjectSession)CollectionsKt.singleOrNull((List)ClientSessionsManager.Companion.getProjectSessions($project, ClientKind.FRONTEND));
        if (clientProjectSession == null) {
            return Unit.INSTANCE;
        }
        ClientProjectSession session2 = clientProjectSession;
        $protocolHost.getProtocolExtListenerManager().startDeliveringMessages(session2, SolutionHostExtensionsKt.getSolution($project));
        return Unit.INSTANCE;
    }

    private static final Unit initSolution$lambda$1(SolutionHost $solutionHost, Solution $solution, IProtocolHostWithBackend $protocolHost) {
        $solutionHost.remove($solution);
        ApplicationProtocolKt.getProtocolManager(ApplicationKt.getApplication()).release($protocolHost);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SolutionInitializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SolutionInitializer.logger = logger;
        solutionInitializationLifetimeKey = new Key("SolutionInitializationLifetimeKey");
    }

    @com.intellij.openapi.components.Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/projectView/SolutionInitializer$Service;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "initSolutionIfNeeded", "", "intellij.rider.rdclient.dotnet"})
    @SourceDebugExtension(value={"SMAP\nSolutionInitializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolutionInitializer.kt\ncom/jetbrains/rider/projectView/SolutionInitializer$Service\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
    public static final class Service {
        public Service(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.initSolutionIfNeeded(project);
        }

        private final void initSolutionIfNeeded(Project project) {
            if (project.isDefault()) {
                return;
            }
            if (project.getUserData(INSTANCE.getSolutionKey()) != null) {
                return;
            }
            RdSolutionOpenStrategy strategy = SolutionOpenStrategyProvider.Companion.getInstance().getOpenStrategy(project);
            if (strategy == null) {
                project.putUserData(INSTANCE.getSolutionKey(), (Object)new SolutionKey(null));
                return;
            }
            Path path = (Path)project.getUserData(ProjectImpl.PROJECT_PATH);
            if (path != null) {
                Path it = path;
                boolean bl = false;
                project.putUserData(ProjectUtilKt.getRdEarlyProjectDir(), (Object)((Object)it).toString());
            }
            INSTANCE.initSolution(project, strategy);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/projectView/SolutionInitializer$SolutionKey;", "", "solution", "Lcom/jetbrains/rd/ide/model/Solution;", "<init>", "(Lcom/jetbrains/rd/ide/model/Solution;)V", "getSolution", "()Lcom/jetbrains/rd/ide/model/Solution;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.rider.rdclient.dotnet"})
    public static final class SolutionKey {
        @Nullable
        private final Solution solution;

        public SolutionKey(@Nullable Solution solution) {
            this.solution = solution;
        }

        @Nullable
        public final Solution getSolution() {
            return this.solution;
        }

        @Nullable
        public final Solution component1() {
            return this.solution;
        }

        @NotNull
        public final SolutionKey copy(@Nullable Solution solution) {
            return new SolutionKey(solution);
        }

        public static /* synthetic */ SolutionKey copy$default(SolutionKey solutionKey, Solution solution, int n, Object object) {
            if ((n & 1) != 0) {
                solution = solutionKey.solution;
            }
            return solutionKey.copy(solution);
        }

        @NotNull
        public String toString() {
            return "SolutionKey(solution=" + this.solution + ")";
        }

        public int hashCode() {
            return this.solution == null ? 0 : this.solution.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SolutionKey)) {
                return false;
            }
            SolutionKey solutionKey = (SolutionKey)other;
            return Intrinsics.areEqual((Object)this.solution, (Object)solutionKey.solution);
        }
    }
}

