/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol;

import com.intellij.DynamicBundle;
import com.intellij.diagnostic.LoadingState;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.util.io.FileUtil;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\u0005J\n\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/protocol/LocaleHelper;", "", "<init>", "()V", "localizationFileName", "", "isLocaleReady", "", "getCachedLocaleFile", "Ljava/nio/file/Path;", "writeCachedLocaleValue", "", "getLocaleForBackendProcess", "readCachedLocaleValue", "getCurrentLocale", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nReSharperProcessBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReSharperProcessBase.kt\ncom/jetbrains/rider/protocol/LocaleHelper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,896:1\n24#2:897\n83#2,3:898\n24#2:901\n24#2:902\n24#2:903\n24#2:904\n*S KotlinDebug\n*F\n+ 1 ReSharperProcessBase.kt\ncom/jetbrains/rider/protocol/LocaleHelper\n*L\n837#1:897\n837#1:898,3\n858#1:901\n862#1:902\n869#1:903\n888#1:904\n*E\n"})
public final class LocaleHelper {
    @NotNull
    public static final LocaleHelper INSTANCE = new LocaleHelper();
    @NotNull
    private static final String localizationFileName = "rider_locale_cache.txt";

    private LocaleHelper() {
    }

    public final boolean isLocaleReady() {
        return LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred();
    }

    @NotNull
    public final Path getCachedLocaleFile() {
        Path path = PathManager.getSystemDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getSystemDir(...)");
        Path systemPath = path;
        Path path2 = systemPath.resolve("caches");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path cachesFolder = path2;
        Path path3 = cachesFolder.resolve(localizationFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        return path3;
    }

    public final void writeCachedLocaleValue() {
        Object object;
        LocaleHelper $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(LocaleHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger2 = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger2;
            boolean bl = false;
            boolean bl2 = false;
            String locale = INSTANCE.getLocaleForBackendProcess();
            Path file = INSTANCE.getCachedLocaleFile();
            if (locale == null) {
                FileUtil.delete((Path)file);
            } else {
                PathsKt.writeText$default((Path)file, (CharSequence)locale, null, (OpenOption[])new OpenOption[0], (int)2, null);
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
    }

    @Nullable
    public final String getLocaleForBackendProcess() {
        return this.isLocaleReady() ? this.getCurrentLocale() : this.readCachedLocaleValue();
    }

    private final String readCachedLocaleValue() {
        try {
            return PathsKt.readText$default((Path)this.getCachedLocaleFile(), null, (int)1, null);
        }
        catch (Throwable e) {
            if (e instanceof NoSuchFileException) {
                LocaleHelper $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(LocaleHelper.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Cache locale file doesn't exist. return default value");
                return null;
            }
            LocaleHelper $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(LocaleHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to read rider_locale_cache.txt file", e);
            return null;
        }
    }

    @Nullable
    public final String getCurrentLocale() {
        String string;
        block23: {
            block21: {
                if (!LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred()) {
                    LocaleHelper $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(LocaleHelper.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("getLocale is called too early");
                    return null;
                }
                Locale locale = LocalizationUtil.INSTANCE.getLocale(true);
                if (Intrinsics.areEqual((Object)locale, (Object)LocalizationUtil.INSTANCE.getDefaultLocale())) {
                    String tag = locale.toLanguageTag();
                    return Intrinsics.areEqual((Object)tag, (Object)"en") ? "en-US" : tag;
                }
                DynamicBundle.LanguageBundleEP languageBundleEP = LocalizationUtil.INSTANCE.findLanguageBundle(locale);
                if (languageBundleEP == null) break block21;
                Object it = languageBundleEP;
                boolean bl = false;
                String string2 = Locale.forLanguageTag(((DynamicBundle.LanguageBundleEP)it).locale).toLanguageTag();
                if (string2 == null) break block21;
                it = string2;
                boolean bl2 = false;
                switch (it) {
                    case "ja": 
                    case "ja-JP": {
                        string = "ja-JP";
                        break;
                    }
                    case "ko": 
                    case "ko-KR": {
                        string = "ko-KR";
                        break;
                    }
                    case "zh-CN": 
                    case "zh": {
                        string = "zh-CN";
                        break;
                    }
                    default: {
                        LocaleHelper $this$thisLogger$iv = INSTANCE;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(LocaleHelper.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.warn("Locale " + (String)it + " is not well known.");
                        return it;
                    }
                }
                break block23;
            }
            string = null;
        }
        return string;
    }
}

