/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.protocol;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rdclient.protocol.FrontendProtocolInitializer;
import com.jetbrains.rdclient.protocol.RdStartUpSerializerRegistrar;
import com.jetbrains.rider.protocol.IProtocolHost;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 #2\u00020\u0001:\u0001#B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010!\u001a\u00020 J\u0006\u0010\"\u001a\u00020 R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/protocol/ProtocolHost;", "Lcom/jetbrains/rider/protocol/IProtocolHost;", "id", "", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "protocol", "Lcom/jetbrains/rd/framework/IProtocol;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Lcom/jetbrains/rd/framework/IProtocol;)V", "getId", "()Ljava/lang/String;", "getLifetimeDefinition", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getProtocol", "()Lcom/jetbrains/rd/framework/IProtocol;", "projectInstance", "Lcom/jetbrains/rd/util/reactive/IProperty;", "Lcom/intellij/openapi/project/Project;", "project", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "getProject", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "projectFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getProjectFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "attach", "", "release", "init", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nProtocolHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolHost.kt\ncom/jetbrains/rider/protocol/ProtocolHost\n+ 2 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,77:1\n39#2,5:78\n14#3:83\n*S KotlinDebug\n*F\n+ 1 ProtocolHost.kt\ncom/jetbrains/rider/protocol/ProtocolHost\n*L\n66#1:78,5\n26#1:83\n*E\n"})
public abstract class ProtocolHost
implements IProtocolHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final LifetimeDefinition lifetimeDefinition;
    @NotNull
    private final IProtocol protocol;
    @NotNull
    private IProperty<Project> projectInstance;
    @NotNull
    private final StateFlow<Project> projectFlow;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<IProtocolHost> protocolHostOnProjectKey;

    public ProtocolHost(@NotNull String id, @NotNull LifetimeDefinition lifetimeDefinition, @NotNull IProtocol protocol) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)lifetimeDefinition, (String)"lifetimeDefinition");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        this.id = id;
        this.lifetimeDefinition = lifetimeDefinition;
        this.protocol = protocol;
        this.projectInstance = (IProperty)new Property(null);
        this.projectFlow = (StateFlow)StateFlowKt.MutableStateFlow(null);
        this.projectInstance.advise(this.getLifetime(), arg_0 -> ProtocolHost._init_$lambda$0(this, arg_0));
        RdStartUpSerializerRegistrar.Companion.getEP_NAME().forEachExtensionSafe(arg_0 -> ProtocolHost._init_$lambda$2(arg_0 -> ProtocolHost._init_$lambda$1(this, arg_0), arg_0));
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public final LifetimeDefinition getLifetimeDefinition() {
        return this.lifetimeDefinition;
    }

    @Override
    @NotNull
    public final IProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    @NotNull
    public IPropertyView<Project> getProject() {
        return (IPropertyView)this.projectInstance;
    }

    @Override
    @NotNull
    public final StateFlow<Project> getProjectFlow() {
        return this.projectFlow;
    }

    @Override
    @NotNull
    public Lifetime getLifetime() {
        return this.lifetimeDefinition.getLifetime();
    }

    public final void attach(@NotNull Project project) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project currentProject = (Project)this.getProject().getValue();
        boolean bl2 = bl = currentProject == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        project.putUserData(protocolHostOnProjectKey, (Object)this);
        this.projectInstance.set((Object)project);
    }

    public final void release() {
        Project project = (Project)this.getProject().getValue();
        if (project == null) {
            return;
        }
        Project currentProject = project;
        this.projectInstance.set(null);
        currentProject.putUserData(protocolHostOnProjectKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init() {
        Lifetime.Companion this_$iv = Lifetime.Companion;
        boolean $i$f$using = false;
        LifetimeDefinition def$iv = new LifetimeDefinition();
        try {
            Lifetime lifetime = def$iv.getLifetime();
            boolean bl = false;
            IScheduler iScheduler = this.protocol.getScheduler();
            Intrinsics.checkNotNull((Object)iScheduler, (String)"null cannot be cast to non-null type com.jetbrains.rd.platform.protocol.IRdDispatcher");
            ((IRdDispatcher)iScheduler).allowBackgroundThreadAndSuppressPumping(lifetime);
            FrontendProtocolInitializer.Companion.getEP_NAME().forEachExtensionSafe(arg_0 -> ProtocolHost.init$lambda$5$lambda$4(arg_0 -> ProtocolHost.init$lambda$5$lambda$3(this, arg_0), arg_0));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
        }
    }

    private static final Unit _init_$lambda$0(ProtocolHost this$0, Project it) {
        ((MutableStateFlow)this$0.projectFlow).setValue((Object)it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ProtocolHost this$0, RdStartUpSerializerRegistrar it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.register(this$0.protocol.getSerializers());
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit init$lambda$5$lambda$3(ProtocolHost this$0, FrontendProtocolInitializer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.initialize(this$0.protocol);
        return Unit.INSTANCE;
    }

    private static final void init$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProtocolHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProtocolHost.logger = logger;
        Key key = Key.create((String)"ProtocolHostOnProject");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        protocolHostOnProjectKey = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/protocol/ProtocolHost$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "protocolHostOnProjectKey", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rider/protocol/IProtocolHost;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getProtocolHostOnProjectKey", "()Lcom/intellij/openapi/util/Key;", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<IProtocolHost> getProtocolHostOnProjectKey() {
            return protocolHostOnProjectKey;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

