/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.ide.model.KeyPathComponents;
import com.jetbrains.rd.ide.model.NullValue;
import com.jetbrains.rd.ide.model.PredefinedValue;
import com.jetbrains.rd.ide.model.SettingsModel;
import com.jetbrains.rd.ide.model.SettingsModel_GeneratedKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.settings.OptionsUtilsHost;
import com.jetbrains.rider.settings.RiderCustomCodeStyleSettings;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/settings/RiderCustomCodeStyleSettingsSynchronizer;", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsListener;", "<init>", "()V", "codeStyleSettingsChanged", "", "event", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsChangeEvent;", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nRiderCodeStyleSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCodeStyleSettings.kt\ncom/jetbrains/rider/settings/RiderCustomCodeStyleSettingsSynchronizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1869#2,2:155\n*S KotlinDebug\n*F\n+ 1 RiderCodeStyleSettings.kt\ncom/jetbrains/rider/settings/RiderCustomCodeStyleSettingsSynchronizer\n*L\n28#1:155,2\n*E\n"})
public final class RiderCustomCodeStyleSettingsSynchronizer
implements CodeStyleSettingsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final String CPP_SORT_INCLUDE_SETTING_KEYS_PREF = "/Default/CodeStyle/CppSortIncludes";
    @NotNull
    public static final String CPP_NAMING_KEYS_PREF = "/Default/CodeStyle/Naming/CppNaming/Rules";

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SettingsModel settingsModel2 = SettingsModel_GeneratedKt.getSettingsModel((IProtocol)ApplicationProtocolKt.getProtocolHost(event.getProject()).getProtocol());
        if (event.getVirtualFile() == null && OptionsUtilsHost.Companion.getAllowSchemeSupport()) {
            CustomCodeStyleSettings customCodeStyleSettings = CodeStyle.getSettings((Project)event.getProject()).getCustomSettings(RiderCustomCodeStyleSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
            RiderCustomCodeStyleSettings codeStyle = (RiderCustomCodeStyleSettings)customCodeStyleSettings;
            Iterable $this$forEach$iv = CollectionsKt.union((Iterable)codeStyle.getData().keySet(), (Iterable)settingsModel2.getLowPriorityProtocolStorage().keySet());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean isCodeStyleSetting;
                KeyPathComponents keyPathComponents = (KeyPathComponents)element$iv;
                boolean bl = false;
                String key = keyPathComponents.getRawKey();
                boolean bl2 = isCodeStyleSetting = (StringsKt.startsWith$default((String)key, (String)"/Default/CodeStyle", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)key, (String)"/Default/CodeInspection/CppInitialization", (boolean)false, (int)2, null)) && !StringsKt.startsWith$default((String)key, (String)CPP_SORT_INCLUDE_SETTING_KEYS_PREF, (boolean)false, (int)2, null);
                if (isCodeStyleSetting) {
                    PredefinedValue value = codeStyle.getData().getOrDefault(keyPathComponents, (PredefinedValue)new NullValue());
                    if (!(value instanceof NullValue)) {
                        ((Map)settingsModel2.getLowPriorityProtocolStorage()).put(keyPathComponents, value);
                        continue;
                    }
                    logger.warn("Remove code-style option " + key);
                    settingsModel2.getLowPriorityProtocolStorage().remove((Object)keyPathComponents);
                    continue;
                }
                logger.trace("Keeping non code-style option " + key);
            }
        }
    }

    static {
        Logger logger = Logger.getInstance(RiderCustomCodeStyleSettingsSynchronizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderCustomCodeStyleSettingsSynchronizer.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/settings/RiderCustomCodeStyleSettingsSynchronizer$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "CPP_SORT_INCLUDE_SETTING_KEYS_PREF", "", "CPP_NAMING_KEYS_PREF", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

