/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ApplicationKt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdDynamic;
import com.jetbrains.rd.framework.InterfacesKt;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rider.model.LoadedPage;
import com.jetbrains.rider.model.OptionsDialog;
import com.jetbrains.rider.model.OptionsPageContentBase;
import com.jetbrains.rider.model.OptionsPageInfo;
import com.jetbrains.rider.model.PageId;
import com.jetbrains.rider.model.SettingsLayer;
import com.jetbrains.rider.model.SettingsLayerCollection;
import com.jetbrains.rider.model.SettingsViewModel;
import com.jetbrains.rider.model.SettingsViewModel_PregeneratedKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.settings.OptionsUtilsHost;
import com.jetbrains.rider.settings.SaveToLayerListener;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 82\u00020\u0001:\u00018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010!\u001a\u00020\"J\"\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020$0(J\"\u0010*\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020$0(J\u0006\u0010,\u001a\u00020$J\u0006\u0010-\u001a\u00020$J\u000e\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020&J\u0013\u00100\u001a\u00020$2\u000b\u00101\u001a\u00070&\u00a2\u0006\u0002\b2J\u0016\u00103\u001a\u00020$2\u0006\u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020\fJ\u0012\u00106\u001a\u00020$2\b\u0010\u0018\u001a\u0004\u0018\u00010&H\u0002J\u0006\u00107\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\n\u001a.\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f \r*\u0015\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000f\u00a2\u0006\u0002\b\u000e0\u000b\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u00069"}, d2={"Lcom/jetbrains/rider/settings/SettingsViewModelHost;", "", "project", "Lcom/intellij/openapi/project/Project;", "isSearch", "", "<init>", "(Lcom/intellij/openapi/project/Project;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "saveActionListeners", "", "Lcom/jetbrains/rider/settings/SaveToLayerListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "lifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getLifetimeDef", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "settingsViewModel", "Lcom/jetbrains/rider/model/SettingsViewModel;", "getSettingsViewModel", "()Lcom/jetbrains/rider/model/SettingsViewModel;", "layer", "Lcom/jetbrains/rider/model/SettingsLayer;", "getLayer", "()Lcom/jetbrains/rider/model/SettingsLayer;", "currentDialog", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "Lcom/jetbrains/rider/model/OptionsDialog;", "getCurrentDialog", "()Lcom/jetbrains/rd/util/reactive/IOptProperty;", "getCurrentDialogLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "requestPage", "", "id", "", "handler", "Lkotlin/Function1;", "Lcom/jetbrains/rider/model/OptionsPageContentBase;", "requestFullPage", "Lcom/jetbrains/rider/model/OptionsPageInfo;", "ok", "cancel", "reload", "pageId", "saveTo", "layerName", "Lorg/jetbrains/annotations/Nls;", "addSaveToLayerListener", "lifetime", "listener", "fireSaveActionListeners", "isDialogOpen", "Companion", "intellij.rider.rdclient.dotnet"})
@SourceDebugExtension(value={"SMAP\nSettingsViewModelHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsViewModelHost.kt\ncom/jetbrains/rider/settings/SettingsViewModelHost\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,196:1\n1#2:197\n1869#3,2:198\n37#4:200\n36#4,3:201\n83#5,3:204\n14#5:215\n382#6,7:207\n13#7:214\n*S KotlinDebug\n*F\n+ 1 SettingsViewModelHost.kt\ncom/jetbrains/rider/settings/SettingsViewModelHost\n*L\n169#1:198,2\n187#1:200\n187#1:201,3\n188#1:204,3\n31#1:215\n122#1:207,7\n31#1:214\n*E\n"})
public final class SettingsViewModelHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final boolean isSearch;
    @NotNull
    private final List<SaveToLayerListener> saveActionListeners;
    @NotNull
    private final LifetimeDefinition lifetimeDef;
    @NotNull
    private final SettingsViewModel settingsViewModel;
    @Nullable
    private final SettingsLayer layer;
    @NotNull
    private static final Logger logger;
    @Nullable
    private static SettingsViewModelHost instance;
    @Nullable
    private static SettingsViewModelHost searchInstance;

    public SettingsViewModelHost(@NotNull Project project, boolean isSearch) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.isSearch = isSearch;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createLockFreeCopyOnWriteList(...)");
        this.saveActionListeners = list;
        if (this.isSearch) {
            boolean bl = var3_3 = searchInstance == null;
            if (_Assertions.ENABLED && !var3_3) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        } else {
            boolean bl = var3_3 = instance == null;
            if (_Assertions.ENABLED && !var3_3) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }
        Lifetime projectLifetime = !this.project.isDefault() ? ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)) : ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)ApplicationKt.getApplication()));
        this.lifetimeDef = projectLifetime.createNested();
        try {
            this.lifetimeDef.getLifetime().onTermination(() -> SettingsViewModelHost._init_$lambda$0(this));
            IProtocol protocol = this.isSearch || this.project.isDefault() ? ((IProtocolHostWithBackend)CollectionsKt.first((Iterable)((Iterable)ApplicationProtocolKt.getProtocolManager(ApplicationKt.getApplication()).getProtocolHosts()))).getProtocol() : ApplicationProtocolKt.getProtocol(this.project);
            this.settingsViewModel = SettingsViewModel_PregeneratedKt.getSettingsViewModel(protocol);
            this.layer = this.isSearch ? null : OptionsUtilsHost.Companion.getLayer();
            this.getCurrentDialog().set((Object)new OptionsDialog(this.layer));
            if (this.isSearch) {
                searchInstance = this;
            } else {
                instance = this;
            }
        }
        catch (Throwable t) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDef, (boolean)false, (int)1, null);
            throw t;
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final LifetimeDefinition getLifetimeDef() {
        return this.lifetimeDef;
    }

    @NotNull
    public final SettingsViewModel getSettingsViewModel() {
        return this.settingsViewModel;
    }

    @Nullable
    public final SettingsLayer getLayer() {
        return this.layer;
    }

    @NotNull
    public final IOptProperty<OptionsDialog> getCurrentDialog() {
        SettingsViewModel it = this.settingsViewModel;
        boolean bl = false;
        return this.isSearch ? it.getKeywordsDialog() : it.getOptionsDialog();
    }

    @NotNull
    public final Lifetime getCurrentDialogLifetime() {
        return this.lifetimeDef.getLifetime();
    }

    public final void requestPage(@NotNull String id, @NotNull Function1<? super OptionsPageContentBase, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.requestFullPage(id, (Function1<? super OptionsPageInfo, Unit>)((Function1)arg_0 -> SettingsViewModelHost.requestPage$lambda$2(handler, arg_0)));
    }

    public final void requestFullPage(@NotNull String id, @NotNull Function1<? super OptionsPageInfo, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Lifetime lifetime = this.getCurrentDialogLifetime().createNested().getLifetime();
        OptionsDialog dialog2 = (OptionsDialog)((Object)this.getCurrentDialog().getValueOrNull());
        if (dialog2 != null) {
            InterfacesKt.getProtocolOrThrow((IRdDynamic)((IRdDynamic)this.settingsViewModel)).getScheduler().invokeOrQueue(() -> SettingsViewModelHost.requestFullPage$lambda$5(dialog2, id, lifetime, handler));
        }
    }

    public final void ok() {
        this.fireSaveActionListeners(null);
        com.jetbrains.rd.util.reactive.InterfacesKt.fire(((OptionsDialog)((Object)com.jetbrains.rd.util.reactive.InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.getCurrentDialog())))).getSave());
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDef, (boolean)false, (int)1, null);
    }

    public final void cancel() {
        com.jetbrains.rd.util.reactive.InterfacesKt.fire(((OptionsDialog)((Object)com.jetbrains.rd.util.reactive.InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.getCurrentDialog())))).getCancel());
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDef, (boolean)false, (int)1, null);
    }

    public final void reload(@NotNull String pageId) {
        Intrinsics.checkNotNullParameter((Object)pageId, (String)"pageId");
        ((OptionsDialog)((Object)com.jetbrains.rd.util.reactive.InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.getCurrentDialog())))).getReload().fire((Object)pageId);
    }

    public final void saveTo(@NotNull String layerName) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)layerName, (String)"layerName");
            if (this.layer != null) {
                this.ok();
                return;
            }
            OptionsDialog currentDialogValue = (OptionsDialog)((Object)com.jetbrains.rd.util.reactive.InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)this.getCurrentDialog())));
            SettingsLayerCollection layerCollection = (SettingsLayerCollection)((Object)currentDialogValue.getSettingsLayerCollection().getValueOrNull());
            Object object = layerCollection;
            if (object == null || (object = object.getLayers()) == null) break block2;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SettingsLayer it = (SettingsLayer)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)layerName)) continue;
                this.fireSaveActionListeners(it.getDisplayName());
                currentDialogValue.getSaveTo().fire((Object)it);
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDef, (boolean)false, (int)1, null);
                return;
            }
        }
    }

    public final void addSaveToLayerListener(@NotNull Lifetime lifetime, @NotNull SaveToLayerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.saveActionListeners.add(listener2);
        RLifetimeKt.intersect((Lifetime)this.lifetimeDef.getLifetime(), (Lifetime)lifetime).onTermination(() -> SettingsViewModelHost.addSaveToLayerListener$lambda$7(this, listener2));
    }

    private final void fireSaveActionListeners(String layer) {
        Collection $this$toTypedArray$iv = this.saveActionListeners;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        for (SaveToLayerListener listener2 : thisCollection$iv.toArray(new SaveToLayerListener[0])) {
            Object object;
            Logger $this$runAndLogException$iv = logger;
            boolean $i$f$runAndLogException = false;
            Logger logger = $this$runAndLogException$iv;
            try {
                Logger $this$runAndLogException_u24lambda_u240$iv = logger;
                boolean bl = false;
                boolean bl2 = false;
                listener2.onSave(layer);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        }
    }

    public final boolean isDialogOpen() {
        return RLifetimeKt.isAlive((Lifetime)((Lifetime)this.lifetimeDef));
    }

    private static final Unit _init_$lambda$0(SettingsViewModelHost this$0) {
        if (this$0.isSearch) {
            searchInstance = null;
        } else {
            instance = null;
        }
        return Unit.INSTANCE;
    }

    private static final Unit requestPage$lambda$2(Function1 $handler, OptionsPageInfo it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        $handler.invoke((Object)it.getContent());
        return Unit.INSTANCE;
    }

    private static final Unit requestFullPage$lambda$5$lambda$4(Function1 $handler, OptionsPageInfo it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        $handler.invoke((Object)it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit requestFullPage$lambda$5(OptionsDialog $dialog, String $id, Lifetime $lifetime, Function1 $handler) {
        Object object;
        void $this$getOrPut$iv;
        IPermittedModalities.Companion.getInstance$default((IPermittedModalities.Companion)IPermittedModalities.Companion, null, (int)1, null).allowPumpProtocolUnderCurrentModality();
        Map map = (Map)$dialog.getLoadedPages();
        PageId key$iv = new PageId($id);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            LoadedPage answer$iv = new LoadedPage();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        SourceExKt.adviseNotNull((ISource)((ISource)((LoadedPage)((Object)object)).getBody()), (Lifetime)$lifetime, arg_0 -> SettingsViewModelHost.requestFullPage$lambda$5$lambda$4($handler, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit addSaveToLayerListener$lambda$7(SettingsViewModelHost this$0, SaveToLayerListener $listener) {
        this$0.saveActionListeners.remove($listener);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsViewModelHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SettingsViewModelHost.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u0004\u0018\u00010\tJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/settings/SettingsViewModelHost$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "instance", "Lcom/jetbrains/rider/settings/SettingsViewModelHost;", "searchInstance", "getCurrentInstance", "getOrCreate", "project", "Lcom/intellij/openapi/project/Project;", "getOrCreateForSearch", "intellij.rider.rdclient.dotnet"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @Nullable
        public final SettingsViewModelHost getCurrentInstance() {
            return instance;
        }

        @NotNull
        public final SettingsViewModelHost getOrCreate(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ApplicationKt.getApplication().assertIsDispatchThread();
            if (instance == null) {
                return new SettingsViewModelHost(project, false);
            }
            SettingsViewModelHost settingsViewModelHost = instance;
            Intrinsics.checkNotNull((Object)settingsViewModelHost);
            return settingsViewModelHost;
        }

        @NotNull
        public final SettingsViewModelHost getOrCreateForSearch(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ApplicationKt.getApplication().assertIsDispatchThread();
            if (searchInstance == null) {
                return new SettingsViewModelHost(project, true);
            }
            SettingsViewModelHost settingsViewModelHost = searchInstance;
            Intrinsics.checkNotNull((Object)settingsViewModelHost);
            return settingsViewModelHost;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

