/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.util;

import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.jetbrains.rd.swing.RdSwingKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.SourceExKt;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J1\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J(\u0010\u0011\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/settings/util/TreeUtil;", "", "<init>", "()V", "expandTree", "", "tree", "Ljavax/swing/JTree;", "fitColumnWidth", "column", "", "table", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "desiredWidth", "resizable", "", "(ILcom/intellij/ui/treeStructure/treetable/TreeTable;Ljava/lang/Integer;Z)V", "fitColumnWidthPercent", "desiredWidthPrc", "intellij.rider.rdclient.dotnet"})
public final class TreeUtil {
    @NotNull
    public static final TreeUtil INSTANCE = new TreeUtil();

    private TreeUtil() {
    }

    public final void expandTree(@NotNull JTree tree) {
        int rowCount;
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        int oldRowCount = 0;
        block0: while ((rowCount = tree.getRowCount()) != oldRowCount) {
            oldRowCount = rowCount;
            int i = 0;
            int n = rowCount - 1;
            if (i > n) continue;
            while (true) {
                tree.expandRow(i);
                if (i == n) continue block0;
                ++i;
            }
        }
    }

    public final void fitColumnWidth(int column, @NotNull TreeTable table2, @Nullable Integer desiredWidth, boolean resizable) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        TableColumn tableColumn = table2.getColumnModel().getColumn(column);
        int preferredWidth = tableColumn.getMinWidth();
        int tableMaxWidth = tableColumn.getMaxWidth();
        int n = table2.getRowCount();
        for (int row = 0; row < n; ++row) {
            Component c;
            TableCellRenderer cellRenderer = table2.getCellRenderer(row, column);
            Intrinsics.checkNotNullExpressionValue((Object)table2.prepareRenderer(cellRenderer, row, column), (String)"prepareRenderer(...)");
            int width = c.getPreferredSize().width + table2.getIntercellSpacing().width;
            preferredWidth = Math.max(preferredWidth, width);
            if (preferredWidth < tableMaxWidth) continue;
            preferredWidth = tableMaxWidth;
        }
        if (desiredWidth != null && preferredWidth > desiredWidth) {
            preferredWidth = desiredWidth;
        }
        if (resizable) {
            tableColumn.setPreferredWidth(preferredWidth);
        } else {
            tableColumn.setMinWidth(preferredWidth);
            tableColumn.setMaxWidth(preferredWidth);
        }
    }

    public static /* synthetic */ void fitColumnWidth$default(TreeUtil treeUtil, int n, TreeTable treeTable2, Integer n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        if ((n3 & 8) != 0) {
            bl = true;
        }
        treeUtil.fitColumnWidth(n, treeTable2, n2, bl);
    }

    public final void fitColumnWidthPercent(int column, @NotNull TreeTable table2, int desiredWidthPrc, boolean resizable) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)RdSwingKt.visibleProperty((Component)((Component)table2))), (Lifetime)Lifetime.Companion.getEternal(), arg_0 -> TreeUtil.fitColumnWidthPercent$lambda$1(table2, column, desiredWidthPrc, resizable, arg_0));
    }

    public static /* synthetic */ void fitColumnWidthPercent$default(TreeUtil treeUtil, int n, TreeTable treeTable2, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 8) != 0) {
            bl = true;
        }
        treeUtil.fitColumnWidthPercent(n, treeTable2, n2, bl);
    }

    private static final boolean fitColumnWidthPercent$lambda$1$lambda$0(TreeTable $table, int $column, int $desiredWidthPrc, boolean $resizable, Dimension it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.width > 0) {
            int tableMaxWidth;
            TableColumn tableColumn = $table.getColumnModel().getColumn($column);
            int preferredWidth = ($table.getWidth() - ($table.getIntercellSpacing().width * $table.getColumnCount() - 1)) / 100 * $desiredWidthPrc;
            if (preferredWidth >= (tableMaxWidth = tableColumn.getMaxWidth())) {
                preferredWidth = tableMaxWidth;
            }
            if ($resizable) {
                tableColumn.setPreferredWidth(preferredWidth);
            } else {
                tableColumn.setMinWidth(preferredWidth);
                tableColumn.setMaxWidth(preferredWidth);
            }
            return true;
        }
        return false;
    }

    private static final Unit fitColumnWidthPercent$lambda$1(TreeTable $table, int $column, int $desiredWidthPrc, boolean $resizable, Lifetime lf) {
        Intrinsics.checkNotNullParameter((Object)lf, (String)"lf");
        SourceExKt.adviseUntil((ISource)((ISource)RdSwingKt.sizeProperty((JComponent)((JComponent)$table))), (Lifetime)lf, arg_0 -> TreeUtil.fitColumnWidthPercent$lambda$1$lambda$0($table, $column, $desiredWidthPrc, $resizable, arg_0));
        return Unit.INSTANCE;
    }
}

