/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.util.pngj.Checksum;
import org.jetbrains.letsPlot.util.pngj.Deflater;
import org.jetbrains.letsPlot.util.pngj.Inflater;
import org.jetbrains.letsPlot.util.pngj.PngjException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0010\u001a\u00020\bJ\u0010\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\rJ\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/Zip;", "", "()V", "IS_BYTE_ORDER_BIG_ENDIAN", "", "getIS_BYTE_ORDER_BIG_ENDIAN", "()Z", "adler32", "Lorg/jetbrains/letsPlot/util/pngj/Checksum;", "compressBytes", "", "ori", "offset", "", "len", "compress", "crc32", "newDeflater", "Lorg/jetbrains/letsPlot/util/pngj/Deflater;", "deflaterCompLevel", "newInflater", "Lorg/jetbrains/letsPlot/util/pngj/Inflater;", "Wrapper", "plot-api"})
@SourceDebugExtension(value={"SMAP\nZip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Zip.kt\norg/jetbrains/letsPlot/util/pngj/Zip\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1#2:119\n*E\n"})
public final class Zip {
    @NotNull
    public static final Zip INSTANCE = new Zip();

    private Zip() {
    }

    @NotNull
    public final byte[] compressBytes(@NotNull byte[] ori, int offset2, int len, boolean compress) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)ori, (String)"ori");
        try {
            byte[] tmpbuffer = new byte[4096];
            ByteArrayInputStream inb = new ByteArrayInputStream(ori, offset2, len);
            InputStream in = compress ? (InputStream)inb : (InputStream)new InflaterInputStream(inb);
            ByteArrayOutputStream outb = new ByteArrayOutputStream();
            OutputStream out = compress ? (OutputStream)new DeflaterOutputStream(outb) : (OutputStream)outb;
            int len1 = 0;
            while (true) {
                int n;
                int it = n = in.read(tmpbuffer);
                boolean bl = false;
                len1 = it;
                if (n <= 0) break;
                out.write(tmpbuffer, 0, len1);
            }
            in.close();
            out.close();
            byArray = outb.toByteArray();
            Intrinsics.checkNotNull((Object)byArray);
        }
        catch (Exception e) {
            throw new PngjException(e);
        }
        return byArray;
    }

    public final boolean getIS_BYTE_ORDER_BIG_ENDIAN() {
        return Intrinsics.areEqual((Object)ByteOrder.nativeOrder(), (Object)ByteOrder.BIG_ENDIAN);
    }

    @NotNull
    public final Deflater newDeflater(int deflaterCompLevel) {
        return new Deflater(deflaterCompLevel){
            @NotNull
            private final java.util.zip.Deflater deflater;
            {
                this.deflater = new java.util.zip.Deflater($deflaterCompLevel);
            }

            public void setStrategy(int deflaterStrategy) {
                this.deflater.setStrategy(deflaterStrategy);
            }

            public boolean finished() {
                return this.deflater.finished();
            }

            public void setInput(@NotNull byte[] data2, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                this.deflater.setInput(data2, off, len);
            }

            public boolean needsInput() {
                return this.deflater.needsInput();
            }

            public int deflate(@NotNull byte[] buf, int off, int n) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                return this.deflater.deflate(buf, off, n);
            }

            public void finish() {
                this.deflater.finish();
            }

            public void end() {
                this.deflater.end();
            }

            public void reset() {
                this.deflater.reset();
            }
        };
    }

    public static /* synthetic */ Deflater newDeflater$default(Zip zip, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return zip.newDeflater(n);
    }

    @NotNull
    public final Inflater newInflater() {
        return new Inflater(){
            @NotNull
            private final java.util.zip.Inflater inflater;
            {
                this.inflater = new java.util.zip.Inflater();
            }

            public int inflate(@NotNull byte[] output, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                return this.inflater.inflate(output, off, len);
            }

            public void setInput(@NotNull byte[] input, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                this.inflater.setInput(input, off, len);
            }

            public void end() {
                this.inflater.end();
            }

            public boolean getNeedsDictionary() {
                return this.inflater.needsDictionary();
            }

            public boolean getNeedsInput() {
                return this.inflater.needsInput();
            }

            public boolean getFinished() {
                return this.inflater.finished();
            }
        };
    }

    @NotNull
    public final Checksum crc32() {
        return new Wrapper(new CRC32());
    }

    @NotNull
    public final Checksum adler32() {
        return new Wrapper(new Adler32());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/Zip$Wrapper;", "Lorg/jetbrains/letsPlot/util/pngj/Checksum;", "checksum", "Ljava/util/zip/Checksum;", "(Ljava/util/zip/Checksum;)V", "value", "", "getValue", "()J", "reset", "", "update", "b", "", "off", "", "len", "plot-api"})
    private static final class Wrapper
    implements Checksum {
        @NotNull
        private final java.util.zip.Checksum checksum;

        public Wrapper(@NotNull java.util.zip.Checksum checksum) {
            Intrinsics.checkNotNullParameter((Object)checksum, (String)"checksum");
            this.checksum = checksum;
        }

        @Override
        public void update(int b2) {
            this.checksum.update(b2);
        }

        @Override
        public void update(@NotNull byte[] b2, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
            this.checksum.update(b2, off, len);
        }

        @Override
        public long getValue() {
            return this.checksum.getValue();
        }

        @Override
        public void reset() {
            this.checksum.reset();
        }
    }
}

