/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.memory;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseInputStreamReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class MemoryProfileFileReader
extends BaseDataReader {
    private static final Logger LOG = Logger.getInstance(MemoryProfileFileReader.class);
    @NotNull
    private final Reader myReader;
    @NotNull
    private final Consumer<String> myConsumer;
    private final char[] myInputBuffer;
    private final StringBuilder myLineBuffer;

    public MemoryProfileFileReader(@NotNull File fileToRead, @NotNull Consumer<String> consumer, @NotNull String profilerName) throws IOException {
        if (fileToRead == null) {
            MemoryProfileFileReader.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            MemoryProfileFileReader.$$$reportNull$$$0(1);
        }
        if (profilerName == null) {
            MemoryProfileFileReader.$$$reportNull$$$0(2);
        }
        super(BaseDataReader.SleepingPolicy.NON_BLOCKING);
        this.myInputBuffer = new char[8192];
        this.myLineBuffer = new StringBuilder();
        this.myReader = new BaseInputStreamReader((InputStream)new FileInputStream(fileToRead), StandardCharsets.UTF_8);
        this.myConsumer = consumer;
        this.start(profilerName);
    }

    public MemoryProfileFileReader(@NotNull Reader reader, @NotNull Consumer<String> consumer, @NotNull String profilerName) {
        if (reader == null) {
            MemoryProfileFileReader.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            MemoryProfileFileReader.$$$reportNull$$$0(4);
        }
        if (profilerName == null) {
            MemoryProfileFileReader.$$$reportNull$$$0(5);
        }
        super(BaseDataReader.SleepingPolicy.NON_BLOCKING);
        this.myInputBuffer = new char[8192];
        this.myLineBuffer = new StringBuilder();
        this.myReader = reader;
        this.myConsumer = consumer;
        this.start(profilerName);
    }

    public MemoryProfileFileReader(@NotNull Path fileToRead, @NotNull Consumer<String> consumer, @NotNull String profilerName) throws IOException {
        if (fileToRead == null) {
            MemoryProfileFileReader.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            MemoryProfileFileReader.$$$reportNull$$$0(7);
        }
        if (profilerName == null) {
            MemoryProfileFileReader.$$$reportNull$$$0(8);
        }
        super(BaseDataReader.SleepingPolicy.NON_BLOCKING);
        this.myInputBuffer = new char[8192];
        this.myLineBuffer = new StringBuilder();
        this.myReader = new BaseInputStreamReader(Files.newInputStream(fileToRead, StandardOpenOption.READ));
        this.myConsumer = consumer;
        this.start(profilerName);
    }

    protected boolean readAvailableNonBlocking() throws IOException {
        int n;
        boolean read = false;
        while ((n = this.myReader.read(this.myInputBuffer)) >= 0) {
            if (n <= 0) continue;
            read = true;
            this.processInput(n);
        }
        return read;
    }

    private void processInput(int n) {
        for (int i = 0; i < n; ++i) {
            char ch = this.myInputBuffer[i];
            this.myLineBuffer.append(ch);
            if (ch != '\n') continue;
            this.consumeLineBuffer();
        }
    }

    public void stop() {
        super.stop();
        try {
            super.waitFor();
        }
        catch (InterruptedException e) {
            LOG.error("Failed to stop: " + String.valueOf(e));
        }
        finally {
            this.consumeLineBuffer();
        }
    }

    private void consumeLineBuffer() {
        if (!this.myLineBuffer.isEmpty()) {
            this.myConsumer.consume((Object)this.myLineBuffer.toString());
            this.myLineBuffer.setLength(0);
        }
    }

    @NotNull
    protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
        if (runnable == null) {
            MemoryProfileFileReader.$$$reportNull$$$0(9);
        }
        Future future = ApplicationManager.getApplication().executeOnPooledThread(runnable);
        if (future == null) {
            MemoryProfileFileReader.$$$reportNull$$$0(10);
        }
        return future;
    }

    public void close() {
        try {
            this.myReader.close();
        }
        catch (IOException e) {
            LOG.error("Failed to close reader: " + String.valueOf(e));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToRead";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilerName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/profiling/memory/MemoryProfileFileReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/profiling/memory/MemoryProfileFileReader";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnPooledThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "executeOnPooledThread";
                break;
            }
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

