/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.featuresTrainer.lesson.debugger;

import com.intellij.clion.featuresTrainer.CLionLessonsBundle;
import com.intellij.clion.featuresTrainer.lesson.CLionLesson;
import com.intellij.clion.featuresTrainer.lesson.debugger.CLionDebuggerBasicLesson;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.ui.RunConfigurationStartHistory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerManagerListener;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.ui.XDebuggerEmbeddedComboBox;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfigurationType;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import training.dsl.HighlightTriggerParametersContext;
import training.dsl.HighlightingTriggerMethods;
import training.dsl.LessonContext;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.dsl.LessonSamplePosition;
import training.dsl.LessonUtil;
import training.dsl.LessonUtilKt;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.dsl.TaskTestContext;
import training.learn.CourseManager;
import training.learn.LessonsBundle;
import training.learn.course.Lesson;
import training.learn.lesson.general.run.CommonDebugLesson;
import training.learn.lesson.general.run.CommonDebugLessonKt;
import training.statistic.LessonStartingWay;
import training.ui.LearningUiHighlightingManager;
import training.util.WeakReferenceDelegator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\u0018\u0000 72\u00020\u0001:\u00017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002J\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\nH\u0002J\f\u0010.\u001a\u00020**\u00020)H\u0002J\u000e\u0010/\u001a\u0004\u0018\u000100*\u00020\nH\u0002J\f\u00101\u001a\u00020**\u000202H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\u000e\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R)\u0010\u0016\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u001c0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R/\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u001f\u001a\u0004\u0018\u00010 8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R%\u0010(\u001a\u0013\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020*0\u0017\u00a2\u0006\u0002\b+X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R \u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u00068"}, d2={"Lcom/intellij/clion/featuresTrainer/lesson/debugger/CLionDebuggerBasicLesson;", "Lcom/intellij/clion/featuresTrainer/lesson/CLionLesson;", "<init>", "()V", "sampleFilePath", "", "getSampleFilePath", "()Ljava/lang/String;", "runManager", "Lcom/intellij/execution/RunManager;", "Ltraining/dsl/TaskRuntimeContext;", "configurations", "", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "afterFixText", "getAfterFixText", "afterFixText$delegate", "Lkotlin/Lazy;", "sample", "Ltraining/dsl/LessonSample;", "getSample", "()Ltraining/dsl/LessonSample;", "breakpointXRange", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "width", "Lkotlin/ranges/IntRange;", "sessionPaused", "", "<set-?>", "Lcom/intellij/xdebugger/XDebugSession;", "debugSession", "getDebugSession", "()Lcom/intellij/xdebugger/XDebugSession;", "setDebugSession", "(Lcom/intellij/xdebugger/XDebugSession;)V", "debugSession$delegate", "Ltraining/util/WeakReferenceDelegator;", "lessonContent", "Ltraining/dsl/LessonContext;", "", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "startDebugTask", "checkDebugIsRunning", "Ltraining/dsl/TaskContext$RestoreNotification;", "waitForDebugSessionStarted", "Ltraining/dsl/TaskContext;", "helpLinks", "", "getHelpLinks", "()Ljava/util/Map;", "Companion", "intellij.clion.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nCLionDebuggerBasicLesson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLionDebuggerBasicLesson.kt\ncom/intellij/clion/featuresTrainer/lesson/debugger/CLionDebuggerBasicLesson\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 HighlightingTriggerMethods.kt\ntraining/dsl/HighlightingTriggerMethods\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,301:1\n774#2:302\n865#2,2:303\n20#3,2:305\n20#3,2:307\n20#3,2:309\n1#4:311\n*S KotlinDebug\n*F\n+ 1 CLionDebuggerBasicLesson.kt\ncom/intellij/clion/featuresTrainer/lesson/debugger/CLionDebuggerBasicLesson\n*L\n40#1:302\n40#1:303,2\n219#1:305,2\n228#1:307,2\n235#1:309,2\n*E\n"})
public final class CLionDebuggerBasicLesson
extends CLionLesson {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String sampleFilePath;
    @NotNull
    private final Lazy afterFixText$delegate = LazyKt.lazy(() -> CLionDebuggerBasicLesson.afterFixText_delegate$lambda$1(this));
    @NotNull
    private final LessonSample sample = LessonSampleKt.parseLessonSample((String)"#include <iostream>\n#include <string>\n#include <vector>\n#include <stdexcept>\n#include <algorithm>\n#include <numeric>\n\nvoid check_input(const std::vector<std::string> &value) {\n    if (value.empty()) {\n        throw std::invalid_argument(\"Invalid input\");\n    }\n}\n\nint extract_number(const std::string &s) {\n    return std::stoi(<select id=2>s.substr(0,s.find(' '))</select>);\n}\n\nint validate_number(int number) {\n    if (number < 0) {\n        throw std::invalid_argument(\"Invalid number\");\n    }\n    return number;\n}\n\nint find_average(const std::vector<std::string> &value) {\n    check_input(value);\n    int result = 0;\n    for (const std::string &s: value) {\n        <caret>result += validate_number(extract_number(s));\n    }\n    <caret id=3/>return <select id=4>result / value.size()</select>;\n}\n\nstd::vector<std::string> prepare_values() {\n    return {\"apple 1\", \"orange 2\", \"tomato 3\"};\n}\n\nint main() {\n    try {\n        double average = find_average(prepare_values());\n        std::cout << \"The average is \" << average;\n    }\n    catch (const std::exception &e) {\n        std::cerr << e.what();\n    }\n    return 0;\n}");
    @NotNull
    private final Function1<Integer, IntRange> breakpointXRange = LessonUtil.INSTANCE.getBreakpointXRange();
    private boolean sessionPaused;
    @NotNull
    private final WeakReferenceDelegator debugSession$delegate = new WeakReferenceDelegator(null, 1, null);
    @NotNull
    private final Function1<LessonContext, Unit> lessonContent = arg_0 -> CLionDebuggerBasicLesson.lessonContent$lambda$30(this, arg_0);

    public CLionDebuggerBasicLesson() {
        super("Execution.Debug", CLionLessonsBundle.INSTANCE.message("clion.debug.lesson.name", new Object[0]));
        this.sampleFilePath = "main.cpp";
    }

    @NotNull
    public String getSampleFilePath() {
        return this.sampleFilePath;
    }

    private final RunManager runManager(TaskRuntimeContext $this$runManager) {
        return RunManager.Companion.getInstance($this$runManager.getProject());
    }

    /*
     * WARNING - void declaration
     */
    private final List<RunnerAndConfigurationSettings> configurations(TaskRuntimeContext $this$configurations) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.runManager($this$configurations).getAllSettings();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"welcome", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String getAfterFixText() {
        Lazy lazy = this.afterFixText$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final LessonSample getSample() {
        return this.sample;
    }

    private final XDebugSession getDebugSession() {
        return (XDebugSession)this.debugSession$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setDebugSession(XDebugSession xDebugSession) {
        this.debugSession$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)xDebugSession);
    }

    @NotNull
    protected Function1<LessonContext, Unit> getLessonContent() {
        return this.lessonContent;
    }

    private final void startDebugTask(LessonContext $this$startDebugTask) {
        LessonUtilKt.highlightButtonById$default((LessonContext)$this$startDebugTask, (String)"Debug", (boolean)false, (boolean)false, (boolean)false, null, (int)30, null);
        $this$startDebugTask.task("Debug", (arg_0, arg_1) -> CLionDebuggerBasicLesson.startDebugTask$lambda$32(this, arg_0, arg_1));
    }

    private final TaskContext.RestoreNotification checkDebugIsRunning(TaskRuntimeContext $this$checkDebugIsRunning) {
        return XDebuggerManager.getInstance((Project)$this$checkDebugIsRunning.getProject()).getCurrentSession() == null ? new TaskContext.RestoreNotification(LessonsBundle.INSTANCE.message("debug.workflow.need.restart.lesson", new Object[0]), null, () -> CLionDebuggerBasicLesson.checkDebugIsRunning$lambda$33($this$checkDebugIsRunning, this), 2, null) : null;
    }

    private final void waitForDebugSessionStarted(TaskContext $this$waitForDebugSessionStarted) {
        $this$waitForDebugSessionStarted.addFutureStep(arg_0 -> CLionDebuggerBasicLesson.waitForDebugSessionStarted$lambda$34(this, arg_0));
    }

    @NotNull
    public Map<String, String> getHelpLinks() {
        return MapsKt.mapOf((Pair)new Pair((Object)LessonsBundle.INSTANCE.message("debug.workflow.help.link", new Object[0]), (Object)LessonUtil.INSTANCE.getHelpLink("debugging-code.html")));
    }

    private static final String afterFixText_delegate$lambda$1(CLionDebuggerBasicLesson this$0) {
        return StringsKt.replaceFirst$default((String)this$0.sample.getText(), (String)"(0,s.find(' '))", (String)"(s.find(' '))", (boolean)false, (int)4, null);
    }

    private static final Unit lessonContent$lambda$30$lambda$2(CLionDebuggerBasicLesson this$0, TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        List<RunnerAndConfigurationSettings> configurations = this$0.configurations($this$prepareRuntimeTask);
        for (RunnerAndConfigurationSettings it : configurations) {
            this$0.runManager($this$prepareRuntimeTask).removeConfiguration(it);
        }
        RunConfigurationStartHistory.Companion.getInstance($this$prepareRuntimeTask.getProject()).loadState(new RunConfigurationStartHistory.State());
        RunnerAndConfigurationSettings settings = this$0.runManager($this$prepareRuntimeTask).createConfiguration("welcome", CMakeAppRunConfigurationType.class);
        RunConfiguration runConfiguration = settings.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration");
        ((CMakeAppRunConfiguration)runConfiguration).onNewConfigurationCreated();
        this$0.runManager($this$prepareRuntimeTask).addConfiguration(settings);
        RunManager.Companion.getInstance($this$prepareRuntimeTask.getProject()).setSelectedConfiguration(settings);
        return Unit.INSTANCE;
    }

    private static final LogicalPosition lessonContent$lambda$30$lambda$3() {
        return new LogicalPosition(28, 6);
    }

    private static final Unit lessonContent$lambda$30$lambda$4(TaskContext $this$toggleBreakpointTask) {
        Intrinsics.checkNotNullParameter((Object)$this$toggleBreakpointTask, (String)"$this$toggleBreakpointTask");
        TaskContext.text$default((TaskContext)$this$toggleBreakpointTask, (String)CLionLessonsBundle.INSTANCE.message("clion.debug.workflow.exception.description", new Object[0]), null, (int)2, null);
        Object[] objectArray = new Object[]{$this$toggleBreakpointTask.action("ToggleLineBreakpoint")};
        TaskContext.text$default((TaskContext)$this$toggleBreakpointTask, (String)LessonsBundle.INSTANCE.message("debug.workflow.toggle.breakpoint", objectArray), null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final TaskContext.RestoreNotification lessonContent$lambda$30$lambda$6$lambda$5(CLionDebuggerBasicLesson this$0, TaskRuntimeContext $this$proposeRestore) {
        Intrinsics.checkNotNullParameter((Object)$this$proposeRestore, (String)"$this$proposeRestore");
        TaskContext.RestoreNotification restoreNotification = LessonUtil.checkExpectedStateOfEditor$default((LessonUtil)LessonUtil.INSTANCE, (TaskRuntimeContext)$this$proposeRestore, (LessonSample)this$0.sample, (boolean)false, null, (int)4, null);
        if (restoreNotification == null) {
            restoreNotification = this$0.checkDebugIsRunning($this$proposeRestore);
        }
        return restoreNotification;
    }

    private static final String lessonContent$lambda$30$lambda$6(CLionDebuggerBasicLesson this$0, TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$actionTask.proposeRestore(arg_0 -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$6$lambda$5(this$0, arg_0));
        Object[] objectArray = new Object[2];
        objectArray[0] = $this$actionTask.action(it);
        Icon icon = AllIcons.Actions.TraceInto;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"TraceInto");
        objectArray[1] = $this$actionTask.icon(icon);
        return CLionLessonsBundle.INSTANCE.message("clion.debug.workflow.step.into", objectArray);
    }

    private static final Unit lessonContent$lambda$30$lambda$10$lambda$7(TaskRuntimeContext $this$before) {
        Intrinsics.checkNotNullParameter((Object)$this$before, (String)"$this$before");
        LearningUiHighlightingManager.INSTANCE.clearHighlights();
        return Unit.INSTANCE;
    }

    private static final boolean lessonContent$lambda$30$lambda$10$lambda$8(CLionDebuggerBasicLesson this$0, TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        XDebugSession xDebugSession = this$0.getDebugSession();
        Integer debugLine = xDebugSession != null && (xDebugSession = xDebugSession.getCurrentStackFrame()) != null && (xDebugSession = xDebugSession.getSourcePosition()) != null ? Integer.valueOf(xDebugSession.getLine()) : null;
        int sampleLine = $this$stateCheck.getEditor().offsetToLogicalPosition((int)this$0.sample.getPosition((int)2).getStartOffset()).line;
        Integer n = debugLine;
        int n2 = sampleLine;
        return n != null && n == n2;
    }

    private static final TaskContext.RestoreNotification lessonContent$lambda$30$lambda$10$lambda$9(CLionDebuggerBasicLesson this$0, TaskRuntimeContext $this$proposeRestore) {
        Intrinsics.checkNotNullParameter((Object)$this$proposeRestore, (String)"$this$proposeRestore");
        TaskContext.RestoreNotification restoreNotification = LessonUtil.checkExpectedStateOfEditor$default((LessonUtil)LessonUtil.INSTANCE, (TaskRuntimeContext)$this$proposeRestore, (LessonSample)this$0.sample, (boolean)false, null, (int)4, null);
        if (restoreNotification == null) {
            restoreNotification = this$0.checkDebugIsRunning($this$proposeRestore);
        }
        return restoreNotification;
    }

    private static final Unit lessonContent$lambda$30$lambda$10(CLionDebuggerBasicLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.before(CLionDebuggerBasicLesson::lessonContent$lambda$30$lambda$10$lambda$7);
        $this$task.stateCheck(arg_0 -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$10$lambda$8(this$0, arg_0));
        $this$task.proposeRestore(arg_0 -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$10$lambda$9(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final boolean lessonContent$lambda$30$lambda$13$lambda$11(CLionDebuggerBasicLesson this$0, TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return Intrinsics.areEqual((Object)$this$stateCheck.getEditor().getDocument().getText(), (Object)this$0.getAfterFixText());
    }

    private static final TaskContext.RestoreNotification lessonContent$lambda$30$lambda$13$lambda$12(CLionDebuggerBasicLesson this$0, String $intermediate, int $restorePosition, TaskRuntimeContext $this$proposeRestore) {
        Intrinsics.checkNotNullParameter((Object)$this$proposeRestore, (String)"$this$proposeRestore");
        String string = $this$proposeRestore.getEditor().getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String editorText = string;
        return !Intrinsics.areEqual((Object)editorText, (Object)this$0.getAfterFixText()) && !Intrinsics.areEqual((Object)editorText, (Object)$intermediate) && !Intrinsics.areEqual((Object)editorText, (Object)this$0.sample.getText()) ? LessonUtil.INSTANCE.sampleRestoreNotification($this$proposeRestore, TaskContext.Companion.getModificationRestoreProposal(), new LessonSample(this$0.sample.getText(), $restorePosition)) : null;
    }

    private static final Unit lessonContent$lambda$30$lambda$13(CLionDebuggerBasicLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$this$task.code("0"), $this$task.code("substr")};
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.debug.workflow.fix.error", objectArray), null, (int)2, null);
        String intermediate = StringsKt.replaceFirst$default((String)this$0.sample.getText(), (String)"(0,", (String)"(,", (boolean)false, (int)4, null);
        int restorePosition = StringsKt.indexOf$default((CharSequence)this$0.sample.getText(), (String)"(s.", (int)0, (boolean)false, (int)6, null) + 2;
        $this$task.stateCheck(arg_0 -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$13$lambda$11(this$0, arg_0));
        $this$task.proposeRestore(arg_0 -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$13$lambda$12(this$0, intermediate, restorePosition, arg_0));
        return Unit.INSTANCE;
    }

    private static final String lessonContent$lambda$30$lambda$14(TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[2];
        objectArray[0] = $this$actionTask.action(it);
        Icon icon = AllIcons.Actions.RestartDebugger;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RestartDebugger");
        objectArray[1] = $this$actionTask.icon(icon);
        return CLionLessonsBundle.INSTANCE.message("clion.debug.workflow.rerun.debug", objectArray);
    }

    private static final Unit lessonContent$lambda$30$lambda$15(CLionDebuggerBasicLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        this$0.waitForDebugSessionStarted($this$task);
        return Unit.INSTANCE;
    }

    private static final TaskContext.RestoreNotification lessonContent$lambda$30$lambda$17$lambda$16(CLionDebuggerBasicLesson this$0, TaskRuntimeContext $this$proposeRestore) {
        Intrinsics.checkNotNullParameter((Object)$this$proposeRestore, (String)"$this$proposeRestore");
        TaskContext.RestoreNotification restoreNotification = LessonUtil.checkExpectedStateOfEditor$default((LessonUtil)LessonUtil.INSTANCE, (TaskRuntimeContext)$this$proposeRestore, (LessonSample)LessonSampleKt.parseLessonSample((String)this$0.getAfterFixText()), (boolean)false, null, (int)4, null);
        if (restoreNotification == null) {
            restoreNotification = this$0.checkDebugIsRunning($this$proposeRestore);
        }
        return restoreNotification;
    }

    private static final String lessonContent$lambda$30$lambda$17(CLionDebuggerBasicLesson this$0, TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$actionTask.proposeRestore(arg_0 -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$17$lambda$16(this$0, arg_0));
        Object[] objectArray = new Object[3];
        objectArray[0] = $this$actionTask.code("extract_number");
        objectArray[1] = $this$actionTask.action(it);
        Icon icon = AllIcons.Actions.TraceOver;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"TraceOver");
        objectArray[2] = $this$actionTask.icon(icon);
        return LessonsBundle.INSTANCE.message("debug.workflow.step.over", objectArray);
    }

    private static final TaskContext.RestoreNotification lessonContent$lambda$30$lambda$19$lambda$18(CLionDebuggerBasicLesson this$0, TaskRuntimeContext $this$proposeRestore) {
        Intrinsics.checkNotNullParameter((Object)$this$proposeRestore, (String)"$this$proposeRestore");
        TaskContext.RestoreNotification restoreNotification = LessonUtil.checkExpectedStateOfEditor$default((LessonUtil)LessonUtil.INSTANCE, (TaskRuntimeContext)$this$proposeRestore, (LessonSample)LessonSampleKt.parseLessonSample((String)this$0.getAfterFixText()), (boolean)false, null, (int)4, null);
        if (restoreNotification == null) {
            restoreNotification = this$0.checkDebugIsRunning($this$proposeRestore);
        }
        return restoreNotification;
    }

    private static final String lessonContent$lambda$30$lambda$19(CLionDebuggerBasicLesson this$0, TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$actionTask.proposeRestore(arg_0 -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$19$lambda$18(this$0, arg_0));
        Object[] objectArray = new Object[2];
        objectArray[0] = $this$actionTask.action(it);
        Icon icon = AllIcons.Actions.Resume;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Resume");
        objectArray[1] = $this$actionTask.icon(icon);
        return LessonsBundle.INSTANCE.message("debug.workflow.resume", objectArray);
    }

    private static final TaskContext.RestoreNotification lessonContent$lambda$30$lambda$21$lambda$20(CLionDebuggerBasicLesson this$0, TaskRuntimeContext $this$proposeRestore) {
        Intrinsics.checkNotNullParameter((Object)$this$proposeRestore, (String)"$this$proposeRestore");
        TaskContext.RestoreNotification restoreNotification = LessonUtil.checkExpectedStateOfEditor$default((LessonUtil)LessonUtil.INSTANCE, (TaskRuntimeContext)$this$proposeRestore, (LessonSample)LessonSampleKt.parseLessonSample((String)this$0.getAfterFixText()), (boolean)false, null, (int)4, null);
        if (restoreNotification == null) {
            restoreNotification = this$0.checkDebugIsRunning($this$proposeRestore);
        }
        return restoreNotification;
    }

    private static final String lessonContent$lambda$30$lambda$21(CLionDebuggerBasicLesson this$0, TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$actionTask.proposeRestore(arg_0 -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$21$lambda$20(this$0, arg_0));
        Object[] objectArray = new Object[1];
        Icon icon = AllIcons.Debugger.MuteBreakpoints;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"MuteBreakpoints");
        objectArray[0] = $this$actionTask.icon(icon);
        return LessonsBundle.INSTANCE.message("debug.workflow.mute.breakpoints", objectArray);
    }

    private static final Unit lessonContent$lambda$30$lambda$24$lambda$22(HighlightTriggerParametersContext $this$triggerAndBorderHighlight) {
        Intrinsics.checkNotNullParameter((Object)$this$triggerAndBorderHighlight, (String)"$this$triggerAndBorderHighlight");
        $this$triggerAndBorderHighlight.setUsePulsation(true);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$30$lambda$24(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        HighlightingTriggerMethods this_$iv = $this$task.triggerAndBorderHighlight(CLionDebuggerBasicLesson::lessonContent$lambda$30$lambda$24$lambda$22);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(XDebuggerEmbeddedComboBox.class, null, (Function2)new Function2<TaskRuntimeContext, XDebuggerEmbeddedComboBox<XExpression>, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                XDebuggerEmbeddedComboBox xDebuggerEmbeddedComboBox = (XDebuggerEmbeddedComboBox)it;
                TaskRuntimeContext $this$lessonContent_u24lambda_u2430_u24lambda_u2424_u24lambda_u2423 = $this$explicitComponentDetection;
                boolean bl = false;
                return ui.isEditable();
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$30$lambda$27(String $needToEvaluate, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$this$task.code("result / value.size()")};
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.debug.workflow.evaluate.expression", objectArray), null, (int)2, null);
        HighlightingTriggerMethods this_$iv = TaskContext.triggerUI$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(EditorComponentImpl.class, null, (Function2)new Function2<TaskRuntimeContext, EditorComponentImpl, Boolean>($needToEvaluate){
            final /* synthetic */ String $needToEvaluate$inlined;
            {
                this.$needToEvaluate$inlined = string;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                EditorComponentImpl editorComponentImpl = (EditorComponentImpl)it;
                TaskRuntimeContext $this$lessonContent_u24lambda_u2430_u24lambda_u2427_u24lambda_u2426 = $this$explicitComponentDetection;
                boolean bl = false;
                return Intrinsics.areEqual((Object)ui.getEditor().getDocument().getText(), (Object)this.$needToEvaluate$inlined);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$30$lambda$29(String $needToEvaluate, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{LessonUtil.INSTANCE.rawEnter()};
        TaskContext.text$default((TaskContext)$this$task, (String)LessonsBundle.INSTANCE.message("debug.workflow.evaluate.it", objectArray), null, (int)2, null);
        HighlightingTriggerMethods this_$iv = TaskContext.triggerUI$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(XDebuggerTree.class, null, (Function2)new Function2<TaskRuntimeContext, XDebuggerTree, Boolean>($needToEvaluate){
            final /* synthetic */ String $needToEvaluate$inlined;
            {
                this.$needToEvaluate$inlined = string;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                boolean bl;
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                XDebuggerTree xDebuggerTree = (XDebuggerTree)it;
                TaskRuntimeContext $this$lessonContent_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428 = $this$explicitComponentDetection;
                boolean bl2 = false;
                if (ui.getRoot().getChildCount() == 0) {
                    bl = false;
                } else {
                    TreeNode treeNode = ui.getRoot().getChildAt(0);
                    WatchNodeImpl watchNodeImpl = treeNode instanceof WatchNodeImpl ? (WatchNodeImpl)treeNode : null;
                    if (watchNodeImpl == null) {
                        bl = false;
                    } else {
                        WatchNodeImpl resultNode = watchNodeImpl;
                        bl = Intrinsics.areEqual((Object)this.$needToEvaluate$inlined, (Object)resultNode.getExpression().getExpression());
                    }
                }
                return bl;
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$30(CLionDebuggerBasicLesson this$0, LessonContext lessonContext) {
        String string;
        Intrinsics.checkNotNullParameter((Object)lessonContext, (String)"<this>");
        LessonContext.prepareSample$default((LessonContext)lessonContext, (LessonSample)this$0.sample, (boolean)false, (int)2, null);
        lessonContext.waitBeforeContinue(300);
        LessonContext.prepareRuntimeTask$default((LessonContext)lessonContext, null, arg_0 -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$2(this$0, arg_0), (int)1, null);
        CommonDebugLessonKt.clearBreakpoints((LessonContext)lessonContext);
        LessonUtilKt.showInvalidDebugLayoutWarning((LessonContext)lessonContext);
        lessonContext.caret(29, 9);
        lessonContext.waitBeforeContinue(200);
        Companion.checkIfWelcomeConfigurationExists(lessonContext);
        LessonUtilKt.highlightButtonById$default((LessonContext)lessonContext, (String)"Run", (boolean)false, (boolean)false, (boolean)false, null, (int)24, null);
        CommonDebugLessonKt.runSample((LessonContext)lessonContext, (String)"Run", (String)LessonsBundle.INSTANCE.message("debug.workflow.run.current", new Object[0]));
        CommonDebugLessonKt.toggleBreakpointTask$default((LessonContext)lessonContext, (LessonSample)this$0.sample, CLionDebuggerBasicLesson::lessonContent$lambda$30$lambda$3, (boolean)false, this$0.breakpointXRange, CLionDebuggerBasicLesson::lessonContent$lambda$30$lambda$4, (int)4, null);
        this$0.startDebugTask(lessonContext);
        LessonUtilKt.highlightButtonById$default((LessonContext)lessonContext, (String)"StepInto", (boolean)false, (boolean)false, (boolean)false, null, (int)30, null);
        lessonContext.actionTask("StepInto", (arg_0, arg_1) -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$6(this$0, arg_0, arg_1));
        lessonContext.task(arg_0 -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$10(this$0, arg_0));
        lessonContext.waitBeforeContinue(500);
        LessonUtil.INSTANCE.highlightInEditor(lessonContext, "s.substr(0,s.find(' '))");
        lessonContext.task(arg_0 -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$13(this$0, arg_0));
        LessonUtilKt.highlightButtonById$default((LessonContext)lessonContext, (String)"Rerun", (boolean)false, (boolean)false, (boolean)false, null, (int)30, null);
        lessonContext.actionTask("Rerun", CLionDebuggerBasicLesson::lessonContent$lambda$30$lambda$14);
        lessonContext.task(arg_0 -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$15(this$0, arg_0));
        LessonUtilKt.highlightButtonById$default((LessonContext)lessonContext, (String)"StepOver", (boolean)false, (boolean)false, (boolean)false, null, (int)30, null);
        lessonContext.actionTask("StepOver", (arg_0, arg_1) -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$17(this$0, arg_0, arg_1));
        LessonUtilKt.highlightButtonById$default((LessonContext)lessonContext, (String)"Resume", (boolean)false, (boolean)false, (boolean)false, null, (int)30, null);
        lessonContext.actionTask("Resume", (arg_0, arg_1) -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$19(this$0, arg_0, arg_1));
        LessonUtilKt.highlightButtonById$default((LessonContext)lessonContext, (String)"XDebugger.MuteBreakpoints", (boolean)false, (boolean)false, (boolean)false, null, (int)30, null);
        lessonContext.actionTask("XDebugger.MuteBreakpoints", (arg_0, arg_1) -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$21(this$0, arg_0, arg_1));
        lessonContext.waitBeforeContinue(500);
        CommonDebugLesson.Companion.runToCursorTask(lessonContext, this$0.sample, this$0.getAfterFixText(), "find_average");
        lessonContext.task(CLionDebuggerBasicLesson::lessonContent$lambda$30$lambda$24);
        lessonContext.caret("result / value.size()", true);
        LessonSamplePosition position = this$0.sample.getPosition(4);
        Pair pair = position.getSelection();
        if (pair != null) {
            Pair pair2 = pair;
            boolean bl = false;
            String string2 = this$0.sample.getText().substring(((Number)pair2.getFirst()).intValue(), ((Number)pair2.getSecond()).intValue());
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = null;
        }
        String needToEvaluate = string;
        lessonContext.task(arg_0 -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$27(needToEvaluate, arg_0));
        lessonContext.task(arg_0 -> CLionDebuggerBasicLesson.lessonContent$lambda$30$lambda$29(needToEvaluate, arg_0));
        CommonDebugLesson.Companion.stopTask(lessonContext);
        return Unit.INSTANCE;
    }

    private static final Unit startDebugTask$lambda$32$lambda$31(String $it, TaskTestContext $this$test) {
        Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
        String[] stringArray = new String[]{$it};
        $this$test.actions(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit startDebugTask$lambda$32(CLionDebuggerBasicLesson this$0, TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[2];
        Icon icon = AllIcons.Actions.StartDebugger;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"StartDebugger");
        objectArray[0] = $this$task.icon(icon);
        objectArray[1] = $this$task.action(it);
        TaskContext.text$default((TaskContext)$this$task, (String)LessonsBundle.INSTANCE.message("debug.workflow.start.debug", objectArray), null, (int)2, null);
        this$0.waitForDebugSessionStarted($this$task);
        LessonUtil.INSTANCE.restoreIfModified($this$task, this$0.sample);
        TaskContext.test$default((TaskContext)$this$task, (boolean)false, arg_0 -> CLionDebuggerBasicLesson.startDebugTask$lambda$32$lambda$31(it, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit checkDebugIsRunning$lambda$33(TaskRuntimeContext $this_checkDebugIsRunning, CLionDebuggerBasicLesson this$0) {
        CourseManager.openLesson$default((CourseManager)CourseManager.Companion.getInstance(), (Project)$this_checkDebugIsRunning.getProject(), (Lesson)((Lesson)this$0), (LessonStartingWay)LessonStartingWay.RESTORE_LINK, (boolean)false, (boolean)false, (int)24, null);
        return Unit.INSTANCE;
    }

    private static final Unit waitForDebugSessionStarted$lambda$34(CLionDebuggerBasicLesson this$0, TaskContext.DoneStepContext $this$addFutureStep) {
        Intrinsics.checkNotNullParameter((Object)$this$addFutureStep, (String)"$this$addFutureStep");
        MessageBusConnection messageBusConnection = $this$addFutureStep.getProject().getMessageBus().connect($this$addFutureStep.getLessonDisposable());
        Topic topic = XDebuggerManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new XDebuggerManagerListener(this$0, $this$addFutureStep){
            final /* synthetic */ CLionDebuggerBasicLesson this$0;
            final /* synthetic */ TaskContext.DoneStepContext $this_addFutureStep;
            {
                this.this$0 = $receiver;
                this.$this_addFutureStep = $this_addFutureStep;
            }

            public void processStarted(XDebugProcess debugProcess) {
                Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
                XDebugSession xDebugSession = debugProcess.getSession();
                Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
                XDebugSession debugSession = xDebugSession;
                CLionDebuggerBasicLesson.access$setDebugSession(this.this$0, debugSession);
                ActionsKt.invokeLater$default(null, () -> waitForDebugSessionStarted.1.1.processStarted$lambda$0(debugProcess), (int)1, null);
                debugSession.addSessionListener(new XDebugSessionListener(this.this$0, this.$this_addFutureStep){
                    final /* synthetic */ CLionDebuggerBasicLesson this$0;
                    final /* synthetic */ TaskContext.DoneStepContext $this_addFutureStep;
                    {
                        this.this$0 = $receiver;
                        this.$this_addFutureStep = $this_addFutureStep;
                    }

                    public void sessionPaused() {
                        CLionDebuggerBasicLesson.access$setSessionPaused$p(this.this$0, true);
                        TaskRuntimeContext.taskInvokeLater$default((TaskRuntimeContext)((TaskRuntimeContext)this.$this_addFutureStep), null, () -> waitForDebugSessionStarted.1.processStarted.2.sessionPaused$lambda$0(this.$this_addFutureStep), (int)1, null);
                    }

                    private static final Unit sessionPaused$lambda$0(TaskContext.DoneStepContext $this_addFutureStep) {
                        $this_addFutureStep.completeStep();
                        return Unit.INSTANCE;
                    }
                }, this.$this_addFutureStep.getLessonDisposable());
            }

            private static final Unit processStarted$lambda$0(XDebugProcess $debugProcess) {
                $debugProcess.getSession().setBreakpointMuted(false);
                return Unit.INSTANCE;
            }
        });
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setDebugSession(CLionDebuggerBasicLesson $this, XDebugSession xDebugSession) {
        $this.setDebugSession(xDebugSession);
    }

    public static final /* synthetic */ void access$setSessionPaused$p(CLionDebuggerBasicLesson $this, boolean bl) {
        $this.sessionPaused = bl;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(CLionDebuggerBasicLesson.class, "debugSession", "getDebugSession()Lcom/intellij/xdebugger/XDebugSession;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/clion/featuresTrainer/lesson/debugger/CLionDebuggerBasicLesson$Companion;", "", "<init>", "()V", "checkIfWelcomeConfigurationExists", "", "Ltraining/dsl/LessonContext;", "intellij.clion.featuresTrainer"})
    @SourceDebugExtension(value={"SMAP\nCLionDebuggerBasicLesson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLionDebuggerBasicLesson.kt\ncom/intellij/clion/featuresTrainer/lesson/debugger/CLionDebuggerBasicLesson$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,301:1\n1#2:302\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void checkIfWelcomeConfigurationExists(@NotNull LessonContext $this$checkIfWelcomeConfigurationExists) {
            Intrinsics.checkNotNullParameter((Object)$this$checkIfWelcomeConfigurationExists, (String)"<this>");
            $this$checkIfWelcomeConfigurationExists.task(Companion::checkIfWelcomeConfigurationExists$lambda$2);
        }

        private static final boolean checkIfWelcomeConfigurationExists$lambda$2$lambda$1(TaskRuntimeContext $this$stateCheck) {
            Object v1;
            Iterable iterable;
            block1: {
                Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
                List allConfigurationList = RunManager.Companion.getInstance($this$stateCheck.getProject()).getAllConfigurationsList();
                Iterable iterable2 = allConfigurationList;
                iterable = allConfigurationList;
                Iterable iterable3 = iterable2;
                for (Object t : iterable3) {
                    RunConfiguration it = (RunConfiguration)t;
                    boolean bl = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!StringsKt.endsWith$default((String)string, (String)"welcome", (boolean)false, (int)2, null)) continue;
                    v1 = t;
                    break block1;
                }
                v1 = null;
            }
            return CollectionsKt.contains((Iterable)iterable, v1);
        }

        private static final Unit checkIfWelcomeConfigurationExists$lambda$2(TaskContext $this$task) {
            Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
            $this$task.stateCheck(Companion::checkIfWelcomeConfigurationExists$lambda$2$lambda$1);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

