/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.featuresTrainer.lesson.onboarding;

import com.intellij.clion.featuresTrainer.CLionLessonsBundle;
import com.intellij.clion.featuresTrainer.lesson.CLionLesson;
import com.intellij.clion.featuresTrainer.lesson.onboarding.CLionOnboardingTourLesson;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.ui.UIExperiment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereUI;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actions.ToggleCaseAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.tree.TreePath;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.JsonArrayBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.HighlightTriggerParametersContext;
import training.dsl.HighlightingTriggerMethods;
import training.dsl.LearningBalloonConfig;
import training.dsl.LessonContext;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.dsl.LessonUtil;
import training.dsl.LessonUtilKt;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.dsl.TaskTestContext;
import training.lang.LangSupport;
import training.learn.LearnBundle;
import training.learn.course.Lesson;
import training.learn.course.LessonProperties;
import training.learn.lesson.general.run.CommonDebugLessonKt;
import training.project.ProjectUtils;
import training.ui.LearningUiHighlightingManager;
import training.ui.LearningUiManager;
import training.ui.OnboardingFeedbackFormKt;
import training.util.LessonEndInfo;
import training.util.OnboardingFeedbackData;
import training.util.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010(\u001a\u00020\u0005H\u0002J\f\u0010)\u001a\u00020\u001e*\u00020\u001dH\u0002J\f\u0010*\u001a\u00020\u001e*\u00020\u001dH\u0002J\f\u0010+\u001a\u00020\u001e*\u00020\u001dH\u0002J\f\u0010,\u001a\u00020\u001e*\u00020\u001dH\u0002J\f\u0010-\u001a\u00020\u001e*\u00020\u001dH\u0002J\f\u0010.\u001a\u00020\u001e*\u00020\u001dH\u0002J\f\u0010/\u001a\u00020\u001e*\u00020\u001dH\u0002J\f\u00100\u001a\u00020\u001e*\u00020\u001dH\u0002J\f\u00101\u001a\u00020\u001e*\u00020\u001dH\u0002J\f\u00102\u001a\u000203*\u000204H\u0002J\u0012\u00105\u001a\b\u0012\u0004\u0012\u00020706*\u000204H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c\u00a2\u0006\u0002\b\u001fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00068"}, d2={"Lcom/intellij/clion/featuresTrainer/lesson/onboarding/CLionOnboardingTourLesson;", "Lcom/intellij/clion/featuresTrainer/lesson/CLionLesson;", "<init>", "()V", "demoConfigurationName", "", "demoFileName", "featureTrainerVersion", "uiSettings", "Lcom/intellij/ide/ui/UISettings;", "getUiSettings", "()Lcom/intellij/ide/ui/UISettings;", "properties", "Ltraining/learn/course/LessonProperties;", "getProperties", "()Ltraining/learn/course/LessonProperties;", "testScriptProperties", "Ltraining/dsl/TaskTestContext$TestScriptProperties;", "getTestScriptProperties", "()Ltraining/dsl/TaskTestContext$TestScriptProperties;", "backupPopupLocation", "Ljava/awt/Point;", "hideToolStripesPreference", "", "showMainToolbarPreference", "sample", "Ltraining/dsl/LessonSample;", "lessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "onLessonEnd", "project", "Lcom/intellij/openapi/project/Project;", "lessonEndInfo", "Ltraining/util/LessonEndInfo;", "prepareFeedbackData", "returnToWelcomeScreenRemark", "checkUiSettings", "projectTasks", "openLearnToolwindow", "waitIndexingTasks", "runTasks", "debugTasks", "completionSteps", "contextActions", "searchEverywhereTasks", "runManager", "Lcom/intellij/execution/RunManager;", "Ltraining/dsl/TaskRuntimeContext;", "configurations", "", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "intellij.clion.featuresTrainer"})
@SourceDebugExtension(value={"SMAP\nCLionOnboardingTourLesson.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CLionOnboardingTourLesson.kt\ncom/intellij/clion/featuresTrainer/lesson/onboarding/CLionOnboardingTourLesson\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 HighlightingTriggerMethods.kt\ntraining/dsl/HighlightingTriggerMethods\n*L\n1#1,583:1\n24#2:584\n774#3:585\n865#3,2:586\n1869#3,2:588\n1563#3:592\n1634#3,3:593\n1999#3,14:604\n20#4,2:590\n20#4,2:596\n20#4,2:598\n20#4,2:600\n20#4,2:602\n20#4,2:618\n*S KotlinDebug\n*F\n+ 1 CLionOnboardingTourLesson.kt\ncom/intellij/clion/featuresTrainer/lesson/onboarding/CLionOnboardingTourLesson\n*L\n184#1:584\n581#1:585\n581#1:586,2\n102#1:588,2\n194#1:592\n194#1:593,3\n438#1:604,14\n130#1:590,2\n268#1:596,2\n324#1:598,2\n347#1:600,2\n370#1:602,2\n540#1:618,2\n*E\n"})
public final class CLionOnboardingTourLesson
extends CLionLesson {
    @NotNull
    private final String demoConfigurationName;
    @NotNull
    private final String demoFileName;
    @NotNull
    private final String featureTrainerVersion;
    @NotNull
    private final LessonProperties properties;
    @NotNull
    private final TaskTestContext.TestScriptProperties testScriptProperties;
    @Nullable
    private Point backupPopupLocation;
    private boolean hideToolStripesPreference;
    private boolean showMainToolbarPreference;
    @NotNull
    private final LessonSample sample;
    @NotNull
    private final Function1<LessonContext, Unit> lessonContent;

    public CLionOnboardingTourLesson() {
        Object[] objectArray = new Object[]{LessonUtil.INSTANCE.getProductName()};
        super("clion.onboarding", CLionLessonsBundle.INSTANCE.message("clion.onboarding.lesson.name", objectArray));
        this.demoConfigurationName = "main";
        this.demoFileName = this.demoConfigurationName + ".cpp";
        this.featureTrainerVersion = "feature-trainer-version.txt";
        this.properties = new LessonProperties(true, false, null, 4, null);
        this.testScriptProperties = new TaskTestContext.TestScriptProperties(0, true, 1, null);
        this.showMainToolbarPreference = true;
        this.sample = LessonSampleKt.parseLessonSample((String)"#include <iostream>\n#include <vector>\n\ndouble find_average(std::vector<double> values)\n{\n    double result = 0;\n    for (int i = 0; i < values.size(); ++i)\n        result += values[i];\n\n    <caret>return result<caret id=2/>;\n}\n\nint main() {\n    std::cout << \"AVERAGE \" << find_average({5, 6, 7, 8}) << '\\n';\n}");
        this.lessonContent = arg_0 -> CLionOnboardingTourLesson.lessonContent$lambda$11(this, arg_0);
    }

    private final UISettings getUiSettings() {
        return UISettings.Companion.getInstance();
    }

    @NotNull
    public LessonProperties getProperties() {
        return this.properties;
    }

    @NotNull
    public TaskTestContext.TestScriptProperties getTestScriptProperties() {
        return this.testScriptProperties;
    }

    @NotNull
    protected Function1<LessonContext, Unit> getLessonContent() {
        return this.lessonContent;
    }

    @Override
    public void onLessonEnd(@NotNull Project project, @NotNull LessonEndInfo lessonEndInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lessonEndInfo, (String)"lessonEndInfo");
        super.onLessonEnd(project, lessonEndInfo);
        this.prepareFeedbackData(lessonEndInfo);
        LessonUtil.INSTANCE.restorePopupPosition(project, "search.everywhere.popup", this.backupPopupLocation);
        this.backupPopupLocation = null;
        this.getUiSettings().setHideToolStripes(this.hideToolStripesPreference);
        this.getUiSettings().setShowNewMainToolbar(this.showMainToolbarPreference);
        this.getUiSettings().fireUISettingsChanged();
        LessonUtilKt.showEndOfLessonDialogAndFeedbackForm((Lesson)((Lesson)this), (LessonEndInfo)lessonEndInfo, (Project)project);
    }

    private final void prepareFeedbackData(LessonEndInfo lessonEndInfo) {
        if (!OnboardingFeedbackFormKt.shouldCollectFeedbackResults()) {
            return;
        }
        LangSupport primaryLanguage = this.getModule().getPrimaryLanguage();
        if (primaryLanguage == null) {
            CLionOnboardingTourLesson $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CLionOnboardingTourLesson.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Onboarding lesson has no language support for some magical reason");
            return;
        }
        String configPropertyName = OnboardingFeedbackFormKt.getFeedbackProposedPropertyName((LangSupport)primaryLanguage);
        if (PropertiesComponent.getInstance().getBoolean(configPropertyName, false)) {
            return;
        }
        CompletableFuture<List<String>> toolchainVersions = new CompletableFuture<List<String>>();
        ApplicationManager.getApplication().executeOnPooledThread(() -> CLionOnboardingTourLesson.prepareFeedbackData$lambda$13(toolchainVersions));
        Object object = CPPToolchains.getInstance().getDefaultToolchain();
        if (object == null || (object = object.getName()) == null) {
            object = "none";
        }
        Object usedToolchain = object;
        primaryLanguage.setOnboardingFeedbackData(new OnboardingFeedbackData(lessonEndInfo, toolchainVersions, (String)usedToolchain, configPropertyName){
            private final Lazy toolchains$delegate;
            private final String feedbackReportId;
            private final int additionalFeedbackFormatVersion;
            private final Function1<JsonObjectBuilder, Unit> addAdditionalSystemData;
            private final Function1<Panel, Unit> addRowsForUserAgreement;
            final /* synthetic */ String $configPropertyName;
            {
                this.$configPropertyName = $configPropertyName;
                super("CLion Onboarding Tour Feedback", $lessonEndInfo);
                this.toolchains$delegate = LazyKt.lazy(() -> prepareFeedbackData.2.toolchains_delegate$lambda$0($toolchainVersions));
                this.feedbackReportId = "clion_onboarding_tour";
                this.addAdditionalSystemData = arg_0 -> prepareFeedbackData.2.addAdditionalSystemData$lambda$2($usedToolchain, this, arg_0);
                this.addRowsForUserAgreement = arg_0 -> prepareFeedbackData.2.addRowsForUserAgreement$lambda$5(this, $usedToolchain, arg_0);
            }

            private final List<String> getToolchains() {
                Lazy lazy = this.toolchains$delegate;
                return (List)lazy.getValue();
            }

            public String getFeedbackReportId() {
                return this.feedbackReportId;
            }

            public int getAdditionalFeedbackFormatVersion() {
                return this.additionalFeedbackFormatVersion;
            }

            public Function1<JsonObjectBuilder, Unit> getAddAdditionalSystemData() {
                return this.addAdditionalSystemData;
            }

            public Function1<Panel, Unit> getAddRowsForUserAgreement() {
                return this.addRowsForUserAgreement;
            }

            public void feedbackHasBeenProposed() {
                PropertiesComponent.getInstance().setValue(this.$configPropertyName, true, false);
            }

            private static final List toolchains_delegate$lambda$0(CompletableFuture $toolchainVersions) {
                return $toolchainVersions.isDone() ? (List)$toolchainVersions.get() : null;
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit addAdditionalSystemData$lambda$2(String $usedToolchain, prepareFeedbackData.2 this$0, JsonObjectBuilder jsonObjectBuilder) {
                JsonArrayBuilder builder$iv;
                Intrinsics.checkNotNullParameter((Object)jsonObjectBuilder, (String)"<this>");
                JsonElementBuildersKt.put((JsonObjectBuilder)jsonObjectBuilder, (String)"current_sdk", (String)$usedToolchain);
                boolean $i$f$buildJsonArray = false;
                JsonArrayBuilder jsonArrayBuilder = builder$iv = new JsonArrayBuilder();
                String string = "found_sdks";
                JsonObjectBuilder jsonObjectBuilder2 = jsonObjectBuilder;
                boolean bl = false;
                List list = this$0.getToolchains();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                for (String i : list) {
                    void $this$addAdditionalSystemData_u24lambda_u242_u24lambda_u241;
                    $this$addAdditionalSystemData_u24lambda_u242_u24lambda_u241.add((JsonElement)JsonElementKt.JsonPrimitive((String)i));
                }
                Unit unit = Unit.INSTANCE;
                jsonObjectBuilder2.put(string, (JsonElement)builder$iv.build());
                return Unit.INSTANCE;
            }

            private static final Unit addRowsForUserAgreement$lambda$5$lambda$3(prepareFeedbackData.2 this$0, Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                List<String> list = this$0.getToolchains();
                if (list == null || (list = list.toString()) == null) {
                    list = CLionLessonsBundle.INSTANCE.message("clion.onboarding.feedback.system.no.toolchain", new Object[0]);
                }
                $this$row.label((String)((Object)list));
                return Unit.INSTANCE;
            }

            private static final Unit addRowsForUserAgreement$lambda$5$lambda$4(String $usedToolchain, Row $this$row) {
                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                $this$row.label($usedToolchain);
                return Unit.INSTANCE;
            }

            private static final Unit addRowsForUserAgreement$lambda$5(prepareFeedbackData.2 this$0, String $usedToolchain, Panel panel) {
                Intrinsics.checkNotNullParameter((Object)panel, (String)"<this>");
                panel.row(CLionLessonsBundle.INSTANCE.message("clion.onboarding.feedback.system.found.toolchain", new Object[0]), arg_0 -> prepareFeedbackData.2.addRowsForUserAgreement$lambda$5$lambda$3(this$0, arg_0));
                panel.row(CLionLessonsBundle.INSTANCE.message("clion.onboarding.feedback.system.used.toolchain", new Object[0]), arg_0 -> prepareFeedbackData.2.addRowsForUserAgreement$lambda$5$lambda$4($usedToolchain, arg_0));
                return Unit.INSTANCE;
            }
        });
    }

    private final String returnToWelcomeScreenRemark() {
        boolean isSingleProject = ProjectManager.getInstance().getOpenProjects().length == 1;
        return isSingleProject ? CLionLessonsBundle.INSTANCE.message("clion.onboarding.return.to.welcome", new Object[0]) : "";
    }

    private final void checkUiSettings(LessonContext $this$checkUiSettings) {
        LessonUtilKt.showInvalidDebugLayoutWarning((LessonContext)$this$checkUiSettings);
        if (!this.getUiSettings().getHideToolStripes() && this.getUiSettings().getShowNewMainToolbar()) {
            $this$checkUiSettings.task(CLionOnboardingTourLesson::checkUiSettings$lambda$14);
            $this$checkUiSettings.task(CLionOnboardingTourLesson::checkUiSettings$lambda$15);
            return;
        }
        $this$checkUiSettings.task(CLionOnboardingTourLesson::checkUiSettings$lambda$16);
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$checkUiSettings, null, arg_0 -> CLionOnboardingTourLesson.checkUiSettings$lambda$17(this, arg_0), (int)1, null);
    }

    private final void projectTasks(LessonContext $this$projectTasks) {
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$projectTasks, null, CLionOnboardingTourLesson::projectTasks$lambda$18, (int)1, null);
        $this$projectTasks.task(CLionOnboardingTourLesson::projectTasks$lambda$20);
        $this$projectTasks.task(CLionOnboardingTourLesson::projectTasks$lambda$23);
        $this$projectTasks.task(arg_0 -> CLionOnboardingTourLesson.projectTasks$lambda$25(this, arg_0));
        $this$projectTasks.task(arg_0 -> CLionOnboardingTourLesson.projectTasks$lambda$30(this, arg_0));
    }

    private final void openLearnToolwindow(LessonContext $this$openLearnToolwindow) {
        $this$openLearnToolwindow.task(CLionOnboardingTourLesson::openLearnToolwindow$lambda$32);
        $this$openLearnToolwindow.task(arg_0 -> CLionOnboardingTourLesson.openLearnToolwindow$lambda$34(this, arg_0));
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$openLearnToolwindow, null, CLionOnboardingTourLesson::openLearnToolwindow$lambda$35, (int)1, null);
    }

    private final void waitIndexingTasks(LessonContext $this$waitIndexingTasks) {
        $this$waitIndexingTasks.task(CLionOnboardingTourLesson::waitIndexingTasks$lambda$37);
        $this$waitIndexingTasks.task(CLionOnboardingTourLesson::waitIndexingTasks$lambda$38);
        $this$waitIndexingTasks.waitBeforeContinue(300);
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$waitIndexingTasks, null, CLionOnboardingTourLesson::waitIndexingTasks$lambda$39, (int)1, null);
    }

    private final void runTasks(LessonContext $this$runTasks) {
        LessonUtilKt.highlightRunToolbar((LessonContext)$this$runTasks, (boolean)false, (boolean)false);
        $this$runTasks.task(CLionOnboardingTourLesson::runTasks$lambda$42);
        $this$runTasks.task(arg_0 -> CLionOnboardingTourLesson.runTasks$lambda$43(this, arg_0));
    }

    private final void debugTasks(LessonContext $this$debugTasks) {
        CommonDebugLessonKt.clearBreakpoints((LessonContext)$this$debugTasks);
        Ref.ObjectRef logicalPosition = new Ref.ObjectRef();
        logicalPosition.element = new LogicalPosition(0, 0);
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$debugTasks, null, arg_0 -> CLionOnboardingTourLesson.debugTasks$lambda$44(logicalPosition, this, arg_0), (int)1, null);
        $this$debugTasks.caret(this.sample.getStartOffset());
        CommonDebugLessonKt.toggleBreakpointTask$default((LessonContext)$this$debugTasks, (LessonSample)this.sample, () -> CLionOnboardingTourLesson.debugTasks$lambda$45(logicalPosition), (boolean)false, null, CLionOnboardingTourLesson::debugTasks$lambda$46, (int)8, null);
        LessonUtilKt.highlightButtonById$default((LessonContext)$this$debugTasks, (String)"Debug", (boolean)false, (boolean)false, (boolean)false, null, (int)24, null);
        $this$debugTasks.actionTask("Debug", (arg_0, arg_1) -> CLionOnboardingTourLesson.debugTasks$lambda$48(this, logicalPosition, arg_0, arg_1));
        Ref.ObjectRef debuggerGotItTaskId = new Ref.ObjectRef();
        $this$debugTasks.task(arg_0 -> CLionOnboardingTourLesson.debugTasks$lambda$49(debuggerGotItTaskId, arg_0));
        LessonUtilKt.highlightDebugActionsToolbar$default((LessonContext)$this$debugTasks, (boolean)false, (boolean)false, (int)3, null);
        $this$debugTasks.task(arg_0 -> CLionOnboardingTourLesson.debugTasks$lambda$50(debuggerGotItTaskId, arg_0));
        LessonUtilKt.highlightButtonById$default((LessonContext)$this$debugTasks, (String)"Stop", (boolean)false, (boolean)false, (boolean)false, null, (int)24, null);
        $this$debugTasks.task(arg_0 -> CLionOnboardingTourLesson.debugTasks$lambda$54(this, arg_0));
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$debugTasks, null, CLionOnboardingTourLesson::debugTasks$lambda$55, (int)1, null);
    }

    private final void completionSteps(LessonContext $this$completionSteps) {
        LessonContext.prepareRuntimeTask$default((LessonContext)$this$completionSteps, null, arg_0 -> CLionOnboardingTourLesson.completionSteps$lambda$56(this, arg_0), (int)1, null);
        $this$completionSteps.task(CLionOnboardingTourLesson::completionSteps$lambda$57);
        $this$completionSteps.task(CLionOnboardingTourLesson::completionSteps$lambda$59);
        $this$completionSteps.task(arg_0 -> CLionOnboardingTourLesson.completionSteps$lambda$61(this, arg_0));
    }

    private final void contextActions(LessonContext $this$contextActions) {
        String clangTidyMessage = CLionLessonsBundle.INSTANCE.message("clion.quick.fix.use.range.based.loop", new Object[0]);
        LessonContext.caret$default((LessonContext)$this$contextActions, (String)"for", (boolean)false, (int)2, null);
        $this$contextActions.task("ShowIntentionActions", CLionOnboardingTourLesson::contextActions$lambda$63);
        $this$contextActions.task(arg_0 -> CLionOnboardingTourLesson.contextActions$lambda$65(clangTidyMessage, arg_0));
        LessonContext.caret$default((LessonContext)$this$contextActions, (String)"values", (boolean)false, (int)2, null);
        $this$contextActions.task("ShowIntentionActions", CLionOnboardingTourLesson::contextActions$lambda$67);
        $this$contextActions.task(CLionOnboardingTourLesson::contextActions$lambda$69);
    }

    private final void searchEverywhereTasks(LessonContext $this$searchEverywhereTasks) {
        String toggleCase = ActionsBundle.message((String)"action.EditorToggleCase.text", (Object[])new Object[0]);
        $this$searchEverywhereTasks.caret("AVERAGE", true);
        $this$searchEverywhereTasks.task("SearchEverywhere", (arg_0, arg_1) -> CLionOnboardingTourLesson.searchEverywhereTasks$lambda$71(toggleCase, arg_0, arg_1));
        $this$searchEverywhereTasks.task(arg_0 -> CLionOnboardingTourLesson.searchEverywhereTasks$lambda$74(this, arg_0));
        $this$searchEverywhereTasks.task(arg_0 -> CLionOnboardingTourLesson.searchEverywhereTasks$lambda$76(toggleCase, arg_0));
        $this$searchEverywhereTasks.text(CLionLessonsBundle.INSTANCE.message("clion.onboarding.case.changed", new Object[0]));
    }

    private final RunManager runManager(TaskRuntimeContext $this$runManager) {
        return RunManager.Companion.getInstance($this$runManager.getProject());
    }

    /*
     * WARNING - void declaration
     */
    private final List<RunnerAndConfigurationSettings> configurations(TaskRuntimeContext $this$configurations) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.runManager($this$configurations).getAllSettings();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)this.demoConfigurationName, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Unit lessonContent$lambda$11$lambda$5$lambda$2$lambda$1(VirtualFile $root, CLionOnboardingTourLesson this$0, TaskRuntimeContext $this_prepareRuntimeTask) {
        block0: {
            VirtualFile virtualFile = $root.findChild(this$0.featureTrainerVersion);
            if (virtualFile == null) break block0;
            virtualFile.delete((Object)$this_prepareRuntimeTask);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$11$lambda$5$lambda$2(VirtualFile $root, CLionOnboardingTourLesson this$0, TaskRuntimeContext $this_prepareRuntimeTask) {
        ActionsKt.runWriteAction(() -> CLionOnboardingTourLesson.lessonContent$lambda$11$lambda$5$lambda$2$lambda$1($root, this$0, $this_prepareRuntimeTask));
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$11$lambda$5$lambda$4$lambda$3(VirtualFile $root, TaskRuntimeContext $this_prepareRuntimeTask, CLionOnboardingTourLesson this$0) {
        $root.createChildData((Object)$this_prepareRuntimeTask, this$0.demoFileName);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$11$lambda$5$lambda$4(VirtualFile $root, TaskRuntimeContext $this_prepareRuntimeTask, CLionOnboardingTourLesson this$0) {
        ActionsKt.runWriteAction(() -> CLionOnboardingTourLesson.lessonContent$lambda$11$lambda$5$lambda$4$lambda$3($root, $this_prepareRuntimeTask, this$0));
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$11$lambda$5(CLionOnboardingTourLesson this$0, TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        UtilsKt.invokeActionForFocusContext((AnAction)UtilsKt.getActionById((String)"Stop"));
        Iterable $this$forEach$iv = this$0.configurations($this$prepareRuntimeTask);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)element$iv;
            boolean bl = false;
            this$0.runManager($this$prepareRuntimeTask).removeConfiguration(it);
        }
        VirtualFile root = ProjectUtils.INSTANCE.getCurrentLearningProjectRoot();
        if (root.findChild(this$0.featureTrainerVersion) != null) {
            ActionsKt.invokeLater$default(null, () -> CLionOnboardingTourLesson.lessonContent$lambda$11$lambda$5$lambda$2(root, this$0, $this$prepareRuntimeTask), (int)1, null);
        }
        if (root.findChild(this$0.demoFileName) == null) {
            ActionsKt.invokeLater$default(null, () -> CLionOnboardingTourLesson.lessonContent$lambda$11$lambda$5$lambda$4(root, $this$prepareRuntimeTask, this$0), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$11$lambda$7(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ActionButton.class, null, (Function2)new Function2<TaskRuntimeContext, ActionButton, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void stripe;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ActionButton actionButton = (ActionButton)it;
                TaskRuntimeContext $this$lessonContent_u24lambda_u2411_u24lambda_u247_u24lambda_u246 = $this$explicitComponentDetection;
                boolean bl = false;
                return UtilsKt.isToStringContains((Object)stripe.getAction().getTemplateText(), (String)CLionLessonsBundle.INSTANCE.message("toolbar.settings.button", new Object[0]));
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$11$lambda$8(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.toolchain.description", new Object[0]), null, (int)2, null);
        LessonUtilKt.gotItStep$default((TaskContext)$this$task, (Balloon.Position)Balloon.Position.below, (int)0, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.toolchain.tip", new Object[0]), null, (int)0, (boolean)false, (int)24, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$11$lambda$10$lambda$9() {
        LearningUiManager.INSTANCE.resetModulesView();
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$11$lambda$10(CLionOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{UtilsKt.getCallBackActionId((String)"CloseProject"), this$0.returnToWelcomeScreenRemark(), LearningUiManager.INSTANCE.addCallback(CLionOnboardingTourLesson::lessonContent$lambda$11$lambda$10$lambda$9)};
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.epilogue", objectArray), null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit lessonContent$lambda$11(CLionOnboardingTourLesson this$0, LessonContext lessonContext) {
        Intrinsics.checkNotNullParameter((Object)lessonContext, (String)"<this>");
        LessonContext.prepareRuntimeTask$default((LessonContext)lessonContext, null, arg_0 -> CLionOnboardingTourLesson.lessonContent$lambda$11$lambda$5(this$0, arg_0), (int)1, null);
        CommonDebugLessonKt.clearBreakpoints((LessonContext)lessonContext);
        this$0.checkUiSettings(lessonContext);
        this$0.projectTasks(lessonContext);
        lessonContext.prepareSample(this$0.sample, false);
        this$0.openLearnToolwindow(lessonContext);
        LessonUtilKt.sdkConfigurationTasks((LessonContext)lessonContext);
        lessonContext.task(CLionOnboardingTourLesson::lessonContent$lambda$11$lambda$7);
        lessonContext.task(CLionOnboardingTourLesson::lessonContent$lambda$11$lambda$8);
        this$0.waitIndexingTasks(lessonContext);
        this$0.runTasks(lessonContext);
        this$0.debugTasks(lessonContext);
        this$0.completionSteps(lessonContext);
        lessonContext.waitBeforeContinue(500);
        this$0.contextActions(lessonContext);
        lessonContext.waitBeforeContinue(500);
        this$0.searchEverywhereTasks(lessonContext);
        lessonContext.task(arg_0 -> CLionOnboardingTourLesson.lessonContent$lambda$11$lambda$10(this$0, arg_0));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void prepareFeedbackData$lambda$13(CompletableFuture $toolchainVersions) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list = CPPToolchains.getInstance().getToolchains();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getToolchains(...)");
        Iterable iterable = list;
        CompletableFuture completableFuture = $toolchainVersions;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CPPToolchains.Toolchain toolchain = (CPPToolchains.Toolchain)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            collection.add(string);
        }
        completableFuture.complete((List)destination$iv$iv);
    }

    private static final Unit checkUiSettings$lambda$14(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        return Unit.INSTANCE;
    }

    private static final Unit checkUiSettings$lambda$15(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        return Unit.INSTANCE;
    }

    private static final Unit checkUiSettings$lambda$16(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.change.ui.settings", new Object[0]), null, (int)2, null);
        LessonUtilKt.proceedLink$default((TaskContext)$this$task, (int)0, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit checkUiSettings$lambda$17(CLionOnboardingTourLesson this$0, TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        this$0.hideToolStripesPreference = this$0.getUiSettings().getHideToolStripes();
        this$0.showMainToolbarPreference = this$0.getUiSettings().getShowNewMainToolbar();
        this$0.getUiSettings().setHideToolStripes(false);
        this$0.getUiSettings().setShowNewMainToolbar(true);
        this$0.getUiSettings().fireUISettingsChanged();
        return Unit.INSTANCE;
    }

    private static final Unit projectTasks$lambda$18(TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        LessonUtil.INSTANCE.hideStandardToolwindows($this$prepareRuntimeTask.getProject());
        return Unit.INSTANCE;
    }

    private static final Unit projectTasks$lambda$20(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ActionButton.class, null, (Function2)new Function2<TaskRuntimeContext, ActionButton, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void stripe;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ActionButton actionButton = (ActionButton)it;
                TaskRuntimeContext $this$projectTasks_u24lambda_u2420_u24lambda_u2419 = $this$explicitComponentDetection;
                boolean bl = false;
                return Intrinsics.areEqual((Object)stripe.getAction().getTemplateText(), (Object)IdeUICustomization.getInstance().getProjectViewTitle($this$projectTasks_u24lambda_u2420_u24lambda_u2419.getProject()));
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit projectTasks$lambda$23$lambda$22$lambda$21(JTree $tree, TreePath $path) {
        $tree.collapsePath($path);
        return Unit.INSTANCE;
    }

    private static final boolean projectTasks$lambda$23$lambda$22(Ref.BooleanRef $collapsed, TaskRuntimeContext $this$treeItem, JTree tree, TreePath path) {
        boolean result;
        Intrinsics.checkNotNullParameter((Object)$this$treeItem, (String)"$this$treeItem");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        boolean bl = result = path.getPathCount() >= 1 && UtilsKt.isToStringContains((Object)path.getPathComponent(0), (String)"LearnCppProject");
        if (result) {
            if (!$collapsed.element) {
                ActionsKt.invokeLater$default(null, () -> CLionOnboardingTourLesson.projectTasks$lambda$23$lambda$22$lambda$21(tree, path), (int)1, null);
            }
            $collapsed.element = true;
        }
        return result;
    }

    private static final Unit projectTasks$lambda$23(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Ref.BooleanRef collapsed = new Ref.BooleanRef();
        Object[] objectArray = new Object[]{$this$task.action("ActivateProjectToolWindow")};
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.project.view.description", objectArray), null, (int)2, null);
        $this$task.text(CLionLessonsBundle.INSTANCE.message("clion.onboarding.balloon.project.view", new Object[0]), new LearningBalloonConfig(Balloon.Position.atRight, 0, false, null, 0, 0, 0, null, null, 508, null));
        TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null).treeItem((arg_0, arg_1, arg_2) -> CLionOnboardingTourLesson.projectTasks$lambda$23$lambda$22(collapsed, arg_0, arg_1, arg_2));
        return Unit.INSTANCE;
    }

    private static final boolean projectTasks$isDemoFilePath(CLionOnboardingTourLesson this$0, TreePath path) {
        return path.getPathCount() >= 3 && UtilsKt.isToStringContains((Object)path.getPathComponent(2), (String)this$0.demoFileName);
    }

    private static final boolean projectTasks$lambda$25$lambda$24(CLionOnboardingTourLesson this$0, TaskRuntimeContext $this$treeItem, JTree jTree, TreePath path) {
        Intrinsics.checkNotNullParameter((Object)$this$treeItem, (String)"$this$treeItem");
        Intrinsics.checkNotNullParameter((Object)jTree, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return CLionOnboardingTourLesson.projectTasks$isDemoFilePath(this$0, path);
    }

    private static final Unit projectTasks$lambda$25(CLionOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Balloon.Position position = Balloon.Position.atRight;
        $this$task.text(CLionLessonsBundle.INSTANCE.message("clion.onboarding.balloon.project.directory", new Object[0]), new LearningBalloonConfig(position, 0, true, null, 0, 0, 0, null, null, 504, null));
        TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null).treeItem((arg_0, arg_1, arg_2) -> CLionOnboardingTourLesson.projectTasks$lambda$25$lambda$24(this$0, arg_0, arg_1, arg_2));
        TaskContext.restoreByUi$default((TaskContext)$this$task, null, (int)0, null, (int)7, null);
        return Unit.INSTANCE;
    }

    private static final boolean projectTasks$lambda$30$lambda$26(CLionOnboardingTourLesson this$0, TaskRuntimeContext $this$l) {
        Intrinsics.checkNotNullParameter((Object)$this$l, (String)"$this$l");
        if (FileEditorManager.getInstance((Project)$this$l.getProject()).getSelectedTextEditor() == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)$this$l.getVirtualFile().getName(), (Object)this$0.demoFileName);
    }

    private static final TreeVisitor.Action projectTasks$lambda$30$lambda$29$lambda$28$lambda$27(CLionOnboardingTourLesson this$0, TreePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return CLionOnboardingTourLesson.projectTasks$isDemoFilePath(this$0, path) ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean projectTasks$lambda$30$lambda$29(CLionOnboardingTourLesson this$0, TaskRuntimeContext $this$restoreState) {
        JTree jTree;
        Intrinsics.checkNotNullParameter((Object)$this$restoreState, (String)"$this$restoreState");
        Component component2 = $this$restoreState.getPrevious().getUi();
        if (!(component2 instanceof JTree)) return true;
        JTree jTree2 = (JTree)component2;
        JTree jTree3 = jTree2;
        if (jTree3 == null) return true;
        JTree tree = jTree = jTree3;
        boolean bl = false;
        if (TreeUtil.visitVisibleRows((JTree)tree, arg_0 -> CLionOnboardingTourLesson.projectTasks$lambda$30$lambda$29$lambda$28$lambda$27(this$0, arg_0)) == null) return true;
        boolean bl2 = true;
        if (!bl2) return true;
        JTree jTree4 = jTree;
        component2 = jTree4;
        if (component2 == null) return true;
        if (component2.isShowing()) return false;
        return true;
    }

    private static final Unit projectTasks$lambda$30(CLionOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$this$task.strong(this$0.demoFileName)};
        String string = CLionLessonsBundle.INSTANCE.message("clion.onboarding.balloon.open.file", objectArray);
        objectArray = Balloon.Position.atRight;
        $this$task.text(string, new LearningBalloonConfig((Balloon.Position)objectArray, 0, true, null, 0, 0, 0, null, null, 504, null));
        $this$task.stateCheck(arg_0 -> CLionOnboardingTourLesson.projectTasks$lambda$30$lambda$26(this$0, arg_0));
        TaskContext.restoreState$default((TaskContext)$this$task, null, (int)0, null, arg_0 -> CLionOnboardingTourLesson.projectTasks$lambda$30$lambda$29(this$0, arg_0), (int)7, null);
        return Unit.INSTANCE;
    }

    private static final Unit openLearnToolwindow$lambda$32(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ActionButton.class, null, (Function2)new Function2<TaskRuntimeContext, ActionButton, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void stripe;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ActionButton actionButton = (ActionButton)it;
                TaskRuntimeContext $this$openLearnToolwindow_u24lambda_u2432_u24lambda_u2431 = $this$explicitComponentDetection;
                boolean bl = false;
                return Intrinsics.areEqual((Object)stripe.getAction().getTemplateText(), (Object)LearnBundle.INSTANCE.message("toolwindow.stripe.Learn", new Object[0]));
            }
        });
        return Unit.INSTANCE;
    }

    private static final boolean openLearnToolwindow$lambda$34$lambda$33(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance($this$stateCheck.getProject()).getToolWindow("Learn");
        return toolWindow != null ? toolWindow.isVisible() : false;
    }

    private static final Unit openLearnToolwindow$lambda$34(CLionOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$this$task.strong(LearnBundle.INSTANCE.message("toolwindow.stripe.Learn", new Object[0]))};
        $this$task.text(CLionLessonsBundle.INSTANCE.message("clion.onboarding.balloon.open.learn.toolbar", objectArray), new LearningBalloonConfig(Balloon.Position.atRight, 0, true, null, 0, 0, 0, null, null, 504, null));
        $this$task.stateCheck(CLionOnboardingTourLesson::openLearnToolwindow$lambda$34$lambda$33);
        LessonUtil.INSTANCE.restoreIfModified($this$task, this$0.sample);
        return Unit.INSTANCE;
    }

    private static final Unit openLearnToolwindow$lambda$35(TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        LearningUiHighlightingManager.INSTANCE.clearHighlights();
        $this$prepareRuntimeTask.requestEditorFocus();
        return Unit.INSTANCE;
    }

    private static final Unit waitIndexingTasks$lambda$37(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(NonOpaquePanel.class, null, (Function2)new Function2<TaskRuntimeContext, NonOpaquePanel, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void progress;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                NonOpaquePanel nonOpaquePanel = (NonOpaquePanel)it;
                TaskRuntimeContext $this$waitIndexingTasks_u24lambda_u2437_u24lambda_u2436 = $this$explicitComponentDetection;
                boolean bl = false;
                String string = progress.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                return StringsKt.contains$default((CharSequence)string, (CharSequence)"InlineProgressPanel", (boolean)false, (int)2, null);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit waitIndexingTasks$lambda$38(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.indexing.description", new Object[0]), null, (int)2, null);
        LessonUtilKt.waitSmartModeStep((TaskContext)$this$task);
        return Unit.INSTANCE;
    }

    private static final Unit waitIndexingTasks$lambda$39(TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        LearningUiHighlightingManager.INSTANCE.clearHighlights();
        return Unit.INSTANCE;
    }

    private static final Unit runTasks$lambda$42$lambda$40(HighlightTriggerParametersContext $this$triggerUI) {
        Intrinsics.checkNotNullParameter((Object)$this$triggerUI, (String)"$this$triggerUI");
        $this$triggerUI.setClearPreviousHighlights(false);
        return Unit.INSTANCE;
    }

    private static final Unit runTasks$lambda$42(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        HighlightingTriggerMethods this_$iv = $this$task.triggerUI(CLionOnboardingTourLesson::runTasks$lambda$42$lambda$40);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ActionButton.class, null, (Function2)new Function2<TaskRuntimeContext, ActionButton, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ActionButton actionButton = (ActionButton)it;
                TaskRuntimeContext $this$runTasks_u24lambda_u2442_u24lambda_u2441 = $this$explicitComponentDetection;
                boolean bl = false;
                return Intrinsics.areEqual((Object)ActionManager.getInstance().getId(ui.getAction()), (Object)"Run");
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit runTasks$lambda$43(CLionOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[6];
        Icon icon = AllIcons.Actions.Compile;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Compile");
        objectArray[0] = $this$task.icon(icon);
        Icon icon2 = AllIcons.Actions.Execute;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Execute");
        objectArray[1] = $this$task.icon(icon2);
        Icon icon3 = AllIcons.Actions.StartDebugger;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"StartDebugger");
        objectArray[2] = $this$task.icon(icon3);
        Icon icon4 = AllIcons.General.RunWithCoverage;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"RunWithCoverage");
        objectArray[3] = $this$task.icon(icon4);
        Icon icon5 = AllIcons.Actions.Profile;
        Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Profile");
        objectArray[4] = $this$task.icon(icon5);
        Icon icon6 = AllIcons.Actions.StartMemoryProfile;
        Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"StartMemoryProfile");
        objectArray[5] = $this$task.icon(icon6);
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.run.options", objectArray), null, (int)2, null);
        objectArray = new Object[2];
        Icon icon7 = AllIcons.Actions.Execute;
        Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"Execute");
        objectArray[0] = $this$task.icon(icon7);
        objectArray[1] = $this$task.action("Run");
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.run.sample", objectArray), null, (int)2, null);
        objectArray = new Object[2];
        Icon icon8 = AllIcons.Actions.Execute;
        Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"Execute");
        objectArray[0] = $this$task.icon(icon8);
        objectArray[1] = $this$task.action("Run");
        $this$task.text(CLionLessonsBundle.INSTANCE.message("clion.onboarding.run.sample.balloon", objectArray), new LearningBalloonConfig(Balloon.Position.below, 0, false, null, 0, 0, 0, null, null, 508, null));
        LessonUtilKt.checkToolWindowState((TaskContext)$this$task, (String)"Run", (boolean)true);
        LessonUtil.INSTANCE.restoreIfModified($this$task, this$0.sample);
        return Unit.INSTANCE;
    }

    private static final Unit debugTasks$lambda$44(Ref.ObjectRef $logicalPosition, CLionOnboardingTourLesson this$0, TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        LogicalPosition logicalPosition = $this$prepareRuntimeTask.getEditor().offsetToLogicalPosition(this$0.sample.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
        $logicalPosition.element = logicalPosition;
        return Unit.INSTANCE;
    }

    private static final LogicalPosition debugTasks$lambda$45(Ref.ObjectRef $logicalPosition) {
        return (LogicalPosition)$logicalPosition.element;
    }

    private static final Unit debugTasks$lambda$46(TaskContext $this$toggleBreakpointTask) {
        Intrinsics.checkNotNullParameter((Object)$this$toggleBreakpointTask, (String)"$this$toggleBreakpointTask");
        $this$toggleBreakpointTask.text(CLionLessonsBundle.INSTANCE.message("clion.onboarding.balloon.click.here", new Object[0]), new LearningBalloonConfig(Balloon.Position.below, 0, false, null, 0, 0, 20, null, null, 444, null));
        Object[] objectArray = new Object[]{$this$toggleBreakpointTask.code("6.5"), $this$toggleBreakpointTask.code("find_average"), $this$toggleBreakpointTask.code("26")};
        TaskContext.text$default((TaskContext)$this$toggleBreakpointTask, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.toggle.breakpoint.1", objectArray), null, (int)2, null);
        TaskContext.text$default((TaskContext)$this$toggleBreakpointTask, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.toggle.breakpoint.2", new Object[0]), null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final boolean debugTasks$lambda$48$lambda$47(Ref.ObjectRef $logicalPosition, TaskRuntimeContext $this$restoreState) {
        Intrinsics.checkNotNullParameter((Object)$this$restoreState, (String)"$this$restoreState");
        return !Intrinsics.areEqual((Object)LessonUtilKt.lineWithBreakpoints((TaskRuntimeContext)$this$restoreState), (Object)SetsKt.setOf((Object)((LogicalPosition)$logicalPosition.element).line));
    }

    private static final String debugTasks$lambda$48(CLionOnboardingTourLesson this$0, Ref.ObjectRef $logicalPosition, TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{$this$actionTask.action("Debug")};
        LessonUtilKt.showBalloonOnHighlightingComponent$default((TaskContext)$this$actionTask, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.balloon.start.debugging", objectArray), null, (int)0, null, (int)14, null);
        TaskContext.restoreState$default((TaskContext)$this$actionTask, null, (int)0, null, arg_0 -> CLionOnboardingTourLesson.debugTasks$lambda$48$lambda$47($logicalPosition, arg_0), (int)7, null);
        LessonUtil.INSTANCE.restoreIfModified($this$actionTask, this$0.sample);
        objectArray = new Object[1];
        Icon icon = AllIcons.Actions.StartDebugger;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"StartDebugger");
        objectArray[0] = $this$actionTask.icon(icon);
        return CLionLessonsBundle.INSTANCE.message("clion.onboarding.start.debugging", objectArray);
    }

    private static final Unit debugTasks$lambda$49(Ref.ObjectRef $debuggerGotItTaskId, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $debuggerGotItTaskId.element = $this$task.getTaskId();
        return Unit.INSTANCE;
    }

    private static final Unit debugTasks$lambda$50(Ref.ObjectRef $debuggerGotItTaskId, TaskContext $this$task) {
        TaskContext.TaskId taskId;
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.setRehighlightPreviousUi(Boolean.valueOf(true));
        Balloon.Position position = Balloon.Position.above;
        Object[] objectArray = new Object[2];
        String string = UIBundle.message((String)"tool.window.name.debug", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        objectArray[0] = $this$task.strong(string);
        objectArray[1] = $this$task.strong(CLionLessonsBundle.INSTANCE.message("clion.debug.workflow.lesson.name", new Object[0]));
        String string2 = CLionLessonsBundle.INSTANCE.message("clion.onboarding.balloon.about.debug.panel", objectArray);
        LessonUtilKt.gotItStep$default((TaskContext)$this$task, (Balloon.Position)position, (int)0, (String)string2, null, (int)130, (boolean)false, (int)40, null);
        if ($debuggerGotItTaskId.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggerGotItTaskId");
            taskId = null;
        } else {
            taskId = (TaskContext.TaskId)$debuggerGotItTaskId.element;
        }
        TaskContext.restoreByUi$default((TaskContext)$this$task, (TaskContext.TaskId)taskId, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final JComponent debugTasks$lambda$54$lambda$52(List list) {
        Object v0;
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Iterable $this$maxByOrNull$iv = list;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                JComponent it = (JComponent)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getLocationOnScreen().y;
                do {
                    Object e$iv = iterator$iv.next();
                    JComponent it2 = (JComponent)e$iv;
                    $i$a$-maxByOrNull-CLionOnboardingTourLesson$debugTasks$7$1$1 = false;
                    int v$iv = it2.getLocationOnScreen().y;
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        return v0;
    }

    private static final boolean debugTasks$lambda$54$lambda$53(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return XDebuggerManager.getInstance((Project)$this$stateCheck.getProject()).getCurrentSession() == null;
    }

    private static final Unit debugTasks$lambda$54(CLionOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Balloon.Position position = UIExperiment.isNewDebuggerUIEnabled() ? Balloon.Position.above : Balloon.Position.atRight;
        LessonUtilKt.showBalloonOnHighlightingComponent((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.balloon.stop.debugging", new Object[0]), (Balloon.Position)position, (int)35, CLionOnboardingTourLesson::debugTasks$lambda$54$lambda$52);
        Object[] objectArray = new Object[1];
        Icon icon = AllIcons.Actions.Suspend;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Suspend");
        objectArray[0] = $this$task.icon(icon);
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.stop.debugging", objectArray), null, (int)2, null);
        LessonUtil.INSTANCE.restoreIfModified($this$task, this$0.sample);
        $this$task.stateCheck(CLionOnboardingTourLesson::debugTasks$lambda$54$lambda$53);
        return Unit.INSTANCE;
    }

    private static final Unit debugTasks$lambda$55(TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        LearningUiHighlightingManager.INSTANCE.clearHighlights();
        return Unit.INSTANCE;
    }

    private static final Unit completionSteps$lambda$56(CLionOnboardingTourLesson this$0, TaskRuntimeContext $this$prepareRuntimeTask) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareRuntimeTask, (String)"$this$prepareRuntimeTask");
        TaskRuntimeContext.setSample$default((TaskRuntimeContext)$this$prepareRuntimeTask, (LessonSample)this$0.sample.insertAtPosition(2, " / double(values<caret>)"), (boolean)false, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit completionSteps$lambda$57(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$this$task.code(" / double(values)")};
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.type.division", objectArray), null, (int)2, null);
        LessonUtilKt.proceedLink$default((TaskContext)$this$task, (int)0, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final boolean completionSteps$lambda$59$lambda$58(TaskRuntimeContext $this$listItem, Object it) {
        Intrinsics.checkNotNullParameter((Object)$this$listItem, (String)"$this$listItem");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UtilsKt.isToStringContains((Object)it, (String)"size");
    }

    private static final Unit completionSteps$lambda$59(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$this$task.code(".")};
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.invoke.completion", objectArray), null, (int)2, null);
        objectArray = new Object[]{$this$task.code("size"), $this$task.action("CodeCompletion")};
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.start.typing", objectArray), null, (int)2, null);
        TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null).listItem(CLionOnboardingTourLesson::completionSteps$lambda$59$lambda$58);
        LessonUtilKt.proposeRestoreForInvalidText((TaskContext)$this$task, (String)".size()");
        return Unit.INSTANCE;
    }

    private static final boolean completionSteps$lambda$61$lambda$60(CLionOnboardingTourLesson this$0, TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return LessonUtil.INSTANCE.checkEditorModification($this$stateCheck, this$0.sample, 2, "/double(values.size())");
    }

    private static final Unit completionSteps$lambda$61(CLionOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$this$task.code("size"), $this$task.action("EditorChooseLookupItem")};
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.select.item", objectArray), null, (int)2, null);
        objectArray = new Object[]{$this$task.action("CodeCompletion")};
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.invoke.completion.tip", objectArray), null, (int)2, null);
        $this$task.stateCheck(arg_0 -> CLionOnboardingTourLesson.completionSteps$lambda$61$lambda$60(this$0, arg_0));
        TaskContext.restoreByUi$default((TaskContext)$this$task, null, (int)LessonUtilKt.getDefaultRestoreDelay(), null, (int)5, null);
        return Unit.INSTANCE;
    }

    private static final boolean contextActions$lambda$63$lambda$62(TaskRuntimeContext $this$listItem, Object item) {
        Intrinsics.checkNotNullParameter((Object)$this$listItem, (String)"$this$listItem");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return UtilsKt.isToStringContains((Object)item, (String)"Clang");
    }

    private static final Unit contextActions$lambda$63(TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.invoke.intention.for.warning.1", new Object[0]), null, (int)2, null);
        Object[] objectArray = new Object[]{$this$task.action(it)};
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.invoke.intention.for.warning.2", objectArray), null, (int)2, null);
        TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null).listItem(CLionOnboardingTourLesson::contextActions$lambda$63$lambda$62);
        LessonUtil.restoreIfModifiedOrMoved$default((LessonUtil)LessonUtil.INSTANCE, (TaskContext)$this$task, null, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final boolean contextActions$lambda$65$lambda$64(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        return !Intrinsics.areEqual((Object)$this$stateCheck.getPrevious().getSample().getText(), (Object)$this$stateCheck.getEditor().getDocument().getText());
    }

    private static final Unit contextActions$lambda$65(String $clangTidyMessage, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{$this$task.strong($clangTidyMessage)};
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.select.fix", objectArray), null, (int)2, null);
        $this$task.stateCheck(CLionOnboardingTourLesson::contextActions$lambda$65$lambda$64);
        TaskContext.restoreByUi$default((TaskContext)$this$task, null, (int)LessonUtilKt.getDefaultRestoreDelay(), null, (int)5, null);
        return Unit.INSTANCE;
    }

    private static final boolean contextActions$lambda$67$lambda$66(TaskRuntimeContext $this$listItem, Object item) {
        Intrinsics.checkNotNullParameter((Object)$this$listItem, (String)"$this$listItem");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return UtilsKt.isToStringContains((Object)item, (String)"Clang");
    }

    private static final Unit contextActions$lambda$67(TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{$this$task.code("std::vector"), $this$task.code("find_average"), $this$task.action(it)};
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.invoke.intention.for.code", objectArray), null, (int)2, null);
        TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null).listItem(CLionOnboardingTourLesson::contextActions$lambda$67$lambda$66);
        LessonUtil.restoreIfModifiedOrMoved$default((LessonUtil)LessonUtil.INSTANCE, (TaskContext)$this$task, null, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final boolean contextActions$lambda$69$lambda$68(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        String string = $this$stateCheck.getEditor().getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        return !Intrinsics.areEqual((Object)$this$stateCheck.getPrevious().getSample().getText(), (Object)text) && StringsKt.contains$default((CharSequence)text, (CharSequence)"const", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)text, (CharSequence)"<double> values", (boolean)false, (int)2, null);
    }

    private static final Unit contextActions$lambda$69(TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[]{LessonUtil.INSTANCE.rawEnter()};
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.apply.intention", objectArray), null, (int)2, null);
        $this$task.stateCheck(CLionOnboardingTourLesson::contextActions$lambda$69$lambda$68);
        TaskContext.restoreByUi$default((TaskContext)$this$task, null, (int)LessonUtilKt.getDefaultRestoreDelay(), null, (int)5, null);
        return Unit.INSTANCE;
    }

    private static final Unit searchEverywhereTasks$lambda$71(String $toggleCase, TaskContext $this$task, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNull((Object)$toggleCase);
        objectArray[0] = $this$task.strong($toggleCase);
        objectArray[1] = $this$task.code("AVERAGE");
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.invoke.search.everywhere.1", objectArray), null, (int)2, null);
        objectArray = new Object[]{LessonUtil.INSTANCE.rawKeyStroke(16), LessonUtil.INSTANCE.actionName(it)};
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.invoke.search.everywhere.2", objectArray), null, (int)2, null);
        HighlightingTriggerMethods this_$iv = TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null);
        boolean $i$f$component = false;
        this_$iv.explicitComponentDetection(ExtendableTextField.class, null, (Function2)new Function2<TaskRuntimeContext, ExtendableTextField, Boolean>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public final Boolean invoke(TaskRuntimeContext $this$explicitComponentDetection, Component it) {
                void ui;
                Intrinsics.checkNotNullParameter((Object)$this$explicitComponentDetection, (String)"$this$explicitComponentDetection");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ExtendableTextField extendableTextField = (ExtendableTextField)it;
                TaskRuntimeContext $this$searchEverywhereTasks_u24lambda_u2471_u24lambda_u2470 = $this$explicitComponentDetection;
                boolean bl = false;
                return UIUtil.getParentOfType(SearchEverywhereUI.class, (Component)((Component)ui)) != null;
            }
        });
        LessonUtil.restoreIfModifiedOrMoved$default((LessonUtil)LessonUtil.INSTANCE, (TaskContext)$this$task, null, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit searchEverywhereTasks$lambda$74$lambda$72(CLionOnboardingTourLesson this$0, TaskRuntimeContext $this$before) {
        Intrinsics.checkNotNullParameter((Object)$this$before, (String)"$this$before");
        if (this$0.backupPopupLocation != null) {
            return Unit.INSTANCE;
        }
        Component component2 = $this$before.getPrevious().getUi();
        if (component2 == null) {
            return Unit.INSTANCE;
        }
        Component ui = component2;
        JWindow jWindow = (JWindow)UIUtil.getParentOfType(JWindow.class, (Component)ui);
        if (jWindow == null) {
            return Unit.INSTANCE;
        }
        JWindow popupWindow = jWindow;
        Point oldPopupLocation = WindowStateService.getInstance((Project)$this$before.getProject()).getLocation("search.everywhere.popup");
        if (LessonUtil.INSTANCE.adjustSearchEverywherePosition($this$before, popupWindow, "8})") || LessonUtil.INSTANCE.adjustPopupPosition($this$before.getProject(), (Window)popupWindow)) {
            this$0.backupPopupLocation = oldPopupLocation;
        }
        return Unit.INSTANCE;
    }

    private static final boolean searchEverywhereTasks$lambda$74$lambda$73(TaskRuntimeContext $this$listItem, Object item) {
        Intrinsics.checkNotNullParameter((Object)$this$listItem, (String)"$this$listItem");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        GotoActionModel.MatchedValue matchedValue = item instanceof GotoActionModel.MatchedValue ? (GotoActionModel.MatchedValue)item : null;
        Object value = matchedValue != null ? matchedValue.value : null;
        GotoActionModel.ActionWrapper actionWrapper = value instanceof GotoActionModel.ActionWrapper ? (GotoActionModel.ActionWrapper)value : null;
        return (actionWrapper != null ? actionWrapper.getAction() : null) instanceof ToggleCaseAction;
    }

    private static final Unit searchEverywhereTasks$lambda$74(CLionOnboardingTourLesson this$0, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.setTransparentRestore(Boolean.valueOf(true));
        $this$task.before(arg_0 -> CLionOnboardingTourLesson.searchEverywhereTasks$lambda$74$lambda$72(this$0, arg_0));
        Object[] objectArray = new Object[]{$this$task.code("AVERAGE"), $this$task.code(CLionLessonsBundle.INSTANCE.message("clion.onboarding.toggle.case.part", new Object[0]))};
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.search.everywhere.description", objectArray), null, (int)2, null);
        TaskContext.triggerAndBorderHighlight$default((TaskContext)$this$task, null, (int)1, null).listItem(CLionOnboardingTourLesson::searchEverywhereTasks$lambda$74$lambda$73);
        TaskContext.restoreByUi$default((TaskContext)$this$task, null, (int)0, null, (int)7, null);
        LessonUtil.restoreIfModifiedOrMoved$default((LessonUtil)LessonUtil.INSTANCE, (TaskContext)$this$task, null, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final boolean searchEverywhereTasks$lambda$76$lambda$75(TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        String string = $this$stateCheck.getEditor().getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"\"average", (boolean)false, (int)2, null);
    }

    private static final Unit searchEverywhereTasks$lambda$76(String $toggleCase, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNull((Object)$toggleCase);
        objectArray[0] = $this$task.strong($toggleCase);
        objectArray[1] = LessonUtil.INSTANCE.rawEnter();
        TaskContext.text$default((TaskContext)$this$task, (String)CLionLessonsBundle.INSTANCE.message("clion.onboarding.apply.action", objectArray), null, (int)2, null);
        $this$task.stateCheck(CLionOnboardingTourLesson::searchEverywhereTasks$lambda$76$lambda$75);
        TaskContext.restoreByUi$default((TaskContext)$this$task, null, (int)LessonUtilKt.getDefaultRestoreDelay(), null, (int)5, null);
        return Unit.INSTANCE;
    }
}

