/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.eventtrace.holder;

import com.intellij.clion.profiling.eventtrace.abstractevent.MetadataRenameEventType;
import com.intellij.clion.profiling.eventtrace.abstractevent.MetadataType;
import com.intellij.clion.profiling.eventtrace.abstractevent.TraceEvent;
import com.intellij.clion.profiling.eventtrace.abstractevent.TraceGlobalEvent;
import com.intellij.clion.profiling.eventtrace.abstractevent.TraceGlobalEventType;
import com.intellij.clion.profiling.eventtrace.abstractevent.TraceMetadataEvent;
import com.intellij.clion.profiling.eventtrace.abstractevent.TracePartialEvent;
import com.intellij.clion.profiling.eventtrace.holder.ClosableEventHolder;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001dH\u0014J\u001c\u0010\u001e\u001a\u00020\u001c2\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150 H\u0014J,\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030(H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000e\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/clion/profiling/eventtrace/holder/EventNodeHolder;", "Lcom/intellij/clion/profiling/eventtrace/holder/ClosableEventHolder;", "level", "", "name", "splitKey", "globalLevel", "Lcom/intellij/clion/profiling/eventtrace/abstractevent/TraceGlobalEventType;", "childConstructor", "Lkotlin/Function1;", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/clion/profiling/eventtrace/abstractevent/TraceGlobalEventType;Lkotlin/jvm/functions/Function1;)V", "getLevel", "()Ljava/lang/String;", "getName", "setName", "(Ljava/lang/String;)V", "childes", "Ljava/util/HashMap;", "globalEvents", "Ljava/util/ArrayList;", "Lcom/intellij/clion/profiling/eventtrace/abstractevent/TraceGlobalEvent;", "metadataAdd", "", "e", "Lcom/intellij/clion/profiling/eventtrace/abstractevent/TraceMetadataEvent;", "safeAdd", "", "Lcom/intellij/clion/profiling/eventtrace/abstractevent/TraceEvent;", "forcePush", "higherLevelEvents", "Ljava/util/LinkedList;", "safeBuildNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "isCompact", "isReverseList", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "model", "Lkotlin/reflect/KClass;", "intellij.clion.profiling"})
public class EventNodeHolder
extends ClosableEventHolder {
    @NotNull
    private final String level;
    @NotNull
    private String name;
    @NotNull
    private final String splitKey;
    @Nullable
    private final TraceGlobalEventType globalLevel;
    @NotNull
    private final Function1<Long, ClosableEventHolder> childConstructor;
    @NotNull
    private final HashMap<Long, ClosableEventHolder> childes;
    @NotNull
    private final ArrayList<TraceGlobalEvent> globalEvents;

    public EventNodeHolder(@NotNull String level, @NotNull String name, @NotNull String splitKey, @Nullable TraceGlobalEventType globalLevel, @NotNull Function1<? super Long, ? extends ClosableEventHolder> childConstructor) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)splitKey, (String)"splitKey");
        Intrinsics.checkNotNullParameter(childConstructor, (String)"childConstructor");
        this.level = level;
        this.name = name;
        this.splitKey = splitKey;
        this.globalLevel = globalLevel;
        this.childConstructor = childConstructor;
        this.childes = new HashMap();
        this.globalEvents = new ArrayList();
    }

    @NotNull
    public final String getLevel() {
        return this.level;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    public boolean metadataAdd(@NotNull TraceMetadataEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getMetadata() instanceof MetadataRenameEventType) {
            MetadataType metadataType = e.getMetadata();
            Intrinsics.checkNotNull((Object)metadataType, (String)"null cannot be cast to non-null type com.intellij.clion.profiling.eventtrace.abstractevent.MetadataRenameEventType");
            if (Intrinsics.areEqual((Object)((MetadataRenameEventType)metadataType).getLevel(), (Object)this.level)) {
                MetadataType metadataType2 = e.getMetadata();
                Intrinsics.checkNotNull((Object)metadataType2, (String)"null cannot be cast to non-null type com.intellij.clion.profiling.eventtrace.abstractevent.MetadataRenameEventType");
                this.name = ((MetadataRenameEventType)metadataType2).getName();
                return true;
            }
        }
        return false;
    }

    @Override
    protected void safeAdd(@NotNull TraceEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof TraceGlobalEvent && this.globalLevel != null && ((TraceGlobalEvent)e).getTypeEvent().compareTo(this.globalLevel) <= 0) {
            this.globalEvents.add((TraceGlobalEvent)e);
            return;
        }
        if (e instanceof TraceMetadataEvent && this.metadataAdd((TraceMetadataEvent)e)) {
            return;
        }
        if (e instanceof TracePartialEvent && ((TracePartialEvent)e).getPart().containsKey(this.splitKey)) {
            Long l = ((TracePartialEvent)e).getPart().get(this.splitKey);
            Intrinsics.checkNotNull((Object)l);
            long splitter = ((Number)l).longValue();
            if (!this.childes.containsKey(splitter)) {
                ((Map)this.childes).put(splitter, this.childConstructor.invoke((Object)splitter));
            }
            ClosableEventHolder closableEventHolder = this.childes.get(splitter);
            Intrinsics.checkNotNull((Object)closableEventHolder);
            closableEventHolder.add(e);
        }
    }

    @Override
    protected void forcePush(@NotNull LinkedList<ArrayList<TraceGlobalEvent>> higherLevelEvents) {
        Intrinsics.checkNotNullParameter(higherLevelEvents, (String)"higherLevelEvents");
        higherLevelEvents.addLast(this.globalEvents);
        Iterator<ClosableEventHolder> iterator = this.childes.values().iterator();
        while (iterator.hasNext()) {
            ClosableEventHolder child;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            child.close(higherLevelEvents);
        }
        higherLevelEvents.removeLast();
        this.globalEvents.clear();
    }

    @Override
    @NotNull
    protected DefaultMutableTreeNode safeBuildNode(boolean isCompact, boolean isReverseList, @NotNull ProgressIndicator progressIndicator, @NotNull KClass<?> model) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.name);
        Iterator<ClosableEventHolder> iterator = this.childes.values().iterator();
        while (iterator.hasNext()) {
            ClosableEventHolder it;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            root.add(it.buildNode(isCompact, isReverseList, progressIndicator, model));
            if (!progressIndicator.isCanceled()) continue;
            return root;
        }
        return root;
    }
}

