/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.eventtrace.intervals;

import com.intellij.clion.profiling.eventtrace.intervals.ColorizeTimelineInterval;
import com.intellij.clion.profiling.eventtrace.intervals.TextualTimelineInterval;
import com.intellij.clion.profiling.eventtrace.intervals.TraceLineIntervalEvent;
import com.intellij.execution.filters.Filter;
import com.intellij.ui.JBColor;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/intellij/clion/profiling/eventtrace/intervals/TraceEventLineInterval;", "Lcom/intellij/clion/profiling/eventtrace/intervals/ColorizeTimelineInterval;", "Lcom/intellij/clion/profiling/eventtrace/intervals/TraceLineIntervalEvent;", "Lcom/intellij/clion/profiling/eventtrace/intervals/TextualTimelineInterval;", "intervalEvent", "<init>", "(Lcom/intellij/clion/profiling/eventtrace/intervals/TraceLineIntervalEvent;)V", "getIntervalEvent", "()Lcom/intellij/clion/profiling/eventtrace/intervals/TraceLineIntervalEvent;", "content", "getContent", "start", "", "getStart", "()J", "end", "getEnd", "toString", "", "toLabel", "Ljavax/swing/JComponent;", "filter", "Lcom/intellij/execution/filters/Filter;", "hyperLinkCreator", "Lkotlin/Function0;", "Ljavax/swing/event/HyperlinkListener;", "color", "Lcom/intellij/ui/JBColor;", "getColor", "()Lcom/intellij/ui/JBColor;", "text", "getText", "()Ljava/lang/String;", "intellij.clion.profiling"})
public final class TraceEventLineInterval
implements ColorizeTimelineInterval<TraceLineIntervalEvent>,
TextualTimelineInterval<TraceLineIntervalEvent> {
    @NotNull
    private final TraceLineIntervalEvent intervalEvent;
    private final long start;
    private final long end;

    public TraceEventLineInterval(@NotNull TraceLineIntervalEvent intervalEvent) {
        Intrinsics.checkNotNullParameter((Object)intervalEvent, (String)"intervalEvent");
        this.intervalEvent = intervalEvent;
        this.start = this.intervalEvent.getStart();
        this.end = this.intervalEvent.getEnd();
    }

    @NotNull
    public final TraceLineIntervalEvent getIntervalEvent() {
        return this.intervalEvent;
    }

    @NotNull
    public TraceLineIntervalEvent getContent() {
        return this.intervalEvent;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.intervalEvent);
    }

    @NotNull
    public final JComponent toLabel(@Nullable Filter filter, @Nullable Function0<? extends HyperlinkListener> hyperLinkCreator) {
        return this.intervalEvent.toLabel(filter, hyperLinkCreator);
    }

    @Override
    @Nullable
    public JBColor getColor() {
        JBColor jBColor;
        if (this.intervalEvent.getColor() == null) {
            jBColor = null;
        } else {
            Color color = this.intervalEvent.getColor();
            Intrinsics.checkNotNull((Object)color);
            Color color2 = this.intervalEvent.getColor();
            Intrinsics.checkNotNull((Object)color2);
            jBColor = new JBColor(color, color2);
        }
        return jBColor;
    }

    @Override
    @NotNull
    public String getText() {
        return this.intervalEvent.toShortString();
    }
}

