/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.memory;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeBuildProfileExecutionTarget;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CLionMemoryProfileUtil {
    private static final Logger LOG = Logger.getInstance(CLionMemoryProfileUtil.class);

    private CLionMemoryProfileUtil() {
    }

    @Nullable
    public static String tryResolvePath(@NotNull String path, @NotNull CidrToolEnvironment environment) {
        if (path == null) {
            CLionMemoryProfileUtil.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            CLionMemoryProfileUtil.$$$reportNull$$$0(1);
        }
        try {
            HostMachine hostMachine = environment.getHostMachine();
            Object[] canonicalPath = hostMachine.toCanonicalPath(List.of(path), true);
            if (!ContainerUtil.and((Object[])canonicalPath, p -> Files.exists(hostMachine.getPath(p, new String[0]), new LinkOption[0]))) {
                return null;
            }
            List localPaths = hostMachine.resolveAndCache(Arrays.asList(canonicalPath));
            return localPaths.size() == 1 ? (String)localPaths.get(0) : null;
        }
        catch (Exception e) {
            LOG.warn("Cannot resolveAndCache directory: " + path, (Throwable)e);
            return null;
        }
    }

    public static boolean checkPathExistAllowed(@NotNull HostMachine host) {
        if (host == null) {
            CLionMemoryProfileUtil.$$$reportNull$$$0(2);
        }
        return host instanceof LocalHost || !host.isRemote() || host.hasRemoteFS();
    }

    public static boolean checkPathExist(@NotNull HostMachine host, @NotNull String path) {
        if (host == null) {
            CLionMemoryProfileUtil.$$$reportNull$$$0(3);
        }
        if (path == null) {
            CLionMemoryProfileUtil.$$$reportNull$$$0(4);
        }
        return !CLionMemoryProfileUtil.checkPathExistAllowed(host) || StringUtil.isNotEmpty((String)path) && Files.exists(host.getPath(path, new String[0]), new LinkOption[0]);
    }

    @Nullable
    public static CidrToolEnvironment getEnvironment(@NotNull Project project) {
        if (project == null) {
            CLionMemoryProfileUtil.$$$reportNull$$$0(5);
        }
        CMakeWorkspace workspace = CMakeWorkspace.getInstance((Project)project);
        Pair configurationWithTarget = CMakeAppRunConfiguration.getSelectedConfigurationAndTarget((Project)project);
        if (configurationWithTarget == null) {
            return null;
        }
        CMakeAppRunConfiguration configuration = (CMakeAppRunConfiguration)configurationWithTarget.getFirst();
        CMakeBuildProfileExecutionTarget target = (CMakeBuildProfileExecutionTarget)configurationWithTarget.getSecond();
        if (configuration == null || target == null) {
            return null;
        }
        CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations = configuration.getBuildAndRunConfigurations((ExecutionTarget)target);
        if (buildAndRunConfigurations == null) {
            return null;
        }
        try {
            CMakeProfileInfo profileInfo = workspace.getProfileInfoFor(buildAndRunConfigurations.buildConfiguration);
            return profileInfo.getEnvironment();
        }
        catch (ExecutionException e) {
            LOG.error("Cannot get environment", (Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/clion/profiling/memory/CLionMemoryProfileUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryResolvePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPathExistAllowed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPathExist";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnvironment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

