/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.sanitizers;

import com.intellij.clion.profiling.sanitizers.SanitizersKind;
import com.intellij.clion.profiling.sanitizers.SanitizersUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SanitizersOptionsBuilder {
    @Nullable
    private final Map<SanitizersKind, String> myRuntimeFlags;
    private final boolean myUseVisualRepresentation;

    public SanitizersOptionsBuilder(@Nullable Map<SanitizersKind, String> runtimeFlags, boolean useVisualRepresentation) {
        this.myRuntimeFlags = runtimeFlags;
        this.myUseVisualRepresentation = useVisualRepresentation;
    }

    public Map<SanitizersKind, String> getOptions(@NotNull String outputFilePathPrefix) {
        if (outputFilePathPrefix == null) {
            SanitizersOptionsBuilder.$$$reportNull$$$0(0);
        }
        HashMap<SanitizersKind, String> flags = new HashMap<SanitizersKind, String>();
        for (SanitizersKind sanitizer : SanitizersKind.values()) {
            flags.put(sanitizer, this.getFlags(sanitizer, outputFilePathPrefix));
        }
        return flags;
    }

    @NotNull
    private String getFlags(@NotNull SanitizersKind sanitizer, @NotNull String outputFilePathPrefix) {
        if (sanitizer == null) {
            SanitizersOptionsBuilder.$$$reportNull$$$0(1);
        }
        if (outputFilePathPrefix == null) {
            SanitizersOptionsBuilder.$$$reportNull$$$0(2);
        }
        ArrayList<String> flags = this.myRuntimeFlags != null ? ParametersListUtil.parse((String)StringUtil.notNullize((String)this.myRuntimeFlags.get((Object)sanitizer))) : new ArrayList<String>();
        this.overridePredefinedFlags(flags, sanitizer, outputFilePathPrefix);
        String string = StringUtil.join(flags, (String)" ");
        if (string == null) {
            SanitizersOptionsBuilder.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void overridePredefinedFlags(@NotNull List<String> flags, @NotNull SanitizersKind sanitizer, @NotNull String outputFilePathPrefix) {
        if (flags == null) {
            SanitizersOptionsBuilder.$$$reportNull$$$0(4);
        }
        if (sanitizer == null) {
            SanitizersOptionsBuilder.$$$reportNull$$$0(5);
        }
        if (outputFilePathPrefix == null) {
            SanitizersOptionsBuilder.$$$reportNull$$$0(6);
        }
        if (this.myUseVisualRepresentation) {
            SanitizersOptionsBuilder.putOrReplace("log_path", outputFilePathPrefix, flags);
            SanitizersOptionsBuilder.putOrReplace("stack_trace_format", SanitizersUtil.STACK_TRACE_FORMAT, flags);
            SanitizersOptionsBuilder.putOrReplace("print_summary", "true", flags);
        } else {
            SanitizersOptionsBuilder.putOrReplace("log_path", "stderr", flags);
        }
        if (sanitizer == SanitizersKind.UNDEFINED_BEHAVIOR_SANITIZER) {
            SanitizersOptionsBuilder.putOrReplace("print_stacktrace", "1", flags);
        }
    }

    private static void putOrReplace(@NonNls @NotNull String flagName, @NonNls @NotNull String flagValue, @NotNull List<String> flags) {
        if (flagName == null) {
            SanitizersOptionsBuilder.$$$reportNull$$$0(7);
        }
        if (flagValue == null) {
            SanitizersOptionsBuilder.$$$reportNull$$$0(8);
        }
        if (flags == null) {
            SanitizersOptionsBuilder.$$$reportNull$$$0(9);
        }
        flags.removeIf(flag -> flag.startsWith(flagName));
        flags.add(flagName + "='" + flagValue + "'");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFilePathPrefix";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sanitizer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/clion/profiling/sanitizers/SanitizersOptionsBuilder";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flags";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flagName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flagValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/clion/profiling/sanitizers/SanitizersOptionsBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOptions";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFlags";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "overridePredefinedFlags";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putOrReplace";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

