/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.profiler.api.XLocalAttachProfiler;
import com.intellij.profiler.api.XLocalAttachProfilerProvider;
import com.intellij.profiler.clion.ProfilerPresentationGroup;
import com.intellij.profiler.clion.dtrace.DTraceAttachProfiler;
import com.intellij.profiler.clion.perf.PerfAttachProfiler;
import com.intellij.xdebugger.attach.XAttachProcessPresentationGroup;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/profiler/clion/CLionLocalAttachProfilerProvider;", "Lcom/intellij/profiler/api/XLocalAttachProfilerProvider;", "<init>", "()V", "isEnabled", "", "getPresentationGroup", "Lcom/intellij/xdebugger/attach/XAttachProcessPresentationGroup;", "getAvailableProfilers", "", "Lcom/intellij/profiler/api/XLocalAttachProfiler;", "project", "Lcom/intellij/openapi/project/Project;", "process", "Lcom/intellij/execution/process/ProcessInfo;", "contextHolder", "Lcom/intellij/openapi/util/UserDataHolder;", "intellij.profiler.clion"})
final class CLionLocalAttachProfilerProvider
implements XLocalAttachProfilerProvider {
    public boolean isEnabled() {
        return SystemInfo.isMac || SystemInfo.isLinux;
    }

    @NotNull
    public XAttachProcessPresentationGroup getPresentationGroup() {
        return ProfilerPresentationGroup.Companion.getPresentationGroup();
    }

    @NotNull
    public List<XLocalAttachProfiler> getAvailableProfilers(@NotNull Project project, @NotNull ProcessInfo process, @NotNull UserDataHolder contextHolder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)contextHolder, (String)"contextHolder");
        if (SystemInfo.isMac) {
            return CollectionsKt.listOf((Object)new DTraceAttachProfiler(process));
        }
        if (SystemInfo.isLinux) {
            return CollectionsKt.listOf((Object)new PerfAttachProfiler(process));
        }
        return CollectionsKt.emptyList();
    }
}

