/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.profiler.api.AttachableTargetProcess;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/intellij/profiler/clion/NativeTargetProcess;", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "pid", "", "fullName", "", "<init>", "(ILjava/lang/String;)V", "process", "Lcom/intellij/execution/process/ProcessInfo;", "(Lcom/intellij/execution/process/ProcessInfo;)V", "getPid", "()I", "getFullName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "intellij.profiler.clion"})
public final class NativeTargetProcess
implements AttachableTargetProcess {
    private final int pid;
    @NotNull
    private final String fullName;

    public NativeTargetProcess(int pid, @NotNull String fullName) {
        Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
        this.pid = pid;
        this.fullName = fullName;
    }

    public int getPid() {
        return this.pid;
    }

    @NotNull
    public String getFullName() {
        return this.fullName;
    }

    public NativeTargetProcess(@NotNull ProcessInfo process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        int n = process.getPid();
        String string = process.getExecutableDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExecutableDisplayName(...)");
        this(n, string);
    }

    public final int component1() {
        return this.pid;
    }

    @NotNull
    public final String component2() {
        return this.fullName;
    }

    @NotNull
    public final NativeTargetProcess copy(int pid, @NotNull String fullName) {
        Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
        return new NativeTargetProcess(pid, fullName);
    }

    public static /* synthetic */ NativeTargetProcess copy$default(NativeTargetProcess nativeTargetProcess, int n, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = nativeTargetProcess.pid;
        }
        if ((n2 & 2) != 0) {
            string = nativeTargetProcess.fullName;
        }
        return nativeTargetProcess.copy(n, string);
    }

    @NotNull
    public String toString() {
        return "NativeTargetProcess(pid=" + this.pid + ", fullName=" + this.fullName + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.pid);
        result = result * 31 + this.fullName.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NativeTargetProcess)) {
            return false;
        }
        NativeTargetProcess nativeTargetProcess = (NativeTargetProcess)other;
        if (this.pid != nativeTargetProcess.pid) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.fullName, (Object)nativeTargetProcess.fullName);
    }
}

