/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion;

import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.profiler.clion.CPPProfilerBundleKt;
import com.intellij.profiler.dtrace.SimpleProfilerSettingsState;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\u0012\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\tH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/profiler/clion/PerfProfilerConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "settings", "Lcom/intellij/profiler/dtrace/SimpleProfilerSettingsState;", "<init>", "(Lcom/intellij/profiler/dtrace/SimpleProfilerSettingsState;)V", "getSettings", "()Lcom/intellij/profiler/dtrace/SimpleProfilerSettingsState;", "profilerName", "", "profilerPathTextField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "frequencyTextField", "Lcom/intellij/ui/components/fields/IntegerField;", "outputDirectoryTextField", "deleteOutputOnExitCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "processInlineFunctions", "getId", "getDisplayName", "getHelpTopic", "createComponent", "Ljavax/swing/JComponent;", "isModified", "", "reset", "", "apply", "normalizeString", "str", "Companion", "intellij.profiler.clion"})
public final class PerfProfilerConfigurable
implements SearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleProfilerSettingsState settings;
    @NotNull
    private final String profilerName;
    @Nullable
    private TextFieldWithBrowseButton profilerPathTextField;
    @Nullable
    private IntegerField frequencyTextField;
    @NotNull
    private TextFieldWithBrowseButton outputDirectoryTextField;
    @Nullable
    private JBCheckBox deleteOutputOnExitCheckBox;
    @Nullable
    private JBCheckBox processInlineFunctions;
    @NotNull
    public static final String ID = "dynamic.analysis.tools.profiler";

    public PerfProfilerConfigurable(@NotNull SimpleProfilerSettingsState settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.profilerName = "Perf";
        this.outputDirectoryTextField = new TextFieldWithBrowseButton();
    }

    @NotNull
    protected final SimpleProfilerSettingsState getSettings() {
        return this.settings;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        return CPPProfilerBundleKt.profilerMessage("perf.profiler.configurable.name", new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return "procedures.profiler";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JComponent createComponent() {
        void $this$createComponent_u24lambda_u240;
        Object[] objectArray;
        Object[] objectArray2 = objectArray = new IntegerField(null, 0, Integer.MAX_VALUE);
        PerfProfilerConfigurable perfProfilerConfigurable = this;
        boolean bl = false;
        $this$createComponent_u24lambda_u240.setValue(Integer.valueOf(this.settings.getSamplingFrequency()));
        $this$createComponent_u24lambda_u240.setDefaultValue(Integer.valueOf(this.settings.getSamplingFrequency()));
        perfProfilerConfigurable.frequencyTextField = objectArray;
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.profilerPathTextField = new TextFieldWithBrowseButton();
        Intrinsics.checkNotNull((Object)textFieldWithBrowseButton);
        String string = this.settings.getExecutablePath();
        if (string == null) {
            string = "";
        }
        textFieldWithBrowseButton.setText(string);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.profilerPathTextField;
        Intrinsics.checkNotNull((Object)textFieldWithBrowseButton2);
        TextFieldWithBrowseButton textFieldWithBrowseButton3 = this.profilerPathTextField;
        Intrinsics.checkNotNull((Object)textFieldWithBrowseButton3);
        objectArray = new Object[]{this.profilerName};
        textFieldWithBrowseButton2.addActionListener((ActionListener)new BrowseFilesListener(textFieldWithBrowseButton3.getTextField(), FileChooserDescriptorFactory.createSingleFileDescriptor().withTitle(CPPProfilerBundleKt.profilerMessage("profiler.executable.dialog.title", objectArray))));
        this.outputDirectoryTextField = new TextFieldWithBrowseButton();
        UiUtils.getEmptyText((TextFieldWithBrowseButton)this.outputDirectoryTextField).setText(CPPProfilerBundleKt.profilerMessage("profiler.data.default.output.directory.placeholder", new Object[0]));
        String string2 = this.settings.getOutputDirectory();
        if (string2 == null) {
            string2 = "";
        }
        this.outputDirectoryTextField.setText(string2);
        this.outputDirectoryTextField.addActionListener((ActionListener)new BrowseFilesListener(this.outputDirectoryTextField.getTextField(), FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(CPPProfilerBundleKt.profilerMessage("profiler.browse.directory.dialog.title", new Object[0]))));
        return (JComponent)BuilderKt.panel(arg_0 -> PerfProfilerConfigurable.createComponent$lambda$6(this, arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        String string = this.normalizeString(this.settings.getExecutablePath());
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.profilerPathTextField;
        Intrinsics.checkNotNull((Object)textFieldWithBrowseButton);
        if (!Intrinsics.areEqual((Object)string, (Object)this.normalizeString(textFieldWithBrowseButton.getText()))) return true;
        int n = this.settings.getSamplingFrequency();
        IntegerField integerField = this.frequencyTextField;
        Intrinsics.checkNotNull((Object)integerField);
        Integer n2 = integerField.getValue();
        if (n2 == null) return true;
        if (n != n2) return true;
        if (!Intrinsics.areEqual((Object)this.normalizeString(this.settings.getOutputDirectory()), (Object)this.normalizeString(this.outputDirectoryTextField.getText()))) return true;
        boolean bl = this.settings.getDeleteOutputOnExit();
        JBCheckBox jBCheckBox = this.deleteOutputOnExitCheckBox;
        Intrinsics.checkNotNull((Object)jBCheckBox);
        if (bl != jBCheckBox.isSelected()) return true;
        boolean bl2 = this.settings.getProcessInlineFunctions();
        JBCheckBox jBCheckBox2 = this.processInlineFunctions;
        Intrinsics.checkNotNull((Object)jBCheckBox2);
        if (bl2 == jBCheckBox2.isSelected()) return false;
        return true;
    }

    public void reset() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.profilerPathTextField;
        Intrinsics.checkNotNull((Object)textFieldWithBrowseButton);
        textFieldWithBrowseButton.setText(this.normalizeString(this.settings.getExecutablePath()));
        IntegerField integerField = this.frequencyTextField;
        Intrinsics.checkNotNull((Object)integerField);
        integerField.setValue(Integer.valueOf(this.settings.getSamplingFrequency()));
        this.outputDirectoryTextField.setText(this.normalizeString(this.settings.getOutputDirectory()));
        JBCheckBox jBCheckBox = this.deleteOutputOnExitCheckBox;
        Intrinsics.checkNotNull((Object)jBCheckBox);
        jBCheckBox.setSelected(this.settings.getDeleteOutputOnExit());
        JBCheckBox jBCheckBox2 = this.processInlineFunctions;
        Intrinsics.checkNotNull((Object)jBCheckBox2);
        jBCheckBox2.setSelected(this.settings.getProcessInlineFunctions());
    }

    public void apply() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.profilerPathTextField;
        Intrinsics.checkNotNull((Object)textFieldWithBrowseButton);
        this.settings.setExecutablePath(this.normalizeString(textFieldWithBrowseButton.getText()));
        IntegerField integerField = this.frequencyTextField;
        Intrinsics.checkNotNull((Object)integerField);
        Integer n = integerField.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getValue(...)");
        this.settings.setSamplingFrequency(((Number)n).intValue());
        this.settings.setOutputDirectory(this.normalizeString(this.outputDirectoryTextField.getText()));
        JBCheckBox jBCheckBox = this.deleteOutputOnExitCheckBox;
        Intrinsics.checkNotNull((Object)jBCheckBox);
        this.settings.setDeleteOutputOnExit(jBCheckBox.isSelected());
        JBCheckBox jBCheckBox2 = this.processInlineFunctions;
        Intrinsics.checkNotNull((Object)jBCheckBox2);
        this.settings.setProcessInlineFunctions(jBCheckBox2.isSelected());
        IntegerField integerField2 = this.frequencyTextField;
        Intrinsics.checkNotNull((Object)integerField2);
        integerField2.setDefaultValue(Integer.valueOf(this.settings.getSamplingFrequency()));
    }

    private final String normalizeString(String str) {
        String string = str;
        String string2 = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private static final Unit createComponent$lambda$6$lambda$1(PerfProfilerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldWithBrowseButton textFieldWithBrowseButton = this$0.profilerPathTextField;
        Intrinsics.checkNotNull((Object)textFieldWithBrowseButton);
        $this$row.cell((JComponent)textFieldWithBrowseButton).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$6$lambda$2(PerfProfilerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        IntegerField integerField = this$0.frequencyTextField;
        Intrinsics.checkNotNull((Object)integerField);
        Cell.comment$default((Cell)$this$row.cell((JComponent)integerField), (String)CPPProfilerBundleKt.profilerMessage("profiler.sampling.frequency.note", new Object[0]), (int)0, null, (int)6, null).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$6$lambda$3(PerfProfilerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.outputDirectoryTextField).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$6$lambda$4(PerfProfilerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.deleteOutputOnExitCheckBox = (JBCheckBox)ButtonKt.selected((Cell)$this$row.checkBox(CPPProfilerBundleKt.profilerMessage("profiler.delete.files.on.exit.checkbox", new Object[0])), (boolean)this$0.settings.getDeleteOutputOnExit()).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$6$lambda$5(PerfProfilerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.processInlineFunctions = (JBCheckBox)ButtonKt.selected((Cell)Cell.comment$default((Cell)$this$row.checkBox(CPPProfilerBundleKt.profilerMessage("profiler.show.inline.functions", new Object[0])), (String)CPPProfilerBundleKt.profilerMessage("profiler.show.inline.functions.hint", new Object[0]), (int)0, null, (int)6, null).align((Align)AlignX.FILL.INSTANCE), (boolean)this$0.settings.getProcessInlineFunctions()).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createComponent$lambda$6(PerfProfilerConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Object[] objectArray = new Object[]{this$0.profilerName};
        $this$panel.row(CPPProfilerBundleKt.profilerMessage("profiler.executable.label", objectArray), arg_0 -> PerfProfilerConfigurable.createComponent$lambda$6$lambda$1(this$0, arg_0));
        $this$panel.row(CPPProfilerBundleKt.profilerMessage("profiler.sampling.frequency.label", new Object[0]), arg_0 -> PerfProfilerConfigurable.createComponent$lambda$6$lambda$2(this$0, arg_0));
        $this$panel.row(CPPProfilerBundleKt.profilerMessage("profiler.output.directory.label", new Object[0]), arg_0 -> PerfProfilerConfigurable.createComponent$lambda$6$lambda$3(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PerfProfilerConfigurable.createComponent$lambda$6$lambda$4(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PerfProfilerConfigurable.createComponent$lambda$6$lambda$5(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/clion/PerfProfilerConfigurable$Companion;", "", "<init>", "()V", "ID", "", "intellij.profiler.clion"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

