/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.NotNull;

public final class OCDFAUtilsBase {
    public static final Key<Integer> DFA_TIME_LIMIT = Key.create((String)"DFA_TIME_LIMIT");
    public static final int DEFAULT_TIME_LIMIT_IN_SEC = 5;
    private static final Logger LOG = Logger.getInstance((String)OCDFAUtilsBase.class.getName());

    public static long getTimeLimit(@NotNull Project project) {
        if (project == null) {
            OCDFAUtilsBase.$$$reportNull$$$0(0);
        }
        try {
            Integer forcedTimeLimit = (Integer)project.getUserData(DFA_TIME_LIMIT);
            if (forcedTimeLimit != null && forcedTimeLimit > 0) {
                return Math.multiplyExact(forcedTimeLimit, 1000);
            }
            int timeLimitFromRegistry = Registry.get((String)"cidr.inspection.dfa.timeout.in.sec").asInteger();
            if (timeLimitFromRegistry > 0) {
                return Math.multiplyExact(timeLimitFromRegistry, 1000);
            }
        }
        catch (ArithmeticException e) {
            LOG.debug("Cannot use preferred TIME_LIMIT. Default one will be used:" + e.getMessage());
            return 5000L;
        }
        LOG.debug("Using default TIME_LIMIT for DFA");
        return 5000L;
    }

    public static long getPerFunctionBatchTimeLimit(@NotNull Project project) {
        if (project == null) {
            OCDFAUtilsBase.$$$reportNull$$$0(1);
        }
        try {
            int timeLimitFromRegistry = Registry.get((String)"cidr.inspection.dfa.timeout.per.function.batch.in.sec").asInteger();
            if (timeLimitFromRegistry > 0) {
                return Math.multiplyExact(timeLimitFromRegistry, 1000);
            }
        }
        catch (ArithmeticException e) {
            LOG.debug("Cannot use preferred TIME_LIMIT. Default one will be used:" + e.getMessage());
            return 5000L;
        }
        LOG.debug("Using default TIME_LIMIT for DFA");
        return 5000L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCDFAUtilsBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTimeLimit";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPerFunctionBatchTimeLimit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

