/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.bridge;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.rml.dfa.AnalysisOptions;
import com.intellij.rml.dfa.DfaAnalysisRmlResult;
import com.intellij.rml.dfa.DfaRegistry;
import com.intellij.rml.dfa.analyzes.ConstantConditionsGlobalAnalysisKt;
import com.intellij.rml.dfa.analyzes.ParametersSubstitutorAnalysisKt;
import com.intellij.rml.dfa.attributes.Attribute;
import com.intellij.rml.dfa.attributes.DfaTuple;
import com.intellij.rml.dfa.ide.DfaIntentionActionProvider;
import com.intellij.rml.dfa.ir.IrEnvironment;
import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.ir.IrProject;
import com.intellij.rml.dfa.rml.DfaConstants;
import com.intellij.rml.dfa.rml.DfaConstantsKt;
import com.intellij.rml.dfa.rml.dsl.lang.RmlRelation;
import com.intellij.rml.dfa.test.DfaTestUtils;
import com.intellij.rml.dfa.test.IrSerializationProvider;
import com.intellij.rml.dfa.test.IrSerializer;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.Location;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangQuickFixFactoryKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.DFARawTuple;
import com.jetbrains.cidr.lang.dfa.DFATuplesParserKt;
import com.jetbrains.cidr.lang.dfa.OCControlFlowBuilder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDFAInput;
import com.jetbrains.cidr.lang.dfa.OCDFAInspectionBaseRunner;
import com.jetbrains.cidr.lang.dfa.OCDFAUtilsBase;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCLocalDefinitionsSearcher;
import com.jetbrains.cidr.lang.dfa.analyzes.ArrayIndexOutOfBoundsAnalysisKt;
import com.jetbrains.cidr.lang.dfa.analyzes.EndlessLoopAndUnreachableNodesAnalysisKt;
import com.jetbrains.cidr.lang.dfa.analyzes.EscapeAnalysisKt;
import com.jetbrains.cidr.lang.dfa.analyzes.InfiniteRecursionAnalysisKt;
import com.jetbrains.cidr.lang.dfa.analyzes.LoopConditionsAnalysisKt;
import com.jetbrains.cidr.lang.dfa.analyzes.UnusedAnalysisKt;
import com.jetbrains.cidr.lang.dfa.analyzes.extensions.CppConstantConditionsExtensionKt;
import com.jetbrains.cidr.lang.dfa.analyzes.extensions.CppParametersSubstitutorExtensionKt;
import com.jetbrains.cidr.lang.dfa.analyzes.input.GlobalInput;
import com.jetbrains.cidr.lang.dfa.bridge.OCDFAUtils;
import com.jetbrains.cidr.lang.dfa.translator.OCRmlToIrTranslatorExtension;
import com.jetbrains.cidr.lang.inspections.OCChecksSettings;
import com.jetbrains.cidr.lang.inspections.OCDFAInspection;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.inspections.OCProblemRegister;
import com.jetbrains.cidr.lang.inspections.SimplifyInspectionKt;
import com.jetbrains.cidr.lang.inspections.dfa.DFARunner;
import com.jetbrains.cidr.lang.inspections.dfa.OCDFAInspectionConfigUtil;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCoyieldStatement;
import com.jetbrains.cidr.lang.psi.OCCppCoawaitExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingDeclaration;
import com.jetbrains.cidr.lang.psi.impl.OCCppCoreturnStatementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeGCCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCInlineParameterFix;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationButInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveInitializerIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.util.OCSimplifyUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class OCDFAInspectionRunner
extends OCDFAInspectionBaseRunner
implements DFARunner {
    public boolean canRun(@NotNull PsiFile file) {
        if (file == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(0);
        }
        if (!(file instanceof OCFile)) {
            return false;
        }
        if (!OCDFAInspectionConfigUtil.isClangdDFAEnabled((PsiFile)file)) {
            return false;
        }
        if (!ClangUtils.isClangdOn((Project)file.getProject()) || !ClangdBridge.isClangdShowErrors((Project)file.getProject(), (VirtualFile)file.getViewProvider().getVirtualFile())) {
            return false;
        }
        if (((OCFile)file).getKind().isObjC()) {
            return ApplicationManager.getApplication().isUnitTestMode();
        }
        return true;
    }

    public void run(@NotNull PsiFile psiFile, @NotNull ProblemsHolder problemsHolder, @Nullable Predicate<Class<? extends OCInspectionBase.DfaMarker>> filter) {
        if (psiFile == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(1);
        }
        if (problemsHolder == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(2);
        }
        ProblemsHolder testProblemsHolder = (ProblemsHolder)psiFile.getProject().getUserData(TEST_PROBLEMS_HOLDER);
        List<VirtualFile> testScope = (List<VirtualFile>)psiFile.getProject().getUserData(TEST_SCOPE);
        ProblemsHolder holder = testProblemsHolder != null ? testProblemsHolder : problemsHolder;
        List<VirtualFile> scope = testScope != null ? testScope : Collections.singletonList(psiFile.getVirtualFile());
        OCDFAInspectionRunner.run(scope, psiFile, psiFile.getProject(), new OCProblemRegister.ProblemConsumer(holder), filter);
    }

    public static void run(@NotNull List<VirtualFile> files, @NotNull Object scope, @NotNull Project project, @NotNull OCProblemRegister.ProblemConsumer consumer, @Nullable Predicate<Class<? extends OCInspectionBase.DfaMarker>> filter) {
        if (files == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(4);
        }
        if (project == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(5);
        }
        if (consumer == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(6);
        }
        long timeLimit = scope instanceof PsiFile ? OCDFAUtilsBase.getTimeLimit(project) : -1L;
        long perFunctionTimeLimit = scope instanceof PsiFile ? timeLimit : OCDFAUtilsBase.getPerFunctionBatchTimeLimit(project);
        OCDFAInput dfaInput = OCDFAInspectionRunner.getDFAInput(files, project, !consumer.isOnTheFly());
        if (dfaInput == null) {
            return;
        }
        if (dfaInput.isEmpty()) {
            if (DfaRegistry.isLogEnabled()) {
                LOG.warn("DFA input is empty");
            }
            return;
        }
        if (dfaInput.isTooComplex()) {
            if (DfaRegistry.isLogEnabled()) {
                LOG.warn("DFA input is empty because the file is too large");
            }
            if (scope instanceof OCFile) {
                OCDFAInspectionRunner.reportTimeOverWarning(consumer, (OCFile)scope, OCInspectionsBundle.message((String)"inspection.message.file.too.complex.to.perform.data.flow.analysis", (Object[])new Object[0]));
            }
            return;
        }
        VirtualFile file = files.size() == 1 ? files.get(0) : null;
        DfaAnalysisRmlResult result = OCDFAInspectionRunner.computeDFA(dfaInput, project, timeLimit, perFunctionTimeLimit, -1, AnalysisOptions.INSTANCE.getDefaultOptions(), file);
        String generateIR = (String)project.getUserData(GENERATE_IR);
        if (generateIR != null) {
            DfaTestUtils testUtils = (DfaTestUtils)ApplicationManager.getApplication().getService(DfaTestUtils.class);
            kotlin.Pair topLevelDecls = testUtils.translateToIR(dfaInput.getAllTuples(), Collections.singletonList(new OCRmlToIrTranslatorExtension()));
            IrSerializer serializer = IrSerializationProvider.Companion.getInstance().createIrSerializer();
            serializer.setAnalysisResult(result);
            serializer.setWarningLocations((Map)topLevelDecls.component2());
            serializer.serialize((IrProject)topLevelDecls.component1());
            try {
                FileUtil.writeToFile((File)new File(generateIR), (String)serializer.getResult());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        ReadAction.run(() -> {
            if (result == null) {
                if (scope instanceof OCFile) {
                    OCDFAInspectionRunner.reportTimeOverWarning(consumer, (OCFile)scope, OCInspectionsBundle.message((String)"inspection.message.file.too.complex.to.perform.data.flow.analysis", (Object[])new Object[0]));
                }
                return;
            }
            IrEnvironment environment = result.getEnvironment();
            if (OCDFAInspectionRunner.shouldRunInspection(OCInspections.ConstantConditionsOC.class, filter)) {
                ArrayList<DfaTuple> conditions = new ArrayList<DfaTuple>();
                conditions.addAll(result.get((RmlRelation)ConstantConditionsGlobalAnalysisKt.getAlwaysTrueCondition()));
                conditions.addAll(result.get((RmlRelation)ConstantConditionsGlobalAnalysisKt.getAlwaysFalseCondition()));
                conditions.addAll(result.get(CppConstantConditionsExtensionKt.getAlwaysTrueWhenReachedCondition()));
                conditions.addAll(result.get(CppConstantConditionsExtensionKt.getAlwaysFalseWhenReachedCondition()));
                conditions.addAll(result.get(GlobalInput.INSTANCE.getImplicitRead()));
                Set<PsiElement> parents = OCDFAInspectionRunner.getParents(OCDFAInspectionRunner.getElements(conditions, environment, project));
                OCDFAInspectionRunner.registerWarnings(consumer, result.get((RmlRelation)ConstantConditionsGlobalAnalysisKt.getAlwaysTrueCondition()), environment, file, project, parents, OCInspectionsBundle.message((String)"inspection.message.condition.always.true", (Object[])new Object[0]), OCInspections.ConstantConditionsOC.class, OCDFAInspectionRunner.getSimplifyFixes(true));
                OCDFAInspectionRunner.registerWarnings(consumer, result.get((RmlRelation)ConstantConditionsGlobalAnalysisKt.getAlwaysFalseCondition()), environment, file, project, parents, OCInspectionsBundle.message((String)"inspection.message.condition.always.false", (Object[])new Object[0]), OCInspections.ConstantConditionsOC.class, OCDFAInspectionRunner.getSimplifyFixes(false));
                OCDFAInspectionRunner.registerWarnings(consumer, result.get(CppConstantConditionsExtensionKt.getAlwaysTrueWhenReachedCondition()), environment, file, project, parents, OCInspectionsBundle.message((String)"inspection.message.condition.always.true.when.reached", (Object[])new Object[0]), OCInspections.ConstantConditionsOC.class, OCDFAInspectionRunner.getSimplifyFixes(true));
                OCDFAInspectionRunner.registerWarnings(consumer, result.get(CppConstantConditionsExtensionKt.getAlwaysFalseWhenReachedCondition()), environment, file, project, parents, OCInspectionsBundle.message((String)"inspection.message.condition.always.false.when.reached", (Object[])new Object[0]), OCInspections.ConstantConditionsOC.class, OCDFAInspectionRunner.getSimplifyFixes(false));
            }
            if (OCDFAInspectionRunner.shouldRunInspection(OCInspections.NullDereference.class, filter)) {
                OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get((RmlRelation)ParametersSubstitutorAnalysisKt.getNullDereference()), environment, file, project, (PsiElement e) -> false, OCDFAInspectionRunner.calledFromSuffix((Function<Object[], String>)((Function)elements -> OCInspectionsBundle.message((String)"inspection.message.reference.may.be.choice.null", (Object[])new Object[0]))), OCInspections.NullDereference.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, OCDFAInspectionRunner.getInitializeFix());
            }
            if (OCDFAInspectionRunner.shouldRunInspection(OCInspections.NotInitializedField.class, filter)) {
                OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get((RmlRelation)ParametersSubstitutorAnalysisKt.getNotInitializedFieldUsage()), environment, file, project, (PsiElement e) -> false, OCDFAInspectionRunner.calledFromSuffix(OCDFAInspectionRunner.message(1, OCSymbolKind.STRUCT_FIELD, "inspection.message.not.initialized.field.usage", false, true)), OCInspections.NotInitializedField.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
            }
            if (OCDFAInspectionRunner.shouldRunInspection(OCInspections.LoopDoesntUseConditionVariableInspection.class, filter)) {
                OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get(LoopConditionsAnalysisKt.getLoopConditionNotUpdated()), environment, file, project, (PsiElement e) -> false, OCDFAInspectionRunner.message(1, "inspection.message.not.updated.in.loop", true), OCInspections.LoopDoesntUseConditionVariableInspection.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
            }
            if (OCDFAInspectionRunner.shouldRunInspection(OCInspections.DanglingPointer.class, filter)) {
                OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get(CppParametersSubstitutorExtensionKt.getDeletedPointerUsage()), environment, file, project, (PsiElement e) -> false, OCDFAInspectionRunner.calledFromSuffix(OCDFAInspectionRunner.message(1, "inspection.message.may.point.to.deallocated.memory", true)), OCInspections.DanglingPointer.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
                OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get(CppParametersSubstitutorExtensionKt.getDeletedFieldUsage()), environment, file, project, (PsiElement e) -> false, OCDFAInspectionRunner.calledFromSuffix(OCDFAInspectionRunner.message(1, "inspection.message.may.point.to.deallocated.memory", true)), OCInspections.DanglingPointer.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
            }
            if (OCDFAInspectionRunner.shouldRunInspection(OCInspections.MemoryLeak.class, filter)) {
                OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get(CppParametersSubstitutorExtensionKt.getMemoryLeak()), environment, file, project, (PsiElement e) -> false, OCDFAInspectionRunner.memoryLeakMessage(), OCInspections.MemoryLeak.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
                OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get(CppParametersSubstitutorExtensionKt.getLeakedMemoryAllocation()), environment, file, project, (PsiElement e) -> false, OCDFAInspectionRunner.calledFromSuffix((Function<Object[], String>)((Function)elements -> OCInspectionsBundle.message((String)"inspection.message.allocated.memory.leaked", (Object[])new Object[0]))), OCInspections.MemoryLeak.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
            }
            if (OCDFAInspectionRunner.shouldRunInspection(OCInspections.LocalValueEscapesScope.class, filter)) {
                OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get(EscapeAnalysisKt.getOutOfScopePointerUsage()), environment, file, project, (PsiElement e) -> false, OCDFAInspectionRunner.message(1, "inspection.message.may.point.to.out.of.scope.memory", true), OCInspections.LocalValueEscapesScope.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
                OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get(EscapeAnalysisKt.getInvalidatedPointerUsage()), environment, file, project, (PsiElement e) -> false, OCDFAInspectionRunner.message(1, "inspection.message.may.point.to.invalidated.memory", true), OCInspections.LocalValueEscapesScope.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
                OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get(EscapeAnalysisKt.getEscapedVarLocalReference()), environment, file, project, (PsiElement e) -> false, OCDFAInspectionRunner.message(1, OCSymbolKind.LOCAL_VARIABLE, "inspection.message.address.local.variable.may.escape.function", false, true), OCInspections.LocalValueEscapesScope.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
                OCDFAInspectionRunner.registerWarnings(consumer, result.get(EscapeAnalysisKt.getEscapedObjectLocalReference()), environment, file, project, null, OCInspectionsBundle.message((String)"inspection.message.address.local.object.may.escape.function", (Object[])new Object[0]), OCInspections.LocalValueEscapesScope.class, null);
            }
            if (OCDFAInspectionRunner.shouldRunInspection(OCInspections.ConstantParameter.class, filter)) {
                OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get((RmlRelation)ParametersSubstitutorAnalysisKt.getConstantParameter()), environment, file, project, (PsiElement e) -> false, OCDFAInspectionRunner.constantParameterMessage(), OCInspections.ConstantParameter.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, OCDFAInspectionRunner.getConstantParameterFix());
            }
            if (OCDFAInspectionRunner.shouldRunInspection(OCInspections.ConstantFunctionResult.class, filter)) {
                OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get((RmlRelation)ParametersSubstitutorAnalysisKt.getConstantFunctionResult()), environment, file, project, OCDFAInspectionRunner.excludeConstFunctionResult(), OCDFAInspectionRunner.constantFunctionResultMessage(), OCInspections.ConstantFunctionResult.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
            }
            if (OCDFAInspectionRunner.shouldRunInspection(OCInspections.ArrayIndexOutOfBounds.class, filter)) {
                OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get(ArrayIndexOutOfBoundsAnalysisKt.getArrayIndexOutOfBounds()), environment, file, project, (PsiElement e) -> false, OCDFAInspectionRunner.calledFromSuffix(OCDFAInspectionRunner.arrayIndexOutOfBoundsMessage()), OCInspections.ArrayIndexOutOfBounds.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
                OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get(ArrayIndexOutOfBoundsAnalysisKt.getArraySomeIndexOutOfBounds()), environment, file, project, (PsiElement e) -> false, OCDFAInspectionRunner.calledFromSuffix(OCDFAInspectionRunner.arrayIndexOutOfBoundsMessage()), OCInspections.ArrayIndexOutOfBounds.class, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null);
            }
            if (project.getUserData(OCChecksSettings.DFA_UNREACHABLE_CODE) != Boolean.FALSE) {
                if (OCDFAInspectionRunner.shouldRunInspection(OCInspections.UnreachableCode.class, filter)) {
                    List unreachableRanges = ContainerUtil.filter(OCDFAInspectionRunner.getElementRanges(result.get(EndlessLoopAndUnreachableNodesAnalysisKt.getUnreachableRange()), environment, project), OCDFAInspectionRunner.excludeUnreachableCode());
                    OCDFAInspectionRunner.registerWarnings(consumer, OCInspectionsBundle.message((String)"inspection.message.unreachable.code", (Object[])new Object[0]), OCInspections.UnreachableCode.class, unreachableRanges, ProblemHighlightType.LIKE_UNUSED_SYMBOL, null);
                }
                if (OCDFAInspectionRunner.shouldRunInspection(OCInspections.UnreachableCallsOfFunction.class, filter)) {
                    Function<Object[], String> message = OCDFAInspectionRunner.message(0, OCSymbolKind.FUNCTION_DECLARATION, "inspection.message.calls.unreachable", false, true);
                    OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get(EndlessLoopAndUnreachableNodesAnalysisKt.getFunctionCallsUnreachable()), environment, file, project, OCDFAInspectionRunner.excludeUnreachableFunctionCalls(), message, OCInspections.UnreachableCallsOfFunction.class, ProblemHighlightType.LIKE_UNUSED_SYMBOL, null);
                }
            }
            if (OCDFAInspectionRunner.shouldRunInspection(OCInspections.EndlessLoop.class, filter)) {
                List endlessRanges = ContainerUtil.filter(OCDFAInspectionRunner.getElementRanges(result.get(EndlessLoopAndUnreachableNodesAnalysisKt.getEndlessLoop()), environment, project), OCDFAInspectionRunner.excludeEndlessLoops());
                OCDFAInspectionRunner.registerWarnings(consumer, OCInspectionsBundle.message((String)"inspection.message.endless.loop", (Object[])new Object[0]), OCInspections.EndlessLoop.class, endlessRanges, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, OCDFAInspectionRunner.getMarkNoreturnFix());
            }
            if (OCDFAInspectionRunner.shouldRunInspection(OCInspections.InfiniteRecursion.class, filter)) {
                OCDFAInspectionRunner.registerWarnings(consumer, result.get(InfiniteRecursionAnalysisKt.getInfiniteRecursion()), environment, file, project, null, OCInspectionsBundle.message((String)"inspection.message.infinite.recursion", (Object[])new Object[0]), OCInspections.InfiniteRecursion.class, null);
            }
            if (project.getUserData(OCChecksSettings.DFA_UNUSED_CHECKS) != OCChecksSettings.UnusedChecksMode.DISABLED) {
                Predicate<PsiElement> excludeUnused = OCDFAInspectionRunner.excludeUnusedElement(OCDFAInspectionRunner.getElements(result.get(GlobalInput.INSTANCE.getImplicitRead()), environment, project));
                if (OCDFAInspectionRunner.shouldRunInspection(OCInspections.UnusedValue.class, filter)) {
                    OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get(UnusedAnalysisKt.getUnusedValue()), environment, file, project, excludeUnused, (Function<Object[], String>)((Function)e -> OCInspectionsBundle.message((String)"inspection.message.value.never.used", (Object[])new Object[0])), OCInspections.UnusedValue.class, ProblemHighlightType.LIKE_UNUSED_SYMBOL, OCDFAInspectionRunner.getRemoveValueFix());
                }
                if (OCDFAInspectionRunner.shouldRunInspection(OCInspections.UnusedParameter.class, filter) || OCDFAInspectionRunner.shouldRunInspection(OCInspections.UnusedLocalVariable.class, filter)) {
                    OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get(UnusedAnalysisKt.getUnusedVariable()), environment, file, project, excludeUnused, OCDFAInspectionRunner.message(0, "inspection.message.is.never.used", false), OCDFAInspectionRunner.unusedInspectionClass(filter), ProblemHighlightType.LIKE_UNUSED_SYMBOL, OCDFAInspectionRunner.getRemoveVariableFix());
                    OCDFAInspectionRunner.registerWarnings(consumer, (List<DfaTuple>)result.get(UnusedAnalysisKt.getVariableNotRead()), environment, file, project, excludeUnused, OCDFAInspectionRunner.message(0, "inspection.message.only.assigned.but.never.accessed", true), OCDFAInspectionRunner.unusedInspectionClass(filter), ProblemHighlightType.LIKE_UNUSED_SYMBOL, OCDFAInspectionRunner.getRemoveVariableFix());
                }
            }
        });
    }

    private static boolean shouldRunInspection(@NotNull Class<? extends OCInspections.DataFlowAnalysis> inspectionClass, @Nullable Predicate<Class<? extends OCInspectionBase.DfaMarker>> filter) {
        if (inspectionClass == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(7);
        }
        return filter == null || filter.test(inspectionClass);
    }

    private static void reportTimeOverWarning(@NotNull OCProblemRegister.ProblemConsumer consumer, OCFile file, @InspectionMessage String message) {
        if (consumer == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(8);
        }
        final Ref elementRef = new Ref();
        file.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            public void visitClassDeclaration(OCClassDeclaration dcl) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)dcl.getNameIdentifier());
                }
            }

            public void visitStruct(OCStruct struct) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)struct.getNameIdentifier());
                }
            }

            public void visitFunctionDefinition(OCFunctionDefinition functionDefinition) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)functionDefinition.getNameIdentifier());
                }
            }
        });
        if (!elementRef.isNull()) {
            OCProblemRegister.registerProblem((OCProblemRegister.ProblemConsumer)consumer, (PsiElement)((PsiElement)elementRef.get()), (String)message, (String)"CIDR", (ProblemHighlightType)ProblemHighlightType.WEAK_WARNING, OCDFAInspection.class, (IntentionAction[])new IntentionAction[0]);
        }
    }

    private static List<OCElementsRange> getElementRanges(List<DfaTuple> tuples, IrEnvironment environment, @NotNull Project project) {
        if (project == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(9);
        }
        ArrayList<OCElementsRange> ranges = new ArrayList<OCElementsRange>();
        OCDFAInspectionRunner.processTuples(tuples, (Consumer<Pair<Object[], DfaTuple>>)((Consumer)pair -> {
            Object attr = ((Object[])pair.first)[0];
            if (attr instanceof PsiElement) {
                PsiElement element = (PsiElement)attr;
                OCElementsRange range = new OCElementsRange(element, element);
                range.setContainsCompositeElement(true);
                ranges.add(range.expand());
            }
        }), environment, project);
        return ranges;
    }

    private static Set<Object> getElements(List<DfaTuple> tuples, IrEnvironment environment, @NotNull Project project) {
        if (project == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(10);
        }
        HashSet<Object> result = new HashSet<Object>();
        OCDFAInspectionRunner.processTuples(tuples, (Consumer<Pair<Object[], DfaTuple>>)((Consumer)pair -> result.add(((Object[])pair.first)[0])), environment, project);
        return result;
    }

    @NotNull
    private static Set<PsiElement> getParents(Set<Object> elements) {
        HashSet<PsiElement> parents = new HashSet<PsiElement>();
        for (Object element : elements) {
            if (!(element instanceof PsiElement)) continue;
            for (PsiElement parent = ((PsiElement)element).getParent(); parent != null; parent = parent.getParent()) {
                parents.add(parent);
            }
        }
        HashSet<PsiElement> hashSet = parents;
        if (hashSet == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    private static void registerWarnings(@NotNull OCProblemRegister.ProblemConsumer consumer, @NotNull List<DfaTuple> tuples, IrEnvironment environment, @Nullable VirtualFile file, Project project, @Nullable Set<PsiElement> excludeElements, @InspectionMessage String message, Class<? extends OCInspection> inspection, @Nullable ElementFix fixes) {
        if (consumer == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(12);
        }
        if (tuples == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(13);
        }
        OCDFAInspectionRunner.registerWarnings(consumer, tuples, environment, file, project, (PsiElement element) -> excludeElements != null && excludeElements.contains(element), (Function<Object[], String>)((Function)element -> message), inspection, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
    }

    private static void registerWarnings(@NotNull OCProblemRegister.ProblemConsumer consumer, @NotNull List<DfaTuple> tuples, IrEnvironment environment, @Nullable VirtualFile file, Project project, Predicate<PsiElement> excludeElement, Function<Object[], @InspectionMessage String> messageFun, Class<? extends OCInspection> inspection, ProblemHighlightType highlightType, @Nullable ElementFix fixes) {
        if (consumer == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(14);
        }
        if (tuples == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(15);
        }
        OCDFAInspectionRunner.registerWarnings(consumer, tuples, environment, file, project, excludeElement, messageFun, (Function<Object[], Class<? extends OCInspection>>)((Function)element -> inspection), highlightType, fixes);
    }

    private static void registerWarnings(@NotNull OCProblemRegister.ProblemConsumer consumer, @NotNull List<DfaTuple> attrs, IrEnvironment environment, @Nullable VirtualFile file, Project project, Predicate<PsiElement> excludeElement, Function<Object[], @InspectionMessage String> messageFun, Function<Object[], Class<? extends OCInspection>> inspectionFun, ProblemHighlightType highlightType, @Nullable ElementFix fixes) {
        if (consumer == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(16);
        }
        if (attrs == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(17);
        }
        HashSet<Object[]> tuples = new HashSet<Object[]>();
        HashMap tuplesMap = new HashMap();
        OCDFAInspectionRunner.processTuples(attrs, (Consumer<Pair<Object[], DfaTuple>>)((Consumer)pair -> {
            tuples.add((Object[])pair.getFirst());
            tuplesMap.put((Object[])pair.getFirst(), (DfaTuple)pair.getSecond());
        }), environment, project);
        tuples.removeIf(tuple -> ContainerUtil.exists((Object[])tuple, el -> el instanceof PsiElement && excludeElement.test((PsiElement)el)));
        ArrayList sorted = new ArrayList(tuples);
        ContainerUtil.sort(sorted, Comparator.comparing(tuple -> {
            Object element = tuple[((Object[])tuple).length - 1];
            return element instanceof PsiElement ? (double)((PsiElement)element).getTextOffset() : (element instanceof Double ? Double.parseDouble(element.toString()) : (double)element.hashCode());
        }));
        for (Object[] tuple2 : sorted) {
            Class inspectionCls;
            Object object = tuple2[0];
            if (!(object instanceof PsiElement)) continue;
            PsiElement element = (PsiElement)object;
            if (file != null && !element.getContainingFile().getVirtualFile().equals(file)) continue;
            List<IntentionAction> fixesList = fixes != null ? fixes.getFixes(tuple2) : Collections.emptyList();
            fixesList = new ArrayList(fixesList);
            fixesList.addAll(DfaIntentionActionProvider.getInstance().getTupleIntentionAction((DfaTuple)tuplesMap.get(tuple2)));
            String message = (String)messageFun.fun((Object)tuple2);
            if (message == null || (inspectionCls = (Class)inspectionFun.fun((Object)tuple2)) == null) continue;
            OCProblemRegister.registerProblem((OCProblemRegister.ProblemConsumer)consumer, (PsiElement)element, (String)message, (String)"CIDR", (ProblemHighlightType)highlightType, (Class)((Class)inspectionFun.fun((Object)tuple2)), (IntentionAction[])fixesList.toArray(IntentionAction.EMPTY_ARRAY));
        }
    }

    private static void registerWarnings(@NotNull OCProblemRegister.ProblemConsumer consumer, @InspectionMessage String message, Class<? extends OCInspection> inspection, @Unmodifiable List<? extends OCElementsRange> ranges, ProblemHighlightType highlightType, @Nullable ElementFix fixes) {
        if (consumer == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(18);
        }
        for (OCElementsRange range : OCElementsRange.mergeRanges(ranges, (inspection == OCInspections.UnreachableCode.class ? 1 : 0) != 0, (inspection == OCInspections.EndlessLoop.class ? 1 : 0) != 0)) {
            PsiElement startElement = range.getFirstElement();
            PsiElement endElement = range.getLastElement();
            while (startElement instanceof OCMacroForeignLeafElement) {
                startElement = startElement.getParent();
            }
            while (endElement instanceof OCMacroForeignLeafElement) {
                endElement = endElement.getParent();
            }
            range = new OCElementsRange(startElement, endElement);
            OCElementsRange trimmedRange = range.trim(TokenSet.orSet((TokenSet[])new TokenSet[]{OCElementsRange.NON_IMPORTANT_TOKENS, TokenSet.create((IElementType[])new IElementType[]{OCLexerTokenTypes.SEMICOLON})}));
            if (trimmedRange == null || trimmedRange.isEmpty()) continue;
            OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)startElement, OCCallable.class);
            List<IntentionAction> fixesList = fixes != null ? fixes.getFixes(new Object[]{callable}) : Collections.emptyList();
            OCProblemRegister.registerProblem((OCProblemRegister.ProblemConsumer)consumer, (OCElementsRange)range, (String)message, (String)"CIDR", (ProblemHighlightType)highlightType, inspection, (IntentionAction[])fixesList.toArray(IntentionAction.EMPTY_ARRAY));
        }
    }

    private static ElementFix getSimplifyFixes(boolean constantCondition) {
        return tuple -> {
            Object patt29157$temp = tuple[0];
            if (!(patt29157$temp instanceof PsiElement)) {
                return Collections.emptyList();
            }
            PsiElement element = (PsiElement)patt29157$temp;
            ArrayList<Object> fixes = new ArrayList<Object>();
            OCResolveContext context = OCResolveContext.forPsi((PsiElement)element);
            String constant = OCDFAUtils.getTypeConstant((OCType)OCIntType.getAppropriateBool((PsiElement)element.getContainingFile()), constantCondition ? 1 : 0, context, element.getContainingFile());
            OCExpression newElement = OCElementFactory.expressionFromText((String)constant, (PsiElement)element, (boolean)false);
            fixes.add(new OCChangeElementIntentionAction(element, (PsiElement)newElement, OCInspectionsBundle.message((String)"intention.family.name.simplify.condition", (Object[])new Object[]{constant})));
            OCElement parent = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCIfStatement.class, OCLoopStatement.class, OCBinaryExpression.class, OCConditionalExpression.class});
            OCStatement simplified = null;
            if (parent instanceof OCStatement) {
                simplified = SimplifyInspectionKt.simplifyStatementWithConstCondition((boolean)constantCondition, (OCStatement)((OCStatement)parent));
            } else if (parent instanceof OCBinaryExpression) {
                simplified = OCSimplifyUtil.simplifyLogicExpression((boolean)constantCondition, (OCBinaryExpression)((OCBinaryExpression)parent), (PsiElement)element);
            }
            if (simplified != null && SimplifyInspectionKt.isSafeToSimplify((PsiElement)parent, (PsiElement)simplified)) {
                fixes.add(SimplifyInspectionKt.getSimplifyFix((PsiElement)parent, (PsiElement)simplified));
            }
            return fixes;
        };
    }

    private static ElementFix getInitializeFix() {
        return tuple -> {
            Object patt30705$temp = tuple[0];
            if (!(patt30705$temp instanceof PsiElement)) {
                return Collections.emptyList();
            }
            PsiElement element = (PsiElement)patt30705$temp;
            OCSymbol symbol = element instanceof OCReferenceElement ? ((OCReferenceElement)element).resolveToSymbol() : null;
            OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
            if (symbol != null && callable != null) {
                OCInstruction instruction;
                OCControlFlowGraph graph2 = new OCControlFlowGraph((PsiElement)callable, null);
                OCControlFlowBuilder builder = new OCControlFlowBuilder(null, graph2, null);
                builder.processFirstCodeFragment((PsiElement)callable);
                OCLocalDefinitionsSearcher defSearcher = new OCLocalDefinitionsSearcher(graph2, symbol, element.getParent(), false, true, true);
                defSearcher.process();
                Collection declarators = defSearcher.getInstructionsOfKind(OCInstruction.InstructionKind.DECLARATOR);
                if (!declarators.isEmpty() && (instruction = (OCInstruction)declarators.iterator().next()).getRValue() instanceof OCDeclarator) {
                    return Collections.singletonList(new OCAddInitializerIntentionAction((OCDeclarator)instruction.getRValue(), symbol));
                }
            }
            return Collections.emptyList();
        };
    }

    private static ElementFix getMarkNoreturnFix() {
        return tuple -> {
            OCSymbolWithQualifiedName symbol;
            Object patt32005$temp = tuple[0];
            if (!(patt32005$temp instanceof PsiElement)) {
                return Collections.emptyList();
            }
            PsiElement callable = (PsiElement)patt32005$temp;
            if (!(!(callable instanceof OCFunctionDeclaration) || (symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)callable).getSymbol()) == null || symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isMainFunction())) {
                return Collections.singletonList(OCChangeGCCAttributeIntentionAction.noreturn((OCSymbol)symbol, (PsiFile)callable.getContainingFile()));
            }
            return Collections.emptyList();
        };
    }

    private static ElementFix getRemoveValueFix() {
        return tuple -> {
            Object patt32633$temp = tuple[0];
            if (!(patt32633$temp instanceof PsiElement)) {
                return Collections.emptyList();
            }
            PsiElement element = (PsiElement)patt32633$temp;
            PsiElement expr = PsiTreeUtil.getParentOfType((PsiElement)element, OCExpression.class, (boolean)false);
            if (expr == null) {
                return Collections.emptyList();
            }
            PsiElement parent = expr.getParent();
            ArrayList<Object> fixes = new ArrayList<Object>();
            IElementType type = OCElementUtil.getElementType((PsiElement)element);
            if (type == OCLexerTokenTypes.PLUSPLUS || type == OCLexerTokenTypes.MINUSMINUS) {
                if (expr instanceof OCPrefixExpression) {
                    fixes.add(new OCChangeElementIntentionAction(expr, (PsiElement)((OCPrefixExpression)expr).getOperand(), OCInspectionsBundle.message((String)"intentions.remove.subj", (Object[])new Object[]{element.getText()})));
                } else if (expr instanceof OCPostfixExpression) {
                    fixes.add(new OCChangeElementIntentionAction(expr, (PsiElement)((OCPostfixExpression)expr).getOperand(), OCInspectionsBundle.message((String)"intentions.remove.subj", (Object[])new Object[]{element.getText()})));
                }
                return fixes;
            }
            if (parent instanceof OCCompoundInitializer) {
                parent = parent.getParent();
            }
            if (parent instanceof OCDeclarator) {
                fixes.add(new OCRemoveInitializerIntentionAction((OCDeclarator)parent));
            } else {
                fixes.add(new OCRemoveDeclarationIntentionAction("statement", parent, element.getProject()));
                fixes.add(new OCRemoveDeclarationButInitializerIntentionAction("statement", parent, element.getProject()));
            }
            return fixes;
        };
    }

    private static ElementFix getRemoveVariableFix() {
        return tuple -> {
            Object patt34184$temp = tuple[0];
            if (!(patt34184$temp instanceof PsiElement)) {
                return Collections.emptyList();
            }
            PsiElement element = (PsiElement)patt34184$temp;
            OCSymbol symbol = element.getParent() instanceof OCDeclarator ? ((OCDeclarator)element.getParent()).getSymbol() : null;
            ArrayList<Object> fixes = new ArrayList<Object>();
            PsiElement maybeSBD = OCDFAUtils.getBindingDeclaration(element);
            if (maybeSBD != null) {
                fixes.add(new OCRemoveDeclarationIntentionAction("structured binding", maybeSBD, element.getProject()));
                fixes.add(new OCRemoveDeclarationButInitializerIntentionAction("structured binding", maybeSBD, element.getProject()));
                if (symbol != null) {
                    fixes.add(OCChangeGCCAttributeIntentionAction.unused((OCSymbol)symbol, (String)"structured binding", (PsiFile)element.getContainingFile()));
                }
            } else if (symbol != null) {
                if (!(symbol instanceof OCSymbolWithParent && ((OCSymbolWithParent)symbol).getParent() instanceof OCFunctionSymbol && ((OCFunctionSymbol)((OCSymbolWithParent)symbol).getParent()).isMainFunction())) {
                    fixes.add(new OCRemoveDeclarationIntentionAction(symbol, element.getProject()));
                    fixes.add(new OCRemoveDeclarationButInitializerIntentionAction(symbol, element.getProject()));
                }
                fixes.add(OCChangeGCCAttributeIntentionAction.unused((OCSymbol)symbol, (PsiFile)element.getContainingFile()));
            }
            return fixes;
        };
    }

    private static ElementFix getConstantParameterFix() {
        return tuple -> {
            String constantValue;
            Object patt35638$temp = tuple[0];
            if (!(patt35638$temp instanceof PsiElement)) {
                return Collections.emptyList();
            }
            PsiElement element = (PsiElement)patt35638$temp;
            Object constant = tuple[1];
            PsiElement parent = element.getParent();
            OCSymbol symbol = parent instanceof OCDeclarator ? ((OCDeclarator)parent).getSymbol() : null;
            String string = constantValue = constant instanceof PsiElement ? OCElementUtil.getTextWithMacros((PsiElement)((PsiElement)constant)) : constant.toString();
            if (symbol instanceof OCDeclaratorSymbol) {
                return Collections.singletonList(new OCInlineParameterFix((OCDeclarator)parent, (OCDeclaratorSymbol)symbol, constantValue));
            }
            return Collections.emptyList();
        };
    }

    private static Function<Object[], String> message(int index, OCSymbolKind kind, String key, boolean subjectIsFirst, boolean showName) {
        return elements -> {
            String subject;
            if (!(elements[index] instanceof PsiElement)) {
                return null;
            }
            PsiElement parent = ((PsiElement)elements[index]).getParent();
            OCSymbol symbol = parent instanceof OCDeclarator ? ((OCDeclarator)parent).getSymbol() : null;
            OCResolveContext context = OCResolveContext.forPsi((PsiElement)parent);
            if (symbol != null && showName) {
                subject = subjectIsFirst ? symbol.getNameWithKindUppercase((OCCompilationContext)context) : symbol.getNameWithKindLowercase((OCCompilationContext)context);
            } else {
                OCSymbolKind curKind = symbol != null ? symbol.getKind() : kind;
                subject = subjectIsFirst ? curKind.getNameUppercase() : curKind.getNameLowercase();
            }
            return OCInspectionsBundle.message((String)key, (Object[])new Object[]{subject});
        };
    }

    private static Function<Object[], String> message(int index, String key, boolean showName) {
        return OCDFAInspectionRunner.message(index, OCSymbolKind.LOCAL_VARIABLE, key, true, showName);
    }

    private static Function<Object[], String> calledFromSuffix(Function<Object[], String> messageFun) {
        return elements -> {
            Object lastElement = elements[((Object[])elements).length - 1];
            String message = (String)messageFun.fun(elements);
            if (message == null) {
                return null;
            }
            if (lastElement instanceof PsiElement) {
                PsiElement parent = ((PsiElement)lastElement).getParent();
                if (parent instanceof OCDeclarator) {
                    OCDeclarator caller = (OCDeclarator)parent;
                    return message + OCInspectionsBundle.message((String)"intention.suffix.called.from", (Object[])new Object[]{caller.getName()});
                }
                return message;
            }
            if (DfaConstantsKt.isGlobalFunction((Attribute)new Attribute(lastElement.toString()))) {
                return message + OCInspectionsBundle.message((String)"intention.suffix.called.from.global.scope", (Object[])new Object[0]);
            }
            if (lastElement.equals(DfaConstants.INSTANCE.getCurFunction().getKey())) {
                return message;
            }
            return null;
        };
    }

    private static Function<Object[], String> memoryLeakMessage() {
        return elements -> {
            if (!(elements[0] instanceof PsiElement) || !(elements[1] instanceof PsiElement)) {
                return null;
            }
            PsiElement parent = ((PsiElement)elements[1]).getParent();
            if (parent instanceof OCDeclarator) {
                OCDeclarator caller = (OCDeclarator)parent;
                return OCInspectionsBundle.message((String)"inspection.message.memory.leak", (Object[])new Object[]{caller.getName()});
            }
            return null;
        };
    }

    private static Function<Object[], String> constantParameterMessage() {
        return elements -> {
            String constantValue;
            if (!(elements[0] instanceof PsiElement)) {
                return null;
            }
            PsiElement parent = ((PsiElement)elements[0]).getParent();
            OCSymbol symbol = parent instanceof OCDeclarator ? ((OCDeclarator)parent).getSymbol() : null;
            Object constant = elements[1];
            OCResolveContext context = OCResolveContext.forPsi((PsiElement)parent);
            if (constant instanceof Number && symbol != null) {
                constantValue = OCDFAUtils.getTypeConstant(symbol.getResolvedType(context), (Number)constant, context, parent.getContainingFile());
            } else if (constant instanceof PsiElement && ((PsiElement)constant).getNode().getElementType() == OCLexerTokenTypes.STRING_LITERAL) {
                constantValue = OCElementUtil.getTextWithMacros((PsiElement)((PsiElement)constant));
            } else {
                return null;
            }
            return (symbol != null ? symbol.getNameWithKindUppercase((OCCompilationContext)context) : "Parameter") + " always equals to " + constantValue;
        };
    }

    private static Function<Object[], String> constantFunctionResultMessage() {
        return elements -> {
            if (!(elements[0] instanceof PsiElement)) {
                return null;
            }
            PsiElement parent = ((PsiElement)elements[0]).getParent();
            OCSymbol symbol = parent instanceof OCDeclarator ? ((OCDeclarator)parent).getSymbol() : null;
            Object constant = elements[1];
            if (!(constant instanceof Number)) {
                return null;
            }
            OCResolveContext context = OCResolveContext.forPsi((PsiElement)parent);
            if (symbol instanceof OCFunctionSymbol) {
                constant = OCDFAUtils.getTypeConstant(((OCFunctionSymbol)symbol).getType().getReturnType().resolve(context), (Number)constant, context, parent.getContainingFile());
            }
            return (symbol != null ? symbol.getNameWithKindUppercase((OCCompilationContext)context) : "Function") + " always returns " + String.valueOf(constant);
        };
    }

    private static Function<Object[], String> arrayIndexOutOfBoundsMessage() {
        return elements -> {
            if (((Object[])elements).length == 1) {
                return "Index may be out of bounds";
            }
            Object constant = elements[1];
            if (!(constant instanceof Number)) {
                return null;
            }
            return "Index may have a value of '" + String.valueOf(constant) + "' which is out of bounds";
        };
    }

    private static Predicate<PsiElement> excludeConstFunctionResult() {
        return element -> {
            PsiElement parent = element.getParent();
            OCSymbol symbol = parent instanceof OCDeclarator ? ((OCDeclarator)parent).getSymbol() : null;
            return symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isMainFunction();
        };
    }

    private static Predicate<PsiElement> excludeUnusedElement(Set<Object> implicitReads) {
        return element -> {
            OCSymbol symbol;
            OCSymbol callableSymbol;
            PsiElement callable;
            if (OCElementUtil.getElementType((PsiElement)element) == OCLexerTokenTypes.COLON) {
                return true;
            }
            OCParameterList parameterList = (OCParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, OCParameterList.class);
            PsiElement psiElement = callable = parameterList != null ? parameterList.getParent() : null;
            if (callable instanceof OCDeclarator) {
                callable = callable.getParent();
            }
            OCSymbol oCSymbol = callableSymbol = callable instanceof OCCallable ? ((OCCallable)callable).getSymbol() : null;
            if (callableSymbol != null) {
                if (callableSymbol.getKind() == OCSymbolKind.BLOCK || callableSymbol.getKind() == OCSymbolKind.LAMBDA) {
                    return true;
                }
                if (callableSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)callableSymbol).isWinMainFunction()) {
                    return true;
                }
            }
            if (element instanceof OCDeclarator) {
                symbol = ((OCDeclarator)element).getSymbol();
            } else if (element.getParent() instanceof OCDeclarator) {
                symbol = ((OCDeclarator)element.getParent()).getSymbol();
            } else if (element instanceof OCConstructorFieldInitializer) {
                OCReferenceElement referenceElement = ((OCConstructorFieldInitializer)element).getReferenceElement();
                symbol = referenceElement != null ? referenceElement.resolveToSymbol() : null;
            } else {
                return false;
            }
            if (symbol != null && symbol.isUnused()) {
                return true;
            }
            if (implicitReads.contains(element)) {
                return false;
            }
            if (OCDFAUtils.getBindingDeclaration(element) instanceof OCStructuredBindingDeclaration) {
                return false;
            }
            if (symbol instanceof OCDeclaratorSymbol) {
                boolean isLocalVariable = symbol.getKind() == OCSymbolKind.LOCAL_VARIABLE;
                boolean isStructField = symbol.getKind() == OCSymbolKind.STRUCT_FIELD;
                OCResolveContext context = OCResolveContext.forPsi((PsiElement)element);
                OCType declaratorType = symbol.getType().resolve(context);
                if (declaratorType instanceof OCStructType) {
                    OCStructSymbol structSymbol = ((OCStructType)declaratorType).getSymbol();
                    return structSymbol.isUnused() || (isLocalVariable || isStructField) && !structSymbol.hasTrivialDestructor(context);
                }
                return isLocalVariable && declaratorType instanceof OCTypeParameterType;
            }
            return false;
        };
    }

    private static Predicate<PsiElement> excludeUnreachableFunctionCalls() {
        return element -> !(element.getParent().getParent() instanceof OCFunctionDefinition);
    }

    @NotNull
    private static Condition<OCElementsRange> excludeUnreachableCode() {
        Condition condition = r -> r.getFirstElement() != r.getLastElement() || OCElementUtil.getElementType((PsiElement)r.getFirstElement()) != OCLexerTokenTypes.COLON;
        if (condition == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(19);
        }
        return condition;
    }

    @NotNull
    private static Condition<OCElementsRange> excludeEndlessLoops() {
        Condition condition = r -> {
            OCLoopStatement loop = (OCLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)r.getFirstElement(), OCLoopStatement.class, (boolean)false);
            return PsiTreeUtil.findChildOfAnyType((PsiElement)loop, (Class[])new Class[]{OCCppCoawaitExpression.class, OCCoyieldStatement.class, OCCppCoreturnStatementImpl.class}) == null;
        };
        if (condition == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(20);
        }
        return condition;
    }

    private static Function<Object[], Class<? extends OCInspection>> unusedInspectionClass(@Nullable Predicate<Class<? extends OCInspectionBase.DfaMarker>> filter) {
        return elements -> {
            OCSymbol symbol;
            if (!(elements[0] instanceof PsiElement)) {
                return null;
            }
            PsiElement parent = ((PsiElement)elements[0]).getParent();
            OCSymbol oCSymbol = symbol = parent instanceof OCDeclarator ? ((OCDeclarator)parent).getSymbol() : null;
            if (symbol != null && symbol.getKind() == OCSymbolKind.PARAMETER) {
                return OCDFAInspectionRunner.shouldRunInspection(OCInspections.UnusedParameter.class, filter) ? OCInspections.UnusedParameter.class : null;
            }
            return OCDFAInspectionRunner.shouldRunInspection(OCInspections.UnusedLocalVariable.class, filter) ? OCInspections.UnusedLocalVariable.class : null;
        };
    }

    private static void processTuples(List<DfaTuple> tuples, Consumer<Pair<Object[], DfaTuple>> consumer, IrEnvironment environment, @NotNull Project project) {
        if (project == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(21);
        }
        for (DfaTuple tuple : tuples) {
            List attributes = tuple.getAttributes();
            int prefixLen = attributes.size();
            Object[] result = new Object[prefixLen];
            for (int i = 0; i < prefixLen; ++i) {
                Attribute attr = (Attribute)attributes.get(i);
                if (attr == null) continue;
                IrLocation location = environment.findLocation(attr, tuple.getFunction());
                if (location != null) {
                    result[i] = ClangQuickFixFactoryKt.locatePsiElementPair((Location)DFATuplesParserKt.convert(location), (Project)project).component1();
                    continue;
                }
                try {
                    result[i] = Integer.parseInt(attr.getKey());
                    continue;
                }
                catch (NumberFormatException e) {
                    try {
                        result[i] = Double.parseDouble(attr.getKey());
                        continue;
                    }
                    catch (NumberFormatException e2) {
                        result[i] = attr.getKey();
                    }
                }
            }
            if (!ContainerUtil.and((Object[])result, Objects::nonNull)) continue;
            consumer.consume((Object)Pair.create((Object)result, (Object)tuple));
        }
    }

    @NotNull
    public static @Unmodifiable List<DFARawTuple> readTuplesFromJson(String inputPath) throws IOException {
        String json = FileUtil.loadFile((File)new File(inputPath));
        JsonObject rootObject = JsonParser.parseString((String)json).getAsJsonObject();
        JsonObject params = rootObject.get("params").getAsJsonObject();
        JsonArray tuplesObj = params.get("tuples").getAsJsonArray();
        List list = ContainerUtil.map((Iterable)tuplesObj, element -> {
            JsonObject object = element.getAsJsonObject();
            String relation = object.get("relation").getAsString();
            String function = object.get("function").getAsString();
            List attributes = ContainerUtil.map((Iterable)object.get("attributes").getAsJsonArray(), JsonElement::getAsString);
            return new DFARawTuple(relation, function, attributes);
        });
        if (list == null) {
            OCDFAInspectionRunner.$$$reportNull$$$0(22);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 19, 20, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionClass";
                break;
            }
            case 11: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/dfa/bridge/OCDFAInspectionRunner";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tuples";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/dfa/bridge/OCDFAInspectionRunner";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeUnreachableCode";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeEndlessLoops";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "readTuplesFromJson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldRunInspection";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reportTimeOverWarning";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElementRanges";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 11: 
            case 19: 
            case 20: 
            case 22: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "registerWarnings";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processTuples";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 19, 20, 22 -> new IllegalStateException(string);
        };
    }

    private static interface ElementFix {
        public List<IntentionAction> getFixes(Object[] var1);
    }
}

