/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.statistics;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rml.dfa.utils.Key;
import com.intellij.rml.dfa.utils.measurements.DfaMeasurementKind;
import com.intellij.rml.dfa.utils.measurements.DfaMeasurementRunner;
import com.intellij.rml.dfa.utils.measurements.DfaSingleMeasurementResult;
import com.jetbrains.cidr.lang.dfa.statistics.DfaStatisticService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u001b\u0010\u0016\u001a\u0004\u0018\u00010\u00032\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0018\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/lang/dfa/statistics/DfaStatisticsMeasurement;", "Lcom/intellij/rml/dfa/utils/measurements/DfaMeasurementRunner;", "parallelism", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(ILcom/intellij/openapi/vfs/VirtualFile;)V", "hasErrors", "", "getHasErrors", "()Z", "setHasErrors", "(Z)V", "getStatus", "Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult$Status;", "getMemoryPeak", "Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult$Numeric$MemoryConsumption;", "getTotalTime", "Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult$Numeric$ExecutionDuration;", "getBddOps", "Lcom/intellij/rml/dfa/utils/measurements/DfaSingleMeasurementResult$Numeric;", "getDomainSize", "domainKey", "Lcom/intellij/rml/dfa/utils/Key;", "(Lcom/intellij/rml/dfa/utils/Key;)Ljava/lang/Integer;", "finish", "", "intellij.clion.dfa"})
@SourceDebugExtension(value={"SMAP\nDfaStatisticsMeasurement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DfaStatisticsMeasurement.kt\ncom/jetbrains/cidr/lang/dfa/statistics/DfaStatisticsMeasurement\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,47:1\n40#2,3:48\n*S KotlinDebug\n*F\n+ 1 DfaStatisticsMeasurement.kt\ncom/jetbrains/cidr/lang/dfa/statistics/DfaStatisticsMeasurement\n*L\n44#1:48,3\n*E\n"})
public final class DfaStatisticsMeasurement
extends DfaMeasurementRunner {
    @NotNull
    private final VirtualFile file;
    private boolean hasErrors;

    public DfaStatisticsMeasurement(int parallelism, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object[] objectArray = new DfaMeasurementKind[]{new DfaMeasurementKind.EvaluationStatus(), new DfaMeasurementKind.Memory(parallelism), new DfaMeasurementKind.Time(), new DfaMeasurementKind.BddOperationCount(), new DfaMeasurementKind.DomainSizes()};
        super(CollectionsKt.listOf((Object[])objectArray));
        this.file = file;
    }

    public final boolean getHasErrors() {
        return this.hasErrors;
    }

    public final void setHasErrors(boolean bl) {
        this.hasErrors = bl;
    }

    @Nullable
    public final DfaSingleMeasurementResult.Status getStatus() {
        return (DfaSingleMeasurementResult.Status)this.getMetrics().get(DfaMeasurementKind.EvaluationStatus.Companion.getSTATUS());
    }

    @Nullable
    public final DfaSingleMeasurementResult.Numeric.MemoryConsumption getMemoryPeak() {
        return (DfaSingleMeasurementResult.Numeric.MemoryConsumption)this.getMetrics().get(DfaMeasurementKind.Memory.Companion.getPEAK_SUM_LOCAL_MEM());
    }

    @Nullable
    public final DfaSingleMeasurementResult.Numeric.ExecutionDuration getTotalTime() {
        return (DfaSingleMeasurementResult.Numeric.ExecutionDuration)this.getMetrics().get(DfaMeasurementKind.Time.Companion.getTOTAL_TIME());
    }

    @Nullable
    public final DfaSingleMeasurementResult.Numeric getBddOps() {
        return (DfaSingleMeasurementResult.Numeric)this.getMetrics().get(DfaMeasurementKind.BddOperationCount.Companion.getBDD_OP_COUNT());
    }

    @Nullable
    public final Integer getDomainSize(@NotNull Key<DfaSingleMeasurementResult.Numeric> domainKey) {
        Intrinsics.checkNotNullParameter(domainKey, (String)"domainKey");
        Object object = (DfaSingleMeasurementResult.Numeric)this.getMetrics().get(domainKey);
        return object != null && (object = object.getValue()) != null ? Integer.valueOf(((Number)object).intValue()) : null;
    }

    public final boolean hasErrors() {
        return this.hasErrors;
    }

    public void finish() {
        boolean $i$f$service = false;
        Class<DfaStatisticService> serviceClass$iv = DfaStatisticService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((DfaStatisticService)object).recordRunInfo(this.file, this);
    }
}

