/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.makefile.MakefileFile;
import com.jetbrains.lang.makefile.MakefileRunConfiguration;
import com.jetbrains.lang.makefile.MakefileRunConfigurationType;
import com.jetbrains.lang.makefile.psi.MakefileTarget;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/lang/makefile/MakefileRunConfigurationFactory;", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "runConfigurationType", "Lcom/jetbrains/lang/makefile/MakefileRunConfigurationType;", "<init>", "(Lcom/jetbrains/lang/makefile/MakefileRunConfigurationType;)V", "getId", "", "getName", "createTemplateConfiguration", "Lcom/jetbrains/lang/makefile/MakefileRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "createConfigurationFromTarget", "target", "Lcom/jetbrains/lang/makefile/psi/MakefileTarget;", "intellij.makefile"})
public final class MakefileRunConfigurationFactory
extends ConfigurationFactory {
    @NotNull
    private final MakefileRunConfigurationType runConfigurationType;

    public MakefileRunConfigurationFactory(@NotNull MakefileRunConfigurationType runConfigurationType) {
        Intrinsics.checkNotNullParameter((Object)runConfigurationType, (String)"runConfigurationType");
        super((ConfigurationType)runConfigurationType);
        this.runConfigurationType = runConfigurationType;
    }

    @NotNull
    public String getId() {
        return "Makefile";
    }

    @NotNull
    public String getName() {
        return this.runConfigurationType.getDisplayName();
    }

    @NotNull
    public MakefileRunConfiguration createTemplateConfiguration(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new MakefileRunConfiguration(project, this, "name");
    }

    @Nullable
    public final MakefileRunConfiguration createConfigurationFromTarget(@NotNull MakefileTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Project project = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = target.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        MakefileRunConfiguration configuration = new MakefileRunConfiguration(project, this, string);
        PsiFile psiFile = target.getContainingFile();
        MakefileFile makefileFile = psiFile instanceof MakefileFile ? (MakefileFile)psiFile : null;
        if (makefileFile == null) {
            return null;
        }
        MakefileFile file = makefileFile;
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)target.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
        PathMacroManager macroManager = pathMacroManager;
        Object object = file.getVirtualFile();
        if (object == null || (object = object.getPath()) == null) {
            return null;
        }
        Object path = object;
        String string2 = macroManager.collapsePath((String)path);
        if (string2 == null) {
            string2 = "";
        }
        configuration.setFilename(string2);
        String string3 = target.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        configuration.setTarget(string3);
        if (((CharSequence)configuration.getTarget()).length() > 0) {
            configuration.setName(configuration.getTarget());
        } else {
            configuration.setName(new File((String)path).getName());
        }
        return configuration;
    }
}

