/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.execution.CidrDebuggerPluginService;
import com.jetbrains.cidr.execution.debugger.CidrDebugEventsTimelineColumnHeader;
import com.jetbrains.cidr.execution.debugger.CidrDebugEventsTimelineContent;
import com.jetbrains.cidr.execution.debugger.CidrDebugEventsTimelineRowHeader;
import com.jetbrains.cidr.execution.debugger.CidrDebugSessionEventListener;
import com.jetbrains.cidr.execution.debugger.CidrDebugSessionEventType;
import com.jetbrains.cidr.execution.debugger.CidrDevToolLogger;
import com.jetbrains.cidr.execution.debugger.CidrTimelineEvent;
import com.jetbrains.cidr.execution.debugger.TimelineElement;
import com.jetbrains.cidr.execution.debugger.TimelineElementDetailsConsole;
import com.jetbrains.cidr.execution.debugger.TimelineModel;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimeline;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugSessionEventListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "model", "Lcom/jetbrains/cidr/execution/debugger/TimelineModel;", "detailsView", "Lcom/jetbrains/cidr/execution/debugger/TimelineElementDetailsConsole;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "timePulseJob", "Lkotlinx/coroutines/Job;", "getLogger", "Lcom/jetbrains/cidr/execution/debugger/CidrDevToolLogger;", "sessionEvent", "", "time", "", "eventType", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugSessionEventType;", "Companion", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCidrDebuggerDevToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrDebuggerDevToolWindow.kt\ncom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimeline\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,1100:1\n30#2,2:1101\n30#2,2:1103\n*S KotlinDebug\n*F\n+ 1 CidrDebuggerDevToolWindow.kt\ncom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimeline\n*L\n108#1:1101,2\n254#1:1103,2\n*E\n"})
public final class CidrDebugEventsTimeline
implements CidrDebugSessionEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final TimelineModel model;
    @NotNull
    private final TimelineElementDetailsConsole detailsView;
    @NotNull
    private final JComponent component;
    @Nullable
    private Job timePulseJob;
    @NotNull
    public static final String CONTENT_ID = "Timeline";
    @NotNull
    private static final Key<CidrDebugEventsTimeline> TIMELINE_KEY;

    public CidrDebugEventsTimeline(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.model = new TimelineModel();
        this.detailsView = new TimelineElementDetailsConsole(this.project, this.model);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<CidrDebuggerPluginService> serviceClass$iv = CidrDebuggerPluginService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Disposer.register((Disposable)((Disposable)object), (Disposable)((Disposable)this.detailsView));
        this.detailsView.setVisible(false);
        final CidrDebugEventsTimelineContent timelineContent = new CidrDebugEventsTimelineContent(this.model, this.detailsView);
        CidrDebugEventsTimelineColumnHeader header = new CidrDebugEventsTimelineColumnHeader(this.model);
        final CidrDebugEventsTimelineRowHeader rowHeader = new CidrDebugEventsTimelineRowHeader(this.model, timelineContent, this.detailsView);
        final JBScrollPane timelineScrollPane = new JBScrollPane((Component)timelineContent, 20, 30);
        timelineScrollPane.setColumnHeaderView((Component)header);
        timelineScrollPane.setRowHeaderView((Component)rowHeader);
        timelineContent.setScrollPane(timelineScrollPane);
        rowHeader.setScrollPane(timelineScrollPane);
        timelineScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){
            private int prevScrollValue;

            public final int getPrevScrollValue() {
                return this.prevScrollValue;
            }

            public final void setPrevScrollValue(int n) {
                this.prevScrollValue = n;
            }

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int scrollValue = e.getValue();
                if (scrollValue < this.prevScrollValue) {
                    TimelineElement timelineElement;
                    TimelineElement timelineElement2 = timelineElement = scrollValue == 0 ? (TimelineElement)CollectionsKt.firstOrNull((List)model.getElements()) : CidrDebugEventsTimelineContent.Companion.elementAtY(model, timelineContent, scrollValue + timelineScrollPane.getHeight() / 2);
                    if (timelineElement != null) {
                        IntRange elementRangeX = CidrDebugEventsTimelineContent.Companion.elementRangeX(model, timelineElement);
                        Rectangle scrollRect = new Rectangle(Math.max(elementRangeX.getFirst() - (timelineScrollPane.getWidth() - rowHeader.getWidth()) / 3, 0), scrollValue, Math.max(elementRangeX.getLast() - elementRangeX.getFirst(), 30), 10);
                        timelineContent.scrollRectToVisible(scrollRect);
                    }
                } else {
                    TimelineElement element;
                    TimelineElement timelineElement = element = scrollValue + timelineScrollPane.getVerticalScrollBar().getVisibleAmount() == e.getAdjustable().getMaximum() ? (TimelineElement)CollectionsKt.lastOrNull((List)model.getElements()) : CidrDebugEventsTimelineContent.Companion.elementAtY(model, timelineContent, scrollValue + timelineScrollPane.getHeight() / 2);
                    if (element != null) {
                        IntRange elementRangeX = CidrDebugEventsTimelineContent.Companion.elementRangeX(model, element);
                        Rectangle scrollRect = new Rectangle(Math.max(elementRangeX.getFirst() + (timelineScrollPane.getWidth() - rowHeader.getWidth()) / 3, 0), scrollValue, Math.max(elementRangeX.getLast() - elementRangeX.getFirst(), 30), 10);
                        timelineContent.scrollRectToVisible(scrollRect);
                    }
                }
                this.prevScrollValue = scrollValue;
            }
        });
        ThreeComponentsSplitter splitter = new ThreeComponentsSplitter(true, false, 2, null);
        splitter.setDividerWidth(5);
        splitter.setDividerMouseZoneSize(5);
        splitter.setBackground(UIUtil.CONTRAST_BORDER_COLOR);
        splitter.setFirstSize(300);
        splitter.setFirstComponent((JComponent)timelineScrollPane);
        splitter.setInnerComponent(this.detailsView.getComponent());
        UiUtils.putUserData((JComponent)((JComponent)splitter), TIMELINE_KEY, (Object)this);
        this.component = (JComponent)splitter;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final CidrDevToolLogger getLogger() {
        return new CidrDevToolLogger(this){
            private final String lldbLogPrefix;
            final /* synthetic */ CidrDebugEventsTimeline this$0;
            {
                this.this$0 = $receiver;
                this.lldbLogPrefix = "[protobuf client";
            }

            private final boolean enqueueGdbMessage(long time, String message) {
                boolean bl;
                long pid = 0L;
                int idx = 0;
                while (idx < message.length() && Character.isDigit(message.charAt(idx))) {
                    pid = pid * (long)10 + (long)(message.charAt(idx++) - 48);
                }
                if (idx >= message.length()) {
                    return false;
                }
                switch (message.charAt(idx++)) {
                    case '>': {
                        bl = true;
                        break;
                    }
                    case '<': {
                        bl = false;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                boolean isRequest = bl;
                StringBuilder reqId = new StringBuilder();
                while (idx < message.length() && Character.isDigit(message.charAt(idx))) {
                    reqId.append(message.charAt(idx++));
                }
                if (isRequest) {
                    String string;
                    TimelineModel timelineModel = CidrDebugEventsTimeline.access$getModel$p(this.this$0);
                    if (((CharSequence)reqId).length() == 0) {
                        string = "0";
                    } else {
                        String string2 = reqId.toString();
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    }
                    timelineModel.enqueue(new CidrTimelineEvent.Request(string, time, pid, message, null, 16, null));
                } else {
                    CidrDebugEventsTimeline.access$getModel$p(this.this$0).enqueue(new CidrTimelineEvent.Response(((CharSequence)reqId).length() == 0 ? null : reqId.toString(), time, pid, message));
                }
                return true;
            }

            public final String getLldbLogPrefix() {
                return this.lldbLogPrefix;
            }

            public void log(long time, LogLevel logLevel, String message, Throwable t) {
                Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
                CharSequence charSequence = message;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    CidrDebugEventsTimeline.access$getModel$p(this.this$0).enqueue(new CidrTimelineEvent.Response(null, time, 0L, this.buildMessage(message, t)));
                    return;
                }
                if (this.enqueueGdbMessage(time, message)) {
                    return;
                }
                if (StringsKt.startsWith$default((String)message, (String)this.lldbLogPrefix, (boolean)false, (int)2, null)) {
                    int colonIdx = StringsKt.indexOf$default((CharSequence)message, (char)':', (int)this.lldbLogPrefix.length(), (boolean)false, (int)4, null);
                    if (colonIdx != -1) {
                        CharSequence messageHeader = message.subSequence(0, colonIdx);
                        if (StringsKt.contains$default((CharSequence)messageHeader, (CharSequence)" res(len=", (boolean)false, (int)2, null)) {
                            if (StringsKt.startsWith$default((String)message, (String)" composite_broadcast", (int)(colonIdx + 1), (boolean)false, (int)4, null)) {
                                CidrDebugEventsTimeline.access$getModel$p(this.this$0).enqueue(new CidrTimelineEvent.Response(null, time, 0L, message));
                            } else {
                                CidrDebugEventsTimeline.access$getModel$p(this.this$0).enqueue(new CidrTimelineEvent.FifoResponse(time, message));
                            }
                        } else {
                            TimelineModel timelineModel = CidrDebugEventsTimeline.access$getModel$p(this.this$0);
                            String string = message.substring(colonIdx + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                            timelineModel.enqueue(new CidrTimelineEvent.FifoRequest(time, message, string));
                        }
                    }
                    return;
                }
                CidrDebugEventsTimeline.access$getModel$p(this.this$0).enqueue(new CidrTimelineEvent.Response(null, time, 0L, this.buildMessage(message, t)));
            }
        };
    }

    @Override
    public void sessionEvent(long time, @NotNull CidrDebugSessionEventType eventType) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
        if (eventType == CidrDebugSessionEventType.FIRST_SESSION_STARTED) {
            this.detailsView.setVisible(false);
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<CidrDebuggerPluginService> serviceClass$iv = CidrDebuggerPluginService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            this.timePulseJob = BuildersKt.launch$default((CoroutineScope)((CidrDebuggerPluginService)object).getCoroutineScope(), (CoroutineContext)((CoroutineContext)new CoroutineName("CidrDebuggerDevToolTimePulse")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ CidrDebugEventsTimeline this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (CoroutineScope)this.L$0;
                    var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
lbl6:
                            // 3 sources

                            while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                                CidrDebugEventsTimeline.access$getModel$p(this.this$0).enqueue(new CidrTimelineEvent.TimeTick(System.currentTimeMillis()));
                                this.L$0 = $this$launch;
                                this.label = 1;
                                v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                                if (v0 != var3_3) continue;
                                return var3_3;
                            }
                            break;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
                            ** GOTO lbl6
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        if (eventType == CidrDebugSessionEventType.LAST_SESSION_STOPPED) {
            Job job2 = this.timePulseJob;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
        }
        this.model.enqueue(new CidrTimelineEvent.DebugSessionEvent(eventType, time));
    }

    static {
        Key key = Key.create((String)CidrDebugEventsTimeline.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TIMELINE_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimeline$Companion;", "", "<init>", "()V", "CONTENT_ID", "", "TIMELINE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimeline;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "findTimeline", "project", "Lcom/intellij/openapi/project/Project;", "intellij.cidr.debugger.core"})
    @SourceDebugExtension(value={"SMAP\nCidrDebuggerDevToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrDebuggerDevToolWindow.kt\ncom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimeline$Companion\n+ 2 UiUtils.kt\ncom/intellij/openapi/ui/UiUtils\n*L\n1#1,1100:1\n56#2:1101\n*S KotlinDebug\n*F\n+ 1 CidrDebuggerDevToolWindow.kt\ncom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimeline$Companion\n*L\n94#1:1101\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final CidrDebugEventsTimeline findTimeline(@NotNull Project project) {
            CidrDebugEventsTimeline cidrDebugEventsTimeline;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("CidrDebuggerDevTool");
            ToolWindow toolWindow2 = toolWindow;
            Content content = toolWindow2 != null && (toolWindow2 = toolWindow2.getContentManager()) != null ? toolWindow2.findContent(CidrDebugEventsTimeline.CONTENT_ID) : null;
            Object object = content;
            if (object != null && (object = object.getComponent()) != null) {
                void $this$getUserData$iv;
                Object object2 = object;
                Key key$iv = TIMELINE_KEY;
                boolean $i$f$getUserData = false;
                Object object3 = $this$getUserData$iv.getClientProperty(key$iv);
                if (!(object3 instanceof CidrDebugEventsTimeline)) {
                    object3 = null;
                }
                cidrDebugEventsTimeline = (CidrDebugEventsTimeline)object3;
            } else {
                cidrDebugEventsTimeline = null;
            }
            return cidrDebugEventsTimeline;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

