/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.cidr.execution.debugger.CidrDebugEventsTimeline;
import com.jetbrains.cidr.execution.debugger.CidrDebugLogConsole;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebugSessionEventListener;
import com.jetbrains.cidr.execution.debugger.CidrDebugSessionEventType;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebugLogConsoleConfigurator;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "<init>", "()V", "sessionCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "configure", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCidrDebuggerDevToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrDebuggerDevToolWindow.kt\ncom/jetbrains/cidr/execution/debugger/CidrDebugLogConsoleConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1100:1\n1869#2,2:1101\n1869#2,2:1103\n*S KotlinDebug\n*F\n+ 1 CidrDebuggerDevToolWindow.kt\ncom/jetbrains/cidr/execution/debugger/CidrDebugLogConsoleConfigurator\n*L\n1058#1:1101,2\n1060#1:1103,2\n*E\n"})
public final class CidrDebugLogConsoleConfigurator
implements CidrDebugProcessConfigurator {
    @NotNull
    private final AtomicInteger sessionCount = new AtomicInteger(0);

    @Override
    public void configure(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        if (ApplicationManager.getApplication().isInternal()) {
            CidrDebugSessionEventListener it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Object[] objectArray = new CidrDebugSessionEventListener[2];
            Project project = process.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
            objectArray[0] = CidrDebugLogConsole.Companion.findConsole(project);
            Project project2 = process.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"<get-project>(...)");
            objectArray[1] = CidrDebugEventsTimeline.Companion.findTimeline(project2);
            List consumers = CollectionsKt.listOfNotNull((Object[])objectArray);
            long now = System.currentTimeMillis();
            int count = this.sessionCount.incrementAndGet();
            if (count == 1) {
                $this$forEach$iv = consumers;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (CidrDebugSessionEventListener)element$iv;
                    boolean bl = false;
                    it.sessionEvent(now, CidrDebugSessionEventType.FIRST_SESSION_STARTED);
                }
            }
            $this$forEach$iv = consumers;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (CidrDebugSessionEventListener)element$iv;
                boolean bl = false;
                it.sessionEvent(now, CidrDebugSessionEventType.SESSION_STARTED);
            }
            process.getSession().addSessionListener(new XDebugSessionListener(consumers, this){
                final /* synthetic */ List<CidrDebugSessionEventListener> $consumers;
                final /* synthetic */ CidrDebugLogConsoleConfigurator this$0;
                {
                    this.$consumers = $consumers;
                    this.this$0 = $receiver;
                }

                public void sessionPaused() {
                    this.sessionEvent(CidrDebugSessionEventType.SESSION_PAUSED);
                }

                public void sessionResumed() {
                    this.sessionEvent(CidrDebugSessionEventType.SESSION_RESUMED);
                }

                public void sessionStopped() {
                    this.sessionEvent(CidrDebugSessionEventType.SESSION_STOPPED);
                }

                public void stackFrameChanged() {
                    this.sessionEvent(CidrDebugSessionEventType.FRAME_CHANGED);
                }

                public void settingsChanged() {
                    this.sessionEvent(CidrDebugSessionEventType.SETTINGS_CHANGED);
                }

                public void breakpointsMuted(boolean muted) {
                    this.sessionEvent(muted ? CidrDebugSessionEventType.BREAKPOINTS_MUTED : CidrDebugSessionEventType.BREAKPOINTS_UNMUTED);
                }

                public final void sessionEvent(CidrDebugSessionEventType eventType) {
                    int remaining;
                    Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
                    long time = System.currentTimeMillis();
                    Iterable $this$forEach$iv = this.$consumers;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        CidrDebugSessionEventListener it = (CidrDebugSessionEventListener)element$iv;
                        boolean bl = false;
                        it.sessionEvent(time, eventType);
                    }
                    if (eventType == CidrDebugSessionEventType.SESSION_STOPPED && (remaining = CidrDebugLogConsoleConfigurator.access$getSessionCount$p(this.this$0).decrementAndGet()) == 0) {
                        Iterable $this$forEach$iv2 = this.$consumers;
                        boolean $i$f$forEach2 = false;
                        for (T element$iv : $this$forEach$iv2) {
                            CidrDebugSessionEventListener it = (CidrDebugSessionEventListener)element$iv;
                            boolean bl = false;
                            it.sessionEvent(time, CidrDebugSessionEventType.LAST_SESSION_STOPPED);
                        }
                    }
                }
            });
        }
    }

    public static final /* synthetic */ AtomicInteger access$getSessionCount$p(CidrDebugLogConsoleConfigurator $this) {
        return $this.sessionCount;
    }
}

