/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.ui.MessageType;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessSoftwareBreakpointInterceptor;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtilKt;
import com.jetbrains.cidr.execution.debugger.CidrLowLevelExceptionsInterceptor;
import com.jetbrains.cidr.execution.debugger.CidrLowLevelExceptionsSuppressor;
import com.jetbrains.cidr.execution.debugger.CidrSoftwareBreakpointsAdjuster;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCleanableBreakpointHandlerInterface;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#J\u0016\u0010$\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#J\u0016\u0010%\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#J\u001e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0'2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00150'2\u0006\u0010.\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010\u00a8\u0006/"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrLowLevelExceptionsInterceptor;", "Lcom/intellij/xdebugger/XDebugSessionListener;", "myProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "myEnableSoftwareBreakpointAdjustment", "", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;Z)V", "mySuppressor", "Lcom/jetbrains/cidr/execution/debugger/CidrLowLevelExceptionsSuppressor;", "myAdjuster", "Lcom/jetbrains/cidr/execution/debugger/CidrSoftwareBreakpointsAdjuster;", "suppressionCleanableHandlers", "", "Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrCleanableBreakpointHandlerInterface;", "getSuppressionCleanableHandlers", "()Ljava/util/List;", "suppressionHandlers", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "getSuppressionHandlers", "sessionPaused", "", "interceptInterruption", "interceptResume", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "interceptRunToPosition", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "file", "", "line", "", "interceptStepOver", "resumptionThread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "interceptStepInto", "interceptStepOut", "interceptLowLevelException", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jetbrains/cidr/execution/debugger/CidrSoftwareBreakpointsAdjuster$AdjustedCauseAndPlace;", "stopPlace", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;", "cause", "Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;", "interceptProcessDisconnect", "shouldDetach", "intellij.cidr.debugger.core"})
public final class CidrLowLevelExceptionsInterceptor
implements XDebugSessionListener {
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final CidrLowLevelExceptionsSuppressor mySuppressor;
    @Nullable
    private final CidrSoftwareBreakpointsAdjuster myAdjuster;

    public CidrLowLevelExceptionsInterceptor(@NotNull CidrDebugProcess myProcess, boolean myEnableSoftwareBreakpointAdjustment) {
        Intrinsics.checkNotNullParameter((Object)myProcess, (String)"myProcess");
        this.myProcess = myProcess;
        this.mySuppressor = new CidrLowLevelExceptionsSuppressor(this.myProcess);
        this.myAdjuster = myEnableSoftwareBreakpointAdjustment ? new CidrSoftwareBreakpointsAdjuster(this.myProcess) : null;
    }

    @NotNull
    public final List<CidrCleanableBreakpointHandlerInterface<?>> getSuppressionCleanableHandlers() {
        return this.mySuppressor.getSuppressionCleanableHandlers();
    }

    @NotNull
    public final List<XBreakpointHandler<?>> getSuppressionHandlers() {
        return this.mySuppressor.getSuppressionHandlers();
    }

    public void sessionPaused() {
        this.mySuppressor.registerSessionPause();
    }

    public final boolean interceptInterruption() {
        this.mySuppressor.registerInterrupt();
        return false;
    }

    public final boolean interceptResume(@NotNull DebuggerDriver driver) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            this.mySuppressor.registerResume();
            CidrSoftwareBreakpointsAdjuster cidrSoftwareBreakpointsAdjuster = this.myAdjuster;
            if (cidrSoftwareBreakpointsAdjuster == null) break block0;
            cidrSoftwareBreakpointsAdjuster.prepareForResume(driver);
        }
        return false;
    }

    public final boolean interceptRunToPosition(@NotNull DebuggerDriver driver, @Nullable Address address, @NotNull String file, int line) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.mySuppressor.registerStepOrRunTo();
        CidrSoftwareBreakpointsAdjuster cidrSoftwareBreakpointsAdjuster = this.myAdjuster;
        if (cidrSoftwareBreakpointsAdjuster == null || (cidrSoftwareBreakpointsAdjuster = cidrSoftwareBreakpointsAdjuster.prepareForRunToPosition(driver, address, file, line)) == null) {
            return false;
        }
        CidrSoftwareBreakpointsAdjuster newStop = cidrSoftwareBreakpointsAdjuster;
        CidrDebuggerUtilKt.launchCoroutine(this.myProcess, () -> CidrLowLevelExceptionsInterceptor.interceptRunToPosition$lambda$0(this, (DebuggerDriver.StopPlace)newStop));
        return true;
    }

    public final boolean interceptStepOver(@NotNull DebuggerDriver driver, @NotNull LLThread resumptionThread) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)resumptionThread, (String)"resumptionThread");
        this.mySuppressor.registerStepOrRunTo();
        CidrSoftwareBreakpointsAdjuster cidrSoftwareBreakpointsAdjuster = this.myAdjuster;
        if (cidrSoftwareBreakpointsAdjuster == null || (cidrSoftwareBreakpointsAdjuster = cidrSoftwareBreakpointsAdjuster.prepareForStepOver(driver, resumptionThread)) == null) {
            return false;
        }
        CidrSoftwareBreakpointsAdjuster newStop = cidrSoftwareBreakpointsAdjuster;
        CidrDebuggerUtilKt.launchCoroutine(this.myProcess, () -> CidrLowLevelExceptionsInterceptor.interceptStepOver$lambda$1(this, (DebuggerDriver.StopPlace)newStop));
        return true;
    }

    public final boolean interceptStepInto(@NotNull DebuggerDriver driver, @NotNull LLThread resumptionThread) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)resumptionThread, (String)"resumptionThread");
        this.mySuppressor.registerStepOrRunTo();
        CidrSoftwareBreakpointsAdjuster cidrSoftwareBreakpointsAdjuster = this.myAdjuster;
        if (cidrSoftwareBreakpointsAdjuster == null || (cidrSoftwareBreakpointsAdjuster = cidrSoftwareBreakpointsAdjuster.prepareForStepInto(driver, resumptionThread)) == null) {
            return false;
        }
        CidrSoftwareBreakpointsAdjuster newStop = cidrSoftwareBreakpointsAdjuster;
        CidrDebuggerUtilKt.launchCoroutine(this.myProcess, () -> CidrLowLevelExceptionsInterceptor.interceptStepInto$lambda$2(this, (DebuggerDriver.StopPlace)newStop));
        return true;
    }

    public final boolean interceptStepOut(@NotNull DebuggerDriver driver, @NotNull LLThread resumptionThread) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter((Object)resumptionThread, (String)"resumptionThread");
        this.mySuppressor.registerStepOrRunTo();
        CidrSoftwareBreakpointsAdjuster cidrSoftwareBreakpointsAdjuster = this.myAdjuster;
        if (cidrSoftwareBreakpointsAdjuster == null || (cidrSoftwareBreakpointsAdjuster = cidrSoftwareBreakpointsAdjuster.prepareForStepOut(driver, resumptionThread)) == null) {
            return false;
        }
        CidrSoftwareBreakpointsAdjuster newStop = cidrSoftwareBreakpointsAdjuster;
        CidrDebuggerUtilKt.launchCoroutine(this.myProcess, () -> CidrLowLevelExceptionsInterceptor.interceptStepOut$lambda$3(this, (DebuggerDriver.StopPlace)newStop));
        return true;
    }

    @NotNull
    public final CompletableFuture<CidrSoftwareBreakpointsAdjuster.AdjustedCauseAndPlace> interceptLowLevelException(@NotNull DebuggerDriver.StopPlace stopPlace, @NotNull CidrSuspensionCause cause) {
        Intrinsics.checkNotNullParameter((Object)stopPlace, (String)"stopPlace");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        if (CidrDebugProcessSoftwareBreakpointInterceptor.Companion.tryInterceptSoftwareBreakpoint(this.myProcess, cause, stopPlace)) {
            this.myProcess.postCommand(DebuggerDriver::resume);
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CoroutineScope coroutineScope = this.myProcess.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
        return FutureKt.future$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CidrSoftwareBreakpointsAdjuster.AdjustedCauseAndPlace>, Object>(this, stopPlace, cause, null){
            Object L$0;
            int label;
            final /* synthetic */ CidrLowLevelExceptionsInterceptor this$0;
            final /* synthetic */ DebuggerDriver.StopPlace $stopPlace;
            final /* synthetic */ CidrSuspensionCause $cause;
            {
                this.this$0 = $receiver;
                this.$stopPlace = $stopPlace;
                this.$cause = $cause;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = CidrLowLevelExceptionsInterceptor.access$getMyAdjuster$p(this.this$0);
                        if (v0 == null) ** GOTO lbl16
                        this.label = 1;
                        v1 = v0.adjustSoftwareBreakpoint(this.$stopPlace, this.$cause, (Continuation<? super CidrSoftwareBreakpointsAdjuster.AdjustedCauseAndPlace>)((Continuation)this));
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        if ((v0 = (CidrSoftwareBreakpointsAdjuster.AdjustedCauseAndPlace)v1) != null) ** GOTO lbl17
lbl16:
                        // 2 sources

                        v0 = new CidrSoftwareBreakpointsAdjuster.AdjustedCauseAndPlace(this.$stopPlace, this.$cause);
lbl17:
                        // 2 sources

                        this.L$0 = adjusted = v0;
                        this.label = 2;
                        v2 = CidrLowLevelExceptionsInterceptor.access$getMySuppressor$p(this.this$0).suppressSuspensionCauseIfNeeded(adjusted.getAdjustedCause(), (Continuation<? super CidrLowLevelExceptionsSuppressor.SuppressionResult>)((Continuation)this));
                        if (v2 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl27
                    }
                    case 2: {
                        adjusted = (CidrSoftwareBreakpointsAdjuster.AdjustedCauseAndPlace)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl27:
                        // 2 sources

                        suppressionResult = (CidrLowLevelExceptionsSuppressor.SuppressionResult)v2;
                        switch (interceptLowLevelException.WhenMappings.$EnumSwitchMapping$0[suppressionResult.ordinal()]) {
                            case 1: {
                                CidrLowLevelExceptionsInterceptor.access$getMyProcess$p(this.this$0).postCommand((CidrDebugProcess.VoidDebuggerCommand)LambdaMetafactory.metafactory(null, null, null, (Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;)V, invokeSuspend$lambda$0(com.jetbrains.cidr.execution.debugger.CidrLowLevelExceptionsInterceptor com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver ), (Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;)V)((CidrLowLevelExceptionsInterceptor)this.this$0));
                                return null;
                            }
                            case 2: {
                                var4_5 = new Object[]{this.$cause.getLowLevelDisplayString()};
                                CidrLowLevelExceptionsInterceptor.access$getMyProcess$p(this.this$0).getSession().reportMessage(CidrDebuggerBundle.message("debug.lowLevel.exception.suppressedAndCannotResume.message", var4_5), MessageType.WARNING);
                                break;
                            }
                            case 3: {
                                var4_6 = new Object[]{this.$cause.getLowLevelDisplayString()};
                                CidrLowLevelExceptionsInterceptor.access$getMyProcess$p(this.this$0).getSession().reportMessage(CidrDebuggerBundle.message("debug.lowLevel.exception.notSuppressedAndCannotResume.message", var4_6), MessageType.WARNING);
                                break;
                            }
                            case 4: {
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        return adjusted;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super CidrSoftwareBreakpointsAdjuster.AdjustedCauseAndPlace> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(CidrLowLevelExceptionsInterceptor this$0, DebuggerDriver driver) {
                CidrSoftwareBreakpointsAdjuster cidrSoftwareBreakpointsAdjuster = CidrLowLevelExceptionsInterceptor.access$getMyAdjuster$p(this$0);
                if (cidrSoftwareBreakpointsAdjuster != null) {
                    cidrSoftwareBreakpointsAdjuster.prepareForResume(driver);
                }
                driver.resume();
            }
        }), (int)3, null);
    }

    @NotNull
    public final CompletableFuture<Unit> interceptProcessDisconnect(boolean shouldDetach) {
        if (shouldDetach) {
            return this.mySuppressor.restoreAllPatchedInstructionOnDisconnect();
        }
        CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    private static final void interceptRunToPosition$lambda$0(CidrLowLevelExceptionsInterceptor this$0, DebuggerDriver.StopPlace $newStop) {
        this$0.myProcess.handleInterrupted($newStop);
    }

    private static final void interceptStepOver$lambda$1(CidrLowLevelExceptionsInterceptor this$0, DebuggerDriver.StopPlace $newStop) {
        this$0.myProcess.handleInterrupted($newStop);
    }

    private static final void interceptStepInto$lambda$2(CidrLowLevelExceptionsInterceptor this$0, DebuggerDriver.StopPlace $newStop) {
        this$0.myProcess.handleInterrupted($newStop);
    }

    private static final void interceptStepOut$lambda$3(CidrLowLevelExceptionsInterceptor this$0, DebuggerDriver.StopPlace $newStop) {
        this$0.myProcess.handleInterrupted($newStop);
    }

    public static final /* synthetic */ CidrSoftwareBreakpointsAdjuster access$getMyAdjuster$p(CidrLowLevelExceptionsInterceptor $this) {
        return $this.myAdjuster;
    }

    public static final /* synthetic */ CidrLowLevelExceptionsSuppressor access$getMySuppressor$p(CidrLowLevelExceptionsInterceptor $this) {
        return $this.mySuppressor;
    }

    public static final /* synthetic */ CidrDebugProcess access$getMyProcess$p(CidrLowLevelExceptionsInterceptor $this) {
        return $this.myProcess;
    }
}

