/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.GdbMiVariablesView;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/GdbMiVariablesView;", "Lcom/intellij/xdebugger/impl/frame/XVariablesView;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "session", "Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;Lcom/intellij/xdebugger/impl/XDebugSessionImpl;)V", "getProcess", "()Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "doCreateNewRootNode", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode;", "frame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "intellij.cidr.debugger.core"})
public final class GdbMiVariablesView
extends XVariablesView {
    @NotNull
    private final CidrDebugProcess process;

    public GdbMiVariablesView(@NotNull CidrDebugProcess process, @NotNull XDebugSessionImpl session) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session);
        this.process = process;
        Disposer.register((Disposable)this.process.getUiDisposable(), (Disposable)((Disposable)this));
    }

    @NotNull
    public final CidrDebugProcess getProcess() {
        return this.process;
    }

    @NotNull
    protected XValueContainerNode<?> doCreateNewRootNode(@Nullable XStackFrame frame) {
        if (!(frame instanceof CidrStackFrame)) {
            XValueContainerNode xValueContainerNode = super.doCreateNewRootNode(frame);
            Intrinsics.checkNotNullExpressionValue((Object)xValueContainerNode, (String)"doCreateNewRootNode(...)");
            return xValueContainerNode;
        }
        XValueContainer valueContainer2 = new XValueContainer(this, frame){
            final /* synthetic */ GdbMiVariablesView this$0;
            final /* synthetic */ XStackFrame $frame;
            {
                this.this$0 = $receiver;
                this.$frame = $frame;
            }

            public void computeChildren(XCompositeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.this$0.getProcess().postCommand(arg_0 -> doCreateNewRootNode.valueContainer.1.computeChildren$lambda$2(this.$frame, this.this$0, node, arg_0));
            }

            private static final Unit computeChildren$lambda$2$lambda$0(GdbMiVariablesView this$0, XStackFrame $frame, XCompositeNode $node, List filteredVars, Throwable throwable) {
                CidrValue.addLocalValues(filteredVars, this$0.getProcess(), null, (CidrStackFrame)$frame, $node, true);
                return Unit.INSTANCE;
            }

            private static final void computeChildren$lambda$2$lambda$1(Function2 $tmp0, Object p0, Object p1) {
                $tmp0.invoke(p0, p1);
            }

            private static final void computeChildren$lambda$2(XStackFrame $frame, GdbMiVariablesView this$0, XCompositeNode $node, DebuggerDriver driver) {
                Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                DebuggerDriver.FrameVariables frameVariables = ((GDBDriver)driver).doGetFrameVariablesGdbMi(((CidrStackFrame)$frame).getThreadId(), ((CidrStackFrame)$frame).getFrameIndex());
                Intrinsics.checkNotNullExpressionValue((Object)frameVariables, (String)"doGetFrameVariablesGdbMi(...)");
                DebuggerDriver.FrameVariables gdbMiFrameVars = frameVariables;
                if (gdbMiFrameVars.isFiltered()) {
                    CidrValue.addLocalValues(gdbMiFrameVars.getVariables(), this$0.getProcess(), null, (CidrStackFrame)$frame, $node, true);
                } else {
                    this$0.getProcess().getTypesHelper((CidrStackFrame)$frame).filterLocalVariables(((CidrStackFrame)$frame).getSourcePosition(), gdbMiFrameVars.getVariables(), () -> ((XCompositeNode)$node).isObsolete()).whenComplete((arg_0, arg_1) -> doCreateNewRootNode.valueContainer.1.computeChildren$lambda$2$lambda$1((arg_0, arg_1) -> doCreateNewRootNode.valueContainer.1.computeChildren$lambda$2$lambda$0(this$0, $frame, $node, arg_0, arg_1), arg_0, arg_1));
                }
            }
        };
        XDebuggerTree xDebuggerTree = this.getTree();
        return (XValueContainerNode)new XValueContainerNode<XValueContainer>(valueContainer2, xDebuggerTree){};
    }
}

