/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.jetbrains.cidr.execution.debugger.actions.CidrImageChannelFormat;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageDataType;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageDescriptor;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageShape;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.UByte;
import kotlin.UShort;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B,\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0016H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006%"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrByteArrayImageDescriptor;", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageDescriptor;", "shape", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape;", "title", "", "Lcom/intellij/openapi/util/NlsSafe;", "startAddress", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "bytesBGR", "", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape;Ljava/lang/String;Lcom/jetbrains/cidr/execution/debugger/memory/Address;[B)V", "getShape", "()Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape;", "getTitle", "()Ljava/lang/String;", "memory", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "getPixelAddress", "x", "", "y", "getPixelData", "getImage", "Ljava/awt/image/BufferedImage;", "format", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageChannelFormat;", "supportedFormats", "", "getSupportedFormats", "()Ljava/util/List;", "createBufferedImage", "imageData", "", "bufferedImageType", "intellij.cidr.debugger.core"})
public final class CidrByteArrayImageDescriptor
implements CidrImageDescriptor {
    @NotNull
    private final CidrImageShape shape;
    @NotNull
    private final String title;
    @NotNull
    private final Address startAddress;
    private final ByteBuffer memory;

    public CidrByteArrayImageDescriptor(@NotNull CidrImageShape shape, @NotNull String title, @NotNull Address startAddress, @NotNull byte[] bytesBGR) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)startAddress, (String)"startAddress");
        Intrinsics.checkNotNullParameter((Object)bytesBGR, (String)"bytesBGR");
        this.shape = shape;
        this.title = title;
        this.startAddress = startAddress;
        this.memory = ByteBuffer.wrap(bytesBGR).order(ByteOrder.nativeOrder());
    }

    @Override
    @NotNull
    public CidrImageShape getShape() {
        return this.shape;
    }

    @Override
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Override
    @NotNull
    public Address getPixelAddress(int x, int y) {
        Integer n = this.getShape().getPixelOffset(x, y);
        int offset = n != null ? n : 0;
        return this.startAddress.plus((Number)offset);
    }

    @Override
    @Nullable
    public String getPixelData(int x, int y) {
        Integer pixelOffset = this.getShape().getPixelOffset(x, y);
        if (pixelOffset == null) {
            return null;
        }
        ArrayList<String> channelValues = new ArrayList<String>(this.getShape().getChannelsCount());
        int n = this.getShape().getChannelsCount();
        for (int chan = 0; chan < n; ++chan) {
            int offset = pixelOffset + chan * this.getShape().getDataType().getSize();
            String channelValue = switch (WhenMappings.$EnumSwitchMapping$0[this.getShape().getDataType().ordinal()]) {
                case 1 -> String.valueOf(this.memory.get(offset));
                case 2 -> UByte.toString-impl((byte)UByte.constructor-impl((byte)this.memory.get(offset)));
                case 3 -> String.valueOf(this.memory.getShort(offset));
                case 4 -> UShort.toString-impl((short)UShort.constructor-impl((short)this.memory.getShort(offset)));
                case 5 -> String.valueOf(this.memory.getInt(offset));
                case 6 -> String.valueOf(this.memory.getFloat(offset));
                case 7 -> String.valueOf(this.memory.getDouble(offset));
                default -> throw new NoWhenBranchMatchedException();
            };
            channelValues.add(channelValue);
        }
        return CollectionsKt.joinToString$default((Iterable)channelValues, null, null, null, (int)0, null, null, (int)63, null);
    }

    @Override
    @NotNull
    public BufferedImage getImage(@Nullable CidrImageChannelFormat format) {
        Object object;
        if (format == CidrImageChannelFormat.RGB565) {
            short[] bufferedImageData = new short[this.getShape().getPixelCount()];
            int dst = 0;
            IntIterator intIterator = this.getShape().getPixelOffsets();
            while (((Iterator)intIterator).hasNext()) {
                int pixel = intIterator.nextInt();
                short v = this.memory.getShort(pixel);
                bufferedImageData[dst++] = v;
            }
            return this.createBufferedImage(bufferedImageData, 8);
        }
        if (format == CidrImageChannelFormat.BGR565) {
            int mask5 = 31;
            int mask6 = 63;
            short[] bufferedImageData = new short[this.getShape().getPixelCount()];
            int dst = 0;
            IntIterator v = this.getShape().getPixelOffsets();
            while (((Iterator)v).hasNext()) {
                int pixel = v.nextInt();
                short v2 = this.memory.getShort(pixel);
                int b = v2 >>> 11 & mask5;
                int g = v2 >>> 5 & mask6;
                int r = v2 & mask5;
                bufferedImageData[dst++] = (short)(r << 11 | g << 5 | b);
            }
            return this.createBufferedImage(bufferedImageData, 8);
        }
        CidrImageChannelFormat cidrImageChannelFormat = format;
        int[] channelOffsets = switch (cidrImageChannelFormat == null ? -1 : WhenMappings.$EnumSwitchMapping$1[cidrImageChannelFormat.ordinal()]) {
            case 1 -> {
                int[] dst = new int[]{1, 0, 0};
                yield dst;
            }
            case 2 -> {
                int[] dst = new int[]{0, 1, 0};
                yield dst;
            }
            case 3 -> {
                int[] dst = new int[]{0, 1, 2};
                yield dst;
            }
            case 4 -> {
                int[] dst = new int[]{2, 1, 0};
                yield dst;
            }
            case 5 -> {
                int[] dst = new int[]{0, 1, 2, 3};
                yield dst;
            }
            case 6 -> {
                int[] dst = new int[]{2, 1, 0, 3};
                yield dst;
            }
            case 7 -> {
                int[] dst = new int[]{0};
                yield dst;
            }
            case 8 -> {
                int[] dst = new int[]{0};
                yield dst;
            }
            case 9 -> {
                int[] dst = new int[]{1};
                yield dst;
            }
            case 10 -> {
                int[] dst = new int[]{2};
                yield dst;
            }
            case 11 -> {
                int[] dst = new int[]{3};
                yield dst;
            }
            case -1 -> {
                int[] dst = new int[]{0};
                yield dst;
            }
            case 12 -> throw new IllegalStateException();
            case 13 -> throw new IllegalStateException();
            default -> throw new NoWhenBranchMatchedException();
        };
        int i = 0;
        int bufferedImageData = channelOffsets.length;
        while (i < bufferedImageData) {
            int dst = i++;
            channelOffsets[dst] = channelOffsets[dst] * this.getShape().getDataType().getSize();
        }
        CidrImageChannelFormat cidrImageChannelFormat2 = format;
        int[] channelMasks = switch (cidrImageChannelFormat2 == null ? -1 : WhenMappings.$EnumSwitchMapping$1[cidrImageChannelFormat2.ordinal()]) {
            case 1 -> {
                int[] v = new int[]{255, 255, 0};
                yield v;
            }
            case 2 -> {
                int[] v = new int[]{255, 255, 0};
                yield v;
            }
            default -> {
                int v = 0;
                int var7_25 = channelOffsets.length;
                object = new int[var7_25];
                while (v < var7_25) {
                    int b = v++;
                    object[b] = 255;
                }
                yield object;
            }
        };
        byte[] bufferedImageBytes = new byte[this.getShape().getPixelCount() * channelOffsets.length];
        int dst = 0;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getShape().getDataType().ordinal()]) {
            case 2: {
                int pixel;
                object = this.getShape().getPixelOffsets();
                while (((Iterator)object).hasNext()) {
                    pixel = object.nextInt();
                    int n = channelOffsets.length;
                    for (int i2 = 0; i2 < n; ++i2) {
                        byte v;
                        int chan = channelOffsets[i2];
                        byte chanVal = v = this.memory.get(pixel + chan);
                        bufferedImageBytes[dst++] = (byte)(chanVal & channelMasks[i2]);
                    }
                }
                break;
            }
            case 1: {
                int pixel;
                object = this.getShape().getPixelOffsets();
                while (((Iterator)object).hasNext()) {
                    pixel = object.nextInt();
                    int n = channelOffsets.length;
                    for (int i3 = 0; i3 < n; ++i3) {
                        int chan = channelOffsets[i3];
                        byte v = this.memory.get(pixel + chan);
                        int chanVal = v + 128;
                        bufferedImageBytes[dst++] = (byte)(chanVal & channelMasks[i3]);
                    }
                }
                break;
            }
            case 3: {
                int pixel;
                object = this.getShape().getPixelOffsets();
                while (((Iterator)object).hasNext()) {
                    pixel = object.nextInt();
                    int n = channelOffsets.length;
                    for (int i4 = 0; i4 < n; ++i4) {
                        int chan = channelOffsets[i4];
                        short v = this.memory.getShort(pixel + chan);
                        int chanVal = RangesKt.coerceIn((int)MathKt.roundToInt((float)((float)v / 255.0f + (float)128)), (int)0, (int)255);
                        bufferedImageBytes[dst++] = (byte)(chanVal & channelMasks[i4]);
                    }
                }
                break;
            }
            case 4: {
                int pixel;
                object = this.getShape().getPixelOffsets();
                while (((Iterator)object).hasNext()) {
                    pixel = object.nextInt();
                    int n = channelOffsets.length;
                    for (int i5 = 0; i5 < n; ++i5) {
                        int chan = channelOffsets[i5];
                        short v = UShort.constructor-impl((short)this.memory.getShort(pixel + chan));
                        int chanVal = RangesKt.coerceIn((int)MathKt.roundToInt((float)((float)UnsignedKt.uintToDouble((int)(v & 0xFFFF)) / 255.0f)), (int)0, (int)255);
                        bufferedImageBytes[dst++] = (byte)(chanVal & channelMasks[i5]);
                    }
                }
                break;
            }
            case 5: {
                int pixel;
                object = this.getShape().getPixelOffsets();
                while (((Iterator)object).hasNext()) {
                    pixel = object.nextInt();
                    int n = channelOffsets.length;
                    for (int i6 = 0; i6 < n; ++i6) {
                        int chan = channelOffsets[i6];
                        int v = this.memory.getInt(pixel + chan);
                        int s = RangesKt.coerceIn((int)v, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
                        int chanVal = RangesKt.coerceIn((int)MathKt.roundToInt((float)((float)s / 255.0f + (float)128)), (int)0, (int)255);
                        bufferedImageBytes[dst++] = (byte)(chanVal & channelMasks[i6]);
                    }
                }
                break;
            }
            case 6: {
                int pixel;
                object = this.getShape().getPixelOffsets();
                while (((Iterator)object).hasNext()) {
                    pixel = object.nextInt();
                    int n = channelOffsets.length;
                    for (int i7 = 0; i7 < n; ++i7) {
                        int chan = channelOffsets[i7];
                        float v = this.memory.getFloat(pixel + chan);
                        int chanVal = RangesKt.coerceIn((int)MathKt.roundToInt((float)(v * (float)255)), (int)0, (int)255);
                        bufferedImageBytes[dst++] = (byte)(chanVal & channelMasks[i7]);
                    }
                }
                break;
            }
            case 7: {
                int pixel;
                object = this.getShape().getPixelOffsets();
                while (((Iterator)object).hasNext()) {
                    pixel = object.nextInt();
                    int n = channelOffsets.length;
                    for (int i8 = 0; i8 < n; ++i8) {
                        int chan = channelOffsets[i8];
                        double v = this.memory.getDouble(pixel + chan);
                        int chanVal = RangesKt.coerceIn((int)MathKt.roundToInt((double)(v * (double)255)), (int)0, (int)255);
                        bufferedImageBytes[dst++] = (byte)(chanVal & channelMasks[i8]);
                    }
                }
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int bufferedImageType = switch (channelOffsets.length) {
            case 3 -> 5;
            case 4 -> 6;
            default -> 10;
        };
        return this.createBufferedImage(bufferedImageBytes, bufferedImageType);
    }

    @Override
    @NotNull
    public List<CidrImageChannelFormat> getSupportedFormats() {
        return switch (this.getShape().getChannelsCount()) {
            case 1 -> {
                if (this.getShape().getDataType().getSize() == 2) {
                    CidrImageChannelFormat[] var1_1 = new CidrImageChannelFormat[]{CidrImageChannelFormat.GRAY, CidrImageChannelFormat.BGR565, CidrImageChannelFormat.RGB565};
                    yield CollectionsKt.listOf((Object[])var1_1);
                }
                yield CollectionsKt.emptyList();
            }
            case 2 -> {
                if (this.getShape().getDataType().getSize() == 1) {
                    CidrImageChannelFormat[] var1_2 = new CidrImageChannelFormat[]{CidrImageChannelFormat.GR, CidrImageChannelFormat.RG, CidrImageChannelFormat.BGR565, CidrImageChannelFormat.RGB565, CidrImageChannelFormat.CHANNEL0, CidrImageChannelFormat.CHANNEL1};
                    yield CollectionsKt.listOf((Object[])var1_2);
                }
                CidrImageChannelFormat[] var1_3 = new CidrImageChannelFormat[]{CidrImageChannelFormat.GR, CidrImageChannelFormat.RG, CidrImageChannelFormat.CHANNEL0, CidrImageChannelFormat.CHANNEL1};
                yield CollectionsKt.listOf((Object[])var1_3);
            }
            case 3 -> {
                CidrImageChannelFormat[] var1_4 = new CidrImageChannelFormat[]{CidrImageChannelFormat.BGR, CidrImageChannelFormat.RGB, CidrImageChannelFormat.CHANNEL0, CidrImageChannelFormat.CHANNEL1, CidrImageChannelFormat.CHANNEL2};
                yield CollectionsKt.listOf((Object[])var1_4);
            }
            case 4 -> {
                CidrImageChannelFormat[] var1_5 = new CidrImageChannelFormat[]{CidrImageChannelFormat.BGRA, CidrImageChannelFormat.RGBA, CidrImageChannelFormat.CHANNEL0, CidrImageChannelFormat.CHANNEL1, CidrImageChannelFormat.CHANNEL2, CidrImageChannelFormat.CHANNEL3};
                yield CollectionsKt.listOf((Object[])var1_5);
            }
            default -> throw new IllegalStateException();
        };
    }

    private final BufferedImage createBufferedImage(Object imageData, int bufferedImageType) {
        BufferedImage result = new BufferedImage(this.getShape().getWidthPixels(), this.getShape().getHeightPixels(), bufferedImageType);
        result.getRaster().setDataElements(0, 0, this.getShape().getWidthPixels(), this.getShape().getHeightPixels(), imageData);
        return result;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[CidrImageDataType.values().length];
            try {
                nArray[CidrImageDataType.Int8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageDataType.Uint8.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageDataType.Int16.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageDataType.Uint16.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageDataType.Int32.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageDataType.Float32.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageDataType.Float64.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CidrImageChannelFormat.values().length];
            try {
                nArray[CidrImageChannelFormat.GR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.RG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.RGB.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.BGR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.RGBA.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.BGRA.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.GRAY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.CHANNEL0.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.CHANNEL1.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.CHANNEL2.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.CHANNEL3.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.BGR565.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CidrImageChannelFormat.RGB565.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

