/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.TasksKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.actions.XDebuggerSuspendedActionHandler;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtilKt;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrThreadFreezer;
import com.jetbrains.cidr.execution.debugger.actions.CidrFreezeThreadActionsKt;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B%\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u001e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u00a6@\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrThreadFreezeHandler;", "Lcom/intellij/xdebugger/impl/actions/XDebuggerSuspendedActionHandler;", "progressTitle", "", "successNotification", "failureNotification", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "perform", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "handle", "freezer", "Lcom/jetbrains/cidr/execution/debugger/CidrThreadFreezer;", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "(Lcom/jetbrains/cidr/execution/debugger/CidrThreadFreezer;Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.cidr.debugger.core"})
public abstract class CidrThreadFreezeHandler
extends XDebuggerSuspendedActionHandler {
    @NotNull
    private final String progressTitle;
    @NotNull
    private final String successNotification;
    @NotNull
    private final String failureNotification;

    public CidrThreadFreezeHandler(@NlsContexts.ProgressTitle @NlsSafe @NotNull String progressTitle, @NlsContexts.NotificationContent @NlsSafe @NotNull String successNotification, @NlsContexts.NotificationContent @NlsSafe @NotNull String failureNotification) {
        Intrinsics.checkNotNullParameter((Object)progressTitle, (String)"progressTitle");
        Intrinsics.checkNotNullParameter((Object)successNotification, (String)"successNotification");
        Intrinsics.checkNotNullParameter((Object)failureNotification, (String)"failureNotification");
        this.progressTitle = progressTitle;
        this.successNotification = successNotification;
        this.failureNotification = failureNotification;
    }

    protected void perform(@NotNull XDebugSession session, @NotNull DataContext dataContext) {
        LLThread selectedThread;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        CidrDebugProcess cidrDebugProcess = CidrDebuggerUtilKt.getCidrDebugProcess(session);
        if (cidrDebugProcess == null) {
            return;
        }
        CidrDebugProcess cidrDebugProcess2 = cidrDebugProcess;
        CidrStackFrame cidrStackFrame = CidrDebuggerUtilKt.getCidrCurrentStackFrame(session);
        Object object = selectedThread = cidrStackFrame != null ? cidrStackFrame.getThread() : null;
        if (selectedThread == null) {
            session.reportMessage(CidrDebuggerBundle.message("debug.freezeThreadNotFound.warning", new Object[0]), MessageType.WARNING);
            return;
        }
        CidrThreadFreezer cidrThreadFreezer = cidrDebugProcess2.getThreadFreezer();
        Intrinsics.checkNotNullExpressionValue((Object)cidrThreadFreezer, (String)"getThreadFreezer(...)");
        CidrThreadFreezer freezer = cidrThreadFreezer;
        BuildersKt.launch$default((CoroutineScope)CidrDebuggerUtilKt.getCidrCoroutineScope(session), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(session, this, freezer, selectedThread, cidrDebugProcess2, null){
            int label;
            final /* synthetic */ XDebugSession $session;
            final /* synthetic */ CidrThreadFreezeHandler this$0;
            final /* synthetic */ CidrThreadFreezer $freezer;
            final /* synthetic */ LLThread $selectedThread;
            final /* synthetic */ CidrDebugProcess $cidrDebugProcess;
            {
                this.$session = $session;
                this.this$0 = $receiver;
                this.$freezer = $freezer;
                this.$selectedThread = $selectedThread;
                this.$cidrDebugProcess = $cidrDebugProcess;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Project project = this.$session.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        this.label = 1;
                        Object object2 = TasksKt.withBackgroundProgressIndicator((Project)project, (String)CidrThreadFreezeHandler.access$getProgressTitle$p(this.this$0), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$freezer, this.$selectedThread, this.$session, this.$cidrDebugProcess, null){
                            int label;
                            final /* synthetic */ CidrThreadFreezeHandler this$0;
                            final /* synthetic */ CidrThreadFreezer $freezer;
                            final /* synthetic */ LLThread $selectedThread;
                            final /* synthetic */ XDebugSession $session;
                            final /* synthetic */ CidrDebugProcess $cidrDebugProcess;
                            {
                                this.this$0 = $receiver;
                                this.$freezer = $freezer;
                                this.$selectedThread = $selectedThread;
                                this.$session = $session;
                                this.$cidrDebugProcess = $cidrDebugProcess;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        v0 = this.this$0.handle(this.$freezer, this.$selectedThread, (Continuation<? super Unit>)((Continuation)this));
                                        ** if (v0 != var3_2) goto lbl11
lbl10:
                                        // 1 sources

                                        return var3_2;
lbl11:
                                        // 1 sources

                                        ** GOTO lbl17
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl17:
                                        // 2 sources

                                        this.label = 2;
                                        v1 = CidrFreezeThreadActionsKt.access$refreshFramesView(this.$session, this.$cidrDebugProcess, this.$selectedThread, (Continuation)this);
                                        ** if (v1 != var3_2) goto lbl21
lbl20:
                                        // 1 sources

                                        return var3_2;
lbl21:
                                        // 1 sources

                                        ** GOTO lbl27
                                    }
                                    case 2: {
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl27:
                                            // 2 sources

                                            this.$session.reportMessage(CidrThreadFreezeHandler.access$getSuccessNotification$p(this.this$0), MessageType.INFO);
                                        }
                                        catch (DebuggerCommandException e) {
                                            CidrDebuggerLog.LOG.warn((Throwable)e);
                                            this.$session.reportError(CidrThreadFreezeHandler.access$getFailureNotification$p(this.this$0));
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public abstract Object handle(@NotNull CidrThreadFreezer var1, @NotNull LLThread var2, @NotNull Continuation<? super Unit> var3) throws DebuggerCommandException;

    public static final /* synthetic */ String access$getProgressTitle$p(CidrThreadFreezeHandler $this) {
        return $this.progressTitle;
    }

    public static final /* synthetic */ String access$getSuccessNotification$p(CidrThreadFreezeHandler $this) {
        return $this.successNotification;
    }

    public static final /* synthetic */ String access$getFailureNotification$p(CidrThreadFreezeHandler $this) {
        return $this.failureNotification;
    }
}

