/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBBundle;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Scanner;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class MacOSDebugSymbols {
    public static LongSet load(@NotNull GeneralCommandLine cl) throws IOException {
        if (cl == null) {
            MacOSDebugSymbols.$$$reportNull$$$0(0);
        }
        try {
            if (Registry.is((String)"cidr.debugger.gdb.workaround.macOS.generateDsymBundle", (boolean)false)) {
                MacOSDebugSymbols.generateDsymBundle(cl.getExePath());
            }
            GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"/usr/bin/otool"});
            commandLine.addParameter("-I");
            commandLine.addParameter(cl.getExePath());
            return MacOSDebugSymbols.parseIndirectSymTable(commandLine.createProcess().getInputStream());
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateDsymBundle(@NotNull String exePath) throws IOException, ExecutionException {
        File executable;
        File dsymBundle;
        if (exePath == null) {
            MacOSDebugSymbols.$$$reportNull$$$0(1);
        }
        if (!(dsymBundle = new File((executable = new File(exePath)).getParentFile(), executable.getName() + ".dSYM")).exists() || executable.lastModified() > dsymBundle.lastModified()) {
            File tmpDir = FileUtil.createTempDirectory((String)executable.getName(), null);
            try {
                File newDSYMBundle = new File(tmpDir, dsymBundle.getName());
                GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"/usr/bin/dsymutil"}).withCharset(Charset.defaultCharset());
                commandLine.addParameter(exePath);
                commandLine.addParameter("-o");
                commandLine.addParameter(newDSYMBundle.getAbsolutePath());
                String output = Objects.requireNonNullElse(ExecUtil.execAndReadLine((GeneralCommandLine)commandLine), "");
                if (output.matches("^error.*")) {
                    throw new IOException("Cannot create dsym bundle for " + exePath);
                }
                if (dsymBundle.exists()) {
                    FileUtil.delete((File)dsymBundle);
                }
                FileUtil.rename((File)newDSYMBundle, (File)dsymBundle);
            }
            finally {
                FileUtil.delete((File)tmpDir);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    public static LongSet parseIndirectSymTable(InputStream input) throws ExecutionException {
        Scanner scanner = new Scanner(input, StandardCharsets.UTF_8);
        LongOpenHashSet symbols = new LongOpenHashSet();
        try {
            block2: while (scanner.hasNext()) {
                if (scanner.findInLine("Indirect symbols for \\(__TEXT,__stubs\\)") != null) {
                    int snum = scanner.nextInt();
                    scanner.nextLine();
                    MacOSDebugSymbols.nextTitle(scanner, "address");
                    MacOSDebugSymbols.nextTitle(scanner, "index");
                    scanner.nextLine();
                    int i = 0;
                    while (true) {
                        if (i >= snum) continue block2;
                        symbols.add(DebuggerDriver.parseAddress((String)scanner.next()).unsignedLongValue());
                        scanner.nextInt();
                        scanner.nextLine();
                        ++i;
                    }
                }
                scanner.nextLine();
            }
            return symbols;
        }
        catch (NoSuchElementException e) {
            throw new ExecutionException(GDBBundle.message("gdb.cannot.parse.indirect.symbol.table", e));
        }
    }

    private static void nextTitle(@NotNull Scanner scanner, @NotNull String expected) throws ExecutionException {
        String str;
        if (scanner == null) {
            MacOSDebugSymbols.$$$reportNull$$$0(2);
        }
        if (expected == null) {
            MacOSDebugSymbols.$$$reportNull$$$0(3);
        }
        if (!expected.equals(str = scanner.next())) {
            throw new ExecutionException(GDBBundle.message("gdb.invalid.section.title", str));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scanner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/MacOSDebugSymbols";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "generateDsymBundle";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "nextTitle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

