/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.codeInsight.daemon.impl.IdentifierHighlightingComputer;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelperBase;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.LocalVariablesFilterHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class CidrDebuggerTypesHelper
implements CidrDebuggerTypesHelperBase {
    private static final Pattern OPTIONAL_PATTERN = Pattern.compile("Swift\\.(ImplicitlyUnwrapped)?Optional<(.*?)>");
    protected CidrDebugProcess myProcess;

    public CidrDebuggerTypesHelper(CidrDebugProcess process) {
        this.myProcess = process;
    }

    @Contract(value="null, _ -> null")
    public static PsiElement getContextElement(@Nullable XSourcePosition sourcePosition, @NotNull Project project) {
        if (project == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(0);
        }
        if (sourcePosition == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(sourcePosition.getFile());
        if (document == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        return CidrDebuggerTypesHelper.findContextElement(sourcePosition, document, psiFile);
    }

    @Nullable
    private static PsiElement findContextElement(XSourcePosition sourcePosition, Document document, PsiFile psiFile) {
        PsiElement element;
        int positionOffset = sourcePosition.getOffset();
        if (!DocumentUtil.isValidOffset((int)positionOffset, (Document)document)) {
            return null;
        }
        int lineEndOffset = document.getLineEndOffset(document.getLineNumber(positionOffset));
        int offset = positionOffset;
        while ((element = psiFile.findElementAt(offset)) != null) {
            if (!(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment)) {
                return element;
            }
            offset = element.getTextRange().getEndOffset() + 1;
            if (offset < lineEndOffset) continue;
        }
        return psiFile.findElementAt(positionOffset);
    }

    @Override
    @NotNull
    public CompletableFuture<XSourcePosition> computeSourcePositionAsync(@NotNull XSourcePosition position, @NotNull LLValue var, @NotNull ProgressIndicator indicator) {
        if (position == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(1);
        }
        if (var == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(3);
        }
        CompletableFuture<XSourcePosition> completableFuture = CompletableFuture.supplyAsync(() -> (XSourcePosition)ReadAction.nonBlocking(() -> this.computeSourcePosition(position, var)).wrapProgress(indicator).executeSynchronously());
        if (completableFuture == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(4);
        }
        return completableFuture;
    }

    @Nullable
    public XSourcePosition computeSourcePosition(XSourcePosition position, LLValue var) {
        PsiElement resolved = this.resolveToDeclaration(position, var);
        if (resolved == null) {
            return null;
        }
        return XDebuggerUtil.getInstance().createPositionByOffset(resolved.getContainingFile().getVirtualFile(), resolved.getTextOffset());
    }

    @Override
    @NotNull
    public CompletableFuture<XSourcePosition> computeSourcePositionAsync(@NotNull CidrMemberValue value, @NotNull ProgressIndicator indicator) {
        if (value == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(6);
        }
        CompletableFuture<XSourcePosition> completableFuture = CompletableFuture.supplyAsync(() -> (XSourcePosition)ReadAction.nonBlocking(() -> this.computeSourcePosition(value)).wrapProgress(indicator).executeSynchronously());
        if (completableFuture == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    @Nullable
    public XSourcePosition computeSourcePosition(@NotNull CidrMemberValue value) {
        if (value == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Override
    @NotNull
    public CompletableFuture<XSourcePosition> computeNearestUsageSourcePositionAsync(@NotNull XSourcePosition position, @NotNull LLValue var, @NotNull ProgressIndicator indicator) {
        if (position == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(9);
        }
        if (var == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(11);
        }
        CompletableFuture completableFuture = Promises.asCompletableFuture((Promise)ReadAction.nonBlocking(() -> this.computeNearestUsageSourcePosition(position, var)).wrapProgress(indicator).submit((Executor)AppExecutorUtil.getAppExecutorService()));
        if (completableFuture == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(12);
        }
        return completableFuture;
    }

    @Nullable
    private XSourcePosition computeNearestUsageSourcePosition(@NotNull XSourcePosition position, @NotNull LLValue var) {
        PsiElement resolved;
        if (position == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(13);
        }
        if (var == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(14);
        }
        if ((resolved = this.resolveToDeclaration(position, var)) == null) {
            return null;
        }
        PsiFile file = resolved.getContainingFile();
        if (file == null) {
            return null;
        }
        int positionLine = position.getLine();
        int bestLine = -1;
        XSourcePositionImpl bestPos = null;
        Collection usages = IdentifierHighlightingComputer.getUsages((PsiElement)resolved, (PsiElement)file, (boolean)false);
        for (TextRange usage : usages) {
            int currLine;
            XSourcePositionImpl currPos = XSourcePositionImpl.createByOffset((VirtualFile)file.getVirtualFile(), (int)usage.getStartOffset());
            if (currPos == null || bestLine >= (currLine = currPos.getLine()) || currLine > positionLine) continue;
            bestLine = currLine;
            bestPos = currPos;
        }
        return bestPos;
    }

    @Nullable
    public PsiElement getContextElement(@Nullable XSourcePosition position) {
        return CidrDebuggerTypesHelper.getContextElement(position, this.myProcess.getProject());
    }

    @Override
    @Nullable
    public XSourcePosition resolveProperty(@NotNull CidrMemberValue value, @Nullable String dynamicTypeName) {
        if (value == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(15);
        }
        return null;
    }

    @Override
    @NotNull
    public CompletableFuture<List<LLValue>> filterLocalVariables(@Nullable XSourcePosition position, @NotNull List<LLValue> vars, @NotNull Expirable expirable) {
        if (vars == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(16);
        }
        if (expirable == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(17);
        }
        if (position == null) {
            CompletableFuture<List<LLValue>> completableFuture = CompletableFuture.completedFuture(Collections.emptyList());
            if (completableFuture == null) {
                CidrDebuggerTypesHelper.$$$reportNull$$$0(18);
            }
            return completableFuture;
        }
        if (!CidrDebuggerSettings.getInstance().isValuesFilterEnabled()) {
            CompletableFuture<List<LLValue>> completableFuture = CompletableFuture.completedFuture(vars);
            if (completableFuture == null) {
                CidrDebuggerTypesHelper.$$$reportNull$$$0(19);
            }
            return completableFuture;
        }
        DumbService dumbService = DumbService.getInstance((Project)this.myProcess.getProject());
        if (dumbService.isDumb()) {
            dumbService.runWhenSmart(() -> {
                if (!expirable.isExpired()) {
                    this.myProcess.getSession().rebuildViews();
                }
            });
            CompletableFuture<List<LLValue>> completableFuture = CompletableFuture.completedFuture(vars);
            if (completableFuture == null) {
                CidrDebuggerTypesHelper.$$$reportNull$$$0(20);
            }
            return completableFuture;
        }
        Project project = this.myProcess.getProject();
        LocalVariablesFilterHandler explicitFilterHandler = LocalVariablesFilterHandler.findFilterHandler(project, position);
        if (explicitFilterHandler != null) {
            CompletableFuture<List<LLValue>> completableFuture = explicitFilterHandler.filterVars(project, position, vars);
            if (completableFuture == null) {
                CidrDebuggerTypesHelper.$$$reportNull$$$0(21);
            }
            return completableFuture;
        }
        int positionLine = position.getLine();
        List varInfos = ContainerUtil.map(vars, it -> this.getVarInfo(project, expirable, position, (LLValue)it));
        for (VarInfo info : varInfos) {
            info.value.setValid(info.isSpecial || info.isResolved && info.line < positionLine);
        }
        List<LLValue> filteredAndSorted = varInfos.stream().sorted().map(it -> it.value).filter(it -> it.isValid()).toList();
        CompletableFuture<List<LLValue>> completableFuture = CompletableFuture.completedFuture(filteredAndSorted);
        if (completableFuture == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(22);
        }
        return completableFuture;
    }

    @NotNull
    private VarInfo getVarInfo(@NotNull Project project, @NotNull Expirable expirable, @NotNull XSourcePosition position, @NotNull LLValue value) {
        if (project == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(23);
        }
        if (expirable == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(24);
        }
        if (position == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(25);
        }
        if (value == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(26);
        }
        CidrDebuggerUtil.ReadActionResult computedResult = CidrDebuggerUtil.runInReadActionWithRetries(() -> {
            boolean resolved;
            PsiElement declarator = this.resolveToDeclaration(position, value);
            boolean special = false;
            boolean bl = resolved = declarator != null;
            if (!resolved) {
                Boolean thisSelfSupper = this.isImplicitContextVariable(position, value);
                special = thisSelfSupper != null ? thisSelfSupper : false;
                return new VarInfo(value, resolved, special, null);
            }
            PsiFile targetFile = declarator.getContainingFile();
            if (!Comparing.equal((Object)targetFile.getVirtualFile(), (Object)position.getFile())) {
                return new VarInfo(value, resolved, special, null);
            }
            int endOffset2 = declarator.getTextRange().getEndOffset();
            Document document = PsiDocumentManager.getInstance((Project)targetFile.getProject()).getDocument(targetFile);
            if (document == null) {
                return new VarInfo(value, resolved, special, null);
            }
            return new VarInfo(value, resolved, special, document.getLineNumber(endOffset2));
        }, () -> project.isDisposed() || expirable.isExpired());
        VarInfo result = (VarInfo)computedResult.value;
        return result != null ? result : new VarInfo(value, false, false, null);
    }

    @Nullable
    public PsiElement resolveToDeclaration(@Nullable XSourcePosition position, @NotNull LLValue var) {
        PsiElement context;
        if (var == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(27);
        }
        if ((context = this.getContextElement(position)) == null) {
            return null;
        }
        PsiReference ref = this.createReferenceFromText(var, context);
        if (ref == null) {
            return null;
        }
        try {
            PsiElement resolved = ref.resolve();
            if (resolved == null) {
                return null;
            }
            if (resolved.getContainingFile() == ((PsiElement)ref).getContainingFile()) {
                return null;
            }
            return resolved;
        }
        catch (IndexNotReadyException ignored) {
            return null;
        }
    }

    @Nullable
    protected PsiReference createReferenceFromText(@NotNull LLValue var, @NotNull PsiElement context) {
        if (var == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(28);
        }
        if (context == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(29);
        }
        return null;
    }

    @Nullable
    public Boolean isImplicitContextVariable(@NotNull XSourcePosition position, @NotNull LLValue var) {
        if (position == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(30);
        }
        if (var == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(31);
        }
        return null;
    }

    @Nullable
    public static String unwrapSwiftOptionalType(@NotNull String typeName) {
        Matcher m;
        if (typeName == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(32);
        }
        return (m = OPTIONAL_PATTERN.matcher(typeName)).matches() ? m.group(2) : null;
    }

    @NotNull
    public static String unwrapSwiftOptionalTypeIfNecessary(@NotNull String typeName) {
        if (typeName == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(33);
        }
        String string = StringUtil.notNullize((String)CidrDebuggerTypesHelper.unwrapSwiftOptionalType(typeName), (String)typeName);
        if (string == null) {
            CidrDebuggerTypesHelper.$$$reportNull$$$0(34);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 12, 18, 19, 20, 21, 22, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 13: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: 
            case 10: 
            case 14: 
            case 27: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrDebuggerTypesHelper";
                break;
            }
            case 5: 
            case 8: 
            case 15: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expirable";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrDebuggerTypesHelper";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSourcePositionAsync";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "computeNearestUsageSourcePositionAsync";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "filterLocalVariables";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapSwiftOptionalTypeIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContextElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeSourcePositionAsync";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 34: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeSourcePosition";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeNearestUsageSourcePositionAsync";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeNearestUsageSourcePosition";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveProperty";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "filterLocalVariables";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getVarInfo";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "resolveToDeclaration";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceFromText";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitContextVariable";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "unwrapSwiftOptionalType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "unwrapSwiftOptionalTypeIfNecessary";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 12, 18, 19, 20, 21, 22, 34 -> new IllegalStateException(string);
        };
    }

    private static class VarInfo
    implements Comparable<VarInfo> {
        LLValue value;
        boolean isResolved;
        boolean isSpecial;
        int line;

        private VarInfo(@NotNull LLValue value, boolean resolved, boolean special, @Nullable Integer line) {
            if (value == null) {
                VarInfo.$$$reportNull$$$0(0);
            }
            this.value = value;
            this.isResolved = resolved;
            this.isSpecial = special;
            this.line = line == null ? Integer.MAX_VALUE : line;
        }

        @Override
        public int compareTo(@NotNull VarInfo o) {
            int bySpecial;
            if (o == null) {
                VarInfo.$$$reportNull$$$0(1);
            }
            if ((bySpecial = -Boolean.compare(this.isSpecial, o.isSpecial)) != 0) {
                return bySpecial;
            }
            return Integer.compare(this.line, o.line);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrDebuggerTypesHelper$VarInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

