/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/TextWithPattern;", "", "text", "", "regex", "Lkotlin/text/Regex;", "<init>", "(Ljava/lang/String;Lkotlin/text/Regex;)V", "getText", "()Ljava/lang/String;", "getRegex", "()Lkotlin/text/Regex;", "split", "Lkotlin/Triple;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.cidr.debugger.core"})
public final class TextWithPattern {
    @NotNull
    private final String text;
    @NotNull
    private final Regex regex;

    public TextWithPattern(@NotNull String text, @NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        this.text = text;
        this.regex = regex;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final Regex getRegex() {
        return this.regex;
    }

    @NotNull
    public final Triple<String, String, String> split() {
        MatchResult matchResult = this.regex.matchEntire((CharSequence)this.text);
        if (matchResult != null) {
            MatchResult m = matchResult;
            boolean bl = false;
            if (m.getGroups().size() > 1) {
                MatchGroup matchGroup = m.getGroups().get(1);
                if (matchGroup != null && (matchGroup = matchGroup.getRange()) != null) {
                    MatchGroup r = matchGroup;
                    boolean bl2 = false;
                    String string = StringsKt.substring((String)this.text, (IntRange)RangesKt.until((int)0, (int)r.getStart()));
                    String string2 = StringsKt.substring((String)this.text, (IntRange)r);
                    String string3 = this.text.substring(r.getEndInclusive() + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    return new Triple((Object)string, (Object)string2, (Object)string3);
                }
            }
        }
        return new Triple((Object)"", (Object)this.text, (Object)"");
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final Regex component2() {
        return this.regex;
    }

    @NotNull
    public final TextWithPattern copy(@NotNull String text, @NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return new TextWithPattern(text, regex);
    }

    public static /* synthetic */ TextWithPattern copy$default(TextWithPattern textWithPattern, String string, Regex regex, int n, Object object) {
        if ((n & 1) != 0) {
            string = textWithPattern.text;
        }
        if ((n & 2) != 0) {
            regex = textWithPattern.regex;
        }
        return textWithPattern.copy(string, regex);
    }

    @NotNull
    public String toString() {
        return "TextWithPattern(text=" + this.text + ", regex=" + this.regex + ")";
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = result * 31 + this.regex.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextWithPattern)) {
            return false;
        }
        TextWithPattern textWithPattern = (TextWithPattern)other;
        if (!Intrinsics.areEqual((Object)this.text, (Object)textWithPattern.text)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.regex, (Object)textWithPattern.regex);
    }
}

