/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectorValueRenderer
extends ValueRenderer {
    public SelectorValueRenderer(@NotNull CidrPhysicalValue value) {
        if (value == null) {
            SelectorValueRenderer.$$$reportNull$$$0(0);
        }
        super(value);
    }

    @Nullable
    public static ValueRenderer createIfSelector(@NotNull ValueRendererFactory.FactoryContext context) {
        String type;
        if (context == null) {
            SelectorValueRenderer.$$$reportNull$$$0(1);
        }
        SelectorValueRenderer result = null;
        if (context.getLLValueData().isValidPointer() && SelectorValueRenderer.isSelectorType(type = context.getLLValue().getType())) {
            result = new SelectorValueRenderer(context.getPhysicalValue());
        }
        return result;
    }

    @Override
    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        String result;
        if (context == null) {
            SelectorValueRenderer.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmptyOrSpaces((String)(result = this.getValue().getVarData(context).getDescription())) || StringUtil.unquoteString((String)result).isEmpty()) {
            String pointer = context.getData(this.myValue.getVar()).getPointer();
            result = context.evaluateData("(char *)sel_getName((void *)" + pointer + ")").getPresentableValue();
        }
        Pair pair = Pair.create((Object)result, null);
        if (pair == null) {
            SelectorValueRenderer.$$$reportNull$$$0(3);
        }
        return pair;
    }

    public static boolean isSelectorType(@NlsSafe @NotNull String type) {
        if (type == null) {
            SelectorValueRenderer.$$$reportNull$$$0(4);
        }
        return type.endsWith("objc_selector *") || type.equals("SEL");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/SelectorValueRenderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/SelectorValueRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeValueAndEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createIfSelector";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doComputeValueAndEvaluator";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSelectorType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

