/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpaceKt;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.debugger.memory.InternalMutableIntervalMap;
import com.jetbrains.cidr.execution.debugger.memory.Interval;
import com.jetbrains.cidr.execution.debugger.memory.IntervalTreeMap;
import com.jetbrains.cidr.execution.debugger.memory.IntervalUtilKt;
import com.jetbrains.cidr.execution.debugger.memory.MutableAddressSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001MB\u0011\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0013\b\u0016\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0016J\u0010\u0010\u001a\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0019H\u0016J\u0017\u0010\u001b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0011\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0096\u0002J\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0011\u001a\u00020\tH\u0096\u0002J\u0011\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\fH\u0096\u0002J \u0010#\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000$2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010#\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000$2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u001b\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010&\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010'J7\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010&\u001a\u00028\u00002\u001a\u0010(\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00018\u00000)H\u0016\u00a2\u0006\u0002\u0010*J9\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00028\u00002\u0006\u0010.\u001a\u00020\t2\u001a\u0010(\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00018\u00000)H\u0002\u00a2\u0006\u0002\u0010/J\u001f\u00100\u001a\u0002H1\"\b\b\u0001\u00101*\u00028\u00002\u0006\u0010&\u001a\u0002H1H\u0016\u00a2\u0006\u0002\u00102J)\u00103\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u000005H\u0016\u00a2\u0006\u0002\u00106J3\u00100\u001a\u0002H1\"\b\b\u0001\u00101*\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H105H\u0016\u00a2\u0006\u0002\u00106J\u0010\u00107\u001a\u0002082\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J4\u00109\u001a\b\u0012\u0004\u0012\u0002H10\u0019\"\b\b\u0001\u00101*\u00028\u00002\u0006\u0010\u0011\u001a\u00020\t2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H105H\u0016J6\u0010:\u001a\u0002H1\"\b\b\u0001\u00101*\u00028\u00002\u0006\u0010;\u001a\u0002082\u0014\b\u0004\u00104\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H105H\u0082\b\u00a2\u0006\u0002\u0010<J\u0017\u0010=\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0015\u0010=\u001a\u00028\u00002\u0006\u0010&\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00102J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u001f\u0010>\u001a\u0002H?\"\b\b\u0001\u0010?*\u00020\f2\u0006\u0010\"\u001a\u0002H?H\u0002\u00a2\u0006\u0002\u0010@J\u0010\u0010A\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0010\u0010B\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0016\u0010A\u001a\u00020\t*\u00020\t2\b\b\u0002\u0010C\u001a\u00020!H\u0002J\u001c\u0010A\u001a\u00020\t*\u00020\t2\u0006\u0010D\u001a\u00020!2\u0006\u0010E\u001a\u00020!H\u0002J\f\u0010F\u001a\u00020\t*\u00020\tH\u0002J\b\u0010G\u001a\u00020HH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0004\u0018\u00018\u0000*\u00020\f8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010I\u001a\u00020J8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\u00a8\u0006N"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpaceImpl;", "G", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "Lcom/jetbrains/cidr/execution/debugger/memory/MutableAddressSpace;", "myIntervalMap", "Lcom/jetbrains/cidr/execution/debugger/memory/InternalMutableIntervalMap;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/memory/InternalMutableIntervalMap;)V", "arena", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;)V", "asRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/Interval;", "getAsRegion$annotations", "(Lcom/jetbrains/cidr/execution/debugger/memory/Interval;)V", "getAsRegion", "(Lcom/jetbrains/cidr/execution/debugger/memory/Interval;)Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "range", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "intervals", "", "getIntervals", "()Ljava/util/Collection;", "filterRegions", "", "contiguousRegions", "getRegion", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;)Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "get", "contains", "", "interval", "getNeighbors", "Lkotlin/Pair;", "reallocate", "region", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;)Lcom/jetbrains/cidr/execution/debugger/memory/MutableAddressSpace;", "shrinkEdgeRegion", "Lkotlin/Function2;", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;Lkotlin/jvm/functions/Function2;)Lcom/jetbrains/cidr/execution/debugger/memory/MutableAddressSpace;", "reallocateEdge", "", "edgeRegion", "subRange", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Lkotlin/jvm/functions/Function2;)V", "allocate", "R", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;)Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "getOrAllocate", "createRegion", "Lkotlin/Function1;", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;Lkotlin/jvm/functions/Function1;)Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "allocationHoleFor", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpaceImpl$Hole;", "allocateMissing", "allocateRegion", "hole", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpaceImpl$Hole;Lkotlin/jvm/functions/Function1;)Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "unallocate", "replaceIntervalWithHole", "I", "(Lcom/jetbrains/cidr/execution/debugger/memory/Interval;)Lcom/jetbrains/cidr/execution/debugger/memory/Interval;", "span", "regionSpan", "beyondBoundaries", "beyondLeftBoundary", "beyondRightBoundary", "spanAdjacentHoles", "toString", "", "modificationCount", "", "getModificationCount", "()J", "Hole", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nAddressSpace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddressSpace.kt\ncom/jetbrains/cidr/execution/debugger/memory/AddressSpaceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,409:1\n230#1,15:428\n230#1,15:443\n230#1,15:459\n1617#2,9:410\n1869#2:419\n1870#2:421\n1626#2:422\n1563#2:423\n1634#2,3:424\n1869#2:458\n1870#2:474\n1#3:420\n1#3:427\n*S KotlinDebug\n*F\n+ 1 AddressSpace.kt\ncom/jetbrains/cidr/execution/debugger/memory/AddressSpaceImpl\n*L\n179#1:428,15\n193#1:443,15\n220#1:459,15\n122#1:410,9\n122#1:419\n122#1:421\n122#1:422\n123#1:423\n123#1:424,3\n218#1:458\n218#1:474\n122#1:420\n*E\n"})
public class AddressSpaceImpl<G extends AddressSpace.Region>
implements MutableAddressSpace<G> {
    @NotNull
    private final InternalMutableIntervalMap myIntervalMap;

    private AddressSpaceImpl(InternalMutableIntervalMap myIntervalMap) {
        this.myIntervalMap = myIntervalMap;
    }

    public AddressSpaceImpl(@NotNull AddressRange arena) {
        Intrinsics.checkNotNullParameter((Object)arena, (String)"arena");
        this(new IntervalTreeMap(arena, null, 2, null));
        this.myIntervalMap.put(new Hole(arena));
    }

    public /* synthetic */ AddressSpaceImpl(AddressRange addressRange, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            addressRange = AddressRange.WHOLE;
        }
        this(addressRange);
    }

    private final G getAsRegion(Interval $this$asRegion) {
        AddressSpace.Region region = $this$asRegion instanceof AddressSpace.Region ? (AddressSpace.Region)$this$asRegion : null;
        return (G)(region instanceof AddressSpace.Region ? region : null);
    }

    private static /* synthetic */ void getAsRegion$annotations(Interval interval) {
    }

    @Override
    @NotNull
    public AddressRange getRange() {
        return this.myIntervalMap.getRange();
    }

    @Override
    @NotNull
    public Collection<Interval> getIntervals() {
        return this.myIntervalMap.getIntervals();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<G> filterRegions() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getIntervals();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            G it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Interval it = (Interval)element$iv$iv;
            boolean bl2 = false;
            if (this.getAsRegion(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<G> contiguousRegions() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getIntervals();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Interval interval = (Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            G g = this.getAsRegion((Interval)it);
            if (g == null) {
                return null;
            }
            collection.add(g);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public G getRegion(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return this.getAsRegion(this.myIntervalMap.get(address));
    }

    @Override
    @NotNull
    public Interval get(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return this.myIntervalMap.get(address);
    }

    @Override
    @NotNull
    public MutableAddressSpace<G> get(@NotNull AddressRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new AddressSpaceImpl<G>(this.myIntervalMap.get(range));
    }

    @Override
    public boolean contains(@NotNull Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.myIntervalMap.contains(interval);
    }

    @Override
    @NotNull
    public Pair<G, G> getNeighbors(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Interval interval = this.myIntervalMap.get(address);
        return this.getNeighbors(interval.getRange());
    }

    @Override
    @NotNull
    public Pair<G, G> getNeighbors(@NotNull AddressRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        AddressRange addressRange = this.span(this.spanAdjacentHoles(range), true);
        Address prev = addressRange.component1();
        Address next = addressRange.component2();
        return new Pair(range.contains((Comparable)prev) ? null : this.getRegion(prev), range.contains((Comparable)next) ? null : this.getRegion(next));
    }

    @Override
    @NotNull
    public MutableAddressSpace<G> reallocate(@NotNull G region) {
        Intrinsics.checkNotNullParameter(region, (String)"region");
        MutableAddressSpace<G> unallocatedSpace = this.unallocate(((Interval)region).getRange());
        this.allocate(region);
        return unallocatedSpace;
    }

    @Override
    @NotNull
    public MutableAddressSpace<G> reallocate(@NotNull G region, @NotNull Function2<? super G, ? super AddressRange, ? extends G> shrinkEdgeRegion) {
        Intrinsics.checkNotNullParameter(region, (String)"region");
        Intrinsics.checkNotNullParameter(shrinkEdgeRegion, (String)"shrinkEdgeRegion");
        AddressRange regionRange = ((Interval)region).getRange();
        MutableAddressSpace<G> unallocatedSpace = this.unallocate(regionRange);
        this.allocate(region);
        List unallocatedRegions = unallocatedSpace.filterRegions();
        if (!((Collection)unallocatedRegions).isEmpty()) {
            AddressSpace.Region headRegion = (AddressSpace.Region)CollectionsKt.first(unallocatedRegions);
            AddressSpace.Region tailRegion = (AddressSpace.Region)CollectionsKt.last(unallocatedRegions);
            this.reallocateEdge(headRegion, ((Interval)headRegion).getRange().headUntil(regionRange.getStart()), shrinkEdgeRegion);
            this.reallocateEdge(tailRegion, ((Interval)tailRegion).getRange().tailAfter(regionRange.getEndInclusive()), shrinkEdgeRegion);
        }
        return unallocatedSpace;
    }

    private final void reallocateEdge(G edgeRegion, AddressRange subRange, Function2<? super G, ? super AddressRange, ? extends G> shrinkEdgeRegion) {
        if (subRange.isEmpty()) {
            return;
        }
        AddressSpace.Region region = (AddressSpace.Region)shrinkEdgeRegion.invoke(edgeRegion, (Object)subRange);
        if (region == null) {
            return;
        }
        AddressSpace.Region subRegion = region;
        IntervalUtilKt.checkInRange((Interval)subRegion, subRange);
        this.allocate(subRegion);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <R extends G> R allocate(@NotNull R region) {
        boolean bl;
        void this_$iv;
        AddressRange holeRange$iv;
        Intrinsics.checkNotNullParameter(region, (String)"region");
        AddressRange range = ((Interval)region).getRange();
        Collection<Interval> intervals = this.myIntervalMap.get(range).getIntervals();
        Object object = CollectionsKt.singleOrNull((Iterable)intervals);
        Hole hole = object instanceof Hole ? (Hole)object : null;
        if (hole == null) {
            boolean $i$a$-requireNotNull-AddressSpaceImpl$allocate$22 = false;
            String $i$a$-requireNotNull-AddressSpaceImpl$allocate$22 = "Range " + range + " is occupied with " + intervals;
            throw new IllegalArgumentException($i$a$-requireNotNull-AddressSpaceImpl$allocate$22.toString());
        }
        AddressSpaceImpl $i$a$-requireNotNull-AddressSpaceImpl$allocate$22 = this;
        Hole hole$iv = hole;
        boolean $i$f$allocateRegion = false;
        AddressRange it = holeRange$iv = hole$iv.getRange();
        boolean bl2 = false;
        AddressSpace.Region region$iv = (AddressSpace.Region)IntervalUtilKt.checkInRange((Interval)region, holeRange$iv);
        this_$iv.myIntervalMap.remove(hole$iv);
        AddressRange regionRange$iv = ((Interval)region$iv).getRange();
        AddressRange precedingRange$iv = holeRange$iv.headUntil(regionRange$iv.getStart());
        AddressRange followingRange$iv = holeRange$iv.tailAfter(regionRange$iv.getEndInclusive());
        if (!precedingRange$iv.isEmpty()) {
            this_$iv.myIntervalMap.put(new Hole(precedingRange$iv));
        }
        this_$iv.myIntervalMap.put(region$iv);
        if (!followingRange$iv.isEmpty()) {
            this_$iv.myIntervalMap.put(new Hole(followingRange$iv));
        }
        Object it2 = object = region$iv;
        boolean bl3 = false;
        boolean bl4 = bl = it2 == region;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return (R)object;
    }

    @Override
    @NotNull
    public G getOrAllocate(@NotNull Address address, @NotNull Function1<? super AddressRange, ? extends G> createRegion) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(createRegion, (String)"createRegion");
        G g = this.getRegion(address);
        if (g == null) {
            g = this.allocate(address, createRegion);
        }
        return g;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <R extends G> R allocate(@NotNull Address address, @NotNull Function1<? super AddressRange, ? extends R> createRegion) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(createRegion, (String)"createRegion");
        AddressSpaceKt.access$requireAddressInArena(this.myIntervalMap, address);
        Hole hole = this.allocationHoleFor(address);
        AddressSpaceImpl addressSpaceImpl = this;
        Hole hole$iv = hole;
        boolean $i$f$allocateRegion = false;
        AddressRange holeRange$iv = hole$iv.getRange();
        AddressSpace.Region region$iv = (AddressSpace.Region)IntervalUtilKt.checkInRange((Interval)createRegion.invoke((Object)holeRange$iv), holeRange$iv);
        this_$iv.myIntervalMap.remove(hole$iv);
        AddressRange regionRange$iv = ((Interval)region$iv).getRange();
        AddressRange precedingRange$iv = holeRange$iv.headUntil(regionRange$iv.getStart());
        AddressRange followingRange$iv = holeRange$iv.tailAfter(regionRange$iv.getEndInclusive());
        if (!precedingRange$iv.isEmpty()) {
            this_$iv.myIntervalMap.put(new Hole(precedingRange$iv));
        }
        this_$iv.myIntervalMap.put(region$iv);
        if (!followingRange$iv.isEmpty()) {
            this_$iv.myIntervalMap.put(new Hole(followingRange$iv));
        }
        return (R)region$iv;
    }

    private final Hole allocationHoleFor(Address address) {
        Interval interval = this.myIntervalMap.get(address);
        if (!(interval instanceof Hole)) {
            boolean bl = false;
            String string = "Interval at " + address + " is occupied by " + interval;
            throw new IllegalArgumentException(string.toString());
        }
        return (Hole)interval;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <R extends G> List<R> allocateMissing(@NotNull AddressRange range, @NotNull Function1<? super AddressRange, ? extends R> createRegion) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(createRegion, (String)"createRegion");
        List allocatedRegions = new ArrayList();
        Iterable $this$forEach$iv = this.myIntervalMap.get(range).getIntervals();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void this_$iv;
            AddressRange holeRange$iv;
            Interval interval = (Interval)element$iv;
            boolean bl = false;
            if (!(interval instanceof Hole)) continue;
            Collection collection = allocatedRegions;
            Interval interval2 = this;
            Hole hole$iv = (Hole)interval;
            boolean $i$f$allocateRegion = false;
            AddressRange holeRange = holeRange$iv = hole$iv.getRange();
            boolean bl2 = false;
            AddressSpace.Region region$iv = (AddressSpace.Region)IntervalUtilKt.checkInRange((Interval)((AddressSpace.Region)createRegion.invoke((Object)holeRange.intersectWith(range))), holeRange$iv);
            this_$iv.myIntervalMap.remove(hole$iv);
            AddressRange regionRange$iv = ((Interval)region$iv).getRange();
            AddressRange precedingRange$iv = holeRange$iv.headUntil(regionRange$iv.getStart());
            AddressRange followingRange$iv = holeRange$iv.tailAfter(regionRange$iv.getEndInclusive());
            if (!precedingRange$iv.isEmpty()) {
                this_$iv.myIntervalMap.put(new Hole(precedingRange$iv));
            }
            this_$iv.myIntervalMap.put(region$iv);
            if (!followingRange$iv.isEmpty()) {
                this_$iv.myIntervalMap.put(new Hole(followingRange$iv));
            }
            interval2 = region$iv;
            collection.add(interval2);
        }
        return allocatedRegions;
    }

    private final <R extends G> R allocateRegion(Hole hole, Function1<? super AddressRange, ? extends R> createRegion) {
        boolean $i$f$allocateRegion = false;
        AddressRange holeRange = hole.getRange();
        AddressSpace.Region region = (AddressSpace.Region)IntervalUtilKt.checkInRange((Interval)createRegion.invoke((Object)holeRange), holeRange);
        this.myIntervalMap.remove(hole);
        AddressRange regionRange = ((Interval)region).getRange();
        AddressRange precedingRange = holeRange.headUntil(regionRange.getStart());
        AddressRange followingRange = holeRange.tailAfter(regionRange.getEndInclusive());
        if (!precedingRange.isEmpty()) {
            this.myIntervalMap.put(new Hole(precedingRange));
        }
        this.myIntervalMap.put(region);
        if (!followingRange.isEmpty()) {
            this.myIntervalMap.put(new Hole(followingRange));
        }
        return (R)region;
    }

    @Override
    @Nullable
    public G unallocate(@NotNull Address address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        G g = this.getAsRegion(this.myIntervalMap.get(address));
        if (g == null) {
            return null;
        }
        G unallocatedRegion = g;
        return (G)((AddressSpace.Region)this.replaceIntervalWithHole((Interval)unallocatedRegion));
    }

    @Override
    @NotNull
    public G unallocate(@NotNull G region) {
        Intrinsics.checkNotNullParameter(region, (String)"region");
        if (!this.contains((Interval)region)) {
            boolean bl = false;
            String string = "Attempting to unallocate region " + region + " which is not allocated";
            throw new IllegalArgumentException(string.toString());
        }
        return (G)((AddressSpace.Region)this.replaceIntervalWithHole((Interval)region));
    }

    @Override
    @NotNull
    public MutableAddressSpace<G> unallocate(@NotNull AddressRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        AddressSpace unallocatedSpace = this.get(range);
        return (MutableAddressSpace)this.replaceIntervalWithHole((Interval)unallocatedSpace);
    }

    private final <I extends Interval> I replaceIntervalWithHole(I interval) {
        AddressRange holeRange = this.spanAdjacentHoles(interval.getRange());
        this.myIntervalMap.removeAll(holeRange);
        this.myIntervalMap.put(new Hole(holeRange));
        return interval;
    }

    @Override
    @NotNull
    public AddressRange span(@NotNull AddressRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return this.myIntervalMap.span(range);
    }

    @Override
    @NotNull
    public AddressRange regionSpan(@NotNull AddressRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        AddressRange span = this.span(range);
        Interval firstInterval = this.get(span.getStart());
        Interval lastInterval = this.get(span.getEndInclusive());
        if (firstInterval == lastInterval) {
            return firstInterval instanceof Hole ? AddressRange.EMPTY : firstInterval.getRange();
        }
        Address start = firstInterval instanceof Hole ? ((Hole)firstInterval).getRange().getEndInclusive().plus((Number)1) : firstInterval.getRange().getStart();
        Address endInclusive = lastInterval instanceof Hole ? ((Hole)lastInterval).getRange().getStart().minus((Number)1) : lastInterval.getRange().getEndInclusive();
        return AddressUtil.addressRangeInclusive((Address)start, (Address)endInclusive);
    }

    private final AddressRange span(AddressRange $this$span, boolean beyondBoundaries) {
        return this.span($this$span, beyondBoundaries, beyondBoundaries);
    }

    static /* synthetic */ AddressRange span$default(AddressSpaceImpl addressSpaceImpl, AddressRange addressRange, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: span");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return addressSpaceImpl.span(addressRange, bl);
    }

    private final AddressRange span(AddressRange $this$span, boolean beyondLeftBoundary, boolean beyondRightBoundary) {
        AddressRange $this$span_u24lambda_u249 = this.span($this$span);
        boolean bl = false;
        return !beyondLeftBoundary && !beyondRightBoundary ? $this$span_u24lambda_u249 : this.span(AddressUtil.addressRangeInclusive((Address)AddressSpaceImpl.span$lambda$9$minus($this$span_u24lambda_u249.getStart(), beyondLeftBoundary), (Address)AddressSpaceImpl.span$lambda$9$plus($this$span_u24lambda_u249.getEndInclusive(), beyondRightBoundary)));
    }

    private final AddressRange spanAdjacentHoles(AddressRange $this$spanAdjacentHoles) {
        AddressRange $this$spanAdjacentHoles_u24lambda_u2410 = AddressSpaceImpl.span$default(this, $this$spanAdjacentHoles, false, 1, null);
        boolean bl = false;
        AddressRange adjacentRange = this.span($this$spanAdjacentHoles_u24lambda_u2410, true);
        return this.span($this$spanAdjacentHoles_u24lambda_u2410, this.myIntervalMap.get(adjacentRange.getStart()) instanceof Hole, this.myIntervalMap.get(adjacentRange.getEndInclusive()) instanceof Hole);
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.getRange());
    }

    @Override
    public long getModificationCount() {
        return this.myIntervalMap.getModificationCount();
    }

    private static final Address span$lambda$9$plus(Address $this$span_u24lambda_u249_u24plus, boolean b) {
        Intrinsics.checkNotNullParameter((Object)$this$span_u24lambda_u249_u24plus, (String)"<this>");
        return b ? $this$span_u24lambda_u249_u24plus.plus(Address.Companion.getCoercing((Number)1)) : $this$span_u24lambda_u249_u24plus;
    }

    private static final Address span$lambda$9$minus(Address $this$span_u24lambda_u249_u24minus, boolean b) {
        Intrinsics.checkNotNullParameter((Object)$this$span_u24lambda_u249_u24minus, (String)"<this>");
        return b ? $this$span_u24lambda_u249_u24minus.minus(Address.Companion.getCoercing((Number)1)) : $this$span_u24lambda_u249_u24minus;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpaceImpl$Hole;", "Lcom/jetbrains/cidr/execution/debugger/memory/Interval;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;)V", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.cidr.debugger.core"})
    private static final class Hole
    implements Interval {
        @NotNull
        private final AddressRange range;

        public Hole(@NotNull AddressRange range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.range = range;
        }

        @Override
        @NotNull
        public AddressRange getRange() {
            return this.range;
        }

        @NotNull
        public final AddressRange component1() {
            return this.range;
        }

        @NotNull
        public final Hole copy(@NotNull AddressRange range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return new Hole(range);
        }

        public static /* synthetic */ Hole copy$default(Hole hole, AddressRange addressRange, int n, Object object) {
            if ((n & 1) != 0) {
                addressRange = hole.range;
            }
            return hole.copy(addressRange);
        }

        @NotNull
        public String toString() {
            return "Hole(range=" + this.range + ")";
        }

        public int hashCode() {
            return this.range.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Hole)) {
                return false;
            }
            Hole hole = (Hole)other;
            return Intrinsics.areEqual((Object)this.range, (Object)hole.range);
        }
    }
}

