/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.Disposable;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpaceKt;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.Interval;
import com.jetbrains.cidr.execution.debugger.memory.IntervalUtilKt;
import com.jetbrains.cidr.execution.debugger.memory.MutableAddressSpace;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \"*\u0004\b\u0000\u0010\u00012\u00020\u0002:\t\u001a\u001b\u001c\u001d\u001e\u001f !\"B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014*\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\u0016J,\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190\u0018*\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0082@\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData;", "T", "", "dataProvider", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataProvider;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataProvider;)V", "addressSpace", "Lcom/jetbrains/cidr/execution/debugger/memory/MutableAddressSpace;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "invalidateRange", "", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getOrFetchRangeForAddress", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "loadAndSave", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Loading;", "(Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Loading;Lcom/jetbrains/cidr/execution/debugger/memory/Address;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadAndCleanup", "", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataBlock;", "ReallocatableInterval", "DataPlaceholder", "Data", "DataBlock", "DataEntry", "DataRegion", "DataLoadException", "DataProvider", "Companion", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCidrMemoryData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrMemoryData.kt\ncom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n1869#2,2:217\n1563#2:220\n1634#2,3:221\n1869#2,2:224\n1#3:219\n*S KotlinDebug\n*F\n+ 1 CidrMemoryData.kt\ncom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData\n*L\n24#1:217,2\n51#1:220\n51#1:221,3\n80#1:224,2\n*E\n"})
public final class CidrMemoryData<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataProvider<T> dataProvider;
    @NotNull
    private final MutableAddressSpace<DataRegion<T>> addressSpace;

    public CidrMemoryData(@NotNull DataProvider<T> dataProvider) {
        Intrinsics.checkNotNullParameter(dataProvider, (String)"dataProvider");
        this.dataProvider = dataProvider;
        this.addressSpace = AddressSpaceKt.mutableAddressSpace$default(null, 1, null);
    }

    public final void invalidateRange(@NotNull AddressRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        AddressUtil.requireNotEmpty((ClosedRange)((ClosedRange)range));
        Iterable $this$forEach$iv = this.addressSpace.unallocate(range).getIntervals();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Interval it = (Interval)element$iv;
            boolean bl = false;
            if (!(it instanceof DataRegion.Loading)) continue;
            ((DataRegion.Loading)it).cancel();
        }
    }

    @NotNull
    public final DataRegion<T> getOrFetchRangeForAddress(@NotNull CoroutineScope coroutineScope, @NotNull Address address) throws ExecutionException, DataLoadException {
        DataRegion<T> dataRegion;
        block0: {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            DataRegion<T> it = dataRegion = this.addressSpace.getOrAllocate(address, arg_0 -> CidrMemoryData.getOrFetchRangeForAddress$lambda$1(this, address, coroutineScope, arg_0));
            boolean bl = false;
            DataRegion.Loading loading = it instanceof DataRegion.Loading ? (DataRegion.Loading)it : null;
            if (loading == null) break block0;
            loading.start();
        }
        return dataRegion;
    }

    /*
     * Unable to fully structure code
     */
    private final Object loadAndSave(DataRegion.Loading<T> $this$loadAndSave, Address address, Continuation<? super DataRegion.Completed<T>> $completion) {
        if (!($completion instanceof loadAndSave.1)) ** GOTO lbl-1000
        var18_4 = $completion;
        if ((var18_4.label & -2147483648) != 0) {
            var18_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ CidrMemoryData<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return CidrMemoryData.access$loadAndSave(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var20_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this$loadAndSave;
                $continuation.L$1 = address;
                $continuation.label = 1;
                v0 = this.loadAndCleanup($this$loadAndSave, address, (Continuation<? super List<? extends DataBlock<? extends T>>>)$continuation);
                ** if (v0 != var20_6) goto lbl20
lbl19:
                // 1 sources

                return var20_6;
lbl20:
                // 1 sources

                ** GOTO lbl28
            }
            case 1: {
                address = (Address)$continuation.L$1;
                $this$loadAndSave = (DataRegion.Loading)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    dataBlocks = (List)v0;
                    for (Object block : dataBlocks) {
                        if (!(block.getRange().isEmpty() == false)) {
                            $i$a$-check-CidrMemoryData$loadAndSave$2 = false;
                            $i$a$-check-CidrMemoryData$loadAndSave$2 = (DataBlock)block + " range is empty";
                            throw new IllegalStateException($i$a$-check-CidrMemoryData$loadAndSave$2.toString());
                        }
                        region = new DataRegion.Completed.Loaded<T>((Data)block);
                        this.addressSpace.reallocate((DataRegion<T>)((AddressSpace.Region)region), (Function2<DataRegion<T>, AddressRange, DataRegion<T>>)((Function2)loadAndSave.3.INSTANCE));
                    }
                    v1 = (DataRegion)this.addressSpace.getRegion(address);
                    if (v1 == null) {
                        block = dataBlocks;
                        var15_19 = address;
                        $i$f$map = false;
                        $i$a$-check-CidrMemoryData$loadAndSave$2 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var13_24 = (DataBlock)item$iv$iv;
                            var16_26 = destination$iv$iv;
                            $i$a$-map-CidrMemoryData$loadAndSave$4 = false;
                            var16_26.add(it.getRange());
                        }
                        var19_27 = "Debugger reported unrelated range(s) for " + var15_19 + ": " + (List)destination$iv$iv;
                        throw new DataLoadException(var19_27);
                    }
                    var4_7 = v1;
                }
                catch (DataLoadException e) {
                    var4_7 = this.addressSpace.getOrAllocate(address, (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, loadAndSave$lambda$5(com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData$DataRegion$Loading com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData$DataLoadException com.jetbrains.cidr.execution.debugger.memory.AddressRange ), (Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;)Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;)((DataRegion.Loading)$this$loadAndSave, (DataLoadException)e));
                }
                it = var4_7;
                $i$a$-also-CidrMemoryData$loadAndSave$6 = false;
                if (!(it != $this$loadAndSave)) {
                    $i$a$-check-CidrMemoryData$loadAndSave$6$1 = false;
                    var7_15 = "About to deadlock";
                    throw new IllegalStateException(var7_15.toString());
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$loadAndSave);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)address);
                $continuation.label = 2;
                v2 = var4_7.awaitCompleted($continuation);
                if (v2 == var20_6) {
                    return var20_6;
                }
                ** GOTO lbl77
            }
            case 2: {
                address = (Address)$continuation.L$1;
                $this$loadAndSave = (DataRegion.Loading)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl77:
                // 2 sources

                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object loadAndCleanup(DataRegion.Loading<T> $this$loadAndCleanup, Address address, Continuation<? super List<? extends DataBlock<? extends T>>> $completion) {
        if (!($completion instanceof loadAndCleanup.1)) ** GOTO lbl-1000
        var13_4 = $completion;
        if ((var13_4.label & -2147483648) != 0) {
            var13_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ CidrMemoryData<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return CidrMemoryData.access$loadAndCleanup(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this$loadAndCleanup;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)address);
                $continuation.label = 1;
                v0 = this.dataProvider.loadData(address, $this$loadAndCleanup.getData().getRequestRange(), (Continuation<List<DataBlock<T>>>)$continuation);
                ** if (v0 != var14_6) goto lbl20
lbl19:
                // 1 sources

                return var14_6;
lbl20:
                // 1 sources

                ** GOTO lbl28
            }
            case 1: {
                address = (Address)$continuation.L$1;
                $this$loadAndCleanup = (DataRegion.Loading)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    var4_7 = (List)v0;
                }
                catch (Throwable var5_9) {
                    throw var5_9;
                }
                finally {
                    $this$forEach$iv = this.addressSpace.get($this$loadAndCleanup.getRange()).filterRegions();
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        region = (DataRegion)element$iv;
                        $i$a$-forEach-CidrMemoryData$loadAndCleanup$2 = false;
                        if (!(region instanceof DataRegion.Loading) || !$this$loadAndCleanup.contains((DataRegion.Loading)region)) continue;
                        this.addressSpace.unallocate((DataRegion<T>)((AddressSpace.Region)region));
                    }
                }
                return var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final DataRegion getOrFetchRangeForAddress$lambda$1(CidrMemoryData this$0, Address $address, CoroutineScope $coroutineScope, AddressRange holeRange) {
        Intrinsics.checkNotNullParameter((Object)holeRange, (String)"holeRange");
        DataPlaceholder dataPlaceholder = (DataPlaceholder)IntervalUtilKt.checkInRange((Interval)this$0.dataProvider.createDataPlaceholder($address, holeRange), holeRange);
        return new DataRegion.Loading(dataPlaceholder, $coroutineScope, (Function2)new Function2<DataRegion.Loading<T>, Continuation<? super DataRegion.Completed<T>>, Object>(this$0, $address, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CidrMemoryData<T> this$0;
            final /* synthetic */ Address $address;
            {
                this.this$0 = $receiver;
                this.$address = $address;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                DataRegion.Loading loading = (DataRegion.Loading)this.L$0;
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$Loading;
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$Loading);
                        this.label = 1;
                        Object object2 = CidrMemoryData.access$loadAndSave(this.this$0, (DataRegion.Loading)$this$Loading, this.$address, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(DataRegion.Loading<T> p1, Continuation<? super DataRegion.Completed<T>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private static final DataRegion loadAndSave$lambda$5(DataRegion.Loading $this_loadAndSave, DataLoadException $e, AddressRange holeRange) {
        Intrinsics.checkNotNullParameter((Object)holeRange, (String)"holeRange");
        DataPlaceholder dataPlaceholder = (DataPlaceholder)Companion.subRange($this_loadAndSave.getData(), holeRange.intersectWith($this_loadAndSave.getData().getRange()));
        return new DataRegion.Completed.LoadError(dataPlaceholder, $e);
    }

    public static final /* synthetic */ Object access$loadAndSave(CidrMemoryData $this, DataRegion.Loading $receiver, Address address, Continuation $completion) {
        return $this.loadAndSave($receiver, address, $completion);
    }

    public static final /* synthetic */ Object access$loadAndCleanup(CidrMemoryData $this, DataRegion.Loading $receiver, Address address, Continuation $completion) {
        return $this.loadAndCleanup($receiver, address, $completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u0002H\u0005\"\b\b\u0001\u0010\u0005*\u00020\u0006*\u0002H\u00052\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Companion;", "", "<init>", "()V", "subRange", "D", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$ReallocatableInterval;", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "(Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$ReallocatableInterval;Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;)Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$ReallocatableInterval;", "intellij.cidr.debugger.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <D extends ReallocatableInterval> D subRange(@NotNull D $this$subRange, @NotNull AddressRange subRange) {
            Intrinsics.checkNotNullParameter($this$subRange, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)subRange, (String)"subRange");
            if (Intrinsics.areEqual((Object)subRange, (Object)((Interval)$this$subRange).getRange())) {
                return $this$subRange;
            }
            AddressUtil.requireInRange((AddressRange)subRange, (AddressRange)((Interval)$this$subRange).getRange());
            Interval interval = IntervalUtilKt.checkInRange((Interval)$this$subRange.subRangeImpl(subRange), subRange);
            Intrinsics.checkNotNull((Object)interval, (String)"null cannot be cast to non-null type D of com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData.Companion.subRange");
            return (D)((ReallocatableInterval)interval);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\u00020\u0002J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\r\u001a\u00020\u0004H&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$ReallocatableInterval;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "entries", "", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "getEntries", "()Ljava/lang/Iterable;", "subRangeImpl", "subRange", "intellij.cidr.debugger.core"})
    public static interface Data<T>
    extends ReallocatableInterval {
        @Override
        @NotNull
        public AddressRange getRange();

        @NotNull
        public Iterable<DataEntry<T>> getEntries();

        @Override
        @NotNull
        public Data<T> subRangeImpl(@NotNull AddressRange var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataBlock;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;", "subRangeImpl", "subRange", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "intellij.cidr.debugger.core"})
    public static interface DataBlock<T>
    extends Data<T> {
        @Override
        @NotNull
        public DataBlock<T> subRangeImpl(@NotNull AddressRange var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0005\bf\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0013\u001a\u00020\u0004H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00028\u0001X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getAddress", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "value", "getValue", "()Ljava/lang/Object;", "entries", "", "getEntries", "()Ljava/lang/Iterable;", "subRangeImpl", "subRange", "intellij.cidr.debugger.core"})
    public static interface DataEntry<T>
    extends Data<T> {
        @Override
        @NotNull
        public AddressRange getRange();

        @NotNull
        default public Address getAddress() {
            return this.getRange().getStart();
        }

        public T getValue();

        @Override
        @NotNull
        default public Iterable<DataEntry<T>> getEntries() {
            return CollectionsKt.listOf((Object)this);
        }

        @Override
        @NotNull
        default public DataEntry<T> subRangeImpl(@NotNull AddressRange subRange) {
            Intrinsics.checkNotNullParameter((Object)subRange, (String)"subRange");
            return this;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0016\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataLoadException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "cause", "", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "(Ljava/lang/String;)V", "intellij.cidr.debugger.core"})
    public static class DataLoadException
    extends Exception {
        public DataLoadException(@NotNull String message, @NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super(message, cause);
        }

        public DataLoadException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000*\u0006\b\u0001\u0010\u0001 \u00012\u00020\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u000e\u001a\u00020\u0004H&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$ReallocatableInterval;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "requestRange", "getRequestRange", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "getAddress", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "subRangeImpl", "subRange", "intellij.cidr.debugger.core"})
    public static interface DataPlaceholder<T>
    extends ReallocatableInterval {
        @Override
        @NotNull
        public AddressRange getRange();

        @NotNull
        public AddressRange getRequestRange();

        @NotNull
        default public Address getAddress() {
            return this.getRange().getStart();
        }

        @Override
        @NotNull
        public DataPlaceholder<T> subRangeImpl(@NotNull AddressRange var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\b\u0010\u0003\u001a\u00020\u0004H&J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J*\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\r0\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u00a6@\u00a2\u0006\u0002\u0010\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H'J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0017\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataProvider;", "T", "Lcom/intellij/openapi/Disposable;", "canProvideData", "", "createDataPlaceholder", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "holeRange", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "loadData", "", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataBlock;", "range", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readOnlyReason", "", "storeData", "", "bytes", "", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.cidr.debugger.core"})
    public static interface DataProvider<T>
    extends Disposable {
        public boolean canProvideData();

        @NotNull
        public DataPlaceholder<T> createDataPlaceholder(@NotNull Address var1, @NotNull AddressRange var2);

        @Nullable
        public Object loadData(@NotNull Address var1, @NotNull AddressRange var2, @NotNull Continuation<? super List<? extends DataBlock<? extends T>>> var3) throws DataLoadException, CancellationException;

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @Nullable
        public String readOnlyReason();

        @Nullable
        default public Object storeData(@NotNull Address address, @NotNull byte[] bytes, @NotNull Continuation<? super Unit> $completion) throws DataLoadException, CancellationException {
            return DataProvider.storeData$suspendImpl(this, address, bytes, $completion);
        }

        public static /* synthetic */ <T> Object storeData$suspendImpl(DataProvider<T> $this, Address address, byte[] bytes, Continuation<? super Unit> $completion) throws DataLoadException, CancellationException {
            throw new UnsupportedOperationException("Storing memory is not supported");
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002:\u0002\u0013\u0014B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\r\u001a\u00020\u0006H&J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u000fH\u00a6@\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0001\u0002\u000f\u0015\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace$Region;", "<init>", "()V", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "data", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$ReallocatableInterval;", "getData", "()Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$ReallocatableInterval;", "subRange", "awaitCompleted", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "", "Loading", "Completed", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Loading;", "intellij.cidr.debugger.core"})
    public static abstract class DataRegion<T>
    implements AddressSpace.Region {
        private DataRegion() {
        }

        @Override
        @NotNull
        public AddressRange getRange() {
            return this.getData().getRange();
        }

        @NotNull
        public abstract ReallocatableInterval getData();

        @NotNull
        public abstract DataRegion<T> subRange(@NotNull AddressRange var1);

        @Nullable
        public abstract Object awaitCompleted(@NotNull Continuation<? super Completed<T>> var1);

        @NotNull
        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.getRange() + ")";
        }

        public /* synthetic */ DataRegion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\u0007\bB\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0000H\u0096@\u00a2\u0006\u0002\u0010\u0006\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "<init>", "()V", "awaitCompleted", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Loaded", "LoadError", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed$LoadError;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed$Loaded;", "intellij.cidr.debugger.core"})
        public static abstract class Completed<T>
        extends DataRegion<T> {
            private Completed() {
                super(null);
            }

            @Override
            @Nullable
            public Object awaitCompleted(@NotNull Continuation<? super Completed<T>> $completion) {
                return this;
            }

            public /* synthetic */ Completed(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0003\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00030\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00030\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed$LoadError;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed;", "data", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;", "exception", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataLoadException;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataLoadException;)V", "getData", "()Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;", "getException", "()Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataLoadException;", "subRange", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "intellij.cidr.debugger.core"})
            public static final class LoadError<T>
            extends Completed<T> {
                @NotNull
                private final DataPlaceholder<T> data;
                @NotNull
                private final DataLoadException exception;

                public LoadError(@NotNull DataPlaceholder<? extends T> data, @NotNull DataLoadException exception) {
                    Intrinsics.checkNotNullParameter(data, (String)"data");
                    Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                    super(null);
                    this.data = data;
                    this.exception = exception;
                }

                @Override
                @NotNull
                public DataPlaceholder<T> getData() {
                    return this.data;
                }

                @NotNull
                public final DataLoadException getException() {
                    return this.exception;
                }

                @Override
                @NotNull
                public LoadError<T> subRange(@NotNull AddressRange subRange) {
                    Intrinsics.checkNotNullParameter((Object)subRange, (String)"subRange");
                    return new LoadError<T>((DataPlaceholder)Companion.subRange(this.getData(), subRange), this.exception);
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0003\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00030\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00030\u00002\u0006\u0010\t\u001a\u00020\nH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00030\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed$Loaded;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed;", "data", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;)V", "getData", "()Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;", "subRange", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "intellij.cidr.debugger.core"})
            public static final class Loaded<T>
            extends Completed<T> {
                @NotNull
                private final Data<T> data;

                public Loaded(@NotNull Data<? extends T> data) {
                    Intrinsics.checkNotNullParameter(data, (String)"data");
                    super(null);
                    this.data = data;
                }

                @Override
                @NotNull
                public Data<T> getData() {
                    return this.data;
                }

                @Override
                @NotNull
                public Loaded<T> subRange(@NotNull AddressRange subRange) {
                    Intrinsics.checkNotNullParameter((Object)subRange, (String)"subRange");
                    return new Loaded<T>((Data)Companion.subRange(this.getData(), subRange));
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tBT\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u00123\u0010\f\u001a/\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\u0000\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\u00070\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\r\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\b\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00020\u0000H\u0086\u0002J\u0006\u0010\u0017\u001a\u00020\u0015J\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Loading;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "data", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;", "deferred", "Lkotlinx/coroutines/Deferred;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;Lkotlinx/coroutines/Deferred;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "load", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function2;)V", "getData", "()Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;", "contains", "", "other", "start", "cancel", "", "awaitCompleted", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "subRange", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "intellij.cidr.debugger.core"})
        public static final class Loading<T>
        extends DataRegion<T> {
            @NotNull
            private final DataPlaceholder<T> data;
            @NotNull
            private final Deferred<Completed<T>> deferred;

            @Override
            @NotNull
            public DataPlaceholder<T> getData() {
                return this.data;
            }

            public Loading(@NotNull DataPlaceholder<? extends T> data, @NotNull Deferred<? extends Completed<T>> deferred) {
                Intrinsics.checkNotNullParameter(data, (String)"data");
                Intrinsics.checkNotNullParameter(deferred, (String)"deferred");
                super(null);
                this.data = data;
                this.deferred = deferred;
            }

            public Loading(@NotNull DataPlaceholder<? extends T> data, @NotNull CoroutineScope coroutineScope, @NotNull Function2<? super Loading<T>, ? super Continuation<? super Completed<T>>, ? extends Object> load) {
                Intrinsics.checkNotNullParameter(data, (String)"data");
                Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
                Intrinsics.checkNotNullParameter(load, (String)"load");
                super(null);
                this.data = data;
                this.deferred = BuildersKt.async$default((CoroutineScope)coroutineScope, null, (CoroutineStart)CoroutineStart.LAZY, (Function2)new Function2<CoroutineScope, Continuation<? super Completed<T>>, Object>(load, this, null){
                    int label;
                    final /* synthetic */ Function2<Loading<T>, Continuation<? super Completed<T>>, Object> $load;
                    final /* synthetic */ Loading<T> this$0;
                    {
                        this.$load = $load;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.$load.invoke(this.this$0, (Object)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Completed<T>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (int)1, null);
            }

            public final boolean contains(@NotNull Loading<T> other) {
                Intrinsics.checkNotNullParameter(other, (String)"other");
                return this.deferred == other.deferred && this.getRange().contains(other.getRange());
            }

            public final boolean start() {
                return this.deferred.start();
            }

            public final void cancel() {
                Job.DefaultImpls.cancel$default((Job)((Job)this.deferred), null, (int)1, null);
            }

            @Override
            @Nullable
            public Object awaitCompleted(@NotNull Continuation<? super Completed<T>> $completion) {
                return this.deferred.await($completion);
            }

            @Override
            @NotNull
            public Loading<T> subRange(@NotNull AddressRange subRange) {
                Intrinsics.checkNotNullParameter((Object)subRange, (String)"subRange");
                return new Loading<T>((DataPlaceholder)Companion.subRange(this.getData(), subRange), this.deferred);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$ReallocatableInterval;", "Lcom/jetbrains/cidr/execution/debugger/memory/Interval;", "subRangeImpl", "subRange", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "intellij.cidr.debugger.core"})
    public static interface ReallocatableInterval
    extends Interval {
        @NotNull
        public ReallocatableInterval subRangeImpl(@NotNull AddressRange var1);
    }
}

