/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.clangFormat;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.rider.plugins.clion.radler.clangFormat.icons.RiderPluginsClionRadlerClangFormatIcons;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatFileUtils;
import com.jetbrains.cidr.radler.clangFormat.RadClangFormatBundle;
import com.jetbrains.cidr.radler.clangFormat.RadReadFromCFSettingsModifier;
import com.jetbrains.cidr.radler.clangFormat.RadReadFromCFSettingsModifierKt;
import com.jetbrains.clangFormat.components.ClangFormatModificationTracker;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0019\u0010\n\u001a\u00130\u000b\u00a2\u0006\u000e\b\f\u0012\n\b\r\u0012\u0006\b\n0\u000e8\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0007H\u0017\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/radler/clangFormat/RadReadFromCFSettingsModifier;", "Lcom/intellij/psi/codeStyle/modifier/CodeStyleSettingsModifier;", "<init>", "()V", "modifySettings", "", "settings", "Lcom/intellij/psi/codeStyle/modifier/TransientCodeStyleSettings;", "file", "Lcom/intellij/psi/PsiFile;", "getName", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "mayOverrideSettingsOf", "project", "Lcom/intellij/openapi/project/Project;", "getDisablingFunction", "Ljava/util/function/Consumer;", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "getStatusBarUiContributor", "Lcom/intellij/psi/codeStyle/modifier/CodeStyleStatusBarUIContributor;", "transientSettings", "intellij.rider.plugins.clion.radler.clangFormat"})
@ApiStatus.Experimental
public final class RadReadFromCFSettingsModifier
implements CodeStyleSettingsModifier {
    public boolean modifySettings(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (RadReadFromCFSettingsModifierKt.access$isImportFromCFActive(project) && RadReadFromCFSettingsModifierKt.access$isApplicableForFile(file)) {
            settings.addDependency((ModificationTracker)ClangFormatModificationTracker.getInstance());
            return true;
        }
        return false;
    }

    @NotNull
    public String getName() {
        String string = RadClangFormatBundle.message("settings.codeStyle.CF.import.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean mayOverrideSettingsOf(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RadReadFromCFSettingsModifierKt.access$isImportFromCFActive(project);
    }

    @NotNull
    public Consumer<CodeStyleSettings> getDisablingFunction(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RadReadFromCFSettingsModifier::getDisablingFunction$lambda$0;
    }

    @Contract(value="_ -> new")
    @Nullable
    public CodeStyleStatusBarUIContributor getStatusBarUiContributor(@NotNull TransientCodeStyleSettings transientSettings) {
        Intrinsics.checkNotNullParameter((Object)transientSettings, (String)"transientSettings");
        PsiFile codeFile = transientSettings.getPsiFile();
        if (codeFile == null) {
            return null;
        }
        ClangFormatFileUtils.saveAllClangFormatDocumentsNowOrLater((Project)codeFile.getProject());
        CommonCodeStyleSettings.IndentOptions indentOptions = transientSettings.getLanguageIndentOptions(codeFile.getLanguage());
        return (CodeStyleStatusBarUIContributor)new IndentStatusBarUIContributor(this, indentOptions){
            final /* synthetic */ RadReadFromCFSettingsModifier this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public boolean areActionsAvailable(VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return false;
            }

            public AnAction[] getActions(PsiFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return null;
            }

            public String getHint() {
                return this.this$0.getName();
            }

            public Icon getIcon() {
                Icon icon = RiderPluginsClionRadlerClangFormatIcons.ImportClangFormat;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ImportClangFormat");
                return icon;
            }

            public AnAction createDisableAction(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)RadClangFormatBundle.message("settings.codeStyle.CF.import.disable", new Object[0]), arg_0 -> getStatusBarUiContributor.1.createDisableAction$lambda$1(arg_0 -> getStatusBarUiContributor.1.createDisableAction$lambda$0(project, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
                return (AnAction)dumbAwareAction;
            }

            private static final Unit createDisableAction$lambda$0(Project $project, AnActionEvent it) {
                if (!RadReadFromCFSettingsModifierKt.access$isImportFromCFActive($project)) {
                    return Unit.INSTANCE;
                }
                CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)$project);
                Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getSettings(...)");
                RadReadFromCFSettingsModifierKt.access$setImportFromCF(codeStyleSettings, false);
                CodeStyleSettingsManager.getInstance((Project)$project).notifyCodeStyleSettingsChanged();
                return Unit.INSTANCE;
            }

            private static final void createDisableAction$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        };
    }

    private static final void getDisablingFunction$lambda$0(CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        RadReadFromCFSettingsModifierKt.access$setImportFromCF(settings, false);
    }
}

