/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.UnmodifiableHashMap;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.cpp.toolchains.BuildTool;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPDebugger;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironmentUsageLogger;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSetWithHome;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.CudaGDB;
import com.jetbrains.cidr.cpp.toolchains.Cygwin;
import com.jetbrains.cidr.cpp.toolchains.GDB;
import com.jetbrains.cidr.cpp.toolchains.HostFactory;
import com.jetbrains.cidr.cpp.toolchains.Make;
import com.jetbrains.cidr.cpp.toolchains.Ninja;
import com.jetbrains.cidr.cpp.toolchains.WSL;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostData;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.MappedHost;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.system.SystemUtil;
import com.jetbrains.cidr.toolchains.CidrExecutableTool;
import com.jetbrains.cidr.toolchains.CidrTool;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import com.jetbrains.cidr.toolchains.PathEnvVariableCombiningMap;
import com.jetbrains.cidr.toolchains.SettingsHandler;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CPPEnvironment
extends CidrToolEnvironment
implements Cloneable {
    @NotNull
    private static final Logger LOG = Logger.getInstance(CPPEnvironment.class);
    @NotNull
    protected volatile CPPToolchains.Toolchain myToolchain;
    @NotNull
    protected volatile CPPToolSet myToolSet;
    @NotNull
    protected final List<CPPToolSet.Option> myToolSetOptions;
    @Nullable
    private static Consumer<? super GeneralCommandLine> myAdditionalPreparationInTest;
    @NotNull
    private final Map<CMakeExecutableTool.ToolKind, ToolWithProblem<CMakeExecutableTool>> myCMakeTools;
    @Nullable
    private final ToolWithProblem<BuildTool> myBuildTool;
    @NotNull
    private volatile ToolWithProblem<GDB> myGDB;
    @NotNull
    private final HostMachine myHostMachine;
    public static final DataKey<CPPEnvironment> KEY;
    @NotNull
    private Map<String, String> environment;

    public CPPEnvironment(@NotNull CPPToolchains.Toolchain toolchain) {
        if (toolchain == null) {
            CPPEnvironment.$$$reportNull$$$0(0);
        }
        this(toolchain, null, null);
    }

    public CPPEnvironment(@NotNull CPPToolchains.Toolchain toolchain, @Nullable Project project, @Nullable File projectDir) {
        if (toolchain == null) {
            CPPEnvironment.$$$reportNull$$$0(1);
        }
        this.environment = new ConcurrentHashMap<String, String>();
        this.myToolchain = toolchain;
        this.myToolSet = toolchain.getToolSet();
        this.myToolSetOptions = Collections.unmodifiableList(toolchain.getToolSetOptions());
        this.myHostMachine = this.createHost(toolchain, project, projectDir);
        this.myCMakeTools = this.createCMakeTools();
        this.myBuildTool = this.createBuildTool(this);
        this.myGDB = this.initGDB();
        CPPEnvironmentUsageLogger.CREATED.log((Object)this.myToolSet.getKind());
    }

    public CPPEnvironment clone() {
        try {
            CPPEnvironment clone = (CPPEnvironment)super.clone();
            clone.myToolchain = this.myToolchain.copy();
            clone.myToolSet = clone.myToolchain.getToolSet();
            clone.environment = new ConcurrentHashMap<String, String>(this.environment);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("must implement Cloneable", e);
        }
    }

    @NotNull
    private Map<CMakeExecutableTool.ToolKind, ToolWithProblem<CMakeExecutableTool>> createCMakeTools() {
        HashMap<CMakeExecutableTool.ToolKind, ToolWithProblem> tools = new HashMap<CMakeExecutableTool.ToolKind, ToolWithProblem>();
        for (CMakeExecutableTool.ToolKind tool : CMakeExecutableTool.ToolKind.values()) {
            tools.put(tool, new ToolWithProblem(this, (CidrExecutableTool)CPPEnvironment.createCMakeExecutableTool(this, tool), ToolchainsBundle.message("cmake", new Object[0])));
        }
        UnmodifiableHashMap unmodifiableHashMap = UnmodifiableHashMap.fromMap(tools);
        if (unmodifiableHashMap == null) {
            CPPEnvironment.$$$reportNull$$$0(2);
        }
        return unmodifiableHashMap;
    }

    @NotNull
    private ToolWithProblem<GDB> initGDB() {
        return new ToolWithProblem(this, (CidrExecutableTool)CPPEnvironment.createGDB(this), ToolchainsBundle.message("cpp.toolchains.debugger", new Object[0]));
    }

    private HostMachine createHost(@NotNull CPPToolchains.Toolchain toolchain, @Nullable Project project, @Nullable File projectDir) {
        boolean isRemote;
        CPPToolSet cPPToolSet;
        if (toolchain == null) {
            CPPEnvironment.$$$reportNull$$$0(3);
        }
        if ((cPPToolSet = this.myToolSet) instanceof WSL) {
            WSL wslToolSet = (WSL)cPPToolSet;
            return HostFactory.createWslHost(wslToolSet);
        }
        SettingsHandler handler = toolchain.getDockerSettingsHandler();
        if (this.myToolSet.isDocker() && handler != null) {
            return HostFactory.createOrGetDockerHost(handler, toolchain.getName(), project, projectDir);
        }
        HostData hostData = toolchain.getHostData();
        boolean bl = isRemote = hostData != null;
        if (isRemote) {
            return HostFactory.createOrGetRemoteHost(hostData, toolchain.getName(), project, projectDir);
        }
        return HostFactory.createLocalHost();
    }

    @NotNull
    public Installer createInstaller(@NotNull GeneralCommandLine cl) {
        if (cl == null) {
            CPPEnvironment.$$$reportNull$$$0(4);
        }
        Installer installer = this.myToolSet.createInstaller(cl, this.myHostMachine);
        if (installer == null) {
            CPPEnvironment.$$$reportNull$$$0(5);
        }
        return installer;
    }

    @NotNull
    public CPPToolchains.Toolchain getToolchain() {
        CPPToolchains.Toolchain toolchain = this.myToolchain;
        if (toolchain == null) {
            CPPEnvironment.$$$reportNull$$$0(6);
        }
        return toolchain;
    }

    @NotNull
    public CPPToolSet getToolSet() {
        CPPToolSet cPPToolSet = this.myToolSet;
        if (cPPToolSet == null) {
            CPPEnvironment.$$$reportNull$$$0(7);
        }
        return cPPToolSet;
    }

    public boolean isMSVC() {
        return this.myToolSet.isMSVC();
    }

    public boolean isCygwin() {
        return this.myToolSet.isCygwin();
    }

    public boolean isMinGW() {
        return this.myToolSet.isMinGW();
    }

    public boolean isSystemWindowsToolset() {
        return this.myToolSet.isSystemWindows();
    }

    @NotNull
    public static Charset getCharset() {
        CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getDefaultToolchain();
        Charset charset = toolchain != null && toolchain.getCygwin() == null ? Charset.defaultCharset() : StandardCharsets.UTF_8;
        if (charset == null) {
            CPPEnvironment.$$$reportNull$$$0(8);
        }
        return charset;
    }

    public boolean useWindowsConsole() {
        return this.isMinGW() || this.isMSVC() || this.isSystemWindowsToolset();
    }

    @Nullable
    public CMakeExecutableTool getCMake() {
        return this.getCMakeTool(CMakeExecutableTool.ToolKind.CMAKE);
    }

    @Nullable
    public CMakeExecutableTool getCMakeTool(CMakeExecutableTool.ToolKind toolKind) {
        return (CMakeExecutableTool)this.myCMakeTools.get((Object)((Object)toolKind)).myTool;
    }

    @Nullable
    public CMakeExecutableTool getCMakeChecked(@Nullable Project project, @NotNull EnvironmentProblems problems) {
        if (problems == null) {
            CPPEnvironment.$$$reportNull$$$0(9);
        }
        return this.myCMakeTools.get((Object)CMakeExecutableTool.ToolKind.CMAKE).check(project, problems);
    }

    @Nullable
    public static CMakeExecutableTool createCMakeExecutableTool(@NotNull CPPEnvironment owner, CMakeExecutableTool.ToolKind toolKind) {
        Path path;
        String customCMakePath;
        if (owner == null) {
            CPPEnvironment.$$$reportNull$$$0(10);
        }
        if ((customCMakePath = owner.myToolchain.getCustomCMakePath()) == null) {
            return owner.myToolchain.supportsBundledCMake() ? new CMakeExecutableTool(CMakeExecutableTool.getBundledCMakeToolBinary(owner.isCygwin(), toolKind), owner) : null;
        }
        try {
            path = Paths.get(customCMakePath, new String[0]);
            if (toolKind != CMakeExecutableTool.ToolKind.CMAKE) {
                if ((path = path.getParent()) == null) {
                    return null;
                }
                path = Paths.get(path.toString(), toolKind.getExecutableName(owner.getToolSet()));
            }
        }
        catch (Throwable ignore) {
            return null;
        }
        return new CMakeExecutableTool(path.toFile(), owner);
    }

    @Nullable
    public Make getMake() {
        if (this.myBuildTool != null && this.myBuildTool.myTool instanceof Make) {
            return (Make)this.myBuildTool.myTool;
        }
        return null;
    }

    @Nullable
    public Ninja getNinja() {
        if (this.myBuildTool != null && this.myBuildTool.myTool instanceof Ninja) {
            return (Ninja)this.myBuildTool.myTool;
        }
        return null;
    }

    @Nullable
    private ToolWithProblem<BuildTool> createBuildTool(@NotNull CPPEnvironment owner) {
        String customBuildToolPath;
        if (owner == null) {
            CPPEnvironment.$$$reportNull$$$0(11);
        }
        if ((customBuildToolPath = owner.myToolchain.getCustomBuildToolPath()) == null) {
            return null;
        }
        if (Ninja.isNinjaExecutableName(customBuildToolPath)) {
            return new ToolWithProblem(this, (CidrExecutableTool)new Ninja(new File(customBuildToolPath), owner), ToolchainsBundle.message("ninja", new Object[0]));
        }
        return new ToolWithProblem(this, (CidrExecutableTool)new Make(new File(customBuildToolPath), owner), ToolchainsBundle.message("make", new Object[0]));
    }

    @Nullable
    public GDB getGDB() {
        return (GDB)this.myGDB.myTool;
    }

    public void checkGDBProblems(@Nullable Project project, @NotNull EnvironmentProblems problems) {
        if (problems == null) {
            CPPEnvironment.$$$reportNull$$$0(12);
        }
        this.myGDB.check(project, problems);
    }

    @Nullable
    public GDB refreshAndGetGDB() {
        if (!this.checkGDBEqualsToGDBInToolchain()) {
            this.myGDB = this.initGDB();
        }
        return (GDB)this.myGDB.myTool;
    }

    private boolean checkGDBEqualsToGDBInToolchain() {
        GDB gdb = this.getGDB();
        GDB newGdb = CPPEnvironment.createGDB(this);
        return gdb == null && newGdb == null || gdb != null && newGdb != null && gdb.getExecutablePath().equals(newGdb.getExecutablePath());
    }

    @Nullable
    private static GDB createGDB(@NotNull CPPEnvironment owner) {
        if (owner == null) {
            CPPEnvironment.$$$reportNull$$$0(13);
        }
        CPPDebugger debugger = owner.myToolchain.getDebugger();
        return switch (debugger.getKind()) {
            case CPPDebugger.Kind.CUSTOM_GDB -> {
                File gdbExecutable = debugger.getGdbExecutable();
                if (gdbExecutable != null) {
                    if (PathUtil.getFileName((String)gdbExecutable.getPath()).equals("cuda-gdb")) {
                        yield new CudaGDB(owner, gdbExecutable);
                    }
                    yield new GDB(owner, gdbExecutable);
                }
                yield null;
            }
            case CPPDebugger.Kind.BUNDLED_GDB -> {
                if (owner.myToolchain.supportsBundledGDB()) {
                    yield GDB.getBundledGDB(owner);
                }
                yield null;
            }
            default -> null;
        };
    }

    @NotNull
    public String calcToolchainHash() {
        Path bundledNinja;
        StringBuilder result = new StringBuilder();
        String location = this.myToolSet.getKind().isRemoteLike() ? " (remote)" : " (local)";
        result.append("ToolSet: ").append(this.myToolSet.readVersion()).append(location);
        if (this.myToolSet instanceof CPPToolSetWithHome) {
            result.append("@").append(((CPPToolSetWithHome)this.myToolSet).getHome()).append("\n");
        }
        if ((bundledNinja = Ninja.getBundledNinja(this)) != null && this.myToolchain.getCustomBuildToolPath() == null) {
            Ninja ninjaTool = new Ninja(bundledNinja.toFile(), this);
            result.append("Ninja: ").append(ninjaTool.readVersion()).append("@").append(bundledNinja).append("\n");
        }
        result.append("Options: ");
        StringUtil.join(this.myToolSetOptions, CPPToolSet.Option::getUniqueID, (String)", ", (StringBuilder)result);
        result.append("\n");
        String string = result.toString();
        if (string == null) {
            CPPEnvironment.$$$reportNull$$$0(14);
        }
        return string;
    }

    public String toLocalPath(@Nullable File localBaseDir, @Nullable String absoluteOrRelativeEnvPath) {
        if (absoluteOrRelativeEnvPath == null) {
            return null;
        }
        if (this.myToolSet instanceof Cygwin) {
            return Cygwin.toLocalPath(localBaseDir, absoluteOrRelativeEnvPath, (Cygwin)this.myToolSet);
        }
        if (this.myToolSet instanceof WSL) {
            return ((WSL)this.myToolSet).toLocalPath(localBaseDir, absoluteOrRelativeEnvPath);
        }
        if (this.myHostMachine.isRemote() && this.myHostMachine instanceof MappedHost) {
            return SystemUtil.toLocalPath((MappedHost)this.myHostMachine, localBaseDir, absoluteOrRelativeEnvPath);
        }
        return super.toLocalPath(localBaseDir, absoluteOrRelativeEnvPath);
    }

    public String toEnvPath(@Nullable String localPath) {
        if (localPath == null) {
            return null;
        }
        if (this.myToolSet instanceof Cygwin) {
            return Cygwin.toCygwinPath(localPath, (Cygwin)this.myToolSet);
        }
        if (this.myToolSet instanceof WSL) {
            return ((WSL)this.myToolSet).toEnvPath(localPath);
        }
        if (this.myHostMachine.isRemote() && this.myHostMachine instanceof MappedHost) {
            return SystemUtil.toEnvPath((MappedHost)this.myHostMachine, localPath);
        }
        return super.toEnvPath(localPath);
    }

    public boolean isEnvAbsolute(@NotNull String absoluteOrRelativeEnvPath) {
        if (absoluteOrRelativeEnvPath == null) {
            CPPEnvironment.$$$reportNull$$$0(15);
        }
        if (this.myToolSet instanceof Cygwin) {
            return Cygwin.isAbsolutePath(absoluteOrRelativeEnvPath);
        }
        if (this.myToolSet instanceof WSL) {
            return ((WSL)this.myToolSet).isAbsolutePath(absoluteOrRelativeEnvPath);
        }
        if (this.myHostMachine.isRemote()) {
            return SystemUtil.isAbsolute(this.myHostMachine, absoluteOrRelativeEnvPath);
        }
        return super.isEnvAbsolute(absoluteOrRelativeEnvPath);
    }

    @Contract(value="null -> null")
    @Nullable
    public String toLocalPathAndCopyIfDoesNotExist(@Nullable String absoluteEnvPath) {
        if (absoluteEnvPath == null) {
            return null;
        }
        String localPath = this.toLocalPath(absoluteEnvPath);
        if (new File(localPath).exists()) {
            return localPath;
        }
        return this.myHostMachine.resolveAndCache(Collections.singletonList(absoluteEnvPath)).stream().findFirst().orElse(absoluteEnvPath);
    }

    @NotNull
    public CidrFileSeparators getSupportedFileSeparators() {
        CidrFileSeparators cidrFileSeparators = this.myToolSet.getSupportedFileSeparators();
        if (cidrFileSeparators == null) {
            CPPEnvironment.$$$reportNull$$$0(16);
        }
        return cidrFileSeparators;
    }

    @NotNull
    public ExecutablePathResult resolveEnvPathToLocalExecutable(@Nullable Path workingDir, @Nullable String absoluteOrRelativeEnvPath) throws ExecutionException {
        return CPPEnvironment.doResolveShortWinPath(this.doResolveEnvPathToLocalExecutable(workingDir, absoluteOrRelativeEnvPath, true));
    }

    @NotNull
    public ExecutablePathResult resolveEnvPathToLocalExecutable(@Nullable File workingDir, @Nullable String absoluteOrRelativeEnvPath) throws ExecutionException {
        ExecutablePathResult executablePathResult = this.resolveEnvPathToLocalExecutable(workingDir, absoluteOrRelativeEnvPath, true);
        if (executablePathResult == null) {
            CPPEnvironment.$$$reportNull$$$0(17);
        }
        return executablePathResult;
    }

    @NotNull
    public ExecutablePathResult resolveEnvPathToLocalExecutable(@Nullable File workingDir, @Nullable String absoluteOrRelativeEnvPath, boolean checkIfExecutable) throws ExecutionException {
        Path path = workingDir != null ? workingDir.toPath() : null;
        return CPPEnvironment.doResolveShortWinPath(this.doResolveEnvPathToLocalExecutable(path, absoluteOrRelativeEnvPath, checkIfExecutable));
    }

    @NotNull
    private static ExecutablePathResult doResolveShortWinPath(@NotNull ExecutablePathResult localPathResult) {
        if (localPathResult == null) {
            CPPEnvironment.$$$reportNull$$$0(18);
        }
        if (localPathResult.path != null) {
            try {
                String resolved = FileUtil.resolveShortWindowsName((String)localPathResult.path);
                return new ExecutablePathResult(resolved, localPathResult.isResolvedToExecutable);
            }
            catch (IOException ex) {
                ExecutablePathResult executablePathResult = localPathResult;
                if (executablePathResult == null) {
                    CPPEnvironment.$$$reportNull$$$0(19);
                }
                return executablePathResult;
            }
        }
        ExecutablePathResult executablePathResult = localPathResult;
        if (executablePathResult == null) {
            CPPEnvironment.$$$reportNull$$$0(20);
        }
        return executablePathResult;
    }

    @NotNull
    private ExecutablePathResult doResolveEnvPathToLocalExecutable(@Nullable Path workingDir, @Nullable String absoluteOrRelativeEnvPath, boolean checkIfExecutable) throws ExecutionException {
        boolean isSeparatorFirst;
        if (absoluteOrRelativeEnvPath == null) {
            return new ExecutablePathResult(null, false);
        }
        if (this.myHostMachine.isRemote()) {
            String result;
            String resolvedPath = this.isEnvAbsolute(absoluteOrRelativeEnvPath) ? absoluteOrRelativeEnvPath : ((result = RemoteUtil.resolveToExecutable(this.getHostMachine(), absoluteOrRelativeEnvPath)) != null ? result : absoluteOrRelativeEnvPath);
            return new ExecutablePathResult(resolvedPath, SystemUtil.isExecutable(this.myHostMachine, resolvedPath));
        }
        Predicate<File> isExecutable = file -> file != null && (checkIfExecutable ? file.isFile() && file.canExecute() : file.exists());
        boolean isPosix = this.myHostMachine.getOS() != OS.Windows || this.isCygwin();
        int separatorIndex = StringUtil.indexOfAny((String)absoluteOrRelativeEnvPath, (String)(isPosix ? "/" : "/\\"));
        boolean isNameOnly = separatorIndex == -1;
        boolean bl = isSeparatorFirst = separatorIndex == 0;
        if (isPosix && absoluteOrRelativeEnvPath.startsWith("~/")) {
            File result = new File(FileUtil.expandUserHome((String)absoluteOrRelativeEnvPath));
            return new ExecutablePathResult(result.getPath(), isExecutable.test(result));
        }
        List<String> lookupNames = this.isWindows && !isSeparatorFirst ? Arrays.asList(absoluteOrRelativeEnvPath, absoluteOrRelativeEnvPath + ".exe") : Collections.singletonList(absoluteOrRelativeEnvPath);
        for (String eachLookupName : lookupNames) {
            File result;
            if (this.isEnvAbsolute(eachLookupName)) {
                result = new File(this.toLocalPath(eachLookupName));
                if (!isExecutable.test(result)) continue;
                return new ExecutablePathResult(result.getPath(), true);
            }
            if (workingDir != null && (isPosix ? !isNameOnly : !isSeparatorFirst) && isExecutable.test(result = new File(this.toLocalPath(workingDir.toFile(), eachLookupName)))) {
                return new ExecutablePathResult(result.getPath(), true);
            }
            if (!isNameOnly) continue;
            GeneralCommandLine cl = new GeneralCommandLine();
            this.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
            String pathVariable = (String)cl.getEffectiveEnvironment().get("PATH");
            File result2 = PathEnvironmentVariableUtil.findInPath((String)eachLookupName, (String)pathVariable, null);
            if (result2 != null) {
                String resultPath = result2.getPath();
                String resultExtension = PathUtil.getFileExtension((String)resultPath);
                if (this.isCygwin() && (resultExtension == null || resultExtension.isEmpty())) {
                    resultPath = Cygwin.toLocalPathUnchecked(resultPath, (Cygwin)this.myToolSet);
                    result2 = new File(resultPath);
                }
                if (isExecutable.test(result2)) {
                    return new ExecutablePathResult(resultPath, true);
                }
            }
            if (result2 == null || !isExecutable.test(result2)) continue;
            return new ExecutablePathResult(result2.getPath(), true);
        }
        return new ExecutablePathResult(absoluteOrRelativeEnvPath, false);
    }

    public void prepare(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment.PrepareFor prepareFor) throws ExecutionException {
        if (cl == null) {
            CPPEnvironment.$$$reportNull$$$0(21);
        }
        if (prepareFor == null) {
            CPPEnvironment.$$$reportNull$$$0(22);
        }
        super.prepare(cl, prepareFor);
        this.myToolSet.prepareEnvironment(cl, prepareFor, this.myToolSetOptions);
        if (this.myToolchain.getEnvironment() != null) {
            try {
                this.environment.putAll(this.readEnvironment(this.myToolchain.getEnvironment(), cl.getEnvironment()));
            }
            catch (ExecutionException e) {
                LOG.warn("Failed to read environment from [" + this.myToolchain.getEnvironment() + "]", (Throwable)e);
                throw e;
            }
        }
        cl.getEnvironment().putAll(this.environment);
        if (prepareFor == CidrToolEnvironment.PrepareFor.BUILD && this.myToolSet.supportsPathVariableModification()) {
            PathEnvVariableCombiningMap actualEnvironment = this.myToolSet.createEnvironmentMap();
            actualEnvironment.putAll(cl.getEnvironment());
            this.addBuildToolToEnvironmentMap(actualEnvironment, cl.isPassParentEnvironment());
            this.addBundledNinjaToEnvironmentMap(actualEnvironment, cl.isPassParentEnvironment());
            cl.withEnvironment((Map)actualEnvironment);
        }
        if (myAdditionalPreparationInTest != null) {
            myAdditionalPreparationInTest.consume((Object)cl);
        }
    }

    private void addBundledNinjaToEnvironmentMap(PathEnvVariableCombiningMap map, boolean fixPath) {
        Path path = Ninja.getBundledNinja(this);
        if (path != null) {
            this.addToPath(map, PathUtil.getParentPath((String)path.toString()), fixPath);
        }
    }

    private void addBuildToolToEnvironmentMap(PathEnvVariableCombiningMap map, boolean fixPath) {
        String buildToolPath = this.myToolchain.getCustomBuildToolPath();
        if (buildToolPath != null) {
            this.addToPath(map, PathUtil.getParentPath((String)buildToolPath), fixPath);
        }
    }

    private void addToPath(PathEnvVariableCombiningMap map, @NotNull String path, boolean fixPath) {
        String localPathValue;
        if (path == null) {
            CPPEnvironment.$$$reportNull$$$0(23);
        }
        if (!map.containsKey("PATH") && !this.myToolSet.isSsh() && !this.myToolSet.isWSL() && fixPath && (localPathValue = PathEnvironmentVariableUtil.getPathVariableValue()) != null) {
            map.put("PATH", localPathValue);
        }
        map.put("PATH", path);
    }

    public void convertPathVariableToEnv(@NotNull GeneralCommandLine cl) {
        if (cl == null) {
            CPPEnvironment.$$$reportNull$$$0(24);
        }
        if (this.myToolSet instanceof Cygwin) {
            Cygwin.convertPathVariableToCygwin(cl, (Cygwin)this.myToolSet);
        }
    }

    @NotNull
    public HostMachine getHostMachine() {
        HostMachine hostMachine = this.myHostMachine;
        if (hostMachine == null) {
            CPPEnvironment.$$$reportNull$$$0(25);
        }
        return hostMachine;
    }

    @TestOnly
    public static void setAdditionalPreparationInTest(@Nullable Consumer<? super GeneralCommandLine> additionalPreparationInTest) {
        myAdditionalPreparationInTest = additionalPreparationInTest;
    }

    @NotNull
    public Map<String, String> readEnvironment(String environmentFile, @NotNull Map<String, String> parentEnvironment) throws ExecutionException {
        Map<String, String> map;
        if (parentEnvironment == null) {
            CPPEnvironment.$$$reportNull$$$0(26);
        }
        try {
            map = this.myToolSet.readEnvironment(this.toEnvPath(environmentFile), this.myHostMachine, parentEnvironment);
        }
        catch (ExecutionException | ProcessCanceledException ex) {
            throw ex;
        }
        catch (NoSuchFileException ex) {
            throw new ExecutionException(ToolchainsBundle.message("error.loading.environment.file.not.found", ex.getMessage()), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new ExecutionException(ToolchainsBundle.message("error.loading.environment.file", environmentFile, ex.getMessage()), (Throwable)ex);
        }
        if (map == null) {
            CPPEnvironment.$$$reportNull$$$0(27);
        }
        return map;
    }

    public void invalidateEnvironmentCache() {
        String environmentFile = this.myToolchain.getEnvironment();
        if (environmentFile != null) {
            this.myToolSet.invalidateEnvironment(this.toEnvPath(environmentFile), this.myHostMachine);
        }
    }

    public void applyEnvironmentFromFile(@NotNull String environmentFile, @NotNull GeneralCommandLine cmd) throws ExecutionException {
        if (environmentFile == null) {
            CPPEnvironment.$$$reportNull$$$0(28);
        }
        if (cmd == null) {
            CPPEnvironment.$$$reportNull$$$0(29);
        }
        cmd.withEnvironment(this.readEnvironment(environmentFile, cmd.getEnvironment()));
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        Map<String, String> map = this.environment;
        if (map == null) {
            CPPEnvironment.$$$reportNull$$$0(30);
        }
        return map;
    }

    static {
        KEY = DataKey.create((String)"cpp_environment");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 7, 8, 14, 16, 17, 19, 20, 25, 27, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchain";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 25: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPEnvironment";
                break;
            }
            case 4: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteOrRelativeEnvPath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPathResult";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepareFor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEnvironment";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentFile";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPEnvironment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCMakeTools";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstaller";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolchain";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolSet";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "calcToolchainHash";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFileSeparators";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveEnvPathToLocalExecutable";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolveShortWinPath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostMachine";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "readEnvironment";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 25: 
            case 27: 
            case 30: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createHost";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInstaller";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeChecked";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createCMakeExecutableTool";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createBuildTool";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkGDBProblems";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createGDB";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isEnvAbsolute";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doResolveShortWinPath";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addToPath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "convertPathVariableToEnv";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "readEnvironment";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "applyEnvironmentFromFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 7, 8, 14, 16, 17, 19, 20, 25, 27, 30 -> new IllegalStateException(string);
        };
    }

    private static class ToolWithProblem<T extends CidrExecutableTool> {
        @Nullable
        private final T myTool;
        @NlsSafe
        @NotNull
        private final String myToolName;
        private final @NotNull NullableLazyValue<@NlsContexts.DialogMessage String> myProblemValue;
        final /* synthetic */ CPPEnvironment this$0;

        ToolWithProblem(@NotNull T tool, String toolName) {
            if (toolName == null) {
                ToolWithProblem.$$$reportNull$$$0(0);
            }
            this.this$0 = var1_1;
            this.myProblemValue = NullableLazyValue.atomicLazyNullable(this::doCheck);
            this.myTool = tool;
            this.myToolName = toolName;
        }

        @Nullable
        private T check(@Nullable Project project, @NotNull EnvironmentProblems problems) {
            String problem;
            if (problems == null) {
                ToolWithProblem.$$$reportNull$$$0(1);
            }
            if ((problem = (String)this.myProblemValue.getValue()) != null) {
                problems.addProblem(problem, CPPToolchains.getGenericToolchainsFix(project, this.this$0.getToolchain()));
            }
            return this.myTool;
        }

        @NlsContexts.DialogMessage
        @Nullable
        private synchronized String doCheck() {
            if (this.myTool == null) {
                return ToolchainsBundle.message("dialog.message.executable.not.specified", this.myToolName);
            }
            try {
                if (ApplicationManager.getApplication().isDispatchThread()) {
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.myTool.readVersion(), ToolchainsBundle.message("cpp.toolchains.checking.tool.version", this.myToolName), true, null);
                } else {
                    ((CidrTool)this.myTool).readVersion();
                }
            }
            catch (ExecutionException e) {
                return ToolchainsBundle.message("dialog.message.executable.failed.to.launch", this.myToolName, ((CidrExecutableTool)this.myTool).getExecutablePath(), e.getMessage());
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problems";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPEnvironment$ToolWithProblem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "check";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ExecutablePathResult {
        @Nullable
        public final String path;
        public final boolean isResolvedToExecutable;

        public ExecutablePathResult(@Nullable String path, boolean isResolvedToExecutable) {
            this.path = path;
            this.isResolvedToExecutable = isResolvedToExecutable;
        }

        public String toString() {
            return "{path='" + this.path + "', resolved=" + this.isResolvedToExecutable + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutablePathResult result = (ExecutablePathResult)o;
            if (this.isResolvedToExecutable != result.isResolvedToExecutable) {
                return false;
            }
            return Objects.equals(this.path, result.path);
        }

        public int hashCode() {
            int result = this.path != null ? this.path.hashCode() : 0;
            result = 31 * result + (this.isResolvedToExecutable ? 1 : 0);
            return result;
        }
    }
}

