/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.cpp.toolchains.CPPDebugger;
import com.jetbrains.cidr.cpp.toolchains.CachingEnvironmentReaderService;
import com.jetbrains.cidr.cpp.toolchains.EnvironmentReader;
import com.jetbrains.cidr.cpp.toolchains.LinuxEnvironmentReader;
import com.jetbrains.cidr.cpp.toolchains.MacosEnvironmentReader;
import com.jetbrains.cidr.cpp.toolchains.WindowsEnvironmentReader;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerHelper;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.TrivialInstaller;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.cidr.toolchains.PathEnvVariableCombiningMap;
import com.jetbrains.cidr.toolchains.PathPolicy;
import com.jetbrains.cidr.toolchains.PathSeparator;
import icons.ClionToolchainsIcons;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class CPPToolSet {
    @NotNull
    protected final Kind myKind;

    public CPPToolSet(@NotNull Kind kind) {
        if (kind == null) {
            CPPToolSet.$$$reportNull$$$0(0);
        }
        this.myKind = kind;
    }

    @NotNull
    public Kind getKind() {
        Kind kind = this.myKind;
        if (kind == null) {
            CPPToolSet.$$$reportNull$$$0(1);
        }
        return kind;
    }

    @NotNull
    @Nls
    public String getName() {
        String string = this.myKind.getDisplayName();
        if (string == null) {
            CPPToolSet.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public abstract String readVersion();

    @Nullable
    public abstract ToolVersion readToolVersion();

    @NlsSafe
    public abstract String checkVersion(@NotNull String var1);

    public boolean isMSVC() {
        return this.myKind == Kind.MSVC;
    }

    public boolean isCygwin() {
        return this.myKind == Kind.CYGWIN;
    }

    public boolean isMinGW() {
        return this.myKind == Kind.MINGW;
    }

    public boolean isWSL() {
        return this.myKind == Kind.WSL;
    }

    public boolean isDocker() {
        return this.myKind == Kind.DOCKER;
    }

    public boolean isSsh() {
        return this.myKind == Kind.SSH;
    }

    @Deprecated(forRemoval=true)
    public boolean isRemote() {
        return this.isSsh();
    }

    public boolean isSystemWindows() {
        return this.myKind == Kind.SYSTEM_WINDOWS_TOOLSET;
    }

    @NotNull
    public abstract CidrFileSeparators getSupportedFileSeparators();

    @Nullable
    public abstract File getGDBPath();

    public abstract boolean supportsDebugger(@NotNull CPPDebugger.Kind var1);

    @Deprecated(forRemoval=true)
    @Nullable
    public final String isDebugSupportDisabled() {
        return null;
    }

    public void prepareEnvironment(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment.PrepareFor prepareFor, @NotNull List<Option> options) throws ExecutionException {
        if (cl == null) {
            CPPToolSet.$$$reportNull$$$0(3);
        }
        if (prepareFor == null) {
            CPPToolSet.$$$reportNull$$$0(4);
        }
        if (options == null) {
            CPPToolSet.$$$reportNull$$$0(5);
        }
    }

    public void prependPathVariable(@NotNull GeneralCommandLine cl, String ... paths) {
        if (cl == null) {
            CPPToolSet.$$$reportNull$$$0(6);
        }
        if (paths == null) {
            CPPToolSet.$$$reportNull$$$0(7);
        }
        CPPToolSet.prependPathVariable(cl, this.getPathSeparator(), paths);
    }

    @ApiStatus.Internal
    public static void prependPathVariable(@NotNull GeneralCommandLine cl, @NotNull PathSeparator separator, String ... paths) {
        if (cl == null) {
            CPPToolSet.$$$reportNull$$$0(8);
        }
        if (separator == null) {
            CPPToolSet.$$$reportNull$$$0(9);
        }
        if (paths == null) {
            CPPToolSet.$$$reportNull$$$0(10);
        }
        PathEnvVariableCombiningMap envMap = new PathEnvVariableCombiningMap(cl.getEffectiveEnvironment(), separator.getChar(), PathPolicy.PREPEND);
        for (int i = paths.length - 1; i >= 0; --i) {
            envMap.put("PATH", paths[i]);
        }
        String result = envMap.get("PATH");
        if (result != null) {
            cl.getEnvironment().put("PATH", result);
        }
    }

    public String toString() {
        return this.getName();
    }

    @NotNull
    protected static List<VersionInfo> createSortedVersionsList() {
        return new SortedList(Comparator.naturalOrder());
    }

    @NotNull
    public Map<String, String> readEnvironment(@NotNull String environmentFile, @NotNull HostMachine hostMachine, @NotNull Map<String, String> parentEnvironment) throws ExecutionException, IOException {
        if (environmentFile == null) {
            CPPToolSet.$$$reportNull$$$0(11);
        }
        if (hostMachine == null) {
            CPPToolSet.$$$reportNull$$$0(12);
        }
        if (parentEnvironment == null) {
            CPPToolSet.$$$reportNull$$$0(13);
        }
        EnvironmentReader reader = this.createEnvironmentReader(hostMachine);
        Map<String, String> map = ((CachingEnvironmentReaderService)ApplicationManager.getApplication().getService(CachingEnvironmentReaderService.class)).readEnvironment(environmentFile, reader, parentEnvironment);
        if (map == null) {
            CPPToolSet.$$$reportNull$$$0(14);
        }
        return map;
    }

    void invalidateEnvironment(String path, @NotNull HostMachine hostMachine) {
        if (hostMachine == null) {
            CPPToolSet.$$$reportNull$$$0(15);
        }
        EnvironmentReader reader = this.createEnvironmentReader(hostMachine);
        ((CachingEnvironmentReaderService)ApplicationManager.getApplication().getService(CachingEnvironmentReaderService.class)).invalidate(path, reader);
    }

    protected EnvironmentReader createEnvironmentReader(@NotNull HostMachine hostMachine) {
        if (hostMachine == null) {
            CPPToolSet.$$$reportNull$$$0(16);
        }
        if (SystemInfo.isWindows) {
            return new WindowsEnvironmentReader(hostMachine);
        }
        if (SystemInfo.isMac) {
            return new MacosEnvironmentReader(hostMachine);
        }
        return new LinuxEnvironmentReader(hostMachine);
    }

    public Installer createInstaller(@NotNull GeneralCommandLine cl, @NotNull HostMachine hostMachine) {
        if (cl == null) {
            CPPToolSet.$$$reportNull$$$0(17);
        }
        if (hostMachine == null) {
            CPPToolSet.$$$reportNull$$$0(18);
        }
        return new TrivialInstaller(cl);
    }

    @NotNull
    public abstract PathSeparator getPathSeparator();

    protected PathEnvVariableCombiningMap createEnvironmentMap() {
        return new PathEnvVariableCombiningMap(this.createEnvironmentMapStorage(), this.getPathSeparator().getChar(), PathPolicy.APPEND);
    }

    protected Map<String, String> createEnvironmentMapStorage() {
        return new HashMap<String, String>();
    }

    protected boolean supportsPathVariableModification() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepareFor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environmentFile";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostMachine";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "readEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 14: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareEnvironment";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prependPathVariable";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readEnvironment";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "invalidateEnvironment";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createEnvironmentReader";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createInstaller";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 14 -> new IllegalStateException(string);
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Kind {
        MINGW("https://jb.gg/clion-mingw", ClionToolchainsIcons.MinGW){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = ToolchainsBundle.message("mingw", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$1", "getDisplayName"));
            }
        }
        ,
        CYGWIN("https://jb.gg/clion-cygwin", ClionToolchainsIcons.Cygwin){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = ToolchainsBundle.message("cygwin", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$2", "getDisplayName"));
            }
        }
        ,
        MSVC("https://jb.gg/clion-msvs", ClionToolchainsIcons.MSVC){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = ToolchainsBundle.message("msvc", new Object[0]);
                if (string == null) {
                    3.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$3", "getDisplayName"));
            }
        }
        ,
        WSL("https://jb.gg/clion-wsl", AllIcons.RunConfigurations.Wsl){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = ToolchainsBundle.message("wsl", new Object[0]);
                if (string == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public boolean isSupportedOn(@NotNull OSType os) {
                if (os == null) {
                    4.$$$reportNull$$$0(1);
                }
                return os == OSType.WIN && SystemInfo.isWin10OrNewer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$4";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "os";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isSupportedOn";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        }
        ,
        SYSTEM_UNIX_TOOLSET(null, AllIcons.Nodes.Console){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = ToolchainsBundle.message("system", new Object[0]);
                if (string == null) {
                    5.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public boolean requiresHomePath() {
                return false;
            }

            @Override
            public boolean isSupportedOn(@NotNull OSType os) {
                if (os == null) {
                    5.$$$reportNull$$$0(1);
                }
                return os != OSType.WIN;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$5";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "os";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isSupportedOn";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        }
        ,
        SYSTEM_WINDOWS_TOOLSET(null, AllIcons.Nodes.Console){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = ToolchainsBundle.message("system", new Object[0]);
                if (string == null) {
                    6.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public boolean requiresHomePath() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$6", "getDisplayName"));
            }
        }
        ,
        SSH(null, ClionToolchainsIcons.RemoteToolSet){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = ToolchainsBundle.message("remote.host", new Object[0]);
                if (string == null) {
                    7.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public boolean requiresHomePath() {
                return false;
            }

            @Override
            public boolean isSupportedOn(@NotNull OSType os) {
                if (os == null) {
                    7.$$$reportNull$$$0(1);
                }
                return RemoteUtil.isFullRemoteModeAvailable();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$7";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "os";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$7";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isSupportedOn";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        }
        ,
        DOCKER(null, (Icon)Cancellation.forceNonCancellableSectionInClassInitializer(() -> DockerHelper.getDockerIcon())){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = ToolchainsBundle.message("docker", new Object[0]);
                if (string == null) {
                    8.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public boolean requiresHomePath() {
                return false;
            }

            @Override
            public boolean isSupportedOn(@NotNull OSType os) {
                if (os == null) {
                    8.$$$reportNull$$$0(1);
                }
                return DockerHelper.isDockerAvailable();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$8";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "os";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind$8";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isSupportedOn";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };

        @Nullable
        private final String myDownloadPage;
        @NotNull
        private final Icon myIcon;

        private Kind(String downloadPage, Icon icon) {
            if (icon == null) {
                Kind.$$$reportNull$$$0(0);
            }
            this.myDownloadPage = downloadPage;
            this.myIcon = icon;
        }

        @NotNull
        @Nls
        public abstract String getDisplayName();

        @Nullable
        public String getDownloadPage() {
            return this.myDownloadPage;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = this.myIcon;
            if (icon == null) {
                Kind.$$$reportNull$$$0(1);
            }
            return icon;
        }

        public boolean isSupportedOn(@NotNull OSType os) {
            if (os == null) {
                Kind.$$$reportNull$$$0(2);
            }
            return os == OSType.WIN;
        }

        @NotNull
        public static @Unmodifiable List<Kind> getSupportedOn(@NotNull OSType os) {
            if (os == null) {
                Kind.$$$reportNull$$$0(3);
            }
            List list = ContainerUtil.filter((Object[])Kind.values(), it -> it.isSupportedOn(os));
            if (list == null) {
                Kind.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        public static Kind getDefaultSupportedOn(@NotNull OSType os) {
            if (os == null) {
                Kind.$$$reportNull$$$0(5);
            }
            Kind kind = (Kind)((Object)ContainerUtil.getFirstItem(Kind.getSupportedOn(os), (Object)((Object)SYSTEM_UNIX_TOOLSET)));
            if (kind == null) {
                Kind.$$$reportNull$$$0(6);
            }
            return kind;
        }

        public boolean requiresHomePath() {
            return true;
        }

        public boolean isRemoteLike() {
            return this == SSH || this == WSL || this == DOCKER;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "os";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$Kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSupportedOn";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultSupportedOn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSupportedOn";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getSupportedOn";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultSupportedOn";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 4, 6 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public record VersionInfo(String version, File dir, boolean fullySupported) implements Comparable<VersionInfo>
    {
        @Override
        public int compareTo(@NotNull VersionInfo that) {
            int result;
            if (that == null) {
                VersionInfo.$$$reportNull$$$0(0);
            }
            if ((result = Boolean.compare(that.fullySupported, this.fullySupported)) != 0) {
                return result;
            }
            result = StringUtil.compareVersionNumbers((String)that.version, (String)this.version);
            if (result != 0) {
                return result;
            }
            return FileUtil.compareFiles((File)this.dir, (File)that.dir);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/jetbrains/cidr/cpp/toolchains/CPPToolSet$VersionInfo", "compareTo"));
        }
    }

    @FunctionalInterface
    public static interface InstallationProcessor {
        public boolean process(@NotNull File var1, boolean var2);
    }

    public static interface Option {
        @NotNull
        public String getValue();

        public void write(@NotNull Element var1);

        @NotNull
        public String getUniqueID();
    }
}

