/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.CpuArch;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.cpp.toolchains.CLionToolchainDebuggerProvider;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPDebugger;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSetFactory;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSetWithHome;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsConfigurable;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsListener;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.jetbrains.cidr.cpp.toolchains.Cygwin;
import com.jetbrains.cidr.cpp.toolchains.GDB;
import com.jetbrains.cidr.cpp.toolchains.MSVC;
import com.jetbrains.cidr.cpp.toolchains.MinGW;
import com.jetbrains.cidr.cpp.toolchains.TrivialNativeToolchain;
import com.jetbrains.cidr.cpp.toolchains.WSL;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerHelper;
import com.jetbrains.cidr.cpp.toolchains.fus.CPPToolchainsDetectedCollector;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.cidr.system.HostData;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.cidr.toolchains.SettingsHandler;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function3;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="CPPToolchains", storages={@Storage(value="cpp.toolchains.xml", roamingType=RoamingType.PER_OS, deprecated=true), @Storage(value="toolchains.xml", roamingType=RoamingType.PER_OS)}, presentableName=PresentableNameGetter.class)
public final class CPPToolchains
implements PersistentStateComponent<Element> {
    private static final int STATE_VERSION = 10;
    public static volatile List<Toolchain> InitialToolchains;
    @NotNull
    private final OSType myCurrentOSType;
    private volatile boolean myToolchainsDetected;
    private volatile int myToolchainsDetectedVersion;
    @NotNull
    private final List<Toolchain> myToolchains_DoNotAccess;
    private static volatile boolean ourEmulateEnvironmentError;
    private volatile Set<Toolchain> myUniqueUpdates;
    private volatile Map<String, String> myRenames;
    private static final AtomicReference<ArrayList<String>> myClangClPaths;

    @NotNull
    public static CPPToolchains getInstance() {
        CPPToolchains cPPToolchains = (CPPToolchains)ApplicationManager.getApplication().getService(CPPToolchains.class);
        if (cPPToolchains == null) {
            CPPToolchains.$$$reportNull$$$0(0);
        }
        return cPPToolchains;
    }

    public CPPToolchains() {
        this(OSType.getCurrent());
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(SshConfigManager.SSH_CONFIGS, (Object)new SshConfigManager.Listener(){

            public void sshConfigsChanged() {
                ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> {
                    CPPToolchains.this.beginUpdate();
                    SshConfigManager manager = SshConfigManager.getInstance(null);
                    for (Toolchain toolchain : CPPToolchains.this.getToolchains()) {
                        SshConfig oldConfig;
                        SshUiData sshUiData;
                        HostData hostData = toolchain.myHostData;
                        if (hostData == null || (sshUiData = manager.findCurrentDataById((oldConfig = hostData.getSshConfig()).getId())) == null) continue;
                        toolchain.setHostData(hostData.update(sshUiData.getConfig()));
                    }
                    CPPToolchains.this.endUpdate();
                }));
            }
        });
    }

    @TestOnly
    public CPPToolchains(@NotNull OSType osType) {
        if (osType == null) {
            CPPToolchains.$$$reportNull$$$0(1);
        }
        this.myToolchains_DoNotAccess = ContainerUtil.createConcurrentList();
        this.myCurrentOSType = osType;
    }

    @NotNull
    public OSType getOSType() {
        OSType oSType = this.myCurrentOSType;
        if (oSType == null) {
            CPPToolchains.$$$reportNull$$$0(2);
        }
        return oSType;
    }

    @Nullable
    private static String getTestToolParameter(@NotNull CPPToolSet.Kind environment) {
        if (environment == null) {
            CPPToolchains.$$$reportNull$$$0(3);
        }
        HashMap<CPPToolSet.Kind, String> keys = new HashMap<CPPToolSet.Kind, String>();
        keys.put(CPPToolSet.Kind.MSVC, "cpp.test.msvc.home");
        keys.put(CPPToolSet.Kind.MINGW, "cpp.test.mingw.home");
        keys.put(CPPToolSet.Kind.CYGWIN, "cpp.test.cygwin.home");
        keys.put(CPPToolSet.Kind.WSL, "cpp.test.wsl.name");
        keys.put(CPPToolSet.Kind.DOCKER, "cpp.test.docker.image.name");
        String requestedKey = (String)keys.get((Object)environment);
        if (requestedKey == null) {
            throw new RuntimeException("Please add testing support for " + String.valueOf((Object)environment));
        }
        String param = StringUtil.nullize((String)System.getProperty(requestedKey));
        if (param == null) {
            return null;
        }
        for (String otherKey : keys.values()) {
            if (otherKey.equals(requestedKey) || System.getProperty(otherKey) == null) continue;
            throw new RuntimeException("Only one testing environment should be specified. Got " + requestedKey + " and " + otherKey);
        }
        CPPLog.LOG.assertTrue(environment == CPPToolSet.Kind.WSL || environment == CPPToolSet.Kind.DOCKER || new File(param).exists(), (Object)(String.valueOf((Object)environment) + " not found at: " + param));
        return param;
    }

    @TestOnly
    public static void setEmulateEnvironmentErrorInTests(boolean emulate) {
        ourEmulateEnvironmentError = emulate;
    }

    @Nullable
    public static CPPEnvironment createCPPEnvironment(@Nullable Project project, @Nullable File projectDir, @Nullable String toolchainNameOrNullForDefault, @NotNull EnvironmentProblems problems, boolean checkIfFunctional, @Nullable Runnable onMissingToolchain) {
        if (problems == null) {
            CPPToolchains.$$$reportNull$$$0(4);
        }
        Toolchain toolchain = CPPToolchains.getInstance().getToolchainByNameOrDefault(toolchainNameOrNullForDefault);
        return CPPToolchains.createCPPEnvironment(project, projectDir, toolchain, toolchainNameOrNullForDefault, problems, checkIfFunctional, onMissingToolchain);
    }

    @Contract(value="_, null, _, _ -> null")
    @Nullable
    public static CPPEnvironment createCPPEnvironment(@Nullable Project project, @Nullable Toolchain toolchain, @NotNull EnvironmentProblems problems, boolean checkIfFunctional) {
        if (problems == null) {
            CPPToolchains.$$$reportNull$$$0(5);
        }
        return CPPToolchains.createCPPEnvironment(project, null, toolchain, null, problems, checkIfFunctional, null);
    }

    @Contract(value="_, _, null, _, _, _, _ -> null")
    @Nullable
    private static CPPEnvironment createCPPEnvironment(@Nullable Project project, @Nullable File projectDir, @Nullable Toolchain toolchain, @Nullable String requestedToolchainName, @NotNull EnvironmentProblems problems, boolean checkIfFunctional, @Nullable Runnable onMissingToolchain) {
        OSType currentOS;
        if (problems == null) {
            CPPToolchains.$$$reportNull$$$0(6);
        }
        if (checkIfFunctional) {
            Application application = ApplicationManager.getApplication();
            CPPLog.LOG.assertTrue(application.isUnitTestMode() || !application.isReadAccessAllowed(), (Object)"createCPPEnvironment(checkIfFunctional=true) must not be called from UI/readAction");
        }
        if (ourEmulateEnvironmentError) {
            problems.addProblem(ToolchainsBundle.message("dialog.message.emulated.environment.problem", new Object[0]), null);
            return null;
        }
        if (toolchain == null) {
            if (requestedToolchainName == null) {
                problems.addProblem(ToolchainsBundle.message("cpp.toolchains.error.toolchainNotConfigured", new Object[0]), CPPToolchains.getGenericToolchainsFix(project, null));
            } else {
                problems.addProblem(ToolchainsBundle.message("cpp.toolchains.error.toolchainNotFound", requestedToolchainName), CPPToolchains.getMissingToolchainsFix(project, onMissingToolchain));
            }
            return null;
        }
        if (toolchain.myToolSetKind == CPPToolSet.Kind.SSH) {
            HostData data = toolchain.getHostData();
            if (data != null) {
                SshConfig config = data.getSshConfig();
                if (SshConfigManager.getInstance(null).findConfigByName(config.getName()) == null) {
                    problems.addProblem(ToolchainsBundle.message("ssh.config.0.is.not.found", config.getPresentableFullName()), CPPToolchains.getGenericToolchainsFix(project, toolchain));
                    return null;
                }
            } else {
                problems.addProblem(ToolchainsBundle.message("remote.toolchain.credentials.not.specified", toolchain.getName()), CPPToolchains.getGenericToolchainsFix(project, toolchain));
                return null;
            }
        }
        if ((currentOS = OSType.getCurrent()) == OSType.WIN) {
            CPPToolSet toolSet = toolchain.getToolSet();
            if (checkIfFunctional && toolSet.readVersion() == null) {
                Object problem = toolSet instanceof CPPToolSetWithHome ? ToolchainsBundle.message("dialog.message.tool.not.found.at", toolSet.getName(), ((CPPToolSetWithHome)toolSet).getHome()) : toolSet.getName() + ": ";
                problems.addProblem((String)problem, CPPToolchains.getGenericToolchainsFix(project, toolchain));
            }
        }
        if (problems.hasProblems()) {
            return null;
        }
        return new CPPEnvironment(toolchain, project, projectDir);
    }

    @NotNull
    static EnvironmentProblems.Fix getGenericToolchainsFix(@Nullable Project project, @Nullable Toolchain toolchainToSelect) {
        return new EnvironmentProblems.Fix(ToolchainsBundle.message("cpp.toolchains.error.fix", new Object[0]), () -> ShowSettingsUtil.getInstance().showSettingsDialog(project == null || project.isDisposed() ? null : project, CPPToolchainsConfigurable.class, configurable -> configurable.setPreselectedToolchain(CPPToolchains.getInstance().getToolchainsInternal().indexOf(toolchainToSelect))));
    }

    @NotNull
    private static EnvironmentProblems.Fix getMissingToolchainsFix(@Nullable Project project, @Nullable Runnable action2) {
        if (action2 == null) {
            return CPPToolchains.getGenericToolchainsFix(project, null);
        }
        return new EnvironmentProblems.Fix(ToolchainsBundle.message("cpp.toolchains.error.fix", new Object[0]), action2);
    }

    @TestOnly
    public int getDetectedVersion() {
        return this.myToolchainsDetectedVersion;
    }

    @TestOnly
    public void setDetectedVersion(int version) {
        this.myToolchainsDetectedVersion = version;
    }

    @Nullable
    public Toolchain getDefaultToolchain() {
        List<Toolchain> toolchains = this.getToolchainsInternal();
        Toolchain toolchain = (Toolchain)ContainerUtil.getFirstItem(toolchains);
        if (toolchain == null && Registry.is((String)"clion.use.system.toolchain.as.default")) {
            return TrivialNativeToolchain.createInstance(OSType.getCurrent());
        }
        return toolchain;
    }

    @Nullable
    public Toolchain getToolchainByNameOrDefault(@Nullable String name) {
        List<Toolchain> toolchains = this.getToolchainsInternal();
        for (Toolchain each : toolchains) {
            if (!each.getName().equals(name)) continue;
            return each;
        }
        return name != null ? null : this.getDefaultToolchain();
    }

    @NotNull
    public List<Toolchain> getToolchains() {
        List<Toolchain> list = Collections.unmodifiableList(new ArrayList<Toolchain>(this.getToolchainsInternal()));
        if (list == null) {
            CPPToolchains.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private List<Toolchain> getToolchainsInternal() {
        this.detectOnFirstAccess();
        List<Toolchain> list = this.myToolchains_DoNotAccess;
        if (list == null) {
            CPPToolchains.$$$reportNull$$$0(8);
        }
        return list;
    }

    public void addToolchain(@NotNull Toolchain toolchain) {
        if (toolchain == null) {
            CPPToolchains.$$$reportNull$$$0(9);
        }
        assert (toolchain.getOwner() == null) : "Toolchain already has an owner";
        this.assertCanUpdate();
        this.doAddToolChainUnsafe(toolchain);
        this.scheduleCMakeEnvUpdatedNotification(toolchain);
    }

    private void doAddToolChainUnsafe(@NotNull Toolchain toolchain) {
        if (toolchain == null) {
            CPPToolchains.$$$reportNull$$$0(10);
        }
        toolchain.setOwner(this);
        this.getToolchainsInternal().add(toolchain);
    }

    public void removeToolchain(@NotNull Toolchain toolchain) {
        if (toolchain == null) {
            CPPToolchains.$$$reportNull$$$0(11);
        }
        this.assertCanUpdate();
        if (this.getToolchainsInternal().remove(toolchain)) {
            toolchain.setOwner(null);
            toolchain.clearHostCredentials();
            SettingsHandler dockerSettings = toolchain.myDockerSettingsHandler;
            if (dockerSettings != null) {
                dockerSettings.clear();
            }
            this.scheduleCMakeEnvUpdatedNotification(toolchain);
        }
    }

    void toolchainsRenamed(@NotNull List<Pair<String, String>> renamed) {
        if (renamed == null) {
            CPPToolchains.$$$reportNull$$$0(12);
        }
        assert (this.myRenames != null) : "changes should be done inside beforeUpdate/endUpdate";
        renamed.forEach(it -> this.myRenames.put((String)it.first, (String)it.second));
    }

    public void beginUpdate() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        assert (this.myUniqueUpdates == null) : "beginUpdate was already called";
        this.myUniqueUpdates = new ReferenceOpenHashSet();
        this.myRenames = new LinkedHashMap<String, String>();
    }

    public void endUpdate() {
        this.assertCanUpdate();
        CPPToolchains.fireUpdateEvents(this.myUniqueUpdates, this.myRenames);
        this.myUniqueUpdates = null;
        this.myRenames = null;
    }

    private void assertCanUpdate() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        assert (this.myUniqueUpdates != null) : "beginUpdate was not called";
    }

    private void scheduleCMakeEnvUpdatedNotification(@NotNull Toolchain toolchain) {
        if (toolchain == null) {
            CPPToolchains.$$$reportNull$$$0(13);
        }
        assert (this.myUniqueUpdates != null) : "changes should be done inside beforeUpdate/endUpdate";
        this.myUniqueUpdates.add(toolchain);
    }

    public static void fireUpdateEvents(@NotNull Set<Toolchain> changes, @NotNull Map<String, String> renames) {
        if (changes == null) {
            CPPToolchains.$$$reportNull$$$0(14);
        }
        if (renames == null) {
            CPPToolchains.$$$reportNull$$$0(15);
        }
        Application application = ApplicationManager.getApplication();
        if (!changes.isEmpty()) {
            ((CPPToolchainsListener)application.getMessageBus().syncPublisher(CPPToolchainsListener.TOPIC)).toolchainCMakeEnvironmentChanged(changes);
        }
        if (!renames.isEmpty()) {
            ((CPPToolchainsListener)application.getMessageBus().syncPublisher(CPPToolchainsListener.TOPIC)).toolchainsRenamed(renames);
        }
    }

    private void detectOnFirstAccess() {
        this.detectOnFirstAccess(true, msvcProcessor -> MSVC.processVisualStudioInstallations(msvcProcessor), mingwProcessor -> MinGW.processMinGWInstallations(mingwProcessor), cygwinProcessor -> Cygwin.processCygwinInstallations(cygwinProcessor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detectOnFirstAccess(boolean skipDetectionInTests, @NotNull Consumer<CPPToolSet.InstallationProcessor> msvcInstallations, @NotNull Consumer<CPPToolSet.InstallationProcessor> mingwInstallations, @NotNull Consumer<CPPToolSet.InstallationProcessor> cygwinInstallations) {
        if (msvcInstallations == null) {
            CPPToolchains.$$$reportNull$$$0(16);
        }
        if (mingwInstallations == null) {
            CPPToolchains.$$$reportNull$$$0(17);
        }
        if (cygwinInstallations == null) {
            CPPToolchains.$$$reportNull$$$0(18);
        }
        if (!this.myToolchainsDetected) {
            List<Toolchain> list = this.myToolchains_DoNotAccess;
            synchronized (list) {
                if (!this.myToolchainsDetected) {
                    try {
                        List<Toolchain> detected;
                        List<Toolchain> initialToolchains = InitialToolchains;
                        InitialToolchains = null;
                        Application application = ApplicationManager.getApplication();
                        if (initialToolchains != null) {
                            initialToolchains.forEach(it -> it.setOwner(null));
                            detected = initialToolchains;
                        } else if (skipDetectionInTests && application.isUnitTestMode()) {
                            Toolchain testToolchain = new Toolchain(this.myCurrentOSType);
                            testToolchain.setName("Test Toolchain");
                            if (CPPToolchains.isRemoteTestToolchain()) {
                                testToolchain.setToolSetKind(CPPToolSet.Kind.SSH);
                                testToolchain.setCustomCMakePath("/usr/bin/cmake");
                                testToolchain.setDebugger(CPPDebugger.customGdb("/usr/bin/cmake"));
                            } else {
                                CPPToolchains.prepareTestToolchain(testToolchain);
                            }
                            detected = Collections.singletonList(testToolchain);
                        } else {
                            detected = CPPToolchains.doDetectToolSets(this.myToolchainsDetectedVersion, this.myCurrentOSType, msvcInstallations, mingwInstallations, cygwinInstallations);
                            if (this.myCurrentOSType != OSType.WIN && detected.isEmpty()) {
                                Toolchain defaultToolchain = new Toolchain(this.myCurrentOSType);
                                defaultToolchain.setName(Toolchain.getDefault());
                                defaultToolchain.setToolSetKind(CPPToolSet.Kind.SYSTEM_UNIX_TOOLSET);
                                detected.add(defaultToolchain);
                            }
                        }
                        detected.forEach(it -> {
                            it.setOwner(this);
                            this.myToolchains_DoNotAccess.add((Toolchain)it);
                        });
                        CPPToolchainsDetectedCollector.DETECTED.log((Object)detected.size());
                    }
                    finally {
                        this.myToolchainsDetectedVersion = 5;
                        this.myToolchainsDetected = true;
                    }
                }
            }
        }
    }

    private static boolean isRemoteTestToolchain() {
        return Boolean.getBoolean("cpp.test.remote.toolchain");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void prepareTestToolchain(@NotNull Toolchain testToolchain) {
        if (testToolchain == null) {
            CPPToolchains.$$$reportNull$$$0(19);
        }
        CPPToolSet.Kind kind = null;
        String param = null;
        List supportedToolchains = ContainerUtil.filter(CPPToolSet.Kind.getSupportedOn(SystemInfo.isWindows ? OSType.WIN : OSType.LINUX), t -> !List.of(CPPToolSet.Kind.SYSTEM_WINDOWS_TOOLSET, CPPToolSet.Kind.SSH, CPPToolSet.Kind.SYSTEM_UNIX_TOOLSET).contains(t));
        for (CPPToolSet.Kind each : supportedToolchains) {
            param = CPPToolchains.getTestToolParameter(each);
            if (param == null) continue;
            kind = each;
            break;
        }
        if (kind == null) {
            if (SystemInfo.isWindows) {
                Path mingw = MinGW.getBundledPath().toAbsolutePath();
                if (!Files.isDirectory(mingw, new LinkOption[0])) throw new RuntimeException("Environment is not specified.\nFor MSVC, MinGW or Cygwin use -Dcpp.test.<msvc/mingw/cygwin>.home to set test environment on Windows.\nFor WSL use -Dcpp.test.wsl.name=name to specify WSL distribution name, also you can specify\n    custom CMake path using -Dcpp.test.wsl.cmake=path");
                CPPLog.LOG.info("Using bundled MinGW as test toolchain from " + String.valueOf(mingw));
                kind = CPPToolSet.Kind.MINGW;
                param = MinGW.getBundledPath().toAbsolutePath().toString();
            } else {
                kind = CPPToolSet.Kind.SYSTEM_UNIX_TOOLSET;
            }
        }
        if (kind == CPPToolSet.Kind.WSL) {
            WSL.initTestWSLToolchain(testToolchain, param);
        } else if (kind == CPPToolSet.Kind.DOCKER) {
            testToolchain.setToolSetKind(CPPToolSet.Kind.DOCKER);
            if (DockerHelper.isDockerAvailable()) {
                DockerHelper.getInstance().setupTestToolchain(testToolchain, param);
            }
        } else {
            List<CPPToolSet.Option> toolSetOptions;
            testToolchain.setToolSetKind(kind);
            if (SystemInfo.isWindows) {
                testToolchain.setToolSetPath(FileUtil.toCanonicalPath((String)param));
            }
            if (kind == CPPToolSet.Kind.MSVC && !(toolSetOptions = CPPToolchains.getTestMSVCOptions()).isEmpty()) {
                testToolchain.setToolSetOptions(toolSetOptions);
            }
        }
        if (testToolchain.getDebuggerKind() != CPPDebugger.Kind.BUNDLED_GDB) return;
        testToolchain.setBundledOrToolSetGDB();
    }

    @NotNull
    private static List<CPPToolSet.Option> getTestMSVCOptions() {
        String version;
        String platform;
        ArrayList<CPPToolSet.Option> options = new ArrayList<CPPToolSet.Option>();
        String arch = System.getProperty("cpp.test.msvc.arch");
        if (arch != null) {
            options.add(new MSVC.Arch(arch));
        }
        if ((platform = System.getProperty("cpp.test.msvc.platform")) != null) {
            options.add(new MSVC.Platform(platform));
        }
        if ((version = System.getProperty("cpp.test.msvc.version")) != null) {
            options.add(new MSVC.Version(version));
        }
        ArrayList<CPPToolSet.Option> arrayList = options;
        if (arrayList == null) {
            CPPToolchains.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    private static List<Toolchain> doDetectToolSets(int previousVersion, @NotNull OSType osType, @NotNull Consumer<CPPToolSet.InstallationProcessor> msvcInstallations, @NotNull Consumer<CPPToolSet.InstallationProcessor> mingwInstallations, @NotNull Consumer<CPPToolSet.InstallationProcessor> cygwinInstallations) {
        if (osType == null) {
            CPPToolchains.$$$reportNull$$$0(21);
        }
        if (msvcInstallations == null) {
            CPPToolchains.$$$reportNull$$$0(22);
        }
        if (mingwInstallations == null) {
            CPPToolchains.$$$reportNull$$$0(23);
        }
        if (cygwinInstallations == null) {
            CPPToolchains.$$$reportNull$$$0(24);
        }
        HashMap<CPPToolSet.Kind, Consumer<CPPToolSet.InstallationProcessor>> activeProcessors = new HashMap<CPPToolSet.Kind, Consumer<CPPToolSet.InstallationProcessor>>();
        if (osType == OSType.WIN) {
            if (previousVersion < 3) {
                activeProcessors.put(CPPToolSet.Kind.MINGW, mingwInstallations);
                activeProcessors.put(CPPToolSet.Kind.CYGWIN, cygwinInstallations);
            }
            if (previousVersion < 5) {
                activeProcessors.put(CPPToolSet.Kind.MSVC, msvcInstallations);
            }
        }
        ArrayList<Toolchain> result = new ArrayList<Toolchain>();
        for (CPPToolSet.Kind kind : CPPToolSet.Kind.getSupportedOn(osType)) {
            Consumer processor = (Consumer)activeProcessors.get((Object)kind);
            if (processor == null) continue;
            CPPLog.LOG.info("Looking for " + String.valueOf((Object)kind) + "...");
            File[] found = new File[1];
            processor.accept((dir, fullySupported) -> {
                if (found[0] == null || fullySupported) {
                    found[0] = dir;
                }
                return !fullySupported;
            });
            if (found[0] == null) continue;
            CPPLog.LOG.info(String.valueOf((Object)kind) + " found at " + String.valueOf(found[0]));
            Toolchain toolchain = new Toolchain(osType);
            toolchain.setName(Toolchain.generateToolchainName(kind));
            toolchain.setToolSetKind(kind);
            toolchain.setToolSetPath(found[0].getPath());
            toolchain.setBundledOrToolSetGDB();
            result.add(toolchain);
        }
        return result;
    }

    @NotNull
    public Element getState() {
        Element stateElement = new Element("state");
        if (InitialToolchains != null) {
            this.getToolchainsInternal();
        }
        if (this.myToolchainsDetected) {
            stateElement.setAttribute("version", String.valueOf(10));
            Element toolchainsElement = new Element("toolchains");
            toolchainsElement.setAttribute("detectedVersion", Integer.toString(this.myToolchainsDetectedVersion));
            stateElement.addContent(toolchainsElement);
            Function3 setAttributeIfNotNull = (el, name, value) -> {
                if (value != null) {
                    el.setAttribute(name, value);
                }
                return null;
            };
            for (Toolchain toolchain : this.getToolchainsInternal()) {
                Element element = new Element("toolchain");
                toolchainsElement.addContent(element);
                element.setAttribute("name", toolchain.getName());
                CPPToolSet.Kind kind = toolchain.getToolSetKind();
                element.setAttribute("toolSetKind", kind.name());
                setAttributeIfNotNull.invoke((Object)element, (Object)"toolSetPath", (Object)toolchain.getToolSetPath());
                for (CPPToolSet.Option option : toolchain.getToolSetOptions()) {
                    Element optionEl = new Element("toolSetOption");
                    element.addContent(optionEl);
                    option.write(optionEl);
                }
                setAttributeIfNotNull.invoke((Object)element, (Object)"customCMakePath", (Object)toolchain.getCustomCMakePath());
                setAttributeIfNotNull.invoke((Object)element, (Object)"customMakePath", (Object)toolchain.getCustomBuildToolPath());
                setAttributeIfNotNull.invoke((Object)element, (Object)"customCCompilerPath", (Object)toolchain.getCustomCCompilerPath());
                setAttributeIfNotNull.invoke((Object)element, (Object)"customCXXCompilerPath", (Object)toolchain.getCustomCXXCompilerPath());
                HostData.save(element, toolchain.myHostData);
                CPPToolchains.saveDockerSettings(element, toolchain.myDockerSettingsHandler);
                CPPDebugger.Kind debuggerKind = toolchain.getDebuggerKind();
                element.setAttribute("debuggerKind", debuggerKind.name());
                if (debuggerKind == CPPDebugger.Kind.CUSTOM_GDB) {
                    setAttributeIfNotNull.invoke((Object)element, (Object)"customGDBPath", (Object)toolchain.getCustomGDBExecutablePath());
                } else if (debuggerKind == CPPDebugger.Kind.CUSTOM_LLDB) {
                    setAttributeIfNotNull.invoke((Object)element, (Object)"customPath", (Object)toolchain.getDebugger().getCustomPath());
                } else if (debuggerKind == CPPDebugger.Kind.CUSTOM_DEBUGGER) {
                    setAttributeIfNotNull.invoke((Object)element, (Object)"customDebuggerProviderId", (Object)toolchain.getDebugger().getCustomDebuggerProviderId());
                }
                setAttributeIfNotNull.invoke((Object)element, (Object)"environment", (Object)toolchain.getEnvironment());
            }
        }
        Element element = stateElement;
        if (element == null) {
            CPPToolchains.$$$reportNull$$$0(25);
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element state) {
        if (state == null) {
            CPPToolchains.$$$reportNull$$$0(26);
        }
        ArrayList<Toolchain> toolchains = new ArrayList<Toolchain>();
        int version = StringUtil.parseInt((String)state.getAttributeValue("version"), (int)10);
        Element toolchainsElement = state.getChild("toolchains");
        if (toolchainsElement != null) {
            for (Element eachElement : toolchainsElement.getChildren("toolchain")) {
                Toolchain toolchain = new Toolchain(this.myCurrentOSType);
                String name = eachElement.getAttributeValue("name");
                toolchain.setName(name);
                toolchain.setToolSetKind(CPPToolchains.loadToolSetKind(eachElement));
                toolchain.setToolSetPath(eachElement.getAttributeValue("toolSetPath"));
                ArrayList<CPPToolSet.Option> toolSetOptions = new ArrayList<CPPToolSet.Option>();
                for (Element eachOptionElement : eachElement.getChildren("toolSetOption")) {
                    ContainerUtil.addIfNotNull(toolSetOptions, (Object)MSVC.loadOption(eachOptionElement));
                }
                toolchain.setToolSetOptions(toolSetOptions);
                String legacyIsUseCustomCMake = eachElement.getAttributeValue("useCustomCMake");
                if (legacyIsUseCustomCMake == null || Boolean.parseBoolean(legacyIsUseCustomCMake)) {
                    toolchain.setCustomCMakePath(eachElement.getAttributeValue("customCMakePath"));
                }
                toolchain.setCustomBuildToolPath(eachElement.getAttributeValue("customMakePath"));
                toolchain.setCustomCCompilerPath(eachElement.getAttributeValue("customCCompilerPath"));
                toolchain.setCustomCXXCompilerPath(eachElement.getAttributeValue("customCXXCompilerPath"));
                toolchain.setEnvironment(eachElement.getAttributeValue("environment"));
                toolchain.myHostData = HostData.load(eachElement);
                toolchain.myDockerSettingsHandler = CPPToolchains.loadDockerSettings(eachElement);
                CPPDebugger.Kind debuggerKind = CPPDebugger.Kind.BUNDLED_GDB;
                try {
                    String kindString = eachElement.getAttributeValue("debuggerKind");
                    if (kindString != null) {
                        debuggerKind = CPPDebugger.Kind.valueOf(kindString);
                    }
                }
                catch (IllegalArgumentException kindString) {
                    // empty catch block
                }
                String customPath = null;
                if (debuggerKind == CPPDebugger.Kind.CUSTOM_GDB) {
                    customPath = eachElement.getAttributeValue("customGDBPath");
                } else if (debuggerKind == CPPDebugger.Kind.CUSTOM_LLDB) {
                    customPath = eachElement.getAttributeValue("customPath");
                }
                if (debuggerKind == CPPDebugger.Kind.BUNDLED_GDB) {
                    if (OSType.getCurrent() == OSType.MAC && toolchain.getToolSetKind() != CPPToolSet.Kind.DOCKER) {
                        toolchain.setDebugger(CPPDebugger.bundledLldb());
                    } else {
                        toolchain.setBundledOrToolSetGDB();
                    }
                } else if (debuggerKind == CPPDebugger.Kind.CUSTOM_DEBUGGER) {
                    toolchain.setDebugger(CPPDebugger.customDebugger(eachElement.getAttributeValue("customDebuggerProviderId")));
                } else {
                    toolchain.setDebugger(CPPDebugger.create(debuggerKind, customPath));
                }
                toolchain.setOwner(this);
                toolchains.add(toolchain);
            }
            CPPToolchains.migrateRemoteDeploymentConfigs(toolchains, version);
            List<Toolchain> list = this.myToolchains_DoNotAccess;
            synchronized (list) {
                boolean wasDetected = this.myToolchainsDetected;
                this.myToolchainsDetected = true;
                this.myToolchainsDetectedVersion = StringUtil.parseInt((String)toolchainsElement.getAttributeValue("detectedVersion"), (int)0);
                if (!this.myToolchains_DoNotAccess.equals(toolchains)) {
                    ArrayList<Toolchain> previous = new ArrayList<Toolchain>(this.myToolchains_DoNotAccess);
                    this.myToolchains_DoNotAccess.clear();
                    this.myToolchains_DoNotAccess.addAll(toolchains);
                    if (wasDetected) {
                        ReferenceOpenHashSet changes = new ReferenceOpenHashSet();
                        changes.addAll(previous);
                        changes.addAll(toolchains);
                        CPPToolchains.fireUpdateEvents((Set<Toolchain>)changes, Collections.emptyMap());
                    }
                }
            }
        }
    }

    private static void migrateRemoteDeploymentConfigs(@NotNull List<Toolchain> toolchains, int version) {
        if (toolchains == null) {
            CPPToolchains.$$$reportNull$$$0(27);
        }
        if (version > 7) {
            return;
        }
        List<String> hostIds = toolchains.stream().filter(t -> t.getToolSetKind() == CPPToolSet.Kind.SSH).map(t -> t.myHostData).filter(Objects::nonNull).map(d -> d.getId()).filter(Objects::nonNull).collect(Collectors.toList());
        RemoteDeploymentHelper.enableRsyncForConfigs(hostIds);
    }

    private static void saveDockerSettings(@NotNull Element root, @Nullable SettingsHandler handler) {
        if (root == null) {
            CPPToolchains.$$$reportNull$$$0(28);
        }
        if (handler != null) {
            Element element = new Element("CIDR_DOCKER_CREDENTIALS");
            root.addContent(element);
            handler.save(element);
        }
    }

    @Nullable
    private static SettingsHandler loadDockerSettings(@NotNull Element root) {
        Element element;
        if (root == null) {
            CPPToolchains.$$$reportNull$$$0(29);
        }
        if ((element = root.getChild("CIDR_DOCKER_CREDENTIALS")) != null && DockerHelper.isDockerAvailable()) {
            return DockerHelper.getInstance().loadDockerSettings(element);
        }
        return null;
    }

    @NotNull
    private static CPPToolSet.Kind loadToolSetKind(@NotNull Element toolchainElement) {
        String toolSetKind;
        if (toolchainElement == null) {
            CPPToolchains.$$$reportNull$$$0(30);
        }
        if ((toolSetKind = toolchainElement.getAttributeValue("toolSetKind")) != null) {
            CPPToolSet.Kind kind;
            if (toolSetKind.equals("REMOTE")) {
                toolSetKind = "SSH";
            }
            try {
                kind = CPPToolSet.Kind.valueOf(toolSetKind);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (kind == null) {
                CPPToolchains.$$$reportNull$$$0(31);
            }
            return kind;
        }
        CPPToolSet.Kind kind = CPPToolSet.Kind.getDefaultSupportedOn(OSType.getCurrent());
        if (kind == null) {
            CPPToolchains.$$$reportNull$$$0(32);
        }
        return kind;
    }

    @Nullable
    public static File clangClDirFromRegistry() {
        File file;
        String installDir = WindowsRegistryUtil.readRegistryDefault((String)"HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\LLVM\\LLVM");
        if (installDir != null && !installDir.isEmpty() && (file = new File(installDir, "bin\\clang-cl.exe")).exists()) {
            return file;
        }
        return null;
    }

    @Nullable
    public static File clangClDirFromMSVC(@Nullable String toolSetPath) {
        if (toolSetPath == null) {
            return null;
        }
        String location = switch (MSVC.Arch.getDefault().getArch().getSource()) {
            case CpuArch.X86_64 -> "VC\\Tools\\Llvm\\x64\\bin\\clang-cl.exe";
            case CpuArch.ARM64 -> "VC\\Tools\\Llvm\\ARM64\\bin\\clang-cl.exe";
            default -> "VC\\Tools\\Llvm\\bin\\clang-cl.exe";
        };
        File file = new File(toolSetPath, location);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private static List<File> clangClDirsFromSystem(@NotNull File root, @Nullable String pathVariable) {
        if (root == null) {
            CPPToolchains.$$$reportNull$$$0(33);
        }
        ArrayList<File> clangClDirs = new ArrayList<File>();
        for (File eachRootToCheck : Arrays.asList(root, new File(root, "Program Files"), new File(root, "Program Files (x86)"))) {
            File[] dirs = eachRootToCheck.listFiles();
            if (dirs == null) continue;
            for (File dir : dirs) {
                if (!dir.isDirectory() || !StringUtil.containsIgnoreCase((String)dir.getName(), (String)"llvm")) continue;
                File path = new File(dir.getPath() + "\\bin\\clang-cl.exe");
                clangClDirs.add(path);
            }
        }
        if (pathVariable != null) {
            for (String eachPathDir : PathEnvironmentVariableUtil.getPathDirs((String)pathVariable)) {
                if (!PathUtil.getFileName((String)eachPathDir).equalsIgnoreCase("bin") || !StringUtil.containsIgnoreCase((String)eachPathDir, (String)"llvm")) continue;
                File path = new File(eachPathDir, "clang-cl.exe");
                clangClDirs.add(path);
            }
        }
        return clangClDirs;
    }

    public static void autodetectCustomMSVCCompiler() {
        if (myClangClPaths.get() != null) {
            return;
        }
        HashSet<File> paths = new HashSet<File>();
        File file = CPPToolchains.clangClDirFromRegistry();
        if (file != null) {
            paths.add(file);
        }
        MSVC.processVisualStudioInstallations((msvcFile, supported) -> {
            File clangClFile = CPPToolchains.clangClDirFromMSVC(msvcFile.getPath());
            if (clangClFile != null) {
                paths.add(clangClFile);
            }
            return true;
        });
        paths.addAll(CPPToolchains.clangClDirsFromSystem(new File("C:\\"), EnvironmentUtil.getValue((String)"PATH")));
        ArrayList pathStrings = new ArrayList();
        paths.forEach(item -> pathStrings.add(item.getPath()));
        myClangClPaths.set(pathStrings);
    }

    static {
        ourEmulateEnvironmentError = false;
        myClangClPaths = new AtomicReference();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 24, 26, 27, 28, 29, 30, 33 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchains";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchain";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renamed";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renames";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msvcInstallations";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mingwInstallations";
                break;
            }
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cygwinInstallations";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testToolchain";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchains";
                break;
            }
            case 28: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchainElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchains";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOSType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolchains";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolchainsInternal";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMSVCOptions";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "loadToolSetKind";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTestToolParameter";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCPPEnvironment";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addToolchain";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doAddToolChainUnsafe";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeToolchain";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "toolchainsRenamed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "scheduleCMakeEnvUpdatedNotification";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fireUpdateEvents";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "detectOnFirstAccess";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "prepareTestToolchain";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doDetectToolSets";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "migrateRemoteDeploymentConfigs";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "saveDockerSettings";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "loadDockerSettings";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "loadToolSetKind";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "clangClDirsFromSystem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 24, 26, 27, 28, 29, 30, 33 -> new IllegalArgumentException(string);
        };
    }

    public static class Toolchain {
        public static final String UNNAMED = "Unnamed";
        @NotNull
        private final OSType myCurrentOSType;
        @Nullable
        private volatile CPPToolchains myOwner;
        @NotNull
        private volatile String myName;
        @NotNull
        private volatile CPPToolSet.Kind myToolSetKind;
        @Nullable
        private volatile String myToolSetPath;
        @NotNull
        private volatile List<CPPToolSet.Option> myToolSetOptions;
        @Nullable
        private volatile String myCustomCMakePath;
        @Nullable
        private volatile String myCustomBuildToolPath;
        @Nullable
        private volatile String myCustomCCompilerPath;
        @Nullable
        private volatile String myCustomCXXCompilerPath;
        @Nullable
        private volatile HostData myHostData;
        @Nullable
        private volatile SettingsHandler myDockerSettingsHandler;
        @NotNull
        private volatile CPPDebugger myDebugger;
        @Nullable
        private volatile String myEnvironment;

        public Toolchain(@NotNull OSType osType) {
            if (osType == null) {
                Toolchain.$$$reportNull$$$0(0);
            }
            this(osType, null);
        }

        public Toolchain(@NotNull OSType osType, boolean hasBundledLLDB, boolean hasBundledGDB) {
            if (osType == null) {
                Toolchain.$$$reportNull$$$0(1);
            }
            this(osType, null, hasBundledLLDB, hasBundledGDB);
        }

        protected Toolchain(@NotNull OSType osType, @Nullable CPPToolSet.Kind toolSetKind) {
            if (osType == null) {
                Toolchain.$$$reportNull$$$0(2);
            }
            this(osType, toolSetKind, LLDBDriverConfiguration.hasBundledLLDB(), GDB.hasBundledGDB());
        }

        private Toolchain(@NotNull OSType osType, @Nullable CPPToolSet.Kind toolSetKind, boolean hasBundledLLDB, boolean hasBundledGDB) {
            if (osType == null) {
                Toolchain.$$$reportNull$$$0(3);
            }
            this.myName = Toolchain.normalizeToolchainNameOrUnnamed(null);
            this.myToolSetOptions = Collections.emptyList();
            this.myCurrentOSType = osType;
            this.myToolSetKind = toolSetKind != null ? toolSetKind : CPPToolSet.Kind.getDefaultSupportedOn(osType);
            this.myDebugger = Toolchain.getDefaultDebugger(osType, hasBundledLLDB, hasBundledGDB);
        }

        @NotNull
        private static CPPDebugger getDefaultDebugger(@NotNull OSType osType, boolean hasBundledLLDB, boolean hasBundledGDB) {
            if (osType == null) {
                Toolchain.$$$reportNull$$$0(4);
            }
            if (osType == OSType.MAC) {
                if (hasBundledLLDB) {
                    CPPDebugger cPPDebugger = CPPDebugger.bundledLldb();
                    if (cPPDebugger == null) {
                        Toolchain.$$$reportNull$$$0(5);
                    }
                    return cPPDebugger;
                }
                if (hasBundledGDB) {
                    CPPDebugger cPPDebugger = CPPDebugger.bundledGdb();
                    if (cPPDebugger == null) {
                        Toolchain.$$$reportNull$$$0(6);
                    }
                    return cPPDebugger;
                }
            } else {
                if (hasBundledGDB) {
                    CPPDebugger cPPDebugger = CPPDebugger.bundledGdb();
                    if (cPPDebugger == null) {
                        Toolchain.$$$reportNull$$$0(7);
                    }
                    return cPPDebugger;
                }
                if (hasBundledLLDB) {
                    CPPDebugger cPPDebugger = CPPDebugger.bundledLldb();
                    if (cPPDebugger == null) {
                        Toolchain.$$$reportNull$$$0(8);
                    }
                    return cPPDebugger;
                }
            }
            CPPDebugger cPPDebugger = CPPDebugger.customGdb((File)null);
            if (cPPDebugger == null) {
                Toolchain.$$$reportNull$$$0(9);
            }
            return cPPDebugger;
        }

        @NotNull
        public OSType getOSType() {
            OSType oSType = this.myCurrentOSType;
            if (oSType == null) {
                Toolchain.$$$reportNull$$$0(10);
            }
            return oSType;
        }

        @Nullable
        private CPPToolchains getOwner() {
            return this.myOwner;
        }

        private void setOwner(@Nullable CPPToolchains owner) {
            this.myOwner = owner;
        }

        @NotNull
        public Toolchain copy() {
            Toolchain copy = new Toolchain(this.myCurrentOSType);
            copy.myName = this.myName;
            copy.myToolSetKind = this.myToolSetKind;
            copy.myToolSetPath = this.myToolSetPath;
            copy.myToolSetOptions = this.myToolSetOptions;
            copy.myCustomCMakePath = this.myCustomCMakePath;
            copy.myCustomBuildToolPath = this.myCustomBuildToolPath;
            copy.myCustomCCompilerPath = this.myCustomCCompilerPath;
            copy.myCustomCXXCompilerPath = this.myCustomCXXCompilerPath;
            HostData hostData = this.myHostData;
            copy.myHostData = hostData == null ? null : hostData.copy();
            SettingsHandler dockerSettings = this.myDockerSettingsHandler;
            copy.myDockerSettingsHandler = dockerSettings == null ? null : dockerSettings.copy();
            copy.myDebugger = this.myDebugger;
            Toolchain toolchain = copy;
            if (toolchain == null) {
                Toolchain.$$$reportNull$$$0(11);
            }
            return toolchain;
        }

        private void checkForUpdate() {
            CPPToolchains owner = this.myOwner;
            if (owner != null) {
                owner.assertCanUpdate();
            }
        }

        private void notifyCMakeChange() {
            CPPToolchains owner = this.myOwner;
            if (owner != null) {
                owner.scheduleCMakeEnvUpdatedNotification(this);
            }
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                Toolchain.$$$reportNull$$$0(12);
            }
            return string;
        }

        public void setName(String name) {
            this.checkForUpdate();
            name = Toolchain.normalizeToolchainNameOrUnnamed(name);
            if (!Objects.equals(this.myName, name)) {
                this.myName = name;
                this.notifyCMakeChange();
            }
        }

        @Nullable
        public String getEnvironment() {
            return this.myEnvironment;
        }

        public void setEnvironment(@Nullable String environment) {
            if (!Objects.equals(this.myEnvironment, environment)) {
                this.myEnvironment = environment;
                this.notifyCMakeChange();
            }
        }

        @NotNull
        public static String normalizeToolchainNameOrUnnamed(@Nullable String name) {
            String string = (name = Toolchain.normalizeToolchainName(name)) == null ? UNNAMED : name;
            if (string == null) {
                Toolchain.$$$reportNull$$$0(13);
            }
            return string;
        }

        @Nullable
        public static String normalizeToolchainName(@Nullable String name) {
            return StringUtil.nullize((String)StringUtil.trim((String)name));
        }

        @NotNull
        public static String generateToolchainName(@NotNull CPPToolSet.Kind kind) {
            if (kind == null) {
                Toolchain.$$$reportNull$$$0(14);
            }
            String string = kind.getDisplayName();
            if (string == null) {
                Toolchain.$$$reportNull$$$0(15);
            }
            return string;
        }

        @NotNull
        public CPPToolSet.Kind getToolSetKind() {
            CPPToolSet.Kind kind = this.myToolSetKind;
            if (kind == null) {
                Toolchain.$$$reportNull$$$0(16);
            }
            return kind;
        }

        public void setToolSetKind(@NotNull CPPToolSet.Kind kind) {
            if (kind == null) {
                Toolchain.$$$reportNull$$$0(17);
            }
            this.checkForUpdate();
            if (!kind.isSupportedOn(this.myCurrentOSType)) {
                return;
            }
            if (this.myToolSetKind != kind) {
                this.myToolSetKind = kind;
                this.notifyCMakeChange();
            }
        }

        @Nullable
        @NlsSafe
        public String getToolSetPath() {
            return this.myToolSetPath;
        }

        public void setToolSetPath(@Nullable String path) {
            this.checkForUpdate();
            path = CPPToolchainsUtil.preparePath(path);
            if (!Objects.equals(this.myToolSetPath, path)) {
                this.myToolSetPath = path;
                this.notifyCMakeChange();
            }
        }

        @NotNull
        public List<CPPToolSet.Option> getToolSetOptions() {
            List<CPPToolSet.Option> list = this.myToolSetOptions;
            if (list == null) {
                Toolchain.$$$reportNull$$$0(18);
            }
            return list;
        }

        public void setToolSetOptions(@NotNull List<CPPToolSet.Option> toolSetOptions) {
            if (toolSetOptions == null) {
                Toolchain.$$$reportNull$$$0(19);
            }
            this.checkForUpdate();
            if (!Objects.equals(this.myToolSetOptions, toolSetOptions)) {
                this.notifyCMakeChange();
                this.myToolSetOptions = Collections.unmodifiableList(toolSetOptions);
            }
        }

        @NlsSafe
        @Nullable
        public String getCustomCMakePath() {
            return this.myCustomCMakePath;
        }

        public void setCustomCMakePath(@Nullable String path) {
            this.checkForUpdate();
            path = CPPToolchainsUtil.preparePath(path);
            if (!Objects.equals(this.myCustomCMakePath, path)) {
                this.myCustomCMakePath = path;
                this.notifyCMakeChange();
            }
        }

        @NlsSafe
        @Nullable
        public String getCustomBuildToolPath() {
            return this.myCustomBuildToolPath;
        }

        public void setCustomBuildToolPath(@Nullable String path) {
            this.checkForUpdate();
            path = CPPToolchainsUtil.preparePath(path);
            if (!Objects.equals(this.myCustomBuildToolPath, path)) {
                this.myCustomBuildToolPath = path;
                this.notifyCMakeChange();
            }
        }

        public boolean supportsBundledCMake() {
            return Toolchain.supportsBundledCMake(this.getToolSet());
        }

        public static boolean supportsBundledCMake(@NotNull CPPToolSet toolset) {
            if (toolset == null) {
                Toolchain.$$$reportNull$$$0(20);
            }
            if (toolset.getKind().isRemoteLike()) {
                return false;
            }
            return CMakeExecutableTool.hasBundledCMake(toolset.isCygwin());
        }

        @Nullable
        public List<String> getCustomAutodetectedCCompilerPaths() {
            if (this.myToolSetKind == CPPToolSet.Kind.MSVC) {
                return myClangClPaths.get();
            }
            return null;
        }

        @NlsSafe
        @Nullable
        public String getCustomCCompilerPath() {
            return this.myCustomCCompilerPath;
        }

        public void setCustomCCompilerPath(@Nullable String path) {
            this.checkForUpdate();
            path = CPPToolchainsUtil.preparePath(path);
            if (!Objects.equals(this.myCustomCCompilerPath, path)) {
                this.myCustomCCompilerPath = path;
                this.notifyCMakeChange();
            }
        }

        @Nullable
        public List<String> getCustomAutodetectedCXXCompilerPaths() {
            return this.getCustomAutodetectedCCompilerPaths();
        }

        @NlsSafe
        @Nullable
        public String getCustomCXXCompilerPath() {
            return this.myCustomCXXCompilerPath;
        }

        public void setCustomCXXCompilerPath(@Nullable String path) {
            this.checkForUpdate();
            path = CPPToolchainsUtil.preparePath(path);
            if (!Objects.equals(this.myCustomCXXCompilerPath, path)) {
                this.myCustomCXXCompilerPath = path;
                this.notifyCMakeChange();
            }
        }

        public void setHostData(@Nullable HostData hostData) {
            this.checkForUpdate();
            if (!Objects.equals(this.myHostData, hostData)) {
                this.myHostData = hostData;
                this.notifyCMakeChange();
            }
        }

        private void clearHostCredentials() {
            HostData.deleteRemoteHost(this.myHostData);
        }

        @Nullable
        public HostData getHostData() {
            return this.myHostData;
        }

        public void setDockerSettingsHandler(@Nullable SettingsHandler handler) {
            this.checkForUpdate();
            if (!Objects.equals(this.myDockerSettingsHandler, handler)) {
                this.myDockerSettingsHandler = handler;
                this.notifyCMakeChange();
            }
        }

        @Nullable
        public SettingsHandler getDockerSettingsHandler() {
            return this.myDockerSettingsHandler;
        }

        @NotNull
        public CPPDebugger getDebugger() {
            CPPDebugger cPPDebugger = this.myDebugger;
            if (cPPDebugger == null) {
                Toolchain.$$$reportNull$$$0(21);
            }
            return cPPDebugger;
        }

        public void setDebugger(@NotNull CPPDebugger debugger) {
            if (debugger == null) {
                Toolchain.$$$reportNull$$$0(22);
            }
            this.checkForUpdate();
            this.myDebugger = debugger;
        }

        public void setBundledOrToolSetGDB() {
            CPPToolSet toolSet = this.getToolSet();
            if (!toolSet.supportsDebugger(CPPDebugger.Kind.BUNDLED_GDB)) {
                this.setDebugger(CPPDebugger.customGdb(toolSet.getGDBPath()));
            } else {
                this.setDebugger(CPPDebugger.bundledGdb());
            }
        }

        @Nullable
        public String getCustomGDBExecutablePath() {
            return this.getDebugger().getGdbExecutablePath();
        }

        @NotNull
        public CPPDebugger.Kind getDebuggerKind() {
            CPPDebugger.Kind kind = this.getDebugger().getKind();
            if (kind == null) {
                Toolchain.$$$reportNull$$$0(23);
            }
            return kind;
        }

        public boolean isDebuggerSupported() {
            return Toolchain.isDebuggerSupported(this.getDebugger(), this.getToolSet());
        }

        public static boolean isDebuggerSupported(@NotNull CPPDebugger debugger, @NotNull CPPToolSet toolset) {
            if (debugger == null) {
                Toolchain.$$$reportNull$$$0(24);
            }
            if (toolset == null) {
                Toolchain.$$$reportNull$$$0(25);
            }
            return switch (debugger.getKind()) {
                default -> throw new IncompatibleClassChangeError();
                case CPPDebugger.Kind.BUNDLED_LLDB -> Toolchain.supportsBundledLLDB(toolset);
                case CPPDebugger.Kind.BUNDLED_GDB -> Toolchain.supportsBundledGDB(toolset);
                case CPPDebugger.Kind.CUSTOM_GDB -> toolset.supportsDebugger(CPPDebugger.Kind.CUSTOM_GDB);
                case CPPDebugger.Kind.CUSTOM_LLDB -> toolset.supportsDebugger(CPPDebugger.Kind.CUSTOM_LLDB);
                case CPPDebugger.Kind.CUSTOM_DEBUGGER -> {
                    String providerId = debugger.getCustomDebuggerProviderId();
                    CLionToolchainDebuggerProvider provider = CLionToolchainDebuggerProvider.getProvider(providerId);
                    if (provider != null && provider.isApplicable(toolset)) {
                        yield true;
                    }
                    yield false;
                }
            };
        }

        public boolean supportsBundledGDB() {
            return Toolchain.supportsBundledGDB(this.getToolSet());
        }

        static boolean supportsBundledGDB(@NotNull CPPToolSet toolset) {
            if (toolset == null) {
                Toolchain.$$$reportNull$$$0(26);
            }
            if (!GDB.hasBundledGDB()) {
                return false;
            }
            return toolset.supportsDebugger(CPPDebugger.Kind.BUNDLED_GDB);
        }

        public boolean supportsBundledLLDB() {
            return Toolchain.supportsBundledLLDB(this.getToolSet());
        }

        static boolean supportsBundledLLDB(@NotNull CPPToolSet toolset) {
            if (toolset == null) {
                Toolchain.$$$reportNull$$$0(27);
            }
            if (!LLDBDriverConfiguration.hasBundledLLDB()) {
                return false;
            }
            return toolset.supportsDebugger(CPPDebugger.Kind.BUNDLED_LLDB);
        }

        @Nullable
        public MSVC getMSVC() {
            return (MSVC)this.getToolSetIf(CPPToolSet.Kind.MSVC);
        }

        @Nullable
        public MinGW getMinGW() {
            return (MinGW)this.getToolSetIf(CPPToolSet.Kind.MINGW);
        }

        @Nullable
        public Cygwin getCygwin() {
            return (Cygwin)this.getToolSetIf(CPPToolSet.Kind.CYGWIN);
        }

        @Nullable
        public WSL getWSL() {
            return (WSL)this.getToolSetIf(CPPToolSet.Kind.WSL);
        }

        @NotNull
        public CPPToolSet getToolSet() {
            CPPToolSet.Kind kind = this.myToolSetKind;
            if (!kind.requiresHomePath()) {
                CPPToolSet cPPToolSet = CPPToolSetFactory.create(kind);
                if (cPPToolSet == null) {
                    Toolchain.$$$reportNull$$$0(28);
                }
                return cPPToolSet;
            }
            String path = this.myToolSetPath;
            CPPToolSet cPPToolSet = CPPToolSetFactory.create(kind, StringUtil.notNullize((String)path));
            if (cPPToolSet == null) {
                Toolchain.$$$reportNull$$$0(29);
            }
            return cPPToolSet;
        }

        @Nullable
        public <T extends CPPToolSet> T getToolSetIf(@NotNull CPPToolSet.Kind requiredKind) {
            CPPToolSet.Kind kind;
            if (requiredKind == null) {
                Toolchain.$$$reportNull$$$0(30);
            }
            if ((kind = this.myToolSetKind) != requiredKind) {
                return null;
            }
            if (!kind.requiresHomePath()) {
                return (T)CPPToolSetFactory.create(kind);
            }
            String path = this.myToolSetPath;
            return (T)(path == null ? null : CPPToolSetFactory.create(kind, path));
        }

        public String toString() {
            return "Toolchain{myName='" + this.myName + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Toolchain toolchain = (Toolchain)o;
            return this.myCurrentOSType == toolchain.myCurrentOSType && Objects.equals(this.myEnvironment, toolchain.myEnvironment) && Objects.equals(this.myOwner, toolchain.myOwner) && Objects.equals(this.myName, toolchain.myName) && this.myToolSetKind == toolchain.myToolSetKind && Objects.equals(this.myToolSetPath, toolchain.myToolSetPath) && Objects.equals(this.myToolSetOptions, toolchain.myToolSetOptions) && Objects.equals(this.myCustomCMakePath, toolchain.myCustomCMakePath) && Objects.equals(this.myCustomBuildToolPath, toolchain.myCustomBuildToolPath) && Objects.equals(this.myCustomCCompilerPath, toolchain.myCustomCCompilerPath) && Objects.equals(this.myCustomCXXCompilerPath, toolchain.myCustomCXXCompilerPath) && Objects.equals(this.myHostData, toolchain.myHostData) && Objects.equals(this.myDebugger, toolchain.myDebugger);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.myCurrentOSType, this.myOwner, this.myName, this.myToolSetKind, this.myToolSetPath, this.myToolSetOptions, this.myCustomCMakePath, this.myCustomBuildToolPath, this.myCustomCCompilerPath, this.myCustomCXXCompilerPath, this.myHostData, this.myDebugger, this.myEnvironment});
        }

        public static String getDefault() {
            return ToolchainsBundle.message("cpp.toolchains.default.name", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 18, 21, 23, 28, 29 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "osType";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 18: 
                case 21: 
                case 23: 
                case 28: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain";
                    break;
                }
                case 14: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolSetOptions";
                    break;
                }
                case 20: 
                case 25: 
                case 26: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolset";
                    break;
                }
                case 22: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugger";
                    break;
                }
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requiredKind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultDebugger";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOSType";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "normalizeToolchainNameOrUnnamed";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateToolchainName";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolSetKind";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolSetOptions";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebugger";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebuggerKind";
                    break;
                }
                case 28: 
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultDebugger";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 18: 
                case 21: 
                case 23: 
                case 28: 
                case 29: {
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "generateToolchainName";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "setToolSetKind";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "setToolSetOptions";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "supportsBundledCMake";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "setDebugger";
                    break;
                }
                case 24: 
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "isDebuggerSupported";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "supportsBundledGDB";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "supportsBundledLLDB";
                    break;
                }
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "getToolSetIf";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 18, 21, 23, 28, 29 -> new IllegalStateException(string);
            };
        }
    }

    static final class PresentableNameGetter
    extends State.NameGetter {
        PresentableNameGetter() {
        }

        public String get() {
            return CPPToolchainsConfigurable.getName();
        }
    }
}

