/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class CPPToolchainsUtil {
    public static final Pattern VERSION_PATTERN = Pattern.compile("^[a-zA-Z() \\d]*?(\\d+\\.\\d+\\.?\\d*).*", 8);

    @Nls
    @Nullable
    public static String checkVersion(@NotNull Version min, @NotNull Version max, @NotNull ToolVersion toolVersion) {
        if (min == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(0);
        }
        if (max == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(1);
        }
        if (toolVersion == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(2);
        }
        return CPPToolchainsUtil.checkVersion(min, max, toolVersion.versionNumber);
    }

    @Nls
    @Nullable
    public static String checkVersion(@NotNull Version min, @NotNull Version max, @Nullable Version version) {
        if (min == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(3);
        }
        if (max == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(4);
        }
        return CPPToolchainsUtil.checkVersion(min, max, version, "settings.select.UnsupportedVersion", "settings.select.UnsupportedVersion.range");
    }

    @Nls
    @Nullable
    public static String checkVersion(@NotNull Version min, @NotNull Version max, @Nullable Version version, @PropertyKey(resourceBundle="messages.ToolchainsBundle") @NotNull @PropertyKey(resourceBundle="messages.ToolchainsBundle") @NotNull String singleVersionMessageKey, @PropertyKey(resourceBundle="messages.ToolchainsBundle") @NotNull @PropertyKey(resourceBundle="messages.ToolchainsBundle") @NotNull String versionRangeMessage) {
        if (min == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(5);
        }
        if (max == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(6);
        }
        if (singleVersionMessageKey == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(7);
        }
        if (versionRangeMessage == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(8);
        }
        if (version == null || CPPToolchainsUtil.compareVersions(min, version) < 0 || CPPToolchainsUtil.compareVersions(max, version) > 0) {
            return min.equals((Object)max) ? ToolchainsBundle.message(singleVersionMessageKey, version, CPPToolchainsUtil.toWildcardString(min)) : ToolchainsBundle.message(versionRangeMessage, version, CPPToolchainsUtil.toWildcardString(min), CPPToolchainsUtil.toWildcardString(max));
        }
        return null;
    }

    @NlsSafe
    @NotNull
    public static String toWildcardString(@NotNull Version version) {
        if (version == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(9);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(version.major);
        if (version.minor != -1) {
            builder.append(".").append(version.minor);
            if (version.bugfix != -1) {
                builder.append(".").append(version.bugfix);
            } else {
                builder.append(".x");
            }
        } else {
            builder.append(".x");
        }
        String string = builder.toString();
        if (string == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static int compareVersions(@NotNull Version baseline, @NotNull Version version) {
        if (baseline == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(11);
        }
        if (version == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(12);
        }
        return version.compareTo(baseline.major == -1 ? null : Integer.valueOf(baseline.major), baseline.minor == -1 ? null : Integer.valueOf(baseline.minor), baseline.bugfix == -1 ? null : Integer.valueOf(baseline.bugfix));
    }

    @NlsSafe
    @Nullable
    public static String preparePath(@Nullable String path) {
        return StringUtil.nullize((String)StringUtil.trim((String)path), (boolean)true);
    }

    @Nullable
    public static String getRegistryValue(@NotNull WinReg.HKEY root, @NotNull String keyPath, @NotNull String key) {
        if (root == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(13);
        }
        if (keyPath == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(14);
        }
        if (key == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(15);
        }
        try {
            return Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)keyPath, (String)key);
        }
        catch (Win32Exception ex) {
            return null;
        }
    }

    @NotNull
    public static @NotNull List<@NotNull String> getRegistryValues(@NotNull WinReg.HKEY root, @NotNull String keyPath) {
        List list;
        if (root == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(16);
        }
        if (keyPath == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(17);
        }
        try {
            TreeMap keyValues = Advapi32Util.registryGetValues((WinReg.HKEY)root, (String)keyPath);
            list = ContainerUtil.map(keyValues.values(), value -> value.toString());
        }
        catch (Win32Exception ex) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                CPPToolchainsUtil.$$$reportNull$$$0(19);
            }
            return list2;
        }
        if (list == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(18);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "min";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "max";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolVersion";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleVersionMessageKey";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionRangeMessage";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 10: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchainsUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseline";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchainsUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toWildcardString";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistryValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toWildcardString";
                break;
            }
            case 10: 
            case 18: 
            case 19: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compareVersions";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRegistryValue";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRegistryValues";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 18, 19 -> new IllegalStateException(string);
        };
    }
}

