/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.jetbrains.cidr.system.CidrEnvironmentUtil;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001JH\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00032\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00030\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00030\u0006H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/CancellableEnvironmentReader;", "", "readEnvironmentFileCancellable", "", "", "fileEnvProducer", "Lkotlin/Function0;", "defaultEnvProducer", "intellij.clion.toolchains"})
@SourceDebugExtension(value={"SMAP\nEnvironmentReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvironmentReader.kt\ncom/jetbrains/cidr/cpp/toolchains/CancellableEnvironmentReader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,128:1\n14#2:129\n14#2:130\n*S KotlinDebug\n*F\n+ 1 EnvironmentReader.kt\ncom/jetbrains/cidr/cpp/toolchains/CancellableEnvironmentReader\n*L\n66#1:129\n54#1:130\n*E\n"})
public interface CancellableEnvironmentReader {
    @NotNull
    default public Map<String, String> readEnvironmentFileCancellable(@NotNull Function0<? extends Map<String, String>> fileEnvProducer, @NotNull Function0<? extends Map<String, String>> defaultEnvProducer) throws IOException {
        Intrinsics.checkNotNullParameter(fileEnvProducer, (String)"fileEnvProducer");
        Intrinsics.checkNotNullParameter(defaultEnvProducer, (String)"defaultEnvProducer");
        ExecutorService pool = Executors.newFixedThreadPool(1);
        CompletableFuture<Map> future2 = CompletableFuture.supplyAsync(() -> CancellableEnvironmentReader.readEnvironmentFileCancellable$lambda$0(fileEnvProducer, defaultEnvProducer), pool);
        Map environment = null;
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        while (environment == null) {
            if (indicator != null) {
                try {
                    indicator.checkCanceled();
                }
                catch (ProcessCanceledException pce) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(CancellableEnvironmentReader.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.debug("indicator is cancelled, cancelling future and thread pool");
                    future2.cancel(true);
                    pool.shutdownNow();
                    throw pce;
                }
            }
            try {
                environment = future2.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    if (((RuntimeException)cause).getCause() instanceof IOException) {
                        IOException iOException = (IOException)((RuntimeException)cause).getCause();
                        Intrinsics.checkNotNull((Object)iOException);
                        throw iOException;
                    }
                    RuntimeException runtimeException = (RuntimeException)((RuntimeException)cause).getCause();
                    Intrinsics.checkNotNull((Object)runtimeException);
                    throw runtimeException;
                }
                throw new RuntimeException(e);
            }
            catch (TimeoutException timeoutException) {
            }
        }
        return environment;
    }

    private static Map readEnvironmentFileCancellable$lambda$0(Function0 $fileEnvProducer, Function0 $defaultEnvProducer) {
        Thread.currentThread().setName("env-reader-thread");
        try {
            return CidrEnvironmentUtil.subtractEnvironments((Map)((Map)$fileEnvProducer.invoke()), (Map)((Map)$defaultEnvProducer.invoke()));
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(CancellableEnvironmentReader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

