/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.msvc;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Version;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.toolchains.PathSeparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0006J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u0006H\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/msvc/MSBuildVersionCache;", "", "<init>", "()V", "versions", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/openapi/util/Version;", "getMSBuildVersion", "pathVariable", "computeMSBuildVersion", "Companion", "intellij.clion.toolchains"})
public final class MSBuildVersionCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, Version> versions = new ConcurrentHashMap();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String MSBUILD_BINARY = "msbuild.exe";
    @NotNull
    private static final String MSBUILD_VERSION_FLAG = "--version";

    @Nullable
    public final Version getMSBuildVersion(@NotNull String pathVariable) {
        Intrinsics.checkNotNullParameter((Object)pathVariable, (String)"pathVariable");
        return this.versions.computeIfAbsent(pathVariable, arg_0 -> MSBuildVersionCache.getMSBuildVersion$lambda$1(arg_0 -> MSBuildVersionCache.getMSBuildVersion$lambda$0(this, arg_0), arg_0));
    }

    private final Version computeMSBuildVersion(String pathVariable) {
        String[] stringArray = new String[]{MSBUILD_VERSION_FLAG};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine().withExePath(MSBUILD_BINARY).withParameters(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withParameters(...)");
        GeneralCommandLine msbuildVersionCommand = generalCommandLine;
        String[] stringArray2 = new String[]{pathVariable};
        CPPToolSet.prependPathVariable(msbuildVersionCommand, PathSeparator.WINDOWS, stringArray2);
        try {
            List list = new CapturingProcessHandler(msbuildVersionCommand).runProcess().getStdoutLines();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStdoutLines(...)");
            List msbuildOutput = list;
            String string = (String)msbuildOutput.get(msbuildOutput.size() - 1);
            if (string == null) {
                return null;
            }
            String output = string;
            return Version.parseVersion((String)output);
        }
        catch (ExecutionException exception) {
            LOG.warn("Failed to get msbuild version", (Throwable)exception);
        }
        catch (Exception exception) {
            if (Logger.shouldRethrow((Throwable)exception)) {
                throw exception;
            }
            LOG.error("Failed to get msbuild version", (Throwable)exception);
        }
        return null;
    }

    private static final Version getMSBuildVersion$lambda$0(MSBuildVersionCache this$0, String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this$0.computeMSBuildVersion(key);
    }

    private static final Version getMSBuildVersion$lambda$1(Function1 $tmp0, Object p0) {
        return (Version)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(MSBuildVersionCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/msvc/MSBuildVersionCache$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MSBUILD_BINARY", "", "MSBUILD_VERSION_FLAG", "intellij.clion.toolchains"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

