/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remote.RemoteCredentials;
import com.intellij.util.ApplicationKt;
import com.intellij.util.PathMapper;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.RemoteDeployment;
import com.jetbrains.cidr.system.RemoteDeploymentHelper;
import com.jetbrains.cidr.system.RemoteHostUtil;
import com.jetbrains.cidr.system.RemoteProjectUtilScopeService;
import com.jetbrains.cidr.system.RemoteUtil;
import com.jetbrains.cidr.toolchains.wsl.CidrWSLHost;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\t2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J*\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J(\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/system/RemoteProjectUtil;", "", "<init>", "()V", "SOURCE_UPLOAD_MARKER", "", "syncToHosts", "", "remoteEnvs", "", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "projectDir", "excludeList", "isFullUpload", "", "isRemoteProjectUploaded", "os", "Lcom/intellij/util/system/OS;", "credentials", "Lcom/intellij/remote/RemoteCredentials;", "pathMapper", "Lcom/intellij/util/PathMapper;", "markRemoteProjectAsUploaded", "intellij.clion.toolchains"})
@SourceDebugExtension(value={"SMAP\nRemoteProjectUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteProjectUtil.kt\ncom/jetbrains/cidr/system/RemoteProjectUtil\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,138:1\n30#2,2:139\n*S KotlinDebug\n*F\n+ 1 RemoteProjectUtil.kt\ncom/jetbrains/cidr/system/RemoteProjectUtil\n*L\n76#1:139,2\n*E\n"})
public final class RemoteProjectUtil {
    @NotNull
    public static final RemoteProjectUtil INSTANCE = new RemoteProjectUtil();
    @NotNull
    public static final String SOURCE_UPLOAD_MARKER = ".clion.source.upload.marker";

    private RemoteProjectUtil() {
    }

    @JvmStatic
    @RequiresBackgroundThread
    @JvmOverloads
    public static final void syncToHosts(@NotNull List<? extends CPPEnvironment> remoteEnvs, @NotNull Project project, @NotNull String projectDir, @NotNull List<String> excludeList, boolean isFullUpload) throws ExecutionException {
        Intrinsics.checkNotNullParameter(remoteEnvs, (String)"remoteEnvs");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter(excludeList, (String)"excludeList");
        RemoteDeployment remoteDeployment = (RemoteDeployment)ApplicationKt.getApplication().getService(RemoteDeployment.class);
        if (remoteDeployment == null) {
            return;
        }
        RemoteDeployment remoteDeployment2 = remoteDeployment;
        if (RemoteHostUtil.LOG.isDebugEnabled()) {
            RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: upload project to " + remoteEnvs.size() + " hosts");
        }
        List uploads = new ArrayList(remoteEnvs.size());
        if (Registry.Companion.is("clion.remote.resync.system.cache", false)) {
            remoteEnvs.forEach(RemoteProjectUtil::syncToHosts$lambda$0);
        }
        ExecutionException ex = null;
        Set hosts = new HashSet(remoteEnvs.size());
        for (CPPEnvironment cPPEnvironment : remoteEnvs) {
            RemoteCredentials credentials;
            String hostId;
            HostMachine host;
            Intrinsics.checkNotNullExpressionValue((Object)cPPEnvironment.getHostMachine(), (String)"getHostMachine(...)");
            boolean bl = host.isRemote();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (host instanceof CidrWSLHost) continue;
            Intrinsics.checkNotNullExpressionValue((Object)host.getHostId(), (String)"getHostId(...)");
            if (!remoteDeployment2.isDeploymentConfigSFTP(hostId) || (credentials = RemoteUtil.getCredentials(host)) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)host.getOS(), (String)"getOS(...)");
            PathMapper pathMapper = RemoteDeploymentHelper.getPathMapper(hostId, project, projectDir);
            if (pathMapper == null) continue;
            try {
                OS os;
                remoteDeployment2.addExcludedPaths(hostId, project, excludeList);
                boolean isUploaded = INSTANCE.isRemoteProjectUploaded(os, credentials, projectDir, pathMapper);
                if (RemoteHostUtil.LOG.isDebugEnabled()) {
                    RemoteHostUtil.LOG.debug("RemoteDeploymentHelper: project is uploaded: " + isUploaded);
                }
                if (!isUploaded) {
                    ComponentManager $this$service$iv = (ComponentManager)project;
                    boolean $i$f$service = false;
                    Class<RemoteProjectUtilScopeService> serviceClass$iv = RemoteProjectUtilScopeService.class;
                    Object object = $this$service$iv.getService(serviceClass$iv);
                    if (object == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                    }
                    Deferred future2 = BuildersKt.async$default((CoroutineScope)((RemoteProjectUtilScopeService)object).getCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(remoteDeployment2, hostId, project, isFullUpload, os, credentials, projectDir, pathMapper, null){
                        int label;
                        final /* synthetic */ RemoteDeployment $remoteDeployment;
                        final /* synthetic */ String $hostId;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ boolean $isFullUpload;
                        final /* synthetic */ OS $os;
                        final /* synthetic */ RemoteCredentials $credentials;
                        final /* synthetic */ String $projectDir;
                        final /* synthetic */ PathMapper $pathMapper;
                        {
                            this.$remoteDeployment = $remoteDeployment;
                            this.$hostId = $hostId;
                            this.$project = $project;
                            this.$isFullUpload = $isFullUpload;
                            this.$os = $os;
                            this.$credentials = $credentials;
                            this.$projectDir = $projectDir;
                            this.$pathMapper = $pathMapper;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = this.$remoteDeployment.upload(this.$hostId, this.$project, this.$isFullUpload);
                                    Intrinsics.checkNotNullExpressionValue(v0, (String)"upload(...)");
                                    this.label = 1;
                                    v1 = FutureKt.await((CompletionStage)v0, (Continuation)((Continuation)this));
                                    if (v1 == var2_2) {
                                        return var2_2;
                                    }
                                    ** GOTO lbl15
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v1 = $result;
lbl15:
                                    // 2 sources

                                    RemoteProjectUtil.access$markRemoteProjectAsUploaded(RemoteProjectUtil.INSTANCE, this.$os, this.$credentials, this.$projectDir, this.$pathMapper);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                    uploads.add(FutureKt.asCompletableFuture((Deferred)future2));
                }
            }
            catch (ExecutionException e) {
                if (ex == null) {
                    ex = e;
                }
                ExceptionsKt.addSuppressed((Throwable)ex, (Throwable)e);
            }
            hosts.add(hostId);
        }
        remoteDeployment2.subscribeForUploading(project, hosts);
        for (Future future2 : uploads) {
            RemoteDeploymentHelper.waitForTransferOperation(future2);
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static /* synthetic */ void syncToHosts$default(List list, Project project, String string, List list2, boolean bl, int n, Object object) throws ExecutionException {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        RemoteProjectUtil.syncToHosts(list, project, string, list2, bl);
    }

    private final boolean isRemoteProjectUploaded(OS os, RemoteCredentials credentials, String projectDir, PathMapper pathMapper) throws ExecutionException {
        if (pathMapper == null) {
            return false;
        }
        String string = pathMapper.convertToRemote(projectDir);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertToRemote(...)");
        String remotePath = string;
        String markerPath = remotePath + "/.clion.source.upload.marker";
        return RemoteUtil.fileExists(os, credentials, markerPath);
    }

    private final void markRemoteProjectAsUploaded(OS os, RemoteCredentials credentials, String projectDir, PathMapper pathMapper) {
        String string = pathMapper.convertToRemote(projectDir);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertToRemote(...)");
        String remotePath = string;
        String markerPath = remotePath + "/.clion.source.upload.marker";
        try {
            RemoteUtil.touch(os, credentials, markerPath);
        }
        catch (ExecutionException e) {
            throw new CompletionException(e);
        }
    }

    @JvmStatic
    @RequiresBackgroundThread
    @JvmOverloads
    public static final void syncToHosts(@NotNull List<? extends CPPEnvironment> remoteEnvs, @NotNull Project project, @NotNull String projectDir, @NotNull List<String> excludeList) throws ExecutionException {
        Intrinsics.checkNotNullParameter(remoteEnvs, (String)"remoteEnvs");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        Intrinsics.checkNotNullParameter(excludeList, (String)"excludeList");
        RemoteProjectUtil.syncToHosts$default(remoteEnvs, project, projectDir, excludeList, false, 16, null);
    }

    private static final void syncToHosts$lambda$0(CPPEnvironment env) {
        CPPEnvironment cPPEnvironment = env;
        Intrinsics.checkNotNull((Object)cPPEnvironment);
        cPPEnvironment.getHostMachine().invalidateCache();
    }

    public static final /* synthetic */ void access$markRemoteProjectAsUploaded(RemoteProjectUtil $this, OS os, RemoteCredentials credentials, String projectDir, PathMapper pathMapper) {
        $this.markRemoteProjectAsUploaded(os, credentials, projectDir, pathMapper);
    }
}

